/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.analysis.model.AnnotationType;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IAnalysisProvider;
import com.arm.streamline.model.ModelMessages;
import com.arm.streamline.model.RGBString;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.RGBUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.text.BasicTextFilter;
import com.arm.utils.text.NumericStringComparator;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class LogEntry
implements IAnalysisProvider,
IExtractable,
Comparable<LogEntry> {
    private Analysis mAnalysis;
    private long mTimestampNanoseconds;
    private long mTimestampMicroseconds;
    private long mEndTimestampNanoseconds;
    private long mEndTimestampMicroseconds;
    private int mChannel;
    private AnnotationType mType;
    private String mImage;
    private String mMessage;
    private @NonNull String mOneLineMessage;
    private RGB mRGB;
    private boolean isTerminateMarker;
    private final @NonNull UniqueThread mUniqueThread;

    public LogEntry(LittleEndianDataInputStream in, Analysis analysis, int index) throws IOException {
        this.mAnalysis = analysis;
        long duration = analysis.getStateFile().getDuration();
        this.mTimestampNanoseconds = in.readLELong();
        if (this.mTimestampNanoseconds < 0L) {
            throw new IOException(MessageFormat.format(ModelMessages.INVALID_TIMESTAMP, index, this.mTimestampNanoseconds));
        }
        if (this.mTimestampNanoseconds > duration) {
            this.mTimestampNanoseconds = duration;
        }
        this.mTimestampMicroseconds = this.mTimestampNanoseconds / 1000L;
        if (this.mTimestampMicroseconds > Scales.mapDensestBinIndexToMicroseconds((int)analysis.getLastBin(Scales.DENSEST_POSSIBLE_ZOOM_LEVEL))) {
            this.mTimestampMicroseconds = Scales.mapDensestBinIndexToMicroseconds((int)analysis.getLastBin(Scales.DENSEST_POSSIBLE_ZOOM_LEVEL));
        }
        this.mType = AnnotationType.get((int)in.readLEShort());
        int linkID = in.readLEInt();
        Optional thread = this.mAnalysis.getUniqueIdMap().findThread(linkID);
        this.mUniqueThread = (UniqueThread)thread.orElseThrow(() -> new IOException(MessageFormat.format(ModelMessages.INVALID_LINK, index, linkID)));
        int messageID = in.readLEInt();
        RGBString message = this.mAnalysis.getMessage(messageID);
        if (message == null) {
            this.mRGB = RGBUtils.create(-3092272);
            this.mMessage = "";
        } else {
            this.mRGB = message.getRGB();
            this.mMessage = message.getString();
        }
        this.mOneLineMessage = (String)NullChecking.neverNull((Object)BasicTextFilter.normalizeLineEndings((String)this.mMessage, (String)" "));
        if (this.mType == AnnotationType.STRING) {
            this.mChannel = in.readLEInt();
        }
        if (this.mType == AnnotationType.VISUAL) {
            int imageID = in.readLEInt();
            RGBString image = this.mAnalysis.getImage(imageID);
            if (image != null) {
                this.mImage = image.getString();
            }
            if (this.mImage != null) {
                this.mImage = new File(analysis.getReportDirectory(), "annotate/images/" + this.mImage).getAbsolutePath();
                this.mEndTimestampMicroseconds = this.mTimestampMicroseconds;
                this.mEndTimestampNanoseconds = this.mTimestampNanoseconds;
            }
        }
        this.isTerminateMarker = this.mType == AnnotationType.STRING && messageID == 0;
    }

    @Override
    public int compareTo(LogEntry other) {
        if (this.mTimestampNanoseconds < other.mTimestampNanoseconds) {
            return -1;
        }
        if (this.mTimestampNanoseconds > other.mTimestampNanoseconds) {
            return 1;
        }
        return NumericStringComparator.CASELESS_COMPARATOR.compare(this.mMessage, other.mMessage);
    }

    public <R, E extends Throwable> R accept(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IExtractable.IExtractableVisitor<R, E> visitor) throws E {
        return (R)visitor.visit((IUniqueThreadID)this.mUniqueThread);
    }

    private @NonNull Pair<@NonNull Integer, @NonNull Integer> getProcessIdAndThreadId() {
        @NonNull UniqueProcess process = this.mUniqueThread.getProcess();
        int processId = ((AbstractPerVmId.PerVmNonUniquePid)process.getNonUid().getId()).id;
        int threadId = ((AbstractPerVmId.PerVmNonUniqueTid)this.mUniqueThread.getNonUid().getId()).id;
        return new Pair((Object)processId, (Object)threadId);
    }

    @Override
    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public @NonNull UniqueThread getUniqueProcess() {
        return this.mUniqueThread;
    }

    public int getChannel() {
        return this.mChannel;
    }

    public @NonNull String getChannelName() {
        return this.mAnalysis.getAnnotationDataStructure().getChannelName(this.mUniqueThread.getUid(), this.mChannel);
    }

    public long getDurationNanoseconds() {
        return this.mEndTimestampNanoseconds - this.mTimestampNanoseconds;
    }

    public long getEndTimelineMarker() {
        return this.mEndTimestampMicroseconds;
    }

    public long getEndTimestamp() {
        return this.mEndTimestampNanoseconds;
    }

    public int getGroup() {
        return this.mAnalysis.getAnnotationDataStructure().getGroup(this.mUniqueThread.getUid(), this.mChannel);
    }

    public @NonNull String getGroupName() {
        return this.mAnalysis.getAnnotationDataStructure().getGroupName(this.mUniqueThread.getUid(), this.getGroup());
    }

    public String getImagePath() {
        return this.mImage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public @NonNull String getOneLineMessage() {
        return this.mOneLineMessage;
    }

    public RGB getRGB() {
        return this.mRGB;
    }

    public String getThumbnailPath() {
        String image = this.mImage;
        if (image != null) {
            File file = new File(FilePath.getParent((String)FilePath.getParent((String)image, (boolean)false), (boolean)false), "thumbnails");
            file = new File(file, FilePath.getLeafName((String)image, (boolean)false) + ".png");
            return file.getAbsolutePath();
        }
        return null;
    }

    public @NonNull TimeUnit getTimeUnit() {
        return this.mAnalysis.getTimeUnit();
    }

    public long getTimelineMarker() {
        return this.mTimestampMicroseconds;
    }

    public long getTimestamp() {
        return this.mTimestampNanoseconds;
    }

    public boolean isBookmark() {
        return this.mType == AnnotationType.BOOKMARK;
    }

    public boolean isTerminateMarker() {
        return this.isTerminateMarker;
    }

    public boolean isVisualAnnotation() {
        return this.mType == AnnotationType.VISUAL;
    }

    public void setEndTimelineMarker(long tm) {
        if (!this.isVisualAnnotation()) {
            this.mEndTimestampMicroseconds = Math.max(tm, this.mTimestampMicroseconds);
        }
    }

    public void setEndTimestamp(long ts) {
        if (!this.isVisualAnnotation()) {
            this.mEndTimestampNanoseconds = Math.max(ts, this.mTimestampNanoseconds);
        }
    }

    public @NonNull String getFullName() {
        UniqueProcess process = this.mUniqueThread.getProcess();
        Pair<Integer, Integer> processIdAndThreadId = this.getProcessIdAndThreadId();
        Integer processId = (Integer)processIdAndThreadId.first;
        Integer threadId = (Integer)processIdAndThreadId.second;
        String nameOrUnresolved = this.mUniqueThread.getNonUid().getNameOrUnresolved();
        boolean isIdleOrKernel = this.mUniqueThread.isIdle() || this.mUniqueThread.isKernel();
        return MessageFormat.format("(VM #{0}) | {1}{2} | {3}{4}", process.getVmUID(), process.getNonUid().getNameOrUnresolved(), isIdleOrKernel ? "" : " #" + processId.toString(), nameOrUnresolved, isIdleOrKernel && threadId <= 0 ? "" : " #" + threadId.toString());
    }
}

