/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.hacks;

import com.arm.streamline.common.CommonPlugin;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;

public class FixBadWorkbenchXmi
implements Runnable {
    private File mDir;

    public static void fixIfNeeded() {
        block13: {
            try {
                File workbenchXmi;
                File root = new File(ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                File dir = new File(root, ".metadata/.plugins/org.eclipse.e4.workbench");
                if (!dir.exists() || !(workbenchXmi = new File(dir, "workbench.xmi")).exists()) break block13;
                boolean hasBadData = false;
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedReader in = new BufferedReader(new FileReader(workbenchXmi));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (!line.contains("<tags>popup:streamline.view.LauncherView</tags>")) continue;
                        hasBadData = true;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (hasBadData) {
                    Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new FixBadWorkbenchXmi(dir), "Fix Bad Workbench Xmi"));
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    private FixBadWorkbenchXmi(File dir) {
        this.mDir = dir;
    }

    @Override
    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
    public void run() {
        File existing = new File(this.mDir, "workbench.xmi");
        File fixed = new File(this.mDir, "workbench.xmi.fixed");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter out = new PrintWriter(fixed);){
                ArrayList<String> buffer = new ArrayList<String>();
                Throwable throwable2 = null;
                Iterator iterator = null;
                try (BufferedReader in = new BufferedReader(new FileReader(existing));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (line.contains("<tags>popup:streamline.view.LauncherView</tags>")) {
                            buffer.remove(buffer.size() - 1);
                            buffer.remove(buffer.size() - 1);
                            line = in.readLine();
                        } else {
                            buffer.add(line);
                        }
                        while (buffer.size() > 10) {
                            out.println((String)buffer.get(0));
                            buffer.remove(0);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                for (String line : buffer) {
                    out.println(line);
                }
                out.close();
                existing.delete();
                fixed.renameTo(existing);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

