/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.warnings;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.warnings.WarningsMessages;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.ImageButton;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WarningPanel
extends Composite
implements MouseTrackListener {
    private static final Color BACKGROUND = Colors.create(206, 226, 253);
    private static final Color BACKGROUND_OVER = Colors.create(202, 253, 239);
    private static final Color FOREGROUND = Colors.getBlack();
    private static final int H_MARGIN = 4;
    private static final int V_MARGIN = 2;
    Label mIcon;
    ImageButton mCopyButton;
    Label mTitle;
    Label mDescription;

    public WarningPanel(Composite parent, WarningItem item) {
        super(parent, 0x20000000);
        this.setLayout(new WarningPanelLayout());
        this.mIcon = new Label((Composite)this, 0x20004000);
        this.mIcon.setImage(switch (item.getSeverity()) {
            case WarningSeverity.LOW -> StreamlinePlugin.getImage("WarningLow.png");
            default -> StreamlinePlugin.getImage("Warning.png");
            case WarningSeverity.HIGH -> StreamlinePlugin.getImage("WarningHigh.png");
        });
        this.mIcon.setToolTipText(item.getSeverity().toString());
        this.mIcon.addMouseTrackListener((MouseTrackListener)this);
        this.mCopyButton = new ImageButton((Composite)this, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        this.mCopyButton.setToolTipText(WarningsMessages.COPY_TOOLTIP);
        this.mCopyButton.addClickListener(button -> {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            clipboard.setContents(new Object[]{item.getTitle().trim() + "\n\n" + item.getDescription().trim()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        });
        this.mTitle = new Label((Composite)this, 0x20004000);
        this.mTitle.setFont(Fonts.getNormalStandout());
        this.mTitle.setText(item.getTitle().trim());
        this.mTitle.addMouseTrackListener((MouseTrackListener)this);
        this.mTitle.setForeground(FOREGROUND);
        this.mDescription = new Label((Composite)this, 0x20004040);
        this.mDescription.setFont(Fonts.getNormal());
        this.mDescription.setText(item.getDescription().trim());
        this.mDescription.addMouseTrackListener((MouseTrackListener)this);
        this.mDescription.setForeground(FOREGROUND);
        this.setBackgroundForAll(BACKGROUND);
        this.addMouseTrackListener(this);
    }

    public void mouseEnter(MouseEvent event) {
        this.adjustBackgroundForMouse(event);
    }

    public void mouseExit(MouseEvent event) {
        this.adjustBackgroundForMouse(event);
    }

    public void mouseHover(MouseEvent event) {
    }

    private void adjustBackgroundForMouse(MouseEvent event) {
        this.setBackgroundForAll(this.getClientArea().contains(this.toControl(((Control)event.widget).toDisplay(event.x, event.y))) ? BACKGROUND_OVER : BACKGROUND);
    }

    private void setBackgroundForAll(Color color) {
        ControlHacks.setBackground((Control)this, color);
        ControlHacks.setBackground((Control)this.mIcon, color);
        ControlHacks.setBackground((Control)this.mCopyButton, color);
        ControlHacks.setBackground((Control)this.mTitle, color);
        ControlHacks.setBackground((Control)this.mDescription, color);
        this.redraw();
    }

    class WarningPanelLayout
    extends Layout {
        WarningPanelLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point iconSize = WarningPanel.this.mIcon.computeSize(-1, -1);
            Point copySize = WarningPanel.this.mCopyButton.computeSize(-1, -1);
            Point titleSize = WarningPanel.this.mTitle.computeSize(-1, -1);
            Point descSize = WarningPanel.this.mDescription.computeSize(wHint == -1 ? Math.max(titleSize.x, 375) : wHint - (iconSize.x + 12), -1, true);
            int width = 4 + Math.max(iconSize.x, copySize.x) + 4 + Math.max(descSize.x, titleSize.x) + 4;
            int height = 2 + Math.max(iconSize.y, titleSize.y) + 2 + Math.max(copySize.y, descSize.y) + 2;
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle bounds = composite.getClientArea();
            Point iconSize = WarningPanel.this.mIcon.computeSize(-1, -1);
            Point copySize = WarningPanel.this.mCopyButton.computeSize(-1, -1);
            int col1Width = Math.max(iconSize.x, copySize.x);
            Point titleSize = WarningPanel.this.mTitle.computeSize(-1, -1);
            Point descSize = WarningPanel.this.mDescription.computeSize(bounds.width - (col1Width + 12), -1, true);
            int maxWidth = Math.max(titleSize.x, 375);
            if (descSize.x > maxWidth) {
                descSize = WarningPanel.this.mDescription.computeSize(maxWidth, -1, true);
            }
            int col1 = bounds.x + 4;
            int top = bounds.y + 2;
            int col2 = col1 + col1Width + 4;
            int height = Math.max(iconSize.y, titleSize.y);
            WarningPanel.this.mIcon.setBounds(col1 + (col1Width - iconSize.x) / 2, top + (height - iconSize.y) / 2, iconSize.x, iconSize.y);
            WarningPanel.this.mTitle.setBounds(col2, top + (height - titleSize.y) / 2, titleSize.x, titleSize.y);
            WarningPanel.this.mCopyButton.setBounds(col1 + (col1Width - copySize.x) / 2, top += height + 2, copySize.x, copySize.y);
            WarningPanel.this.mDescription.setBounds(col2, top, descSize.x, descSize.y);
        }
    }
}

