/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.warnings;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.warnings.IWarningListener;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.warnings.WarningsMessages;
import com.arm.streamline.editortabs.warnings.WarningsPopup;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarBadge;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class WarningBadge
extends ToolbarBadge
implements IWarningListener,
DisposeListener,
MouseListener {
    private @Nullable IWarnings mWarnings;
    private WarningsPopup mWarningsPopup;

    public WarningBadge(Composite parent, @NonNull IWarnings warnings) {
        super(parent, Colors.create(248, 216, 67), StreamlinePlugin.getImage("Warning.png"));
        this.setToolTipText(WarningsMessages.WARNINGS_TOOLTIP);
        this.addDisposeListener(this);
        this.mWarnings = warnings;
        warnings.addListener((IWarningListener)this);
        this.addMouseListener(this);
        int count = warnings.size();
        if (count > 0) {
            this.setText(NumberUtils.format((long)count));
        }
    }

    public @NonNull IWarnings getWarnings() {
        return (IWarnings)NullChecking.neverNull((Object)this.mWarnings);
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        Task.callOnUIThread(() -> {
            if (this.mWarningsPopup == null && !this.isDisposed()) {
                this.mWarningsPopup = new WarningsPopup(this);
                this.mWarningsPopup.open();
            }
        });
    }

    public void mouseUp(MouseEvent event) {
    }

    public void warningsUpdated() {
        @Nullable IWarnings mWarnings = this.mWarnings;
        Task.callOnUIThread(() -> {
            int count;
            if (mWarnings != null && !this.isDisposed() && this.setText((count = mWarnings.size()) > 0 ? NumberUtils.format((long)count) : null)) {
                SafeUpdate.layout(this.getParent());
            }
        });
    }

    public void widgetDisposed(DisposeEvent event) {
        @Nullable IWarnings mWarnings = this.mWarnings;
        if (event.widget == this && mWarnings != null) {
            mWarnings.removeListener((IWarningListener)this);
            this.mWarnings = null;
        }
        Task.callOnUIThread(() -> {
            this.mWarningsPopup = null;
        });
    }

    @Override
    protected void paintBackground(GC gc, Rectangle bounds) {
        Pattern pattern = new Pattern(gc.getDevice(), StreamlinePlugin.getImage("WarningStripes.png"));
        gc.setBackgroundPattern(pattern);
        gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        pattern.dispose();
    }
}

