/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.templates;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.templates.RemoveChartsDialog;
import com.arm.streamline.editortabs.timeline.common.templates.RemoveChartsViewModel;
import com.arm.streamline.editortabs.timeline.common.templates.TemplatesMessages;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.templates.ITemplatePath;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.IProvidesStateMaskAtMouseDown;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.utils.MapUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TemplateAction
extends Action
implements IMenuCreator {
    private static final int ADD_MODIFIER = SWT.MOD2;
    private static final int INCLUDE_MISSING_SOURCES_MODIFIER = SWT.MOD1;
    private final @NonNull BaseTimelineContent mContent;
    private Menu mMenu;
    private @NonNull List<@NonNull TemplateFile> mTemplates;
    private @NonNull Collection<@NonNull String> mSpeKeys;

    public static final List<TemplateFile> getAvailableTemplates(@NonNull Map<@NonNull String, @NonNull TIntSet> sourceToClusterIds) {
        ArrayList<TemplateFile> list = new ArrayList<TemplateFile>();
        @NonNull File[] files = TemplatePath.DEFAULT_DIR.listFiles((dir, name) -> name.toLowerCase().endsWith(".st"));
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (TemplatePath.isNamePermitted(file)) {
                    try {
                        list.add(new TemplateFile(file, sourceToClusterIds));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        for (String one : TemplatePath.STOCK_NAMES) {
            try {
                list.add(new TemplateFile(new TemplatePath(one, true), sourceToClusterIds));
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        Collections.sort(list);
        return list;
    }

    private static final String askForNewName(String title, String msg, String name) {
        InputDialog dialog = new InputDialog(WorkspaceUtils.getShell(), title, msg, name, text -> {
            if (!FilePath.isNameValidForFile((String)text)) {
                return TemplatesMessages.INVALID_FILE_NAME;
            }
            if (!text.equals(name)) {
                if (!TemplatePath.isNamePermitted(text)) {
                    return String.format(TemplatesMessages.EXISTS, text);
                }
                String[] list = TemplatePath.DEFAULT_DIR.list();
                if (list != null) {
                    String matchTo = text + ".st";
                    String[] stringArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String one = stringArray[n2];
                        if (one.equalsIgnoreCase(matchTo)) {
                            return String.format(TemplatesMessages.EXISTS, text);
                        }
                        ++n2;
                    }
                }
            }
            return null;
        });
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public TemplateAction(@NonNull BaseTimelineContent content, @NonNull List<@NonNull TemplateFile> templates, @NonNull Collection<@NonNull String> speKeys) {
        this.mContent = content;
        this.mTemplates = templates;
        this.mSpeKeys = speKeys;
        this.setImageDescriptor(StreamlinePlugin.getImageDescriptor("Templates.png"));
        this.setToolTipText(String.format(TemplatesMessages.TEMPLATE_TOOLTIP, KeyStroke.getInstance((int)ADD_MODIFIER).format(), KeyStroke.getInstance((int)INCLUDE_MISSING_SOURCES_MODIFIER).format()));
        this.setMenuCreator(this);
    }

    public final void dispose() {
        if (this.mMenu != null) {
            this.mMenu.dispose();
            this.mMenu = null;
        }
    }

    public final Menu getMenu(Control parent) {
        boolean includeMissingSeries;
        boolean add;
        if (parent instanceof IProvidesStateMaskAtMouseDown) {
            int state = ((IProvidesStateMaskAtMouseDown)parent).getStateMaskAtMouseDown();
            add = (state & ADD_MODIFIER) == ADD_MODIFIER;
            includeMissingSeries = (state & INCLUDE_MISSING_SOURCES_MODIFIER) == INCLUDE_MISSING_SOURCES_MODIFIER;
        } else {
            add = false;
            includeMissingSeries = false;
        }
        this.mMenu = new Menu(parent);
        if (add) {
            MenuItem notice = new MenuItem(this.mMenu, 8);
            notice.setText(TemplatesMessages.ADD_NOTICE);
            notice.setEnabled(false);
            ContextMenu.createSeparator(this.mMenu);
        }
        TemplateFile defTemplate = this.mContent.createDefaultTemplate(false);
        TemplateFile defEmptyTemplate = this.mContent.createDefaultTemplate(true);
        MenuItem defItem = this.createApplyTemplateMenuItem(TemplatesMessages.DEFAULT, defTemplate, add, includeMissingSeries);
        MenuItem defEmptyItem = !defTemplate.matches(defEmptyTemplate, true) ? this.createApplyTemplateMenuItem(TemplatesMessages.DEFAULT_EMPTY, defEmptyTemplate, add, includeMissingSeries) : null;
        ContextMenu.createSeparator(this.mMenu);
        TemplateFile currentTemplate = this.mContent.createTemplateFromCurrent();
        TemplateFile match = null;
        if (!this.mTemplates.isEmpty()) {
            MenuItem notice = new MenuItem(this.mMenu, 8);
            notice.setText(TemplatesMessages.CAPTURED_TEMPLATES);
            notice.setEnabled(false);
        }
        boolean capturedTemplateSelected = false;
        for (TemplateFile template : this.mTemplates) {
            boolean isCurrent;
            String name = template.getName();
            @NonNull String availableChartsSeriesCount = TemplateUtils.getValidSeriesMessage(template, Collections.emptyList(), this.mContent.getCaptureDataProvider().getAllBinData(), Collections.emptyList(), TemplateUtils.isValid(this.mContent.getCaptureDataProvider().getAllBinData()), TemplateUtils.TemplateSelectedFrom.Timeline);
            MenuItem item = this.createApplyTemplateMenuItem(name + availableChartsSeriesCount, template, add, includeMissingSeries);
            String tooltip = MessageFormat.format(TemplatesMessages.SERIES_SUPPORTED, availableChartsSeriesCount, TemplatesMessages.CAPTURE);
            item.setToolTipText(tooltip);
            boolean bl = isCurrent = template.compareTo(currentTemplate) == 0;
            if (!isCurrent) continue;
            item.setSelection(true);
            match = template;
            capturedTemplateSelected = true;
        }
        if (!this.mTemplates.isEmpty()) {
            ContextMenu.createSeparator(this.mMenu);
        }
        boolean saveEnabled = false;
        boolean seenNonStock = false;
        boolean seenStock = false;
        Map<String, TIntSet> sourcesToClusterId = this.mContent.getCaptureDataProvider().getSourceToClusterIdMap();
        Set<String> deviceCpuNames = this.getCpusOfDeviceUsedForCapture();
        Set<String> deviceGpuNames = this.getGpusOfDeviceUsedForCapture();
        for (TemplateFile one : TemplateAction.getAvailableTemplates(sourcesToClusterId)) {
            boolean hasValidSeries;
            Object name = one.getName();
            boolean isCurrent = one.compareTo(currentTemplate) == 0;
            boolean bl = hasValidSeries = TemplateUtils.getValidSeries(one, Collections.emptyList(), this.mContent.getCaptureDataProvider().getAllBinData(), Collections.emptyList(), TemplateUtils.isValid(this.mContent.getCaptureDataProvider().getAllBinData()), TemplateUtils.TemplateSelectedFrom.Timeline) != 0;
            if (!TemplateUtils.templateShouldBeAdded(one, deviceCpuNames, deviceGpuNames, this.mSpeKeys, hasValidSeries)) continue;
            @NonNull String availableChartsSeriesCount = TemplateUtils.getValidSeriesMessage(one, Collections.emptyList(), this.mContent.getCaptureDataProvider().getAllBinData(), Collections.emptyList(), TemplateUtils.isValid(this.mContent.getCaptureDataProvider().getAllBinData()), TemplateUtils.TemplateSelectedFrom.Timeline);
            if (isCurrent && !currentTemplate.matches(one, true)) {
                name = "*" + (String)name;
                saveEnabled = one.canSave();
            }
            if (((ITemplatePath)NullChecking.neverNull((Object)one.getPath())).isStock()) {
                if (!seenStock) {
                    seenStock = true;
                    if (seenNonStock) {
                        ContextMenu.createConditionalSeparator(this.mMenu);
                    }
                    notice = new MenuItem(this.mMenu, 8);
                    notice.setText(TemplatesMessages.BUILT_IN_TEMPLATES);
                    notice.setEnabled(false);
                }
            } else {
                if (!seenNonStock) {
                    notice = new MenuItem(this.mMenu, 8);
                    notice.setText(TemplatesMessages.USER_TEMPLATES);
                    notice.setEnabled(false);
                }
                seenNonStock = true;
            }
            MenuItem item = this.createApplyTemplateMenuItem((String)name + availableChartsSeriesCount, one, add, includeMissingSeries);
            String tooltip = MessageFormat.format(TemplatesMessages.SERIES_SUPPORTED, availableChartsSeriesCount, TemplatesMessages.CAPTURE);
            item.setToolTipText(tooltip);
            if (!isCurrent) continue;
            item.setSelection(true);
            match = one;
        }
        if (match == null && defTemplate.matches(currentTemplate, true)) {
            defItem.setSelection(true);
            match = defTemplate;
        } else if (match == null && defEmptyItem != null && defEmptyTemplate.matches(currentTemplate, true)) {
            defEmptyItem.setSelection(true);
            match = defEmptyTemplate;
        }
        ContextMenu.createConditionalSeparator(this.mMenu);
        this.createMenuItem(TemplatesMessages.INSTALL_AND_LOAD, true, () -> this.installAndLoad(includeMissingSeries, sourcesToClusterId));
        ContextMenu.createConditionalSeparator(this.mMenu);
        this.createMenuItem(TemplatesMessages.SAVE, saveEnabled, () -> this.save());
        this.createMenuItem(TemplatesMessages.SAVE_AS, true, () -> this.saveAs());
        boolean enabled = match != null && match != defTemplate && match.canSave() && !capturedTemplateSelected;
        this.createMenuItem(TemplatesMessages.RENAME, enabled, () -> this.rename());
        this.createMenuItem(TemplatesMessages.DELETE, enabled, () -> this.delete());
        return this.mMenu;
    }

    public static @NonNull Set<@NonNull String> getCpusOfDeviceUsedForCapture(@NonNull IClustersInfo clustersInfo) {
        return StreamUtils.filterOutNull(MapUtils.stream((TIntObjectMap)clustersInfo.getClusterNames()).map(p -> (String)NullChecking.neverNullOrNullable((Object)ClusterNameUtils.getArchName((String)((String)p.first)), (Object)((String)p.first)))).collect(Collectors.toSet());
    }

    private @NonNull Set<@NonNull String> getCpusOfDeviceUsedForCapture() {
        return TemplateAction.getCpusOfDeviceUsedForCapture(this.mContent.getCaptureDataProvider().getClustersInfo());
    }

    public final Menu getMenu(Menu parent) {
        return null;
    }

    public static @NonNull Set<@NonNull String> getGpusOfDeviceUsedForCapture(@NonNull IAllBinDataProvider allBinData) {
        TreeSet<String> result = new TreeSet<String>();
        List<? extends IBinDataProvider> selectedProviders = allBinData.getAllProviders();
        for (IBinDataProvider iBinDataProvider : selectedProviders) {
            Matcher matcher = TemplateUtils.TEMPLATE_GPU_NAME_PATTERN.matcher(iBinDataProvider.getChannelDescriptors()[0].deviceType.getName());
            if (!matcher.find() || matcher.groupCount() <= 0) continue;
            result.add((String)NullChecking.neverNull((Object)matcher.group(1)));
        }
        return result;
    }

    private @NonNull Set<@NonNull String> getGpusOfDeviceUsedForCapture() {
        return TemplateAction.getGpusOfDeviceUsedForCapture(this.mContent.getCaptureDataProvider().getAllBinData());
    }

    private final MenuItem createApplyTemplateMenuItem(String title, TemplateFile template, final boolean add, final boolean includeMissingSeries) {
        MenuItem item = new MenuItem(this.mMenu, 8);
        item.setText(title);
        item.setData((Object)template);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                TemplateAction.this.applyTemplate((TemplateFile)NullChecking.neverNull((Object)((TemplateFile)event.widget.getData())), add, includeMissingSeries);
            }
        });
        return item;
    }

    private final MenuItem createMenuItem(String title, boolean enabled, final Runnable runnable) {
        MenuItem item = new MenuItem(this.mMenu, 8);
        item.setText(title);
        item.setEnabled(enabled);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                runnable.run();
            }
        });
        return item;
    }

    private final void delete() {
        TemplateFile template = this.mContent.createTemplateFromCurrent();
        if (template.canSave()) {
            if (StreamlinePreferences.showDeleteTemplateConfirmDialog()) {
                String msg = MessageFormat.format(TemplatesMessages.DELETE_MESSAGE, template.getName());
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(WorkspaceUtils.getShell(), TemplatesMessages.DELETE, null, msg, 4, new String[]{TemplatesMessages.DELETE, TemplatesMessages.CANCEL}, 1, TemplatesMessages.ALWAYS, false);
                if (dialog.open() < 256) {
                    return;
                }
                if (dialog.getToggleState()) {
                    StreamlinePreferences.setShowDeleteTemplateConfirmDialog(false);
                }
            }
            ((File)NullChecking.neverNull((Object)template.getPathAsFile())).delete();
            this.mContent.setTemplateName(null);
        }
    }

    private final void installAndLoad(boolean includeMissingSources, @NonNull Map<@NonNull String, @NonNull TIntSet> sourcesToClusterId) {
        Optional<File> maybeFile = TemplateUtils.installAndLoad();
        if (maybeFile.isPresent()) {
            File file = maybeFile.get();
            String fileNameWithoutExtension = file.getName();
            int idx = fileNameWithoutExtension.lastIndexOf(46);
            if (idx > 0) {
                fileNameWithoutExtension = fileNameWithoutExtension.substring(0, idx);
            }
            try {
                this.applyTemplate(new TemplateFile(file, sourcesToClusterId), false, includeMissingSources);
            }
            catch (Exception exception) {
                Error.show(String.format(TemplatesMessages.UNABLE_TO_LOAD, fileNameWithoutExtension), exception, true);
                return;
            }
        }
    }

    private final void rename() {
        String name;
        String newName;
        TemplateFile template = this.mContent.createTemplateFromCurrent();
        if (template.canSave() && (newName = TemplateAction.askForNewName(String.format(TemplatesMessages.NEW_NAME, name = template.getName()), TemplatesMessages.RENAME_MESSAGE, name)) != null && !name.equalsIgnoreCase(newName)) {
            TemplatePath newPath = new TemplatePath(newName, false);
            if (((File)NullChecking.neverNull((Object)template.getPathAsFile())).renameTo(newPath.toFile())) {
                template.setPath(new TemplatePath(newName, false));
                this.mContent.setTemplateName(template.getName());
            } else {
                Error.show(String.format(TemplatesMessages.UNABLE_TO_RENAME, name, newName));
            }
        }
    }

    private final void save() {
        try {
            this.mContent.createTemplateFromCurrent().save();
        }
        catch (IOException exception) {
            Error.show(exception);
        }
    }

    private final void saveAs() {
        TemplateFile template = this.mContent.createTemplateFromCurrent();
        String baseName = template.getName();
        int count = 1;
        Object name = baseName;
        while (!TemplatePath.isNamePermitted((String)name) || new File(TemplatePath.DEFAULT_DIR, (String)name + ".st").exists()) {
            name = baseName + "_" + ++count;
        }
        String newName = TemplateAction.askForNewName(TemplatesMessages.SAVE_AS, TemplatesMessages.NAME, (String)name);
        if (newName != null) {
            template.setPath(new TemplatePath(newName, false));
            try {
                template.save();
                this.mContent.setTemplateName(template.getName());
            }
            catch (IOException exception) {
                Error.show(exception);
            }
        }
    }

    final void applyTemplate(@NonNull TemplateFile template, boolean add, boolean includeMissingSeries) {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        ChartsPanel chartsPanel = this.mContent.getChartsPanel();
        if (!add) {
            @NonNull ArrayList<@NonNull ChartHandlePanel> toBeRemovedCharts = new ArrayList<ChartHandlePanel>();
            int i = 0;
            while (i < chartsPanel.getChildCount()) {
                Block child = chartsPanel.getChild(i);
                if (child instanceof ChartHandlePanel && ((ChartHandlePanel)child).getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
                    toBeRemovedCharts.add((ChartHandlePanel)child);
                }
                ++i;
            }
            if (!toBeRemovedCharts.isEmpty()) {
                boolean remove;
                boolean bl = remove = !StreamlinePreferences.showRemoveChartConfirmDialog();
                if (remove) {
                    toBeRemovedCharts.stream().forEach(c -> {
                        c.removeFromParent();
                        c.getCaptureDataProvider().removeChart(c.getChart());
                    });
                } else {
                    RemoveChartsViewModel removeChartsViewModel = new RemoveChartsViewModel(toBeRemovedCharts);
                    RemoveChartsDialog removeChartsDialog = new RemoveChartsDialog(Display.getDefault().getActiveShell(), removeChartsViewModel);
                    int open = removeChartsDialog.open();
                    if (open != 1) {
                        removeChartsViewModel.getSelected().stream().forEach(c -> {
                            c.removeFromParent();
                            c.getCaptureDataProvider().removeChart(c.getChart());
                        });
                        if (((Boolean)removeChartsViewModel.getRemoveAll().getValue()).booleanValue() && ((Boolean)removeChartsViewModel.getRememberMe().getValue()).booleanValue()) {
                            StreamlinePreferences.setShowRemoveChartConfirmDialog(false);
                        }
                    } else {
                        return;
                    }
                }
            }
        }
        Block first = null;
        Block last = null;
        IntPredicate clusterFilter = TemplateUtils.makeClusterFilterPredicate(template, cdp.getClustersInfo());
        List<ChartAndSeriesConfig> toBeAppliedConfigs = TemplateUtils.getChartAndSeriesConfigsToBeApplied(template, includeMissingSeries, cdp.getAllBinData(), clusterFilter);
        for (ChartAndSeriesConfig toBeApplied : toBeAppliedConfigs) {
            IChartDataProvider chart;
            if (add && cdp.isDuplicateChart(toBeApplied) || (chart = cdp.addNewChart(toBeApplied)) == null) continue;
            last = new ChartHandlePanel(chartsPanel, chart);
            chartsPanel.add(last);
            if (first != null) continue;
            first = last;
        }
        chartsPanel.pack();
        if (last != null) {
            last.scrollIntoView();
        }
        if (first != null) {
            first.scrollIntoView();
        }
        chartsPanel.getRoot().layout();
        if (!add) {
            this.mContent.setTemplateName(template.getName());
        }
    }
}

