/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.templates;

import com.arm.databinding.PropertyOnObservable;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.templates.TemplatesMessages;
import com.arm.streamline.model.capture.IChartDataProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RemoveChartsViewModel {
    private final @NonNull WritableValue<@NonNull Boolean> observableRemoveAll = new WritableValue();
    private @NonNull IObservableValue<@NonNull Boolean> observableRememeberMe = new WritableValue();
    private final @NonNull IObservableValue<@NonNull Boolean> observableRememeberMeEnabled;
    private final @NonNull IObservableValue<@NonNull Boolean> observableSearchTextEnabled;
    private final @NonNull IObservableValue<@NonNull Boolean> observableChartTableEnabled;
    private final @NonNull WritableValue<@NonNull Boolean> observableRemoveSelected = new WritableValue();
    private @NonNull IObservableSet<@NonNull ChartHandlePanel> observableSelected = new WritableSet();
    private final @NonNull ComputedList<@NonNull ChartHandlePanel> observableAllVisible;
    final @NonNull WritableValue<@NonNull String> observableSearchText = new WritableValue();

    public RemoveChartsViewModel(final @NonNull List<@NonNull ChartHandlePanel> toBeRemovedCharts) {
        this.observableSelected.addAll(toBeRemovedCharts);
        this.observableSearchText.setValue((Object)"");
        this.observableAllVisible = new ComputedList<ChartHandlePanel>(){
            private String cachedSearchText;
            private Pattern compile;

            protected @NonNull List<@NonNull ChartHandlePanel> calculate() {
                @NonNull ArrayList<@NonNull ChartHandlePanel> visibleChartsonDialog = new ArrayList<ChartHandlePanel>();
                @Nullable String value = (String)RemoveChartsViewModel.this.observableSearchText.getValue();
                if (value.isEmpty()) {
                    visibleChartsonDialog.addAll(toBeRemovedCharts);
                    return visibleChartsonDialog;
                }
                if (this.cachedSearchText == null || !this.cachedSearchText.equals(value)) {
                    this.cachedSearchText = value;
                    try {
                        this.compile = RemoveChartsViewModel.this.getPatternCompiled(this.cachedSearchText);
                    }
                    catch (PatternSyntaxException exception) {
                        return Collections.emptyList();
                    }
                }
                toBeRemovedCharts.stream().forEach(c -> {
                    IChartDataProvider x = c.getChart();
                    String t = x.getTitle();
                    if (this.compile.matcher(t).find()) {
                        visibleChartsonDialog.add((ChartHandlePanel)c);
                    }
                });
                return visibleChartsonDialog;
            }
        };
        this.observableRememeberMeEnabled = ComputedValue.create(() -> (Boolean)this.observableRemoveAll.getValue());
        this.observableSearchTextEnabled = ComputedValue.create(() -> (Boolean)this.observableRemoveSelected.getValue());
        this.observableChartTableEnabled = ComputedValue.create(() -> (Boolean)this.observableRemoveSelected.getValue());
        this.observableRemoveAll.setValue((Object)Boolean.TRUE);
        this.observableRememeberMe.setValue((Object)Boolean.FALSE);
        this.observableRemoveSelected.setValue((Object)Boolean.FALSE);
        this.observableRemoveAll.addValueChangeListener(value -> {
            if (!((Boolean)value.diff.getNewValue()).booleanValue()) {
                this.observableRememeberMe.setValue((Object)Boolean.FALSE);
            }
        });
    }

    public @NonNull ComputedList<@NonNull ChartHandlePanel> getAll() {
        return this.observableAllVisible;
    }

    public @NonNull IObservableSet<@NonNull ChartHandlePanel> getSelected() {
        return this.observableSelected;
    }

    public IObservableValue<@NonNull String> getFilterText() {
        return this.observableSearchText;
    }

    public IObservableValue<@NonNull Boolean> getRemoveAll() {
        return this.observableRemoveAll;
    }

    public IObservableValue<@NonNull Boolean> getRemoveSelected() {
        return this.observableRemoveSelected;
    }

    public IObservableValue<@NonNull Boolean> getRememberMe() {
        return this.observableRememeberMe;
    }

    public @NonNull Predicate<@NonNull ChartHandlePanel> getCheckStatePredicate() {
        return v -> this.getSelected().contains(v);
    }

    public static IValueProperty<ChartHandlePanel, String> getChartInputProperty() {
        PropertyOnObservable<ChartHandlePanel, String> valueProperty = new PropertyOnObservable<ChartHandlePanel, String>(String.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull IObservableValue<@NonNull String> getObservable(@NonNull ChartHandlePanel source) {
                @NonNull WritableValue writableValue = new WritableValue();
                writableValue.setValue((Object)source.getTitle());
                return writableValue;
            }
        };
        return valueProperty;
    }

    public void deSelectAllVisible() {
        this.observableSelected.removeAll(this.getAll());
    }

    public void selectAllVisible() {
        this.observableSelected.addAll(this.getAll());
    }

    public IObservableValue<@NonNull Boolean> getRememeberMeEnabled() {
        return this.observableRememeberMeEnabled;
    }

    public IObservableValue<@NonNull Boolean> getSearchTextEnabled() {
        return this.observableSearchTextEnabled;
    }

    public IObservableValue<@NonNull Boolean> getChartTableEnabled() {
        return this.observableChartTableEnabled;
    }

    public @NonNull IValidator<@Nullable String> getPatternValidator() {
        return this::getPatternValidateStatus;
    }

    public @NonNull IStatus getPatternValidateStatus(@Nullable String value) {
        try {
            if (value != null) {
                this.getPatternCompiled(value);
            }
        }
        catch (PatternSyntaxException exception) {
            @NonNull String message = MessageFormat.format(TemplatesMessages.PATTERN_ERROR, exception.getDescription());
            return ValidationStatus.warning((String)message);
        }
        return ValidationStatus.ok();
    }

    Pattern getPatternCompiled(@NonNull String value) {
        return Pattern.compile(value, 2);
    }
}

