/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.templates;

import com.arm.databinding.dialog.AbstractValidatedTitleAreaDialog;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.templates.RemoveChartsViewModel;
import com.arm.streamline.editortabs.timeline.common.templates.TemplatesMessages;
import com.arm.streamline.utility.ui.ViewerCheckStateProvider;
import com.arm.utils.NullChecking;
import java.util.function.Predicate;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RemoveChartsDialog
extends AbstractValidatedTitleAreaDialog {
    CheckboxTableViewer chartsCheckTableViewer;
    RemoveChartsViewModel removeChartsViewModel;
    Text searchText;
    private Button removeAll;
    private Button removeSelected;
    Composite compositetree;
    private Button rememberMe;

    public RemoveChartsDialog(Shell parentShell, RemoveChartsViewModel removeChartsViewModel) {
        super(parentShell, TemplatesMessages.REMOVE_CHART_TITLE, TemplatesMessages.REMOVE_CHART_MESSAGE);
        this.removeChartsViewModel = removeChartsViewModel;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createRemoveSelection(container);
        this.createChartsLists(container);
        this.createRememerMe(container);
        this.setInitialState();
        return container;
    }

    private void createRememerMe(Composite container) {
        this.rememberMe = new Button(container, 32);
        this.rememberMe.setText(TemplatesMessages.REMEMBER_REMOVE_ALL);
        this.rememberMe.setSelection(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.rememberMe);
    }

    private void createRemoveSelection(Composite firstContent) {
        this.removeAll = new Button(firstContent, 16);
        this.removeAll.setText(TemplatesMessages.REMOVE_ALL);
        this.removeAll.setSelection(true);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeAll);
        this.removeSelected = new Button(firstContent, 16);
        this.removeSelected.setText(TemplatesMessages.REMOVE_SELECTED);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeSelected);
    }

    private void createChartsLists(Composite firstContent) {
        this.compositetree = new Group(firstContent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(this.compositetree);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.compositetree);
        this.searchText = new Text(this.compositetree, 33556868);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchText);
        this.searchText.setMessage(TemplatesMessages.TYPE_CHART_NAME);
        this.chartsCheckTableViewer = CheckboxTableViewer.newCheckList((Composite)this.compositetree, (int)2816);
        assert (this.chartsCheckTableViewer != null);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 200).applyTo((Control)this.chartsCheckTableViewer.getTable());
        ObservableSetContentProvider observableListContentProvider = new ObservableSetContentProvider();
        this.chartsCheckTableViewer.setContentProvider((IContentProvider)observableListContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.chartsCheckTableViewer, (int)1);
        this.createContextMenu();
    }

    private void createContextMenu() {
        final MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        final Action selectAll = new Action(TemplatesMessages.SELECT_ALL){

            public void run() {
                RemoveChartsDialog.this.removeChartsViewModel.selectAllVisible();
            }
        };
        final Action deSelectAll = new Action(TemplatesMessages.DESELECT_ALL){

            public void run() {
                RemoveChartsDialog.this.removeChartsViewModel.deSelectAllVisible();
            }
        };
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                mgr.add((IAction)selectAll);
                mgr.add((IAction)deSelectAll);
            }
        });
        this.chartsCheckTableViewer.getControl().setMenu(mgr.createContextMenu(this.chartsCheckTableViewer.getControl()));
    }

    protected @Nullable DataBindingContext initializeDataBindingContext() {
        DataBindingContext bindingContext = new DataBindingContext();
        IValueProperty<ChartHandlePanel, String> valueProperty = RemoveChartsViewModel.getChartInputProperty();
        ViewerSupport.bind((StructuredViewer)this.chartsCheckTableViewer, this.removeChartsViewModel.getAll(), valueProperty);
        @NonNull Predicate<@NonNull ChartHandlePanel> checkStatePredicate = this.removeChartsViewModel.getCheckStatePredicate();
        ViewerCheckStateProvider<@NonNull ChartHandlePanel> checkStateProvider = new ViewerCheckStateProvider<ChartHandlePanel>(checkStatePredicate);
        this.chartsCheckTableViewer.setCheckStateProvider(checkStateProvider);
        IViewerObservableSet observeCheckedElements = ViewerProperties.checkedElements(ChartHandlePanel.class).observe((Viewer)this.chartsCheckTableViewer);
        @NonNull IObservableSet<@NonNull ChartHandlePanel> chartsSelected = this.removeChartsViewModel.getSelected();
        bindingContext.bindSet((IObservableSet)observeCheckedElements, chartsSelected);
        ISWTObservableValue removeAllObserver = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.removeAll)));
        bindingContext.bindValue((IObservableValue)removeAllObserver, this.removeChartsViewModel.getRemoveAll());
        ISWTObservableValue rememberMeObserverEnabled = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.rememberMe));
        bindingContext.bindValue((IObservableValue)rememberMeObserverEnabled, this.removeChartsViewModel.getRememeberMeEnabled());
        ISWTObservableValue removeSelectedObserver = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.removeSelected)));
        bindingContext.bindValue((IObservableValue)removeSelectedObserver, this.removeChartsViewModel.getRemoveSelected());
        ISWTObservableValue searchTextEnableObserver = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.searchText));
        bindingContext.bindValue((IObservableValue)searchTextEnableObserver, this.removeChartsViewModel.getSearchTextEnabled());
        ISWTObservableValue chartTable = WidgetProperties.enabled().observe((Widget)this.chartsCheckTableViewer.getTable());
        bindingContext.bindValue((IObservableValue)chartTable, this.removeChartsViewModel.getChartTableEnabled());
        ISWTObservableValue rememberMeObserver = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.rememberMe)));
        bindingContext.bindValue((IObservableValue)rememberMeObserver, this.removeChartsViewModel.getRememberMe());
        ISWTObservableValue widgetText = WidgetProperties.text((int)24).observe((Widget)NullChecking.neverNull((Object)this.searchText));
        UpdateValueStrategy updateStrategy = new UpdateValueStrategy().setBeforeSetValidator(this.removeChartsViewModel.getPatternValidator());
        bindingContext.bindValue((IObservableValue)widgetText, this.removeChartsViewModel.getFilterText(), null, updateStrategy);
        return bindingContext;
    }

    private void setInitialState() {
        this.removeAll.setSelection(true);
        this.removeSelected.setSelection(false);
        this.chartsCheckTableViewer.getTable().setEnabled(false);
        this.searchText.setEnabled(false);
    }
}

