/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.ruler;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class CaliperEdgeTracker
extends TimelineDragTracker {
    private RulerPanel mRulerPanel;
    private boolean mLeft;

    public CaliperEdgeTracker(RulerPanel rulerPanel, Block block, boolean left) {
        super(block);
        this.mRulerPanel = rulerPanel;
        this.mLeft = left;
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        Calipers calipers = this.mRulerPanel.getBaseTimelineContent().getCaptureDataProvider().getCalipers();
        int x = where.x;
        int width = StreamlinePlugin.getImage((String)"CaliperLeft.png").getBounds().width / 2;
        Rectangle bounds = this.mRulerPanel.getLocalBounds();
        if (x < bounds.x + width) {
            x = bounds.x + width;
        } else if (x >= bounds.x + bounds.width - width) {
            x = bounds.x + bounds.width - width;
        }
        long slotIndex = this.mRulerPanel.translateToSlot(x);
        if (this.mLeft) {
            calipers.setLeft(Math.min(slotIndex, calipers.getRight() - 1L));
        } else {
            calipers.setRight(Math.max(slotIndex, calipers.getLeft() + 1L));
        }
        this.mRulerPanel.setupAutoScroll(where.x);
    }
}

