/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.model;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapUtils;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.utils.NullChecking;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMContextMenuSelectionModel {
    /*
     * WARNING - void declaration
     */
    public static @NonNull Set<@NonNull ICAMJob> selectWorkload(@NonNull Context ctx) {
        Stream<IGPUWorkloadJob> selectedJobs = CAMContextMenuSelectionModel.getSelectedGPUWorkloadJobs(ctx);
        ICAMJob clicked = ctx.clickedJob;
        if (clicked == null) {
            return Collections.emptySet();
        }
        ICAMJob iCAMJob = clicked;
        if (iCAMJob instanceof IGPUWorkloadJob) {
            void timelineJob;
            IGPUWorkloadJob iGPUWorkloadJob = (IGPUWorkloadJob)iCAMJob;
            IGPUWorkloadJob cfr_ignored_0 = (IGPUWorkloadJob)iCAMJob;
            if (!ctx.selectedJobs.contains(timelineJob)) {
                selectedJobs = Stream.of((IGPUWorkloadJob)NullChecking.neverNull((Object)timelineJob));
            }
        }
        Set selectedCommandBuffers = selectedJobs.map(job -> job.getTimelineWorkload()).collect(Collectors.toSet());
        Set<ICAMJob> jobsWithMatchingFrames = ctx.dataProvider.getAllJobsAsList().stream().filter(job -> {
            void gpuJob;
            ICAMJob iCAMJob = job;
            if (!(iCAMJob instanceof IGPUWorkloadJob)) return false;
            IGPUWorkloadJob iGPUWorkloadJob = (IGPUWorkloadJob)iCAMJob;
            IGPUWorkloadJob cfr_ignored_0 = (IGPUWorkloadJob)iCAMJob;
            if (!selectedCommandBuffers.contains(gpuJob.getTimelineWorkload())) return false;
            return true;
        }).collect(Collectors.toSet());
        return jobsWithMatchingFrames;
    }

    /*
     * WARNING - void declaration
     */
    public static @NonNull Set<@NonNull IGPUWorkloadJob> selectFrame(@NonNull Context ctx) {
        Stream<IGPUWorkloadJob> selectedJobs = CAMContextMenuSelectionModel.getSelectedGPUWorkloadJobs(ctx);
        ICAMJob clicked = ctx.clickedJob;
        if (clicked == null) {
            return Collections.emptySet();
        }
        ICAMJob iCAMJob = clicked;
        if (iCAMJob instanceof IGPUWorkloadJob) {
            void timelineJob;
            IGPUWorkloadJob iGPUWorkloadJob = (IGPUWorkloadJob)iCAMJob;
            IGPUWorkloadJob cfr_ignored_0 = (IGPUWorkloadJob)iCAMJob;
            if (!ctx.selectedJobs.contains(timelineJob)) {
                selectedJobs = Stream.of((IGPUWorkloadJob)NullChecking.neverNull((Object)timelineJob));
            }
        }
        Stream<Long> selectedframes = selectedJobs.map(job -> job.getTimelineWorkload().getFrame()).distinct();
        Set<IGPUWorkloadJob> jobsWithMatchingFrames = selectedframes.flatMap(frame -> context.dataProvider.getGPUWorkloadJobsAsList(frame.longValue()).stream()).collect(Collectors.toSet());
        return jobsWithMatchingFrames;
    }

    public static @NonNull Set<@NonNull ICAMJob> selectItemsInTimeRange(@NonNull Context ctx) {
        long end;
        @Nullable CrossSectionMarker marker = ctx.marker();
        @Nullable ZoomLevel zoomLevel = ctx.zoomLevel();
        if (marker == null || zoomLevel == null) {
            return Collections.emptySet();
        }
        long start = CustomActivityMapUtils.getTimeInNanoSeconds(zoomLevel, marker.getLeftAtDensestScale());
        if (start >= (end = CustomActivityMapUtils.getTimeInNanoSeconds(zoomLevel, marker.getRightAtDensestScale()))) {
            return Collections.emptySet();
        }
        return ctx.dataProvider().getTracksNonHierarchical().stream().flatMap(track -> track.getJobs(start, end).stream()).collect(Collectors.toSet());
    }

    /*
     * WARNING - void declaration
     */
    public static @NonNull Set<@NonNull ICAMJob> selectItemsByCommandBuffer(@NonNull Context ctx) {
        Stream<IGPUWorkloadJob> selectedJobs = CAMContextMenuSelectionModel.getSelectedGPUWorkloadJobs(ctx);
        ICAMJob clicked = ctx.clickedJob;
        if (clicked == null) {
            return Collections.emptySet();
        }
        ICAMJob iCAMJob = clicked;
        if (iCAMJob instanceof IGPUWorkloadJob) {
            void timelineJob;
            IGPUWorkloadJob iGPUWorkloadJob = (IGPUWorkloadJob)iCAMJob;
            IGPUWorkloadJob cfr_ignored_0 = (IGPUWorkloadJob)iCAMJob;
            if (!ctx.selectedJobs.contains(timelineJob)) {
                selectedJobs = Stream.of((IGPUWorkloadJob)NullChecking.neverNull((Object)timelineJob));
            }
        }
        Set selectedCommandBuffers = selectedJobs.map(job -> job.getPerfettoWorkload().commandBufferHandle()).filter(buffer -> buffer != null).collect(Collectors.toSet());
        Set<ICAMJob> jobsWithMatchingCommandBuffer = ctx.dataProvider.getAllJobsAsList().stream().filter(job -> {
            void gpuJob;
            ICAMJob iCAMJob = job;
            if (!(iCAMJob instanceof IGPUWorkloadJob)) return false;
            IGPUWorkloadJob iGPUWorkloadJob = (IGPUWorkloadJob)iCAMJob;
            IGPUWorkloadJob cfr_ignored_0 = (IGPUWorkloadJob)iCAMJob;
            if (!selectedCommandBuffers.contains(gpuJob.getPerfettoWorkload().commandBufferHandle())) return false;
            return true;
        }).collect(Collectors.toSet());
        return jobsWithMatchingCommandBuffer;
    }

    public static @NonNull Set<@NonNull ICAMJob> selectMatching(@NonNull Context ctx) {
        @Nullable Pattern pattern = ctx.filterPattern();
        if (pattern == null) {
            return Collections.emptySet();
        }
        return ctx.dataProvider().getAllJobsAsList().stream().filter(job -> pattern.matcher(job.getName()).find()).collect(Collectors.toSet());
    }

    public static boolean isWorkloadJob(@Nullable ICAMJob job) {
        return job instanceof IGPUWorkloadJob;
    }

    private static @NonNull Stream<@NonNull IGPUWorkloadJob> getSelectedGPUWorkloadJobs(@NonNull Context ctx) {
        return ctx.selectedJobs().stream().filter(job -> job instanceof IGPUWorkloadJob).map(j -> (IGPUWorkloadJob)j);
    }

    public record Context(@Nullable ICAMJob clickedJob, @NonNull Set<@NonNull ICAMJob> selectedJobs, @Nullable Pattern filterPattern, @Nullable CrossSectionMarker marker, @Nullable ZoomLevel zoomLevel, @NonNull ICAMDataProvider dataProvider) {
    }
}

