/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.heatmap;

import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.IFocusChartListener;
import com.arm.streamline.editortabs.timeline.common.IRowSelection;
import com.arm.streamline.editortabs.timeline.common.ITimelineConstants;
import com.arm.streamline.editortabs.timeline.common.IUniqueThreadSelectionHandler;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapWrapper;
import com.arm.streamline.editortabs.timeline.common.heatmap.IAnnotationFilterListener;
import com.arm.streamline.editortabs.timeline.common.heatmap.IHeatMapFilterListener;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICalipersListener;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Checks;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class HeatMapsPanel
extends Block
implements IUniqueThreadSelectionHandler,
IAnnotationFilterListener,
IHeatMapFilterListener,
IFocusChartListener,
IBookmarkListener,
IBlockLayout,
IScrollableBlock,
IHandleAreaListener,
ITimelinePositionListener,
IScaleListener,
ICrossSectionMarkerListener,
ICalipersListener,
ITimelineConstants,
IRowSelection {
    public static final int ROW_HEIGHT = FontInfo.get(Fonts.getNormal()).getHeight() + 4;
    public static final int SELECTION_NO_ENTRY_KEY = -1;
    public static final int SELECTION_NO_ENTRY_VALUE = -1;
    private final @NonNull BaseTimelineContent mContent;
    private @NonNull TIntIntHashMap mSelection = new TIntIntHashMap(10, 0.5f, -1, -1);
    private int mAnchorId = -1;
    private final @NonNull HeatMapWrapper mParentWrapper;
    private boolean notifySelectionChanged = true;

    private static final HeatMapHandlePanel find(Block parent, ITimelineRowProvider one) {
        int count = parent.getChildCount();
        int i = 0;
        while (i < count) {
            HeatMapHandlePanel handle;
            Block child = parent.getChild(i);
            if (child instanceof HeatMapHandlePanel && (handle = (HeatMapHandlePanel)child).getRow() == one) {
                return handle;
            }
            ++i;
        }
        return null;
    }

    private static final ITimelineRowProvider findRow(@NonNull List<@NonNull ITimelineRowProvider> rows, int id) {
        for (ITimelineRowProvider row : rows) {
            if (row.getUID() == id) {
                return row;
            }
            ITimelineRowProvider result = HeatMapsPanel.findRow(row.getChildren(), id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HeatMapsPanel(@NonNull BaseTimelineContent content, TIntHashSet selectedRowIds, @NonNull HeatMapWrapper parent) {
        this.mContent = content;
        this.mParentWrapper = parent;
        if (selectedRowIds != null) {
            for (int id : selectedRowIds) {
                int threadId = this.getThreadUIDForRow(id);
                if (threadId == -1) continue;
                this.mSelection.put(id, threadId);
            }
        }
        this.setFocusable(true);
        this.setLayout(this);
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        cdp.getMapProvider().setMode(TimelineMapMode.HEAT_MAP);
        this.updateForHeatMapFilter();
        this.mContent.getChartsPanel().addHandleAreaListener(this);
        this.mContent.getDividerPanel().addPositionListener(this);
        cdp.getScales().addListener((IScaleListener)this);
        cdp.getCrossSectionMarker().addListener(this);
        cdp.getCalipers().addListener(this);
        this.mContent.addFocusChartListener(this);
        this.mContent.addBookmarkListener(this);
        this.mContent.addHeatMapFilterListener(this);
        this.mContent.addAnnotationFilterListener(this);
    }

    @Override
    public final void annotationFilterChanged() {
        this.repaint();
    }

    @Override
    public final void bookmarkChanged() {
        this.repaint();
    }

    @Override
    public final void calipersChanged(Calipers calipers) {
        this.repaint();
    }

    @Override
    public final void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.repaint();
    }

    public final void deselect() {
        if (!this.mSelection.isEmpty()) {
            this.mSelection.clear();
            this.mAnchorId = -1;
            this.selectionWasChanged();
        }
    }

    public final void deselect(int id) {
        if (this.mSelection.remove(id) != this.mSelection.getNoEntryValue()) {
            if (this.mAnchorId == id) {
                this.selectNewAnchorId();
            }
            this.selectionWasChanged();
        }
    }

    public final void deselect(int ... ids) {
        boolean changed = false;
        boolean needNewAnchorId = false;
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (this.mSelection.remove(id) != this.mSelection.getNoEntryValue()) {
                changed = true;
                if (this.mAnchorId == id) {
                    needNewAnchorId = true;
                }
            }
            ++n2;
        }
        if (needNewAnchorId) {
            this.selectNewAnchorId();
        }
        if (changed) {
            this.selectionWasChanged();
        }
    }

    @Override
    public final void focusChartChanged() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        ITimelineMapProvider mapProvider = cdp.getMapProvider();
        if (mapProvider.focusChartChanged()) {
            this.updateForHeatMapFilter();
            this.pack();
        }
        this.repaint();
    }

    @Override
    public final int getHorizontalIncrement() {
        return 1;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            Point size = this.getChild(i).getMinimumSize(widthHint, -1);
            if (width < size.x) {
                width = size.x;
            }
            height += size.y;
        }
        return new Point(width, height);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            Point size = this.getChild(i).getPreferredSize(widthHint, -1);
            if (width < size.x) {
                width = size.x;
            }
            height += size.y;
        }
        return new Point(width, height);
    }

    public final @NonNull TIntIntHashMap getSelection() {
        return this.mSelection;
    }

    public final @NonNull TIntSet getSelectionRows() {
        return (TIntSet)Checks.requireNonNull((Object)this.mSelection.keySet());
    }

    public final @NonNull TIntSet getSelectionThreads() {
        return new TIntHashSet(this.mSelection.valueCollection());
    }

    @Override
    public final int getVerticalIncrement() {
        return ROW_HEIGHT;
    }

    @Override
    public final void handleAreaWidthChanged() {
        this.layoutAll();
    }

    @Override
    public final void heatMapFilterChanged() {
        this.updateForHeatMapFilter();
        this.pack();
    }

    public final boolean isSelected(int id) {
        return this.mSelection.contains(id);
    }

    @Override
    public final void layout(Block target) {
        Rectangle bounds = this.getLocalBounds();
        int count = this.getChildCount();
        int y = bounds.y;
        int i = 0;
        while (i < count) {
            Block child = this.getChild(i);
            int height = child.getPreferredSize((int)bounds.width, (int)-1).y;
            child.setBounds(bounds.x, y, bounds.width, height);
            y += height;
            ++i;
        }
    }

    public final void scaleChanged(Scales scales) {
        this.repaint();
    }

    public final void select(int id, boolean add) {
        int threadId;
        boolean changed = this.prepSelection(id, add);
        if (id != -1 && (threadId = this.getThreadUIDForRow(id)) != -1 && this.mSelection.put(id, threadId) == this.mSelection.getNoEntryValue()) {
            changed = true;
        }
        if (changed) {
            this.selectionWasChanged();
        }
    }

    public final void select(int id, int stateMask) {
        if (id != -1) {
            if (this.mAnchorId != -1 && (stateMask & SWT.MODIFIER_MASK) == SWT.MOD2) {
                this.select(this.mAnchorId, id, true);
            } else if ((stateMask & SWT.MODIFIER_MASK) == SWT.MOD1) {
                if (this.isSelected(id)) {
                    this.deselect(id);
                } else {
                    this.select(id, true);
                    this.mAnchorId = id;
                }
            } else if (this.isSelected(id)) {
                if (this.mSelection.size() > 1) {
                    this.select(id, false);
                } else {
                    this.deselect(id);
                }
            } else {
                this.select(id, false);
            }
        } else {
            this.deselect();
        }
    }

    public final void select(int fromId, int toId, boolean add) {
        boolean changed = this.prepSelection(fromId, add);
        int fromIndex = -1;
        int toIndex = -1;
        TIntArrayList list = new TIntArrayList();
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            this.addIdsToList((HeatMapHandlePanel)this.getChild(i), list);
            ++i;
        }
        count = list.size();
        i = 0;
        while (i < count) {
            int id = list.get(i);
            if (id == fromId) {
                fromIndex = i;
                if (toIndex != -1) break;
            }
            if (id == toId) {
                toIndex = i;
                if (fromIndex != -1) break;
            }
            ++i;
        }
        if (toIndex == -1 && fromIndex == -1) {
            this.deselect();
        } else {
            if (toIndex == -1) {
                toIndex = fromIndex;
            }
            if (fromIndex == -1) {
                fromIndex = toIndex;
            }
            if (fromIndex > toIndex) {
                int tmp = fromIndex;
                fromIndex = toIndex;
                toIndex = tmp;
            }
            i = fromIndex;
            while (i <= toIndex) {
                int rowId = list.get(i);
                int threadId = this.getThreadUIDForRow(rowId);
                if (threadId != -1 && this.mSelection.put(rowId, threadId) == this.mSelection.getNoEntryValue()) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                this.selectionWasChanged();
            }
        }
    }

    public final void setMode(String mode) {
        switch (mode) {
            case "core": {
                this.setInverted(false);
                this.setMode(TimelineMapMode.CORE_MAP);
                break;
            }
            case "cluster": {
                this.setInverted(false);
                this.setMode(TimelineMapMode.CLUSTER_MAP);
                break;
            }
            case "heat_inverted": {
                this.setInverted(true);
                this.setMode(TimelineMapMode.HEAT_MAP);
                break;
            }
            default: {
                this.setInverted(false);
                this.setMode(TimelineMapMode.HEAT_MAP);
            }
        }
        this.pack();
    }

    public final void setMode(@NonNull TimelineMapMode mode) {
        this.mContent.getCaptureDataProvider().getMapProvider().setMode(mode);
        this.repaint();
    }

    @Override
    public void timelinePositionChanged() {
        this.repaint();
    }

    @Override
    protected final boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        if (vertical) {
            return false;
        }
        DividerPanel dividerPanel = this.mContent.getDividerPanel();
        dividerPanel.setPosition(dividerPanel.getPosition() - (long)amount * dividerPanel.getScrollBar().getIncrement());
        return true;
    }

    private final void addIdsToList(HeatMapHandlePanel handle, TIntArrayList list) {
        list.add(handle.getRow().getUID());
        int count = handle.getChildCount();
        int i = 0;
        while (i < count) {
            Block child = handle.getChild(i);
            if (child instanceof HeatMapHandlePanel) {
                this.addIdsToList((HeatMapHandlePanel)child, list);
            }
            ++i;
        }
    }

    private final boolean addRow(Block parent, boolean parentIsOpen, ITimelineRowProvider row, int indent) {
        boolean passesFilter = row.passesFilter();
        HeatMapHandlePanel handle = new HeatMapHandlePanel(this.mContent, this, row, indent, this);
        for (ITimelineRowProvider child : row.getChildren()) {
            boolean bl = passesFilter = this.addRow(handle, parentIsOpen && row.isOpen(), child, indent + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width / 2 + 4) || passesFilter;
        }
        if (passesFilter && parentIsOpen) {
            parent.add(handle);
        }
        return passesFilter;
    }

    private final boolean prepSelection(int id, boolean add) {
        boolean changed = false;
        if (!add && !this.mSelection.isEmpty()) {
            this.mSelection.clear();
            changed = true;
        }
        if (!add || this.mAnchorId == -1) {
            this.mAnchorId = id;
        }
        return changed;
    }

    private final void selectionWasChanged() {
        if (this.notifySelectionChanged) {
            this.mContent.setProcessAndThreadSelectionFromUIDs(this.mParentWrapper, this.getSelectionThreads());
        }
        this.repaint();
        this.mContent.getChartsPanel().repaint();
    }

    private final void selectNewAnchorId() {
        this.mAnchorId = -1;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            if (this.selectNewAnchorId((HeatMapHandlePanel)this.getChild(i))) break;
            ++i;
        }
    }

    private final boolean selectNewAnchorId(HeatMapHandlePanel handle) {
        int id = handle.getRow().getUID();
        if (this.isSelected(id)) {
            this.mAnchorId = id;
            return true;
        }
        int count = handle.getChildCount();
        int i = 0;
        while (i < count) {
            Block child = handle.getChild(i);
            if (child instanceof HeatMapHandlePanel && this.selectNewAnchorId((HeatMapHandlePanel)child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final boolean show(ITimelineRowProvider row) {
        ArrayList<ITimelineRowProvider> rows = new ArrayList<ITimelineRowProvider>();
        while (row != null) {
            rows.add(0, row);
            row = row.getParent();
        }
        Block target = this;
        for (ITimelineRowProvider one : rows) {
            HeatMapHandlePanel handle;
            if (target instanceof HeatMapHandlePanel && !(handle = (HeatMapHandlePanel)target).isOpen()) {
                handle.setOpen(true);
            }
            if ((target = HeatMapsPanel.find(target, one)) != null) continue;
            return false;
        }
        target.scrollIntoView();
        return true;
    }

    private final void updateForHeatMapFilter() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        ITimelineMapProvider mapProvider = cdp.getMapProvider();
        Pattern pattern = this.mContent.getHeatMapFilterPattern();
        mapProvider.setFilterPattern(pattern);
        int i = this.getChildCount();
        while (--i >= 0) {
            this.remove(i);
        }
        for (ITimelineRowProvider row : mapProvider.getRootTimelineRows()) {
            this.addRow(this, true, row, 0);
        }
    }

    private void setInverted(boolean inverted) {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        ITimelineMapProvider mapProvider = cdp.getMapProvider();
        if (mapProvider.setInverted(inverted)) {
            this.updateForHeatMapFilter();
        }
    }

    public int getPreferredHandlePanelsWidth() {
        return Arrays.stream(this.getChildren()).filter(block -> block instanceof HeatMapHandlePanel).map(block -> (HeatMapHandlePanel)block).mapToInt(handlePanel -> handlePanel.getPreferredWidth()).max().orElse(0);
    }

    private int getThreadUIDForRow(int uid) {
        ITimelineRowProvider row = HeatMapsPanel.findRow(this.mContent.getCaptureDataProvider().getMapProvider().getRootTimelineRows(), uid);
        if (row == null) {
            return -1;
        }
        return row.getThreadLike();
    }

    @Override
    public void selectRow(int rowUID, int stateMask) {
        this.select(rowUID, stateMask);
    }

    @Override
    public void deselectRows(int[] array) {
        this.deselect(array);
    }

    @Override
    public boolean isRowSelected(int id) {
        return this.isSelected(id);
    }

    @Override
    public void handleUniqueThreadSelection(IUniqueID[] uniqueIDs) {
        if (uniqueIDs == null || uniqueIDs.length == 0) {
            this.deselect();
            return;
        }
        List<ITimelineRowProvider> rows = this.mContent.getCaptureDataProvider().getMapProvider().getRootTimelineRows();
        int anchorId = -1;
        TIntIntHashMap selection = new TIntIntHashMap();
        int i = uniqueIDs.length;
        while (--i >= 0) {
            IUniqueID uniqueThread = uniqueIDs[i];
            if (uniqueThread == null) continue;
            int id = uniqueThread.getUID();
            ITimelineRowProvider row = HeatMapsPanel.findRow(rows, id);
            if (row == null && uniqueThread instanceof UniqueThread) {
                id = ((UniqueThread)uniqueThread).getProcess().getUID();
                row = HeatMapsPanel.findRow(rows, id);
            }
            assert (row != null);
            if (selection.put(id, this.getThreadUIDForRow(id)) != selection.getNoEntryValue()) continue;
            this.show(row);
            anchorId = id;
        }
        this.mSelection = selection;
        this.mAnchorId = anchorId;
        this.selectionWasChanged();
    }

    public void selectUIDs(@NonNull TIntSet selection, boolean notifyChange) {
        boolean previousNotify = this.notifySelectionChanged;
        this.notifySelectionChanged = notifyChange;
        try {
            if (this.mSelection.keySet().equals((Object)selection)) {
                return;
            }
            if (selection.isEmpty()) {
                this.deselect();
                return;
            }
            List<ITimelineRowProvider> rows = this.mContent.getCaptureDataProvider().getMapProvider().getRootTimelineRows();
            int anchorId = -1;
            this.mSelection.clear();
            for (int uid : selection) {
                ITimelineRowProvider row = HeatMapsPanel.findRow(rows, uid);
                if (row == null) continue;
                this.mSelection.put(uid, row.getThreadLike());
                this.show(row);
                anchorId = uid;
            }
            this.mAnchorId = anchorId;
            this.selectionWasChanged();
        }
        finally {
            this.notifySelectionChanged = previousNotify;
        }
    }

    @Override
    public void heatMapModeChanged() {
        this.repaint();
    }
}

