/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.heatmap;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.HandlePanel;
import com.arm.streamline.editortabs.timeline.common.IRowSelection;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapMessages;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapPanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapsPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class HeatMapHandlePanel
extends HandlePanel<ITimelineRowProvider> {
    private final @NonNull ITimelineRowProvider mRow;
    private HeatMapPanel mHeatMapPanel;
    private final @NonNull HeatMapsPanel mHeatMapsPanel;

    public HeatMapHandlePanel(@NonNull BaseTimelineContent content, @NonNull HeatMapsPanel heatMapsPanel, @NonNull ITimelineRowProvider row, int indent, @NonNull IRowSelection selection) {
        super(content, indent, selection, HeatMapsPanel.ROW_HEIGHT);
        this.mHeatMapsPanel = heatMapsPanel;
        this.mRow = row;
        this.mHeatMapPanel = new HeatMapPanel(this);
        this.setLayout(this);
        this.add(this.mHeatMapPanel);
    }

    private final @NonNull HeatMapsPanel getHeatMapsPanel() {
        return this.mHeatMapsPanel;
    }

    public @NonNull ITimelineRowProvider getRow() {
        return this.mRow;
    }

    @Override
    protected void setRelatedControlBounds(int i, int y, int j, int rowHeight) {
        this.mHeatMapPanel.setBounds(i, y, j, rowHeight);
    }

    @Override
    protected Color getForegroundColor() {
        switch (this.mRow.getRowType()) {
            case GROUP: 
            case ANNOTATION: {
                return Colors.getBlue();
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: 
            case CPU: {
                return this.mRow.isOpen() ? Colors.getDarkGray() : Colors.getBlack();
            }
        }
        throw new AssertionError((Object)this.mRow.getRowType());
    }

    @Override
    public int getRowUID() {
        return this.mRow.getUID();
    }

    @Override
    protected String getResizeGripToolTipText() {
        switch (this.mRow.getRowType()) {
            case GROUP: 
            case ANNOTATION: {
                return HeatMapMessages.IS_ANNOTATION;
            }
            case PROCESS: 
            case THREAD: 
            case VMUID: 
            case CPU: {
                return this.shouldShowAnnotationMarker(this.getRow()) ? HeatMapMessages.HAS_ANNOTATION : null;
            }
        }
        throw new AssertionError((Object)this.mRow.getRowType());
    }

    @Override
    protected @NonNull String getTitle() {
        return this.getRow().getName();
    }

    @Override
    public void setRowOpenness(boolean open) {
        this.getRow().setOpenness(open);
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getRowChildren() {
        return this.getRow().getChildren();
    }

    @Override
    protected boolean isRowOpen() {
        return this.getRow().isOpen();
    }

    @Override
    protected boolean shouldShowAnnotationMarkerForRow() {
        return this.shouldShowAnnotationMarker(this.getRow());
    }

    @Override
    protected Block getTopmostContainerBlock() {
        return this.getHeatMapsPanel();
    }

    protected HeatMapHandlePanel constructChildPanel(ITimelineRowProvider row) {
        return new HeatMapHandlePanel(this.getContent(), this.mHeatMapsPanel, row, this.mIndent + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width / 2 + 4, this.mSelection);
    }

    @Override
    protected boolean passesFilter(ITimelineRowProvider row) {
        return row.passesFilter();
    }

    @Override
    protected final List<ITimelineRowProvider> getRowSiblings() {
        if (this.getParent() instanceof HeatMapsPanel) {
            return this.getContent().getCaptureDataProvider().getMapProvider().getRootTimelineRows();
        }
        if (this.getParent() instanceof HeatMapHandlePanel) {
            return ((HeatMapHandlePanel)this.getParent()).getRowChildren();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected @Nullable DragTracker createMoveTracker(Point where) {
        return new MoveTracker(where);
    }

    @Override
    protected void showHandlePanelContextMenu(Point locationInDisplayCoords) {
    }

    @Override
    protected @Nullable Image getIconImage() {
        return HeatMapHandlePanel.getIconForRow(this.mRow);
    }

    public static @Nullable Image getIconForRow(@NonNull ITimelineRowProvider row) {
        switch (row.getRowType()) {
            case ANNOTATION: {
                return null;
            }
            case GROUP: {
                return null;
            }
            case PROCESS: {
                return StreamlinePlugin.getImage("Process.png");
            }
            case THREAD: {
                return StreamlinePlugin.getImage("Thread.gif");
            }
            case VMUID: {
                return StreamlinePlugin.getImage("VirtualMachine.png");
            }
            case CPU: {
                return StreamlinePlugin.getImage("CpuIcon.png");
            }
        }
        return null;
    }

    private class MoveTracker
    extends TimelineDragTracker
    implements PaintListener {
        private Point mStartPosition;
        private int mStartY;
        private int mPosition;
        private Shell mShell;

        public MoveTracker(Point where) {
            super(HeatMapHandlePanel.this);
            Point displayCoordsPoint = new Point(where.x, where.y);
            this.mStartY = HeatMapHandlePanel.this.toDisplay((Point)displayCoordsPoint).y;
            this.mStartPosition = HeatMapHandlePanel.this.toDisplay(0, 0);
            this.mPosition = this.mStartPosition.y;
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            if (this.mShell == null) {
                HeatMapHandlePanel.this.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
                HeatMapHandlePanel.this.repaint();
                this.mShell = new Shell(HeatMapHandlePanel.this.getShell(), 537133064);
                this.mShell.setAlpha(192);
                this.mShell.addPaintListener((PaintListener)this);
                Rectangle bounds = HeatMapHandlePanel.this.getLocalBounds();
                this.mShell.setBounds(this.mStartPosition.x, this.mStartPosition.y, bounds.width, bounds.height);
                this.mShell.setCursor(StreamlinePlugin.getClosedHandCursor());
                this.mShell.setVisible(true);
            }
            HeatMapHandlePanel.this.setupAutoScroll(where.y);
            HeatMapHandlePanel.this.toDisplay(where);
            this.mPosition = this.mStartPosition.y + where.y - this.mStartY;
            this.mShell.setLocation(this.mStartPosition.x, this.mPosition);
            HeatMapHandlePanel.this.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
            Block parent = HeatMapHandlePanel.this.getParent();
            Block[] siblings = parent.getChildren();
            List<ITimelineRowProvider> rowSiblings = HeatMapHandlePanel.this.getRowSiblings();
            HeatMapHandlePanel insertBeforeSibling = null;
            parent.fromDisplay(where);
            Block[] blockArray = siblings;
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                Block sibling = blockArray[n2];
                if (sibling instanceof HeatMapHandlePanel && sibling.getY() + sibling.getHeight() / 2 > where.y) {
                    insertBeforeSibling = (HeatMapHandlePanel)sibling;
                    break;
                }
                ++n2;
            }
            if (parent.move(HeatMapHandlePanel.this, insertBeforeSibling)) {
                rowSiblings.remove(HeatMapHandlePanel.this.getRow());
                int index = insertBeforeSibling == null ? rowSiblings.size() : rowSiblings.indexOf(insertBeforeSibling.getRow());
                rowSiblings.add(index, HeatMapHandlePanel.this.getRow());
                parent.layout();
            }
        }

        @Override
        public void mouseDown(Point where, int button, int stateMask, int count) {
            super.mouseDown(where, button, stateMask, count);
            if (HeatMapHandlePanel.this.isOverSelectionArea(where)) {
                HeatMapHandlePanel.this.mSelection.selectRow(HeatMapHandlePanel.this.getRowUID(), stateMask);
            }
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            HeatMapHandlePanel.this.repaint();
            HeatMapHandlePanel.this.getOwner().applyCursor(null);
            if (this.mShell != null) {
                this.mShell.dispose();
                this.mShell = null;
            }
            super.mouseUp(where, button, stateMask, count);
        }

        public final void paintControl(PaintEvent event) {
            GC gc = new GC(event.gc);
            HeatMapHandlePanel.this.paintAsRoot(gc);
        }
    }
}

