/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.csm;

import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.csm.CrossSectionHandlePanel;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Point;

class HandleTracker
extends TimelineDragTracker {
    private CrossSectionHandlePanel mCrossSectionHandlePanel;
    private long mStartSlot;
    private long mStartLeft;
    private long mStartRight;

    HandleTracker(CrossSectionHandlePanel crossSectionHandlePanel, Block block, int x) {
        super(block);
        this.mCrossSectionHandlePanel = crossSectionHandlePanel;
        this.mStartSlot = this.mCrossSectionHandlePanel.translateToSlot(x);
        CrossSectionMarker csm = this.mCrossSectionHandlePanel.getBaseTimelineContent().getCaptureDataProvider().getCrossSectionMarker();
        this.mStartLeft = csm.getLeft();
        this.mStartRight = csm.getRight();
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        CrossSectionMarker csm = this.mCrossSectionHandlePanel.getBaseTimelineContent().getCaptureDataProvider().getCrossSectionMarker();
        long delta = this.mCrossSectionHandlePanel.translateToSlot(where.x) - this.mStartSlot;
        if (delta < -this.mStartLeft) {
            if (this.mStartLeft == this.mStartRight) {
                csm.reset();
                return;
            }
            delta = -this.mStartLeft;
        } else {
            long maxDelta = csm.getMax() + 1L - this.mStartRight;
            if (delta > maxDelta) {
                delta = maxDelta;
            }
        }
        csm.set(this.mStartLeft + delta, this.mStartRight + delta);
        this.mCrossSectionHandlePanel.setupAutoScroll(where.x);
    }
}

