/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.csm;

import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.csm.CrossSectionHandlePanel;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Point;

class HandleEdgeTracker
extends TimelineDragTracker {
    private CrossSectionHandlePanel mCrossSectionHandlePanel;
    private long mStartSlot;
    private long mStart;
    private boolean mLeft;

    HandleEdgeTracker(CrossSectionHandlePanel crossSectionHandlePanel, Block block, int x, boolean left) {
        super(block);
        this.mCrossSectionHandlePanel = crossSectionHandlePanel;
        this.mStartSlot = this.mCrossSectionHandlePanel.translateToSlot(x);
        this.mLeft = left;
        CrossSectionMarker csm = this.mCrossSectionHandlePanel.getBaseTimelineContent().getCaptureDataProvider().getCrossSectionMarker();
        long l = this.mStart = left ? csm.getLeft() : csm.getRight();
        if (this.mStart < 0L) {
            this.mStart = 0L;
        }
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        CrossSectionMarker csm = this.mCrossSectionHandlePanel.getBaseTimelineContent().getCaptureDataProvider().getCrossSectionMarker();
        long slotIndex = this.mStart + this.mCrossSectionHandlePanel.translateToSlot(where.x) - this.mStartSlot;
        if (this.mLeft) {
            csm.setLeft(Math.min(slotIndex, csm.getRight()));
        } else {
            csm.setRight(Math.max(slotIndex, csm.getLeft()));
        }
        this.mCrossSectionHandlePanel.setupAutoScroll(where.x);
    }
}

