/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.utility.text.ScaledFormat;
import com.arm.utils.ArrayUtils;
import com.arm.utils.NullChecking;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SharedLimitCalculator {
    public static final boolean ALWAYS_PERCENT_OUT_100 = true;
    private ICaptureDataProvider captureDataProvider;
    private Key lastKey = null;
    private Result lastResult = null;

    public static double getPlateau(@NonNull IChartDataProvider chart, boolean open, boolean applyLog10IfNeeded) {
        double plateau;
        if (chart.isPercentage()) {
            return 1.0;
        }
        double d = plateau = open ? chart.getCoreLimit() : chart.getAggregateLimit();
        if (applyLog10IfNeeded && chart.getSeriesComposition() == SeriesComposition.LOG10) {
            plateau = Math.log10(plateau);
        }
        return NumberUtils.calculateLimit((double)plateau, (boolean)ScaledFormat.shouldUseKibi(chart.getUnits()));
    }

    private static @NonNull Result createResultCommon(@NonNull IChartDataProvider chart, int first, int last, @Nullable TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @Nullable [] channelDescriptors, double[][][] perSeriesData) {
        int channelCount = channelDescriptors != null ? channelDescriptors.length : 1;
        ResultState resultState = new ResultState(chart);
        int channelIndex = 0;
        while (channelIndex < channelCount) {
            int seriesIndex = seriesList.size();
            while (--seriesIndex >= 0) {
                ISeriesDataProvider series = seriesList.get(seriesIndex);
                double[] data = channelDescriptors != null ? series.getData(channelDescriptors[channelIndex], first, last, selection) : series.getData(first, last, selection);
                perSeriesData[channelIndex][seriesIndex] = data;
                resultState.update(series, selection, data);
            }
            resultState.endOfChannel();
            ++channelIndex;
        }
        resultState.complete(channelDescriptors != null);
        return new Result(resultState.updateLimit, resultState.limitIsDirty, resultState.stackedLimit, resultState.allLessThan1 || resultState.allSeriesLessThan1 ? 1 : 100, perSeriesData, seriesList, channelDescriptors);
    }

    private static Result createResultHeatMapChart(@NonNull IChartDataProvider chart, int first, int last, TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, double[][][] perSeriesData) {
        return SharedLimitCalculator.createResultCommon(chart, first, last, selection, seriesList, channelDescriptors, perSeriesData);
    }

    private static @NonNull Result createResultNormalChart(@NonNull IChartDataProvider chart, int first, int last, @Nullable TIntSet selection, boolean open) {
        ProcessingElementReference[] channelDescriptors = open ? chart.getCoreInformationProvider().getChannelDescriptors() : null;
        List<ISeriesDataProvider> seriesList = chart.getSeries();
        int channelCount = channelDescriptors != null ? channelDescriptors.length : 1;
        double[][][] perSeriesData = new double[channelCount][seriesList.size()][];
        return SharedLimitCalculator.createResultCommon(chart, first, last, selection, seriesList, channelDescriptors, perSeriesData);
    }

    private static double[] getSeriesData(int first, @Nullable TIntSet selection, @NonNull ProcessingElementReference @Nullable [] channelDescriptors, int previousLast, @NonNull HorizontalScrollDirection dir, int channelIndex, int remaning, @NonNull ISeriesDataProvider series) {
        double[] data = null;
        int start = dir == HorizontalScrollDirection.RIGHT ? previousLast + 1 : first;
        int end = dir == HorizontalScrollDirection.RIGHT ? previousLast + remaning : first + remaning - 1;
        data = channelDescriptors != null ? series.getData(channelDescriptors[channelIndex], start, end, selection) : series.getData(start, end, selection);
        return data;
    }

    public SharedLimitCalculator(ICaptureDataProvider captureDataProvider) {
        this.captureDataProvider = captureDataProvider;
    }

    public @NonNull Result calculateHeatMap(@NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
        Key key = new Key(Type.HEAT_MAP, chart, zoomLevel, first, last, slots, selection);
        if (!NullChecking.equalsNullable((Object)this.lastKey, (Object)key)) {
            @NonNull List<@NonNull ISeriesDataProvider> seriesList = chart.getSeries();
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channelDescriptors = coreInformationProvider.getChannelDescriptors();
            Key lastKey = this.lastKey;
            Result lastResult = this.lastResult;
            if (lastKey != null && lastResult != null && lastKey.zoomLevel == zoomLevel && chart.equals(lastKey.chart) && key.selectionHashCode == lastKey.selectionHashCode) {
                int previousFirst = lastKey.first;
                int previousLast = lastKey.last;
                boolean isSuccess = false;
                if (previousLast > first && previousFirst < first && last > previousLast) {
                    isSuccess = this.updateResultHeatMapChart(first, last, selection, seriesList, channelDescriptors, lastResult, previousFirst, previousLast, HorizontalScrollDirection.RIGHT, chart);
                } else if (last > previousFirst && previousLast > last && previousFirst > first) {
                    isSuccess = this.updateResultHeatMapChart(first, last, selection, seriesList, channelDescriptors, lastResult, previousFirst, previousLast, HorizontalScrollDirection.LEFT, chart);
                }
                if (isSuccess) {
                    this.lastKey = key;
                    return (Result)NullChecking.neverNull((Object)lastResult);
                }
            }
            double[][][] perSeriesData = new double[channelDescriptors.length][seriesList.size()][];
            Result result = SharedLimitCalculator.createResultHeatMapChart(chart, first, last, selection, seriesList, channelDescriptors, perSeriesData);
            this.lastKey = key;
            this.lastResult = result;
        }
        return (Result)NullChecking.neverNull((Object)this.lastResult);
    }

    public @NonNull Result calculateNormal(boolean open, @NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
        Type type = open ? Type.OPEN : Type.CLOSED;
        Key key = new Key(type, chart, zoomLevel, first, last, slots, selection);
        if (!NullChecking.equalsNullable((Object)this.lastKey, (Object)key)) {
            List<@NonNull ISeriesDataProvider> seriesList = chart.getSeries();
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = chart.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channelDescriptors = coreInformationProvider.getChannelDescriptors();
            Key lastKey = this.lastKey;
            Result lastResult = this.lastResult;
            if (lastKey != null && lastResult != null && lastKey.zoomLevel == zoomLevel && chart.equals(lastKey.chart) && key.selectionHashCode == lastKey.selectionHashCode) {
                int previousFirst = lastKey.first;
                int previousLast = lastKey.last;
                boolean isSuccess = false;
                if (previousLast > first && previousFirst < first && last > previousLast) {
                    isSuccess = this.updateResultNormalChart(open, first, last, selection, seriesList, channelDescriptors, lastResult, previousFirst, previousLast, HorizontalScrollDirection.RIGHT, chart);
                } else if (last > previousFirst && previousLast > last && previousFirst > first) {
                    isSuccess = this.updateResultNormalChart(open, first, last, selection, seriesList, channelDescriptors, lastResult, previousFirst, previousLast, HorizontalScrollDirection.LEFT, chart);
                }
                if (isSuccess) {
                    this.lastKey = key;
                    return (Result)NullChecking.neverNull((Object)lastResult);
                }
            }
            @NonNull Result result = SharedLimitCalculator.createResultNormalChart(chart, first, last, selection, open);
            this.lastKey = key;
            this.lastResult = result;
            return result;
        }
        return (Result)NullChecking.neverNull((Object)this.lastResult);
    }

    public void clear() {
        this.lastKey = null;
        this.lastResult = null;
    }

    private int getLastBinCount(HorizontalScrollDirection dir) {
        int lastBinCount = 0;
        if (((ICaptureDataProvider)NullChecking.neverNull((Object)this.captureDataProvider)).isLive() && dir == HorizontalScrollDirection.RIGHT) {
            lastBinCount = this.captureDataProvider.getLastBinCount() - 10;
        }
        return lastBinCount;
    }

    private boolean updateResultCommon(@NonNull IChartDataProvider chart, int first, int last, @Nullable TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @Nullable [] channelDescriptors, @NonNull Result previousResult, int previousFirst, int previousLast, @NonNull HorizontalScrollDirection dir) {
        int liveDelta;
        ResultState resultState = new ResultState(chart);
        double[][][] perSeriesData = previousResult.perSeriesData;
        int newRange = last - first + 1;
        int startingIndex = dir == HorizontalScrollDirection.RIGHT ? first - previousFirst : previousFirst - first;
        int count = channelDescriptors != null ? channelDescriptors.length : 1;
        int lastBinCount = this.getLastBinCount(dir);
        if (lastBinCount > 0) {
            liveDelta = previousLast - lastBinCount;
            previousLast = lastBinCount;
        } else {
            liveDelta = 0;
        }
        int channelIndex = 0;
        while (channelIndex < count) {
            int mseriesIndex = seriesList.size();
            while (--mseriesIndex >= 0) {
                double[] ds = perSeriesData[channelIndex][mseriesIndex];
                if (ds.length >= previousLast - previousFirst + 1) {
                    int remaining;
                    double[] newSetofData = new double[newRange];
                    if (dir == HorizontalScrollDirection.RIGHT) {
                        int nToCopy = ds.length - startingIndex - liveDelta;
                        assert (nToCopy <= newSetofData.length);
                        assert (startingIndex + nToCopy <= ds.length);
                        System.arraycopy(ds, startingIndex, newSetofData, 0, nToCopy);
                        remaining = newSetofData.length - (ds.length - startingIndex - liveDelta);
                    } else {
                        System.arraycopy(ds, 0, newSetofData, startingIndex, newSetofData.length - startingIndex);
                        remaining = startingIndex;
                    }
                    ISeriesDataProvider series = seriesList.get(mseriesIndex);
                    double[] data = SharedLimitCalculator.getSeriesData(first, selection, channelDescriptors, previousLast, dir, channelIndex, remaining, series);
                    int copyStartIndex = dir == HorizontalScrollDirection.RIGHT ? ds.length - startingIndex - liveDelta : 0;
                    int j = 0;
                    while (j < data.length && copyStartIndex < newSetofData.length) {
                        newSetofData[copyStartIndex] = data[j];
                        ++copyStartIndex;
                        ++j;
                    }
                    perSeriesData[channelIndex][mseriesIndex] = newSetofData;
                    resultState.update(series, selection, newSetofData);
                    continue;
                }
                return false;
            }
            resultState.endOfChannel();
            ++channelIndex;
        }
        resultState.complete(channelDescriptors != null);
        previousResult.actualLimit = resultState.stackedLimit;
        previousResult.percentScaleDivisor = resultState.allLessThan1 || resultState.allSeriesLessThan1 ? 1 : 100;
        previousResult.updateLimit = resultState.updateLimit;
        previousResult.limitIsDirty = resultState.limitIsDirty;
        return true;
    }

    private boolean updateResultHeatMapChart(int first, int last, @Nullable TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, @NonNull Result previousResult, int previousFirst, int previousLast, @NonNull HorizontalScrollDirection dir, @NonNull IChartDataProvider chart) {
        return this.updateResultCommon(chart, first, last, selection, seriesList, channelDescriptors, previousResult, previousFirst, previousLast, dir);
    }

    private boolean updateResultNormalChart(boolean open, int first, int last, @Nullable TIntSet selection, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @NonNull [] channelDescriptors, @NonNull Result previousResult, int previousFirst, int previousLast, @NonNull HorizontalScrollDirection dir, @NonNull IChartDataProvider chart) {
        return this.updateResultCommon(chart, first, last, selection, seriesList, (ProcessingElementReference[])(open ? channelDescriptors : null), previousResult, previousFirst, previousLast, dir);
    }

    public static enum HorizontalScrollDirection {
        LEFT,
        RIGHT;

    }

    private static final class Key {
        public final @NonNull IChartDataProvider chart;
        public final int first;
        public final int last;
        public final int selectionHashCode;
        public final @NonNull List<@NonNull ISeriesDataProvider> series;
        public final int slots;
        public final @NonNull Type type;
        public final @NonNull ZoomLevel zoomLevel;

        public Key(@NonNull Type type, @NonNull IChartDataProvider chart, @NonNull ZoomLevel zoomLevel, int first, int last, int slots, @Nullable TIntSet selection) {
            this.type = type;
            this.chart = chart;
            this.zoomLevel = zoomLevel;
            this.first = first;
            this.last = last;
            this.slots = slots;
            this.selectionHashCode = selection != null ? selection.hashCode() : 0;
            this.series = new ArrayList<ISeriesDataProvider>(chart.getSeries());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                int end = Math.min(this.last, this.slots);
                int thatEnd = Math.min(that.last, that.slots);
                return this.type == that.type && this.first == that.first && end == thatEnd && this.chart.equals(that.chart) && this.zoomLevel.equals((Object)that.zoomLevel) && this.series.equals(that.series) && this.selectionHashCode == that.selectionHashCode;
            }
            return false;
        }

        public int hashCode() {
            return ((((((this.chart.hashCode() * 31 + this.first) * 31 + this.last) * 31 + this.zoomLevel.hashCode()) * 31 + this.selectionHashCode) * 31 + this.slots) * 31 + this.series.hashCode()) * 31 + this.type.hashCode();
        }

        public String toString() {
            return String.format("Key [chart=%s, first=%s, last=%s, slots=%s, type=%s, selectionHashCode=%s]", new Object[]{this.chart.getTitle(), this.first, this.last, this.slots, this.type, this.selectionHashCode});
        }
    }

    public static final class Result {
        public double actualLimit;
        public double percentScaleDivisor;
        public boolean limitIsDirty;
        public final double[][][] perSeriesData;
        public final @NonNull List<@NonNull ISeriesDataProvider> seriesList;
        public boolean updateLimit;
        private final @NonNull ProcessingElementReference @Nullable [] channelDescriptors;

        public Result(boolean updateLimit, boolean limitIsDirty, double actualLimit, double percentScaleDivisor, double[][][] perSeriesData, @NonNull List<@NonNull ISeriesDataProvider> seriesList, @NonNull ProcessingElementReference @Nullable [] channelDescriptors) {
            this.updateLimit = updateLimit;
            this.limitIsDirty = limitIsDirty;
            this.actualLimit = actualLimit;
            this.percentScaleDivisor = percentScaleDivisor;
            this.perSeriesData = perSeriesData;
            this.seriesList = seriesList;
            this.channelDescriptors = channelDescriptors;
        }

        public double[] getPerSeriesData(int channelIndex, int seriesIndex) {
            @NonNull ProcessingElementReference @Nullable [] channelDescriptors = this.channelDescriptors;
            if (channelDescriptors == null) {
                assert (channelIndex <= 0);
                return this.perSeriesData[0][seriesIndex];
            }
            return this.perSeriesData[channelIndex][seriesIndex];
        }

        public int getTargetChannelIndex(@Nullable ProcessingElementReference channelDescriptor) {
            @NonNull Object @Nullable [] channelDescriptors = this.channelDescriptors;
            if (channelDescriptor == null || channelDescriptors == null) {
                return -1;
            }
            return ArrayUtils.indexOf((Object[])channelDescriptors, (Object)channelDescriptor);
        }
    }

    private static final class ResultState {
        public double stackedLimit = 0.0;
        public boolean limitIsDirty = false;
        public boolean updateLimit = false;
        private boolean allLessThan1 = true;
        private boolean allLessThan100 = true;
        private boolean allSeriesLessThan1 = true;
        private boolean allSeriesLessThan100 = true;
        private boolean anyData = false;
        private final @NonNull IChartDataProvider chart;
        private double currentCoreStackedLimit = 0.0;
        private double @Nullable [] currentData = null;
        private final boolean log10;
        private final boolean stacked;

        public ResultState(@NonNull IChartDataProvider chart) {
            this.chart = chart;
            this.stacked = chart.getSeriesComposition() == SeriesComposition.STACKED;
            this.log10 = chart.getSeriesComposition() == SeriesComposition.LOG10;
        }

        public void complete(boolean open) {
            if (!this.anyData) {
                double plateau;
                double d = plateau = open ? this.chart.getCoreLimit() : this.chart.getAggregateLimit();
                if (this.chart.isPercentage()) {
                    if (Math.floor(plateau) <= 1.0) {
                        plateau = 1.0;
                    } else if (Math.floor(plateau) <= 100.0) {
                        plateau = 100.0;
                    }
                }
                this.stackedLimit = NumberUtils.calculateLimit((double)plateau, (boolean)ScaledFormat.shouldUseKibi(this.chart.getUnits()));
            } else {
                this.stackedLimit = this.chart.isPercentage() ? (this.allLessThan1 ? 1.0 : (this.allSeriesLessThan1 ? Math.max(this.stackedLimit, 0.0) : (this.allLessThan100 ? 100.0 : (this.allSeriesLessThan100 ? Math.max(this.stackedLimit, 0.0) : NumberUtils.calculateLimit((double)this.stackedLimit, (boolean)ScaledFormat.shouldUseKibi(this.chart.getUnits())))))) : NumberUtils.calculateLimit((double)this.stackedLimit, (boolean)ScaledFormat.shouldUseKibi(this.chart.getUnits()));
            }
        }

        public void endOfChannel() {
            if (this.currentCoreStackedLimit > this.stackedLimit) {
                this.stackedLimit = this.currentCoreStackedLimit;
            }
            this.currentCoreStackedLimit = 0.0;
            this.currentData = null;
        }

        public void update(@NonNull ISeriesDataProvider series, @Nullable TIntSet selection, double[] data) {
            if (selection != null && series.isFilterable()) {
                this.updateLimit = true;
            } else {
                this.limitIsDirty = true;
            }
            if (data == null || data.length == 0) {
                return;
            }
            double[] currentData = this.currentData;
            if (currentData == null) {
                this.currentData = currentData = new double[data.length];
            } else if (currentData.length != data.length) {
                int n = Math.max(currentData.length, data.length);
                double[] newData = new double[n];
                System.arraycopy(currentData, 0, newData, 0, currentData.length);
                currentData = newData;
                this.currentData = newData;
            }
            int i = 0;
            while (i < currentData.length) {
                if (i < data.length) {
                    double fd;
                    double d;
                    double d2 = d = this.log10 ? Math.log10(data[i]) : data[i];
                    if (this.stacked) {
                        int n = i;
                        currentData[n] = currentData[n] + d;
                    } else {
                        currentData[i] = Math.max(currentData[i], d);
                    }
                    this.anyData = true;
                    if (currentData[i] > this.currentCoreStackedLimit) {
                        this.currentCoreStackedLimit = currentData[i];
                        if (Math.floor(this.currentCoreStackedLimit) > 1.0) {
                            this.allLessThan1 = false;
                        }
                        if (Math.floor(this.currentCoreStackedLimit) > 100.0) {
                            this.allLessThan100 = false;
                        }
                    }
                    if ((fd = Math.floor(d)) > 1.0) {
                        this.allSeriesLessThan1 = false;
                    }
                    if (fd > 100.0) {
                        this.allSeriesLessThan100 = false;
                    }
                }
                ++i;
            }
        }
    }

    private static enum Type {
        CLOSED,
        HEAT_MAP,
        OPEN;

    }
}

