/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.databrowser.CaptureControlView;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.charts.ChartConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ISeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.SeriesConfigurationPanel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class SeriesPanelMoveTracker
extends TimelineDragTracker
implements PaintListener {
    private Color mSavedBackgroundColor;
    private Point mStartPosition;
    private int mStartY;
    private int mPosition;
    private Shell mShell;
    private boolean mShouldClone;
    private final @NonNull ISeriesConfigurationPanel seriesPanel;
    private final @NonNull ChartConfigurationPanel mConfigPanel;

    public SeriesPanelMoveTracker(Block block, Point where, int stateMask, @NonNull ISeriesConfigurationPanel seriesPanel) {
        super(block);
        this.seriesPanel = seriesPanel;
        this.mConfigPanel = seriesPanel.getConfigPanel();
        this.mSavedBackgroundColor = block.getBackgroundColor();
        block.setBackgroundColor(Colors.darken(this.mSavedBackgroundColor, 10));
        this.mStartY = block.toDisplay((Point)where).y;
        this.mStartPosition = block.toDisplay(0, 0);
        this.mPosition = this.mStartPosition.y;
        block.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
        this.mShell = new Shell(block.getShell(), 537133064);
        this.mShell.setAlpha(192);
        this.mShell.addPaintListener((PaintListener)this);
        Rectangle bounds = block.getLocalBounds();
        this.mShell.setBounds(this.mStartPosition.x, this.mStartPosition.y, bounds.width, bounds.height);
        this.mShell.setCursor(StreamlinePlugin.getClosedHandCursor());
        this.mShell.setVisible(true);
        this.mShouldClone = (stateMask & SWT.MOD1) == SWT.MOD1;
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        this.getBlock().getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
        this.seriesPanel.setupAutoScroll(where.y);
        Point whereDisplay = this.getBlock().toDisplay(where);
        CaptureControlView.getCounterDropTarget().ifPresent(outline -> outline.setDropHighlight(outline.getBounds().contains(outline.toControl(whereDisplay))));
        this.mPosition = this.mStartPosition.y + whereDisplay.y - this.mStartY;
        ChartHandlePanel chartHandlePanel = this.seriesPanel.getConfigPanel().getChartHandlePanel();
        if (this.mShouldClone && Math.abs(this.mPosition - this.mStartPosition.y) > 5) {
            this.mShouldClone = false;
            IChartDataProvider cdp = chartHandlePanel.getChart();
            List<ISeriesDataProvider> list = cdp.getSeries();
            ISeriesDataProvider series = this.seriesPanel.getSeries();
            if (series != null) {
                int index = list.indexOf(series);
                ISeriesDataProvider newSeries = cdp.createSeries(index, series.getConfig().clone());
                SeriesConfigurationPanel newSeriesPanel = this.mConfigPanel.createSeriesPanel(newSeries);
                this.mConfigPanel.add(newSeriesPanel, index + this.mConfigPanel.getSeriesStartIndex());
                chartHandlePanel.seriesCountChanged(newSeriesPanel.getPreferredSize((int)this.getBlock().getWidth(), (int)-1).y);
            }
        }
        this.mShell.setLocation(this.mStartPosition.x, this.mPosition);
        ChartsPanel chartsPanel = chartHandlePanel.getChartsPanel();
        Block[] blockArray = chartsPanel.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block child = blockArray[n2];
            if (child instanceof ChartHandlePanel) {
                ChartHandlePanel chartHandle = (ChartHandlePanel)child;
                if (!chartHandle.getChart().getWildcardSeries().isEmpty()) {
                    return;
                }
                ChartConfigurationPanel configPanel = chartHandle.getConfigurationPanel();
                if (configPanel != null) {
                    Rectangle bounds;
                    Point localWhere = configPanel.fromDisplay(whereDisplay.x, whereDisplay.y);
                    int seriesIndex = 0;
                    Block[] blockArray2 = configPanel.getChildren();
                    int n3 = blockArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Block configChild = blockArray2[n4];
                        if (configChild instanceof SeriesConfigurationPanel) {
                            bounds = configChild.getBounds();
                            if (localWhere.y < bounds.y + bounds.height / 2) {
                                ISeriesDataProvider series = this.seriesPanel.getSeries();
                                if (series != null) {
                                    this.mConfigPanel.getChartHandlePanel().moveSeries(series, chartHandle, seriesIndex);
                                }
                                return;
                            }
                            ++seriesIndex;
                        }
                        ++n4;
                    }
                    bounds = configPanel.getBounds();
                    if (localWhere.y < bounds.height) {
                        ISeriesDataProvider series = this.seriesPanel.getSeries();
                        if (series != null) {
                            this.mConfigPanel.getChartHandlePanel().moveSeries(series, chartHandle, seriesIndex);
                        }
                        return;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public final void mouseUp(Point where, int button, int stateMask, int count) {
        this.getBlock().setBackgroundColor(this.mSavedBackgroundColor);
        this.getBlock().getOwner().applyCursor(null);
        this.mShell.dispose();
        CaptureControlView.getCounterDropTarget().ifPresent(outline -> {
            outline.setDropHighlight(false);
            if (outline.getBounds().contains(outline.toControl(this.getBlock().toDisplay(where)))) {
                this.seriesPanel.removeSeries();
            }
        });
    }

    public final void paintControl(PaintEvent event) {
        GC gc = new GC(event.gc);
        this.getBlock().paintAsRoot(gc);
    }
}

