/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.charts.ChartConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.ConfigurationPanelUtility;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.expression2.ExpressionData;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockColorWell;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ExpandedSeriesConfigurationPanel
extends Block {
    private static final int GAP = 20;
    protected ChartConfigurationPanel mConfigPanel;
    protected @NonNull ISeriesDataProvider mSeries;
    private BlockTextField mNameField;
    private BlockTextField mExpressionField;
    private boolean mAutoScrollPending;
    private BlockColorWell colorWell;
    private boolean updateForAllSeriesFromWildCard = true;

    public ExpandedSeriesConfigurationPanel(@NonNull ChartConfigurationPanel configPanel, @NonNull ISeriesDataProvider series) {
        this.mConfigPanel = configPanel;
        this.mSeries = series;
        this.setBackgroundColor(Colors.getWidgetBackground());
        this.setLayout(new PrecisionLayout().setMargins(6, 20, 0, 0));
        Block wrapper = new Block();
        wrapper.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(5).setHorizontalAlignment(4).setGrabHorizontalSpace(true));
        wrapper.setLayout(new PrecisionLayout().setColumns(5).setSpacing(4, 1));
        this.add(wrapper);
        AbstractSeriesConfig config = this.getSeriesConfig();
        this.colorWell = new BlockColorWell(config.getColor());
        this.colorWell.addColorChangedListener(rgb -> {
            WildcardSeriesConfig expandedFromWildCard;
            this.getSeriesConfig().setColor(rgb);
            if (this.updateForAllSeriesFromWildCard && (expandedFromWildCard = ((SeriesConfig)this.getSeriesConfig()).getExpandedFromWildCard()) != null && !expandedFromWildCard.isAutoRotateColor()) {
                ExpandedSeriesConfigurationPanel.updateColorListForAllSeries(configPanel, expandedFromWildCard);
            }
            this.mConfigPanel.getChartHandlePanel().repaint();
            this.updateForAllSeriesFromWildCard = true;
        });
        wrapper.add(this.colorWell);
        BlockLabel label = new BlockLabel(ChartMessages.SERIES_TITLE);
        wrapper.add(label);
        this.mNameField = ConfigurationPanelUtility.addField(wrapper, config.getName(), 50, field -> {
            this.getSeriesConfig().setName(field.getText());
            this.mNameField.forceScrollToBeginning();
            this.mNameField.setToolTip(field.getText());
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        this.mNameField.setToolTip(this.mNameField.getText());
        label = new BlockLabel(ChartMessages.SERIES_EXPRESSION);
        wrapper.add(label);
        ExpressionData eData = config.getExpression();
        this.mExpressionField = ConfigurationPanelUtility.addField(wrapper, eData != null ? eData.getString() : "", 0, field -> {
            this.getSeriesConfig().setExpression(field.getText());
            this.updateFieldBackground();
            this.mExpressionField.setToolTip(field.getText());
            this.mConfigPanel.getChartHandlePanel().clearSharedLimit();
            this.mConfigPanel.getChartHandlePanel().adjustForSeriesExpressionChange();
        });
        this.mExpressionField.setToolTip(this.mExpressionField.getText());
        this.updateFieldBackground();
        this.mNameField.setEnabled(false);
        this.mExpressionField.setEnabled(false);
    }

    private static void updateColorListForAllSeries(@NonNull ChartConfigurationPanel configPanel, @Nullable WildcardSeriesConfig expandedFromWildCard) {
        if (expandedFromWildCard == null) {
            return;
        }
        List expandedSeries = configPanel.getChartHandlePanel().getChart().getSeries().stream().filter(s -> {
            WildcardSeriesConfig wildCard = s.getConfig().getExpandedFromWildCard();
            if (wildCard == null) {
                return false;
            }
            return wildCard == expandedFromWildCard;
        }).collect(Collectors.toList());
        if (expandedSeries.size() > 0) {
            expandedFromWildCard.getColorList().clear();
            for (ISeriesDataProvider series : expandedSeries) {
                expandedFromWildCard.getColorList().add(RGBUtils.encode(series.getConfig().getColor()));
            }
        }
    }

    public final ChartConfigurationPanel getConfigPanel() {
        return this.mConfigPanel;
    }

    public final ISeriesDataProvider getSeries() {
        return this.mSeries;
    }

    public final void selectAndFocusNameField() {
        this.mNameField.selectAll();
        this.getOwner().setFocus(this.mNameField);
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.mConfigPanel.getChartHandlePanel().getChartsPanel().getBaseTimelineContent().setBookmarkPopOver(null);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = this.getLocalBounds();
        gc.setForeground(Colors.getDivider());
        gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        gc.setAntialias(savedAA);
    }

    private final void autoScroll(int amount) {
        BlockScrollBar scrollbar;
        int y;
        this.mAutoScrollPending = false;
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null && ConfigurationPanelUtility.getScrollAmount(this, scroller, y = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).y) != 0 && (scrollbar = scroller.getVerticalBar()) != null) {
            scrollbar.setValue(scrollbar.getValue() + (long)amount);
        }
    }

    private final @NonNull AbstractSeriesConfig getSeriesConfig() {
        return this.mSeries.getConfig();
    }

    private final void updateFieldBackground() {
        Color expressionColor = Colors.getWhite();
        switch (this.mSeries.getWarningSource()) {
            case DUMMY_COUNTER: 
            case EXPRESSION: 
            case INVALID_COUNTER: {
                break;
            }
            case COUNTER_DISPLAY: {
                break;
            }
        }
        this.mExpressionField.setBackgroundColor(expressionColor);
    }

    public void removeSeries() {
        ChartHandlePanel chartHandlePanel = this.mConfigPanel.getChartHandlePanel();
        int height = this.getHeight();
        chartHandlePanel.getChart().remove(this.mSeries);
        this.removeFromParent();
        chartHandlePanel.seriesCountChanged(-height);
    }

    final void setupAutoScroll(int y) {
        int amount;
        ScrollingBlock scroller;
        if (!this.mAutoScrollPending && (scroller = this.getContainingScrollingBlock()) != null && (amount = ConfigurationPanelUtility.getScrollAmount(this, scroller, y)) != 0) {
            this.mAutoScrollPending = true;
            int scroll = amount;
            Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void setSeriesName(String seriesName) {
        this.mNameField.setText(seriesName);
    }

    public void updateColorOnSeries(@NonNull RGB rgb, boolean updateForAllSeriesFromWildCard) {
        this.updateForAllSeriesFromWildCard = updateForAllSeriesFromWildCard;
        this.colorWell.setRGB(rgb);
    }
}

