/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;

public class DebugLabelFormatter {
    private static final String ELLIPSIS = "\u2026";
    private boolean mDiscardRoot;
    private boolean mDiscardLeaf;
    private @NonNull String mPresentationMode = "";
    private @NonNull String mStackSeparator = "";
    private @NonNull ContractionMode mContractionMode = ContractionMode.KEEP_BOTH;
    private int mContractedLength;
    private final boolean includeContraction;

    public DebugLabelFormatter() {
        this(true);
    }

    public DebugLabelFormatter(boolean includeContraction) {
        this.includeContraction = includeContraction;
    }

    private void loadFromPreferences() {
        IPreferenceStore store = StreamlinePlugin.getInstance().getPreferenceStore();
        this.mDiscardRoot = store.getBoolean("com.arm.streamline.discard_root_label_in_stack_option");
        this.mDiscardLeaf = store.getBoolean("com.arm.streamline.discard_leaf_label_in_stack_option");
        this.mPresentationMode = (String)NullChecking.neverNull((Object)store.getString("com.arm.streamline.presentation_mode_option"));
        this.mStackSeparator = (String)NullChecking.neverNull((Object)store.getString("com.arm.streamline.stack_separator"));
        this.mContractionMode = (ContractionMode)((Object)NullChecking.neverNull((Object)((Object)ContractionMode.fromString(store.getString("com.arm.streamline.contraction_mode")))));
        this.mContractedLength = store.getInt("com.arm.streamline.contracted_length");
    }

    public @NonNull String formatLabels(@NonNull List<@NonNull String> stackLabels) {
        String formatted;
        this.loadFromPreferences();
        @NonNull ArrayList<@NonNull String> filtered = new ArrayList<String>(stackLabels);
        if (this.mDiscardRoot && filtered.size() > 1) {
            filtered.removeFirst();
        }
        if (this.mDiscardLeaf && filtered.size() > 1) {
            filtered.removeLast();
        }
        if ((formatted = this.mPresentationMode.equalsIgnoreCase("com.arm.streamline.presentation_mode_leaf") && !filtered.isEmpty() ? (String)filtered.get(filtered.size() - 1) : (String)NullChecking.neverNull((Object)String.join((CharSequence)this.mStackSeparator, filtered))).length() <= this.mContractedLength) {
            return formatted;
        }
        if (this.includeContraction) {
            switch (this.mContractionMode) {
                case KEEP_LEFT: {
                    return formatted.substring(0, Math.max(0, this.mContractedLength - 1)) + ELLIPSIS;
                }
                case KEEP_RIGHT: {
                    return ELLIPSIS + formatted.substring(formatted.length() - Math.max(0, this.mContractedLength - 1));
                }
                case KEEP_BOTH: {
                    int split = (this.mContractedLength - 1) / 2;
                    return formatted.substring(0, split) + ELLIPSIS + formatted.substring(formatted.length() - split);
                }
            }
            return formatted;
        }
        return formatted;
    }

    public static enum ContractionMode {
        KEEP_LEFT("com.arm.streamline.contraction_mode_left"),
        KEEP_RIGHT("com.arm.streamline.contraction_mode_right"),
        KEEP_BOTH("com.arm.streamline.contraction_mode_both");

        private final String label;

        private ContractionMode(String label) {
            this.label = label;
        }

        public static ContractionMode fromString(String str) {
            ContractionMode[] contractionModeArray = ContractionMode.values();
            int n = contractionModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContractionMode mode = contractionModeArray[n2];
                if (mode.label.equalsIgnoreCase(str)) {
                    return mode;
                }
                ++n2;
            }
            return KEEP_BOTH;
        }
    }
}

