/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapInfoPanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.model.cam.CAMJobSelectionModel;
import com.arm.streamline.model.capture.CAMConfig;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public final class CustomActivityMapScrollableWrapper
extends Block
implements IPropertyChangeListener {
    private @NonNull CustomActivityMapViewPanel mCAMsPanel;
    private @NonNull ScrollingBlock infoPanelScroller;
    private @NonNull CustomActivityMapInfoPanel camInfoPanel;
    private @NonNull Block seperator;
    private @NonNull ScrollingBlock mCamScrollBlock;

    public CustomActivityMapScrollableWrapper(@NonNull BaseTimelineContent content, @NonNull ICAMDataProvider provider, @NonNull CAMConfig config) {
        this.setLayout(new PrecisionLayout().setColumns(3));
        CAMJobSelectionModel camJobSelectionModel = new CAMJobSelectionModel();
        this.mCAMsPanel = new CustomActivityMapViewPanel(content, provider, config, camJobSelectionModel);
        this.mCAMsPanel.pack();
        this.mCamScrollBlock = new ScrollingBlock(this.mCAMsPanel);
        this.mCamScrollBlock.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setFill().setMinimumHeight(0).setMinimumWidth(0));
        this.add(this.mCamScrollBlock);
        this.camInfoPanel = new CustomActivityMapInfoPanel(content, provider, camJobSelectionModel, this.mCAMsPanel);
        this.camInfoPanel.pack();
        this.camInfoPanel.setCAMPanelBackground();
        CustomActivityMapInfoPanel customActivityMapInfoPanel = this.camInfoPanel;
        customActivityMapInfoPanel.getClass();
        final CustomActivityMapInfoPanel.CAMInfoPanelMouseTracker camInfoPanelMouseTracker = customActivityMapInfoPanel.new CustomActivityMapInfoPanel.CAMInfoPanelMouseTracker(this.camInfoPanel);
        this.seperator = new Block(){

            @Override
            protected void mouseDrag(Point where, int button, int stateMask) {
                camInfoPanelMouseTracker.mouseDrag(where, stateMask);
            }

            @Override
            protected void mouseMove(Point where, int stateMask) {
                int cursorID = 9;
                Display display = this.getDisplay();
                if (display != null) {
                    Cursor cursor = display.getSystemCursor(cursorID);
                    this.setCursor(cursor);
                } else {
                    this.setCursor(null);
                }
            }
        };
        this.seperator.setLayoutData(new PrecisionLayoutData().setGrabVerticalSpace(true).setGrabHorizontalSpace(false).setFill().setMinimumHeight(0).setMinimumWidth(0).setWidthHint(10));
        this.add(this.seperator);
        this.infoPanelScroller = new ScrollingBlock(this.camInfoPanel);
        this.infoPanelScroller.setLayoutData(new PrecisionLayoutData().setWidthHint(0));
        this.infoPanelScroller.setHorizontalExpansion(ScrollingBlock.Expansion.SIZE_OF_VIEWPORT);
        this.add(this.infoPanelScroller);
        this.camInfoPanel.updateJobInfo();
        StreamlinePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public @NonNull Point getScrollOffset() {
        return this.mCamScrollBlock.getViewOffset();
    }

    public final CustomActivityMapViewPanel getCAMsPanel() {
        return this.mCAMsPanel;
    }

    public void toogleInfoPanel() {
        boolean isHidden = ((PrecisionLayoutData)this.infoPanelScroller.getLayoutData()).getWidthHint() == 0;
        this.infoPanelScroller.setLayoutData(new PrecisionLayoutData().setFill().setMinimumHeight(0).setMinimumWidth(0).setGrabVerticalSpace(true).setWidthHint(isHidden ? 300 : 0));
        this.layout();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("com.arm.streamline.theme_id".equals(event.getProperty())) {
            this.camInfoPanel.setCAMPanelBackground();
            this.layout();
        }
        if (StreamlinePreferences.DEBUG_LABEL_PREFERENCES_PROPERTIES.contains(event.getProperty())) {
            this.camInfoPanel.updateJobInfo();
            this.mCAMsPanel.repaint();
        }
    }
}

