/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.analysis.model.cam.ICAMDetailPanelInfo;
import com.arm.streamline.analysis.model.cam.ICAMJobSelection;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapMessages;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapUtils;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.editortabs.timeline.common.cam.DebugLabelFormatter;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.model.cam.CAMASTFSyscallsInfoModel;
import com.arm.streamline.model.cam.CAMMaliTimeLineInfoModel;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CustomActivityMapInfoPanel
extends GraphBlock
implements IHandleAreaListener,
ICrossSectionMarkerListener,
IScrollableBlock {
    private final @NonNull ICAMDataProvider provider;
    private final @NonNull BlockTextField infoTextField;
    private final ICaptureDataProvider captureDataProvider;
    private final int MAX_NON_MALI_TOLLTIP_COUNT = 5;
    private final CrossSectionMarker crossSectionMarker;
    private final @NonNull ICAMDetailPanelInfo camMaliTimeLineInfoModel;
    private final @NonNull ICAMDetailPanelInfo camASTFSyscallsInfoModel;
    private final @NonNull ICAMJobSelection camJobSelectionModel;
    private final @NonNull BaseTimelineContent content;
    private @NonNull CustomActivityMapViewPanel mCAMsPanel;

    public CustomActivityMapInfoPanel(@NonNull BaseTimelineContent content, @NonNull ICAMDataProvider provider, @NonNull ICAMJobSelection selection, @NonNull CustomActivityMapViewPanel mCAMsPanel) {
        super(content);
        this.setLayout(new PrecisionLayout().setColumns(1));
        this.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setFill());
        this.provider = provider;
        this.captureDataProvider = content.getCaptureDataProvider();
        this.content = content;
        this.mCAMsPanel = mCAMsPanel;
        this.crossSectionMarker = this.captureDataProvider.getCrossSectionMarker();
        this.crossSectionMarker.addListener(this);
        this.camMaliTimeLineInfoModel = new CAMMaliTimeLineInfoModel(provider, selection, new DebugLabelFormatter(false));
        this.camASTFSyscallsInfoModel = new CAMASTFSyscallsInfoModel(provider, selection);
        this.infoTextField = new BlockTextField();
        this.infoTextField.setHasBorder(false);
        this.infoTextField.setWrapWidth(300);
        this.infoTextField.setMultiLine(true);
        this.infoTextField.setEnabled(true);
        this.infoTextField.setIgnoreKeyPress(true);
        this.infoTextField.setIgnoreCut(true);
        this.infoTextField.setIgnorePaste(true);
        this.infoTextField.enableAutoScroll(false);
        this.setCAMPanelBackground();
        this.infoTextField.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setAlignment(4, 128));
        this.add(this.infoTextField);
        this.camJobSelectionModel = selection;
        this.camJobSelectionModel.addJobSelectionChangeListener(jobs -> {
            if (this.camJobSelectionModel.getSelectedJobs().isEmpty()) {
                this.updateContentForTimeRange(this.crossSectionMarker);
            } else {
                this.updateContentForJobSelection((Set<ICAMJob>)jobs);
            }
        });
        content.getChartsPanel().addHandleAreaListener(this);
    }

    public void updateJobInfo() {
        if (this.hasCustomDetailsPanel()) {
            Set selectedJobs = this.camJobSelectionModel.getSelectedJobs();
            if (!selectedJobs.isEmpty()) {
                this.updateContentForJobSelection(this.camJobSelectionModel.getSelectedJobs());
            } else {
                this.updateContentForTimeRange(this.crossSectionMarker);
            }
        }
    }

    private void updateContentForTimeRange(CrossSectionMarker csm) {
        if (!this.content.getDetailAreaMode().startsWith("cam_")) {
            return;
        }
        if (this.provider.isASTFSyscalls()) {
            if (csm.isParked()) {
                int binCount = this.captureDataProvider.getBinCountForDensestScale();
                long endTimeInNanoSeconds = CustomActivityMapUtils.getTimeInNanoSeconds(csm.getDensestZoomLevel(), binCount);
                String activeRegionStats = this.camASTFSyscallsInfoModel.getActiveRegionStats(0L, endTimeInNanoSeconds);
                this.infoTextField.setText(activeRegionStats);
            } else {
                String activeRegionStats = CustomActivityMapInfoPanel.getInfotextForCSM(csm, this.camASTFSyscallsInfoModel);
                this.infoTextField.setText(activeRegionStats);
            }
            this.showPanel();
            this.pack();
            return;
        }
        if (!this.provider.isMaliTimeline() || csm.isParked()) {
            this.infoTextField.setText(CustomActivityMapMessages.NO_CAM_JOBS_SELECTED_OR_IN_TIME_RANGE);
            this.pack();
            return;
        }
        String activeRegionStats = CustomActivityMapInfoPanel.getInfotextForCSM(csm, this.camMaliTimeLineInfoModel);
        this.infoTextField.setText(activeRegionStats);
        this.showPanel();
        this.pack();
    }

    private static @NonNull String getInfotextForCSM(CrossSectionMarker csm, @NonNull ICAMDetailPanelInfo model) {
        ZoomLevel densestZoomLevel = csm.getDensestZoomLevel();
        long startTimeInNanoSeconds = CustomActivityMapUtils.getTimeInNanoSeconds(densestZoomLevel, csm.getRangeLeftAtDensestScale());
        long endTimeInNanoSeconds = CustomActivityMapUtils.getTimeInNanoSeconds(densestZoomLevel, csm.getRangeRightAtDensestScale());
        String activeRegionStats = model.getActiveRegionStats(startTimeInNanoSeconds, endTimeInNanoSeconds);
        return activeRegionStats;
    }

    private boolean hasCustomDetailsPanel() {
        return this.provider.isMaliTimeline() || this.provider.isASTFSyscalls();
    }

    private void updateContentForJobSelection(@NonNull Set<@NonNull ICAMJob> jobs) {
        if (!this.hasCustomDetailsPanel()) {
            this.showToolTipForNonMaliTimeline(jobs);
            return;
        }
        if (jobs.isEmpty()) {
            this.infoTextField.setText(CustomActivityMapMessages.NO_CAM_JOBS_SELECTED_OR_IN_TIME_RANGE);
        } else {
            if (this.provider.isMaliTimeline()) {
                this.infoTextField.setText(this.camMaliTimeLineInfoModel.getActiveEventStats());
            } else if (this.provider.isASTFSyscalls()) {
                this.infoTextField.setText(this.camASTFSyscallsInfoModel.getActiveEventStats());
            }
            this.showPanel();
        }
        this.pack();
    }

    private void showToolTipForNonMaliTimeline(@NonNull Set<@NonNull ICAMJob> jobs) {
        assert (this.captureDataProvider != null);
        TimeUnit timeUnit = this.captureDataProvider.getTimeUnit();
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(String.format(CustomActivityMapMessages.NON_MALI_TIME_LINE_HEADER, 5));
        LinkedHashSet sortedJobs = jobs.stream().sorted(Comparator.comparingLong(ICAMJob::getStartTime)).collect(Collectors.toCollection(LinkedHashSet::new));
        int count = 0;
        for (ICAMJob job : sortedJobs) {
            if (count >= 5) break;
            CustomActivityMapUtils.addTooltipFor(timeUnit, tooltip, job, false);
            ++count;
        }
        this.infoTextField.setText(tooltip.toString() + (count > 5 ? "\n...." : ""));
        this.pack();
    }

    @Override
    public void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.updateContentForTimeRange(csm);
    }

    @Override
    public void handleAreaWidthChanged() {
        this.layoutAll();
    }

    private final void adjustPanelOnDrag(Point where) {
        int widthNew = this.getWidth() - where.x;
        if (widthNew >= 300) {
            ScrollingBlock containingScrollingBlock = this.getContainingScrollingBlock();
            containingScrollingBlock.setLayoutData(new PrecisionLayoutData().setFill().setMinimumHeight(0).setMinimumWidth(0).setGrabVerticalSpace(true).setWidthHint(widthNew));
            this.infoTextField.setWrapWidth(widthNew);
            containingScrollingBlock.getParent().layout();
        }
    }

    public void setCAMPanelBackground() {
        Color color = StreamlinePreferences.getTheme() == StreamlineTheme.DARK ? Colors.lighten(Colors.getWidgetBackground(), 5) : Colors.getWhite();
        this.setBackgroundColor(color);
        this.infoTextField.setBackgroundColor(color);
    }

    private void showPanel() {
        ScrollingBlock containingScrollingBlock = this.getContainingScrollingBlock();
        if (containingScrollingBlock != null && containingScrollingBlock.getWidth() == 0) {
            containingScrollingBlock.setLayoutData(new PrecisionLayoutData().setFill().setMinimumHeight(0).setMinimumWidth(0).setGrabVerticalSpace(true).setWidthHint(300));
            this.infoTextField.setWrapWidth(300);
            Block parent = containingScrollingBlock.getParent();
            if (parent != null) {
                parent.layout();
                Point lastSelectedMousePosition = this.mCAMsPanel.getLastSelectedMousePosition();
                Rectangle bounds = this.mCAMsPanel.getCAMRowBounds();
                if (lastSelectedMousePosition != null && bounds != null && bounds.width - lastSelectedMousePosition.x < 300) {
                    DividerPanel dividerPanel = this.content.getDividerPanel();
                    dividerPanel.setPosition(dividerPanel.getPosition() + 300L);
                }
            }
        }
    }

    @Override
    public int getHorizontalIncrement() {
        return 1;
    }

    @Override
    public int getVerticalIncrement() {
        return 20;
    }

    public class CAMInfoPanelMouseTracker
    extends DragTracker {
        protected CAMInfoPanelMouseTracker(Block block) {
            super(CustomActivityMapInfoPanel.this);
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            CustomActivityMapInfoPanel.this.adjustPanelOnDrag(where);
        }
    }
}

