/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.bookmarks;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.bookmarks.BookmarkPanel;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BookmarkPopOver
extends Block {
    private BaseTimelineContent mContent;
    private long mSlot;
    private final @NonNull ZoomLevel mZoomLevel;

    public BookmarkPopOver(BaseTimelineContent content, long slot, @NonNull ZoomLevel zoomLevel, List<Bookmark> bookmarks) {
        this.setBackgroundColor(Colors.getDivider());
        this.setLayout(new PrecisionLayout().setMargins(1));
        this.mContent = content;
        this.mSlot = slot;
        this.mZoomLevel = zoomLevel;
        for (Bookmark bookmark : bookmarks) {
            BookmarkPanel panel = new BookmarkPanel(this, bookmark, content.getCaptureDataProvider().getTimeUnit());
            panel.setLayoutData(new PrecisionLayoutData().setFill().setGrabHorizontalSpace(true));
            this.add(panel);
        }
        this.setSize(this.getPreferredSize(-1, -1));
    }

    public final void adjust() {
        RulerPanel rulerPanel = this.mContent.getRulerPanel();
        Rectangle bounds = rulerPanel.getLocalBounds();
        Point size = this.getPreferredSize(-1, -1);
        long x = rulerPanel.translateFromSlot(this.mSlot) - (long)((this.mContent.getSlotWidth() + size.x) / 2);
        if (x < (long)bounds.x) {
            x = bounds.x;
        } else if (x + (long)size.x > (long)(bounds.x + bounds.width)) {
            x -= x + (long)size.x - (long)(bounds.x + bounds.width);
        }
        Block parent = this.getParent();
        Point where = parent.fromRoot(rulerPanel.toRoot((int)x, bounds.y + bounds.height));
        parent.repaint(this.getBounds());
        this.setBounds(where.x, where.y, size.x, size.y);
        Block firstChild = parent.getChild(0);
        if (firstChild != this) {
            parent.move(this, firstChild);
        }
    }

    public final void adjustHeight() {
        Point current = this.getSize();
        Point size = this.getPreferredSize(-1, -1);
        if (!size.equals((Object)current)) {
            this.setSize(size);
        }
    }

    public final void delete(BookmarkPanel bookmarkPanel) {
        this.mContent.getCaptureDataProvider().getBookmarks().remove(bookmarkPanel.getBookmark());
        bookmarkPanel.removeFromParent();
        if (this.getChildren().length > 0) {
            this.adjust();
        } else {
            this.mContent.setBookmarkPopOver(null);
            this.mContent.notifyBookmarkListeners();
        }
    }

    public final BaseTimelineContent getContent() {
        return this.mContent;
    }

    public final @NonNull ZoomLevel getZoomLevel() {
        return this.mZoomLevel;
    }

    public final long getSlot() {
        return this.mSlot;
    }
}

