/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineCommonMessages;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapScrollableWrapper;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapViewPanel;
import com.arm.streamline.editortabs.timeline.common.model.CAMContextMenuSelectionModel;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ITimeStampedData;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TimelineContextMenu
implements MenuListener {
    private static boolean ENABLE_CAM_CSM_ITEMS = false;
    private BaseTimelineContent mContent;

    private TimelineContextMenu(BaseTimelineContent content) {
        this.mContent = content;
    }

    public final void menuHidden(MenuEvent event) {
        this.mContent.getContentWrapper().releaseCapturedMouse();
    }

    public final void menuShown(MenuEvent event) {
    }

    public static final void showContextMenu(BaseTimelineContent content, Point displayLocation) {
        RulerPanel rulerPanel = content.getRulerPanel();
        Point where = rulerPanel.fromDisplay(displayLocation.x, displayLocation.y);
        long slotIndex = rulerPanel.translateToSlot(where.x);
        Menu menu = new Menu((Control)content);
        TimelineContextMenu.addBookmarkMenuItems(menu, content, slotIndex);
        ContextMenu.createSeparator(menu);
        TimelineContextMenu.addCaliperMenuItems(menu, content, slotIndex);
        ContextMenu.createSeparator(menu);
        TimelineContextMenu.addCrossSectionMenuItems(menu, content, slotIndex, displayLocation);
        ContextMenu.createSeparator(menu);
        TimelineContextMenu.addCamViewMenuItems(menu, content, displayLocation);
        menu.setLocation(displayLocation);
        menu.addMenuListener((MenuListener)new TimelineContextMenu(content));
        menu.setVisible(true);
    }

    private static final void addBookmarkMenuItems(Menu menu, final BaseTimelineContent content, long slotIndex) {
        MenuItem item = new MenuItem(menu, 8);
        final ICaptureDataProvider cdp = content.getCaptureDataProvider();
        final long timestamp = Position.scale((long)slotIndex, (ZoomLevel)cdp.getScales().getZoomLevel(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL);
        TimeUnit timeUnit = cdp.getTimeUnit();
        ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
        item.setText(String.format(TimelineCommonMessages.CREATE_BOOKMARK, timeUnit.formatBin(slotIndex, zoomLevel, TimeUnit.Style.SYMBOL_UNIT, false)));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.setBookmarkPopOver(null);
                Bookmark bookmark = new Bookmark(timestamp, new RGB(255, 0, 0), null);
                List<Bookmark> bookmarks = cdp.getBookmarks();
                int pos = ITimeStampedData.binarySearch(bookmarks, (long)timestamp);
                if (pos < 0) {
                    pos = -pos - 1;
                }
                bookmarks.add(pos, bookmark);
                content.notifyBookmarkListeners();
            }
        });
        item.setEnabled(slotIndex >= 0L && slotIndex < (long)cdp.getLastBinCount() && !content.isLiveStopping());
    }

    private static final void addCaliperMenuItems(Menu menu, final BaseTimelineContent content, final long slotIndex) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.SET_CALIPER_LEFT);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCalipers().setLeft(slotIndex);
            }
        });
        Calipers calipers = content.getCaptureDataProvider().getCalipers();
        item.setEnabled(calipers.getRight() > slotIndex);
        item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.SET_CALIPER_RIGHT);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCalipers().setRight(slotIndex);
            }
        });
        item.setEnabled(calipers.getLeft() < slotIndex);
        item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.RESET_CALIPERS);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCalipers().reset();
            }
        });
        item.setEnabled(calipers.canBeReset());
    }

    private static final void addCrossSectionMenuItems(Menu menu, final BaseTimelineContent content, final long slotIndex, Point displayLocation) {
        CustomActivityMapViewPanel camsPanel;
        ICAMJob job;
        Block bottomPanel;
        MenuItem item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.SET_CROSS_SECTION_POSITION);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                long value;
                ICaptureDataProvider cdp = content.getCaptureDataProvider();
                Scales scales = cdp.getScales();
                ZoomLevel zoomLevel = scales.getZoomLevel();
                ZoomLevel densestZoomLevel = scales.getDensestZoomLevel();
                TimeUnit timeUnit = cdp.getTimeUnit();
                String label = MessageFormat.format(TimelineCommonMessages.TIME_INDEX, timeUnit.getBaseTextMany());
                String initial = timeUnit.formatBin(slotIndex, zoomLevel, TimeUnit.Style.NO_UNIT, false);
                IInputValidator validator = newText -> {
                    if (newText == null) {
                        return null;
                    }
                    try {
                        timeUnit.parseInBase(newText);
                        return null;
                    }
                    catch (ParseException e) {
                        return e.getLocalizedMessage();
                    }
                };
                InputDialog dialog = new InputDialog(content.getShell(), TimelineCommonMessages.SET_CROSS_SECTION_POSITION, label, initial, validator);
                if (dialog.open() == 0 && dialog.getValue() != null && (value = timeUnit.parseInBaseToBin((String)NullChecking.neverNull((Object)dialog.getValue()), densestZoomLevel)) >= 0L) {
                    Position position = new Position(value, densestZoomLevel, densestZoomLevel);
                    cdp.getCrossSectionMarker().set(position, position);
                    long pos = position.get(zoomLevel);
                    content.centerViewOn(pos, pos);
                }
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.SET_CROSS_SECTION_LEFT);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCrossSectionMarker().setLeft(slotIndex);
            }
        });
        final CrossSectionMarker csm = content.getCaptureDataProvider().getCrossSectionMarker();
        long right = csm.getRight();
        item.setEnabled(right == -1L || right > slotIndex);
        int insertIndex = menu.indexOf(item);
        item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.SET_CROSS_SECTION_RIGHT);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCrossSectionMarker().setRight(slotIndex);
            }
        });
        long left = csm.getLeft();
        item.setEnabled(left == -1L || left < slotIndex);
        item = new MenuItem(menu, 8);
        item.setText(TimelineCommonMessages.RESET_CROSS_SECTION_MARKER);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent theEvent) {
                content.getCaptureDataProvider().getCrossSectionMarker().reset();
            }
        });
        item.setEnabled(!csm.isParked());
        if (ENABLE_CAM_CSM_ITEMS && (bottomPanel = content.getBottomPanel()) instanceof CustomActivityMapScrollableWrapper && (job = (camsPanel = ((CustomActivityMapScrollableWrapper)bottomPanel).getCAMsPanel()).getJobAt(bottomPanel.fromDisplay(displayLocation.x, displayLocation.y))) != null) {
            item = new MenuItem(menu, 8, insertIndex++);
            item.setText(TimelineCommonMessages.SET_CROSS_SECTION_LEFT_AT_JOB_LEFT);
            final ZoomLevel densestZoomLevel = csm.getDensestZoomLevel();
            final long newLeftFromStart = Position.scale((long)job.getStartTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent theEvent) {
                    csm.setLeft(newLeftFromStart, densestZoomLevel);
                }
            });
            right = csm.getRightAtDensestScale();
            item.setEnabled(right == -1L || right > newLeftFromStart);
            item = new MenuItem(menu, 8, insertIndex++);
            item.setText(TimelineCommonMessages.SET_CROSS_SECTION_LEFT_AT_JOB_RIGHT);
            final long newLeftFromStop = Position.scale((long)job.getStopTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent theEvent) {
                    csm.setLeft(newLeftFromStop, densestZoomLevel);
                }
            });
            item.setEnabled(right == -1L || right > newLeftFromStop);
            int n = ++insertIndex;
            ++insertIndex;
            item = new MenuItem(menu, 8, n);
            item.setText(TimelineCommonMessages.SET_CROSS_SECTION_RIGHT_AT_JOB_LEFT);
            final long newRightFromStart = Position.scale((long)job.getStartTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent theEvent) {
                    csm.setRight(newRightFromStart, densestZoomLevel);
                }
            });
            left = csm.getLeftAtDensestScale();
            item.setEnabled(left == -1L || left < newRightFromStart);
            item = new MenuItem(menu, 8, insertIndex++);
            item.setText(TimelineCommonMessages.SET_CROSS_SECTION_RIGHT_AT_JOB_RIGHT);
            final long newRightFromStop = Position.scale((long)job.getStopTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent theEvent) {
                    csm.setRight(newRightFromStop, densestZoomLevel);
                }
            });
            item.setEnabled(left == -1L || left < newRightFromStop);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addCamViewMenuItems(@NonNull Menu menu, @NonNull BaseTimelineContent content, @NonNull Point displayLocation) {
        void wrapper;
        @Nullable Block bottomPanel = content.getBottomPanel();
        Block block = bottomPanel;
        if (!(block instanceof CustomActivityMapScrollableWrapper)) {
            return;
        }
        CustomActivityMapScrollableWrapper customActivityMapScrollableWrapper = (CustomActivityMapScrollableWrapper)block;
        CustomActivityMapScrollableWrapper cfr_ignored_0 = (CustomActivityMapScrollableWrapper)block;
        @NonNull CustomActivityMapViewPanel camsPanel = (CustomActivityMapViewPanel)NullChecking.neverNull((Object)wrapper.getCAMsPanel());
        @NonNull ICaptureDataProvider cdp = (ICaptureDataProvider)NullChecking.neverNull((Object)content.getCaptureDataProvider());
        @NonNull Point localPoint = (Point)NullChecking.neverNull((Object)bottomPanel.fromDisplay(displayLocation.x, displayLocation.y));
        Point scrollOffset = wrapper.getScrollOffset();
        localPoint.x -= scrollOffset.x;
        localPoint.y -= scrollOffset.y;
        @Nullable ICAMJob clickedJob = camsPanel.getJobAt(localPoint);
        @NonNull Set<@NonNull ICAMJob> selectedJobs = camsPanel.getSelectedJobs();
        @Nullable Pattern pattern = camsPanel.getJobFilterPattern();
        @NonNull CrossSectionMarker marker = (CrossSectionMarker)NullChecking.neverNull((Object)cdp.getCrossSectionMarker());
        @NonNull ZoomLevel zoomLevel = cdp.getScales().getDensestZoomLevel();
        ICAMDataProvider camDataProvider = camsPanel.getCAMDataProvider();
        if (camDataProvider == null) {
            return;
        }
        TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_CLEAR_SELECTION), !selectedJobs.isEmpty(), () -> {
            camsPanel.setSelectedJobs(new ICAMJob[0], false);
            camsPanel.repaint();
        });
        CAMContextMenuSelectionModel.Context context = new CAMContextMenuSelectionModel.Context(clickedJob, selectedJobs, pattern, marker, zoomLevel, camDataProvider);
        if (camsPanel.getCAMDataProvider().isMaliTimeline()) {
            TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_SELECT_WORKLOAD), CAMContextMenuSelectionModel.isWorkloadJob(clickedJob), () -> {
                camsPanel.setSelectedJobs(CAMContextMenuSelectionModel.selectWorkload(context), false);
                camsPanel.repaint();
            });
            TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_SELECT_FRAME), CAMContextMenuSelectionModel.isWorkloadJob(clickedJob), () -> {
                camsPanel.setSelectedJobs(CAMContextMenuSelectionModel.selectFrame(context), false);
                camsPanel.repaint();
            });
            TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_SELECT_CMD_BUFFER), CAMContextMenuSelectionModel.isWorkloadJob(clickedJob), () -> {
                camsPanel.setSelectedJobs(CAMContextMenuSelectionModel.selectItemsByCommandBuffer(context), false);
                camsPanel.repaint();
            });
        }
        TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_SELECT_ITEMS_IN_TIME_RANGE), CAMContextMenuSelectionModel.selectItemsInTimeRange(context).size() > 0, () -> {
            camsPanel.setSelectedJobs(CAMContextMenuSelectionModel.selectItemsInTimeRange(context), false);
            camsPanel.repaint();
        });
        TimelineContextMenu.addSimpleMenuItem(menu, (String)NullChecking.neverNull((Object)TimelineCommonMessages.CV_SELECT_MATCHING), pattern != null, () -> {
            camsPanel.setSelectedJobs(CAMContextMenuSelectionModel.selectMatching(context), false);
            camsPanel.repaint();
        });
    }

    private static void addSimpleMenuItem(@NonNull Menu menu, @NonNull String label, boolean enabled, final @NonNull MenuAction action) {
        @NonNull MenuItem item = new MenuItem(menu, 8);
        item.setText(label);
        item.setEnabled(enabled);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.apply();
            }
        });
    }

    @FunctionalInterface
    private static interface MenuAction {
        public void apply();
    }
}

