/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.IRowSelection;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.utility.Timing;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.utils.NullChecking;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class HandlePanel<T>
extends Block
implements IBlockLayout {
    private final int rowHeightOpen;
    private final int rowHeightClosed;
    private boolean mAutoScrollPending;
    private final @NonNull BaseTimelineContent mContent;
    protected int mIndent;
    private DragTracker mTracker;
    private boolean mTitleWasTruncated;
    protected final @NonNull IRowSelection mSelection;

    public HandlePanel(@NonNull BaseTimelineContent content, int indent, @NonNull IRowSelection selection, int rowHeight) {
        this(content, indent, selection, rowHeight, rowHeight);
    }

    public HandlePanel(@NonNull BaseTimelineContent content, int indent, @NonNull IRowSelection selection, int rowHeightOpen, int rowHeightClosed) {
        this.mContent = content;
        this.mIndent = indent;
        this.mSelection = selection;
        this.rowHeightOpen = rowHeightOpen;
        this.rowHeightClosed = rowHeightClosed;
    }

    private int getRenderRowHeight() {
        if (this.isOpen()) {
            return this.rowHeightOpen;
        }
        return this.rowHeightClosed;
    }

    public final @NonNull BaseTimelineContent getContent() {
        return this.mContent;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return new Point(widthHint == -1 ? 200 : widthHint, this.getRecursiveHandlePanelChildrenHeight());
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        return new Point(widthHint == -1 ? this.mContent.getHandleAreaWidth() + 100 : widthHint, this.getRecursiveHandlePanelChildrenHeight());
    }

    public int getPreferredWidth() {
        int thisPanelPreferredWidth = this.getContentWidth();
        return Arrays.stream(this.getChildren()).filter(child -> child instanceof HandlePanel).map(block -> (HandlePanel)block).mapToInt(handlePanel -> handlePanel.getPreferredWidth()).filter(width -> width > thisPanelPreferredWidth).max().orElse(thisPanelPreferredWidth);
    }

    protected abstract List<? extends T> getRowSiblings();

    public abstract int getRowUID();

    public boolean isOpen() {
        return this.isRowOpen();
    }

    public final boolean isOverSelectionArea(Point where) {
        Rectangle bounds = this.getLocalBounds();
        bounds.width = this.getContent().getHandleAreaWidth();
        return bounds.contains(where) && !this.isOverDisclosure(where) && !this.isOverHorizontalResizeGrip(where);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layout(Block target) {
        Rectangle bounds = this.getLocalBounds();
        int count = this.getChildCount();
        int handleAreaWidth = this.mContent.getHandleAreaWidth();
        int renderRowHeight = this.getRenderRowHeight();
        this.setRelatedControlBounds(bounds.x + handleAreaWidth, bounds.y, bounds.width - handleAreaWidth, renderRowHeight);
        int x = bounds.x;
        int y = bounds.y + renderRowHeight;
        int i = 0;
        while (i < count) {
            Block child = this.getChild(i);
            Block block = child;
            if (block instanceof HandlePanel) {
                void childHandlePanel;
                HandlePanel cfr_ignored_0 = (HandlePanel)block;
                HandlePanel cfr_ignored_1 = (HandlePanel)block;
                int height = childHandlePanel.getRecursiveHandlePanelChildrenHeight();
                child.setBounds(x, y, bounds.width, height);
                y += height;
            }
            ++i;
        }
    }

    public final void setOpen(boolean open) {
        if (this.isRowOpen() != open) {
            this.doOpen(open, true);
        }
    }

    protected int getContentWidth() {
        Font TITLE_FONT = Fonts.getNormal();
        @NonNull String titleText = this.getTitle();
        Rectangle disclosureArea = this.getDisclosureHitArea();
        int left = disclosureArea.x + disclosureArea.width;
        int iconWidth = this.getIconWidth();
        int titleTextWidth = FontInfo.get(TITLE_FONT).getWidth(titleText) + iconWidth;
        int margins = left + 4 + this.mIndent + 14 + 4;
        return titleTextWidth + margins;
    }

    private int getIconWidth() {
        return this.getIconImage() != null ? ((Image)NullChecking.neverNull((Object)this.getIconImage())).getBounds().width + 8 : 0;
    }

    protected final int getSlotWidth() {
        return this.mContent.getSlotWidth();
    }

    protected final Rectangle getDisclosureHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.y += (FontInfo.get(Fonts.getNormal()).getHeight() - StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.height) / 2;
        bounds.width = StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width + 8;
        bounds.height = StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.height + 4;
        if (this.mIndent > 0) {
            bounds.x += this.mIndent;
            int right = bounds.x + this.getContent().getHandleAreaWidth() - 20;
            if (bounds.x + bounds.width > right) {
                bounds.width += right - (bounds.x + bounds.width);
                if (bounds.width < 0) {
                    bounds.width = 0;
                }
            }
        }
        return bounds;
    }

    protected abstract Color getForegroundColor();

    /*
     * WARNING - void declaration
     */
    private int getRecursiveHandlePanelChildrenHeight() {
        int height = this.getRenderRowHeight();
        Block[] blockArray = this.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block child = blockArray[n2];
            Block block = child;
            if (block instanceof HandlePanel) {
                void childHandlePanel;
                HandlePanel cfr_ignored_0 = (HandlePanel)block;
                HandlePanel cfr_ignored_1 = (HandlePanel)block;
                height += childHandlePanel.getRecursiveHandlePanelChildrenHeight();
            }
            ++n2;
        }
        return height;
    }

    public abstract @NonNull List<@NonNull ? extends T> getRowChildren();

    protected abstract @NonNull String getTitle();

    protected abstract String getResizeGripToolTipText();

    protected abstract boolean isRowOpen();

    protected abstract @Nullable Image getIconImage();

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            if (count == 2) {
                if (this.isOverHorizontalResizeGrip(where)) {
                    this.getContent().autoresizeHandlePanels();
                } else if (this.isOverSelectionArea(where) && this.getRowChildren().size() > 0) {
                    this.setOpen(!this.isOpen());
                }
            } else if (count == 1) {
                this.adjustCursorAndToolTip(where);
                if (this.isOverDisclosure(where)) {
                    this.mTracker = new DisclosureTracker();
                } else if (this.isOverHorizontalResizeGrip(where)) {
                    this.mTracker = new HorizontalResizeTracker(where.x);
                } else if (this.isOverSelectionArea(where)) {
                    this.mTracker = this.createMoveTracker(where);
                    if (this.mTracker != null) {
                        this.mTracker.mouseDown(where, button, stateMask, count);
                    }
                }
            }
        } else if (button == 3 && count == 1) {
            Point locationInDisplayCoords = this.toDisplay(where);
            this.showHandlePanelContextMenu(locationInDisplayCoords);
        }
    }

    protected abstract void showHandlePanelContextMenu(Point var1);

    protected abstract @Nullable DragTracker createMoveTracker(Point var1);

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.getContent().setBookmarkPopOver(null);
        this.adjustCursorAndToolTip(where);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursorAndToolTip(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        this.drawBackground(gc);
        this.drawDisclosure(gc);
        this.drawTitle(gc);
        this.drawMarker(gc);
    }

    protected abstract void setRelatedControlBounds(int var1, int var2, int var3, int var4);

    protected abstract void setRowOpenness(boolean var1);

    protected final boolean shouldShowAnnotationMarker(ITimelineRowProvider row) {
        switch (row.getRowType()) {
            case GROUP: 
            case ANNOTATION: {
                return true;
            }
            case PROCESS: 
            case THREAD: {
                for (ITimelineRowProvider child : row.getChildren()) {
                    if (!this.shouldShowAnnotationMarker(child)) continue;
                    return true;
                }
                return false;
            }
            case VMUID: 
            case CPU: {
                return false;
            }
        }
        throw new AssertionError((Object)row.getRowType());
    }

    protected abstract boolean shouldShowAnnotationMarkerForRow();

    private final void adjustCursorAndToolTip(Point where) {
        String tip = null;
        int cursorID = 0;
        if (where.x < this.getLocalBounds().x + this.getContent().getHandleAreaWidth()) {
            if (this.isOverDisclosure(where)) {
                cursorID = 21;
            } else if (this.isOverHorizontalResizeGrip(where)) {
                cursorID = 9;
                tip = this.getResizeGripToolTipText();
            } else if (this.mTitleWasTruncated) {
                tip = this.getTitle();
            }
        }
        this.setCursor(this.getDisplay().getSystemCursor(cursorID));
        this.setToolTip(tip);
    }

    private final void autoScroll(int amount) {
        BlockScrollBar scrollbar;
        int y;
        this.mAutoScrollPending = false;
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null && this.getScrollAmount(scroller, y = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).y) != 0 && (scrollbar = scroller.getVerticalBar()) != null) {
            scrollbar.setValue(scrollbar.getValue() + (long)amount);
            if (this.mTracker != null) {
                this.mTracker.mouseDrag(new Point(0, y), 0);
            }
        }
    }

    protected void doOpen(boolean open, boolean doRepackImmediatelly) {
        Block parent;
        Timing.startDisclosure();
        int count = 0;
        this.setRowOpenness(open);
        if (open) {
            for (T row : this.getRowChildren()) {
                HandlePanel<T> childPanel;
                if (!this.passesFilter(row) || (childPanel = this.constructChildPanel(row)) == null) continue;
                this.add(childPanel);
                ++count;
            }
        } else {
            TIntHashSet removed = new TIntHashSet();
            int i = this.getChildCount();
            while (--i >= 0) {
                Block child = this.getChild(i);
                if (!(child instanceof HandlePanel)) continue;
                HandlePanel childHandlePanel = (HandlePanel)child;
                int id = childHandlePanel.getRowUID();
                if (this.mSelection.isRowSelected(id)) {
                    removed.add(id);
                }
                childHandlePanel.setRowOpenness(open);
                this.remove(i);
                ++count;
            }
            if (!removed.isEmpty()) {
                this.mSelection.deselectRows(removed.toArray());
            }
            this.layoutAll();
        }
        if (doRepackImmediatelly && (parent = this.getTopmostContainerBlock()) != null) {
            parent.pack();
        }
        Timing.endDisclosure((open ? "Opened " : "Closed ") + count + " row" + (count != 1 ? "s" : ""));
    }

    protected abstract boolean passesFilter(@NonNull T var1);

    protected abstract HandlePanel<T> constructChildPanel(@NonNull T var1);

    protected abstract Block getTopmostContainerBlock();

    private final void drawBackground(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int handleAreaWidth = this.getContent().getHandleAreaWidth();
        int renderRowHeight = this.getRenderRowHeight();
        Color background = Colors.getWidgetBackground();
        if (this.mSelection.isRowSelected(this.getRowUID())) {
            background = Colors.darken(background, 10);
        }
        gc.setBackground(background);
        gc.fillRectangle(bounds.x, bounds.y, handleAreaWidth, renderRowHeight);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int bottom = bounds.y + renderRowHeight - 1;
        gc.setForeground(Colors.getWidgetNormalShadow());
        gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        int x = bounds.x + handleAreaWidth - 1;
        gc.drawLine(x, bounds.y, x, bottom);
        Rectangle grip = this.getHorizontalResizeGripHitArea();
        x = grip.x - 1;
        gc.setAlpha(96);
        gc.drawLine(x, bounds.y, x, bottom);
        gc.setForeground(Colors.getWidgetHighlightShadow());
        gc.drawLine(++x, bounds.y, x, bottom);
        gc.setAlpha(255);
        gc.setAntialias(savedAA);
    }

    private final void drawDisclosure(GC gc) {
        if (this.hasDisclosure()) {
            Rectangle bounds = this.getDisclosureHitArea();
            Rectangle clipping = gc.getClipping();
            gc.setClipping(clipping.intersection(bounds));
            gc.drawImage(StreamlinePlugin.getImage(this.isRowOpen() ? StreamlineImages.DISCLOSURE_DOWN : StreamlineImages.DISCLOSURE_UP), bounds.x + 4, bounds.y + 2);
            gc.setClipping(clipping);
        }
    }

    private final void drawMarker(GC gc) {
        if (this.shouldShowAnnotationMarkerForRow()) {
            Rectangle bounds = this.getHorizontalResizeGripHitArea();
            int renderRowHeight = this.getRenderRowHeight();
            gc.setFont(Fonts.getSmall());
            gc.setForeground(this.getForegroundColor());
            TextDrawing.drawString(gc, "A", bounds.x, bounds.y, bounds.width, renderRowHeight, 0x1000000, 0x1000000);
        }
    }

    private final void drawTitle(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        gc.setFont(Fonts.getNormal());
        gc.setForeground(Colors.getWidgetForeground());
        Rectangle disclosureArea = this.getDisclosureHitArea();
        int left = disclosureArea.x + disclosureArea.width;
        int width = this.getHorizontalResizeGripHitArea().x - (left + 4);
        @Nullable Image iconImage = this.getIconImage();
        int iconWidth = this.getIconWidth();
        if (width > iconWidth && iconImage != null) {
            int renderRowHeight = this.getRenderRowHeight();
            int imageY = bounds.y + (renderRowHeight - ((Image)NullChecking.neverNull((Object)iconImage)).getBounds().height) / 2;
            gc.drawImage(this.getIconImage(), left, imageY);
        }
        int textLeft = left + iconWidth;
        int widthForTitle = width - iconWidth;
        if (widthForTitle > 0) {
            String trimmedName;
            String name = this.getTitle();
            this.mTitleWasTruncated = !name.equals(trimmedName = TextDrawing.truncateString(gc, name, widthForTitle, 131072));
            TextDrawing.drawString(gc, trimmedName, textLeft, bounds.y + 2, 16384);
        } else {
            this.mTitleWasTruncated = true;
        }
    }

    final Rectangle getHorizontalResizeGripHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.width = 18;
        bounds.x += this.getContent().getHandleAreaWidth() - bounds.width;
        return bounds;
    }

    final int getScrollAmount(ScrollingBlock scroller, int y) {
        int amount = 0;
        if (scroller != null) {
            int top = scroller.toRootY(0);
            int bottom = top + scroller.getHeight() - 1;
            int pos = this.toRootY(y);
            if (pos < top + 5) {
                amount = -20;
            } else if (pos > bottom - 5) {
                amount = 20;
            }
        }
        return amount;
    }

    final boolean hasDisclosure() {
        return !this.getRowChildren().isEmpty();
    }

    final boolean isOverDisclosure(Point where) {
        if (this.hasDisclosure()) {
            return this.getDisclosureHitArea().contains(where);
        }
        return false;
    }

    final boolean isOverHorizontalResizeGrip(Point where) {
        return this.getHorizontalResizeGripHitArea().contains(where);
    }

    public final void setupAutoScroll(int y) {
        int amount;
        ScrollingBlock scroller;
        if (!this.mAutoScrollPending && (scroller = this.getContainingScrollingBlock()) != null && (amount = this.getScrollAmount(scroller, y)) != 0) {
            this.mAutoScrollPending = true;
            int scroll = amount;
            Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    protected class DisclosureTracker
    extends TimelineDragTracker {
        public DisclosureTracker() {
            super(HandlePanel.this);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            if (HandlePanel.this.isOverDisclosure(where)) {
                HandlePanel.this.setOpen(!HandlePanel.this.isOpen());
            }
            super.mouseUp(where, button, stateMask, count);
        }
    }

    protected class HorizontalResizeTracker
    extends TimelineDragTracker {
        private int mStartX;
        private int mStartWidth;

        public HorizontalResizeTracker(int x) {
            super(HandlePanel.this);
            this.mStartX = x;
            this.mStartWidth = HandlePanel.this.getContent().getHandleAreaWidth();
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            HandlePanel.this.getContent().getChartsPanel().setHandleAreaWidth(this.mStartWidth + where.x - this.mStartX);
        }
    }
}

