/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.IUniqueThreadSelectionHandler;
import com.arm.streamline.editortabs.timeline.common.bookmarks.BookmarkPopOver;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.csm.CrossSectionHandlePanel;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.iterable.LogEntrySelectionIterator;
import com.arm.streamline.model.iterable.SelectionIterator;
import com.arm.streamline.model.iterable.TimelineSelectionIterator;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockComposite;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ContentWrapper
extends BlockComposite
implements ISelectionProvider,
IBlockLayout {
    public static final int DEFAULT_DIVIDER_POSITION = -1;
    public static final int CAM_INFO_PANEL_WIDTH = 300;
    private int mDividerPosition = -1;
    private RulerPanel mRulerPanel;
    private CrossSectionHandlePanel mCrossSectionHandlePanel;
    private ScrollingBlock mChartsScroller;
    private final @NonNull ChartsPanel mChartsPanel;
    private DividerPanel mDividerPanel;
    private Block mBottomPanel;
    private BlockToolbar mBottomToolbar;
    private BookmarkPopOver mBookmarkPopOver;
    private boolean mHasBeenLaidOut;

    private static final void stack(Point totalSize, Point blockSize) {
        if (totalSize.x < blockSize.x) {
            totalSize.x = blockSize.x;
        }
        totalSize.y += blockSize.y;
    }

    private static final void stackMinimumSize(Block block, Point size, int widthHint) {
        ContentWrapper.stack(size, block.getMinimumSize(widthHint, -1));
    }

    private static final void stackPreferredSize(Block block, Point size, int widthHint) {
        ContentWrapper.stack(size, block.getPreferredSize(widthHint, -1));
    }

    public ContentWrapper(@NonNull BaseTimelineContent content, int handleWidth) {
        super(content);
        BlockRoot root = this.getRoot();
        this.mRulerPanel = new RulerPanel(content);
        root.add(this.mRulerPanel);
        this.mCrossSectionHandlePanel = new CrossSectionHandlePanel(content);
        root.add(this.mCrossSectionHandlePanel);
        this.mChartsPanel = new ChartsPanel(content, handleWidth);
        this.mChartsPanel.pack();
        this.mChartsScroller = new ScrollingBlock(this.mChartsPanel);
        this.mChartsScroller.setHorizontalExpansion(ScrollingBlock.Expansion.SIZE_OF_VIEWPORT);
        root.add(this.mChartsScroller);
        this.mDividerPanel = content.createDividerPanel();
        root.add(this.mDividerPanel);
        root.setLayout(this);
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public final BookmarkPopOver getBookmarkPopOver() {
        return this.mBookmarkPopOver;
    }

    public final Block getBottomPanel() {
        return this.mBottomPanel;
    }

    public BlockToolbar getBottomToolbar() {
        return this.mBottomToolbar;
    }

    public final @NonNull ChartsPanel getChartsPanel() {
        return this.mChartsPanel;
    }

    public final ScrollingBlock getChartsScroller() {
        return this.mChartsScroller;
    }

    public final CrossSectionHandlePanel getCrossSectionHandlePanel() {
        return this.mCrossSectionHandlePanel;
    }

    public final DividerPanel getDividerPanel() {
        return this.mDividerPanel;
    }

    public final int getDividerPosition() {
        return this.mDividerPosition;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        Point size = new Point(0, 0);
        ContentWrapper.stackMinimumSize(this.mRulerPanel, size, widthHint);
        ContentWrapper.stackMinimumSize(this.mCrossSectionHandlePanel, size, widthHint);
        ContentWrapper.stackMinimumSize(this.mChartsScroller, size, widthHint);
        ContentWrapper.stackMinimumSize(this.mDividerPanel, size, widthHint);
        if (this.mBottomPanel != null) {
            ContentWrapper.stackMinimumSize(this.mBottomPanel, size, widthHint);
        }
        if (this.mBottomToolbar != null) {
            ContentWrapper.stackMinimumSize(this.mBottomToolbar, size, widthHint);
        }
        return size;
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        Point size = new Point(0, 0);
        ContentWrapper.stackPreferredSize(this.mRulerPanel, size, widthHint);
        ContentWrapper.stackPreferredSize(this.mCrossSectionHandlePanel, size, widthHint);
        ContentWrapper.stackPreferredSize(this.mChartsScroller, size, widthHint);
        ContentWrapper.stackPreferredSize(this.mDividerPanel, size, widthHint);
        if (this.mBottomPanel != null) {
            ContentWrapper.stackPreferredSize(this.mBottomPanel, size, widthHint);
        }
        if (this.mBottomToolbar != null) {
            ContentWrapper.stackPreferredSize(this.mBottomToolbar, size, widthHint);
        }
        return size;
    }

    public final RulerPanel getRulerPanel() {
        return this.mRulerPanel;
    }

    public final ISelection getSelection() {
        return null;
    }

    public final boolean hasBeenLaidOut() {
        return this.mHasBeenLaidOut;
    }

    @Override
    public final void layout(Block target) {
        int topHeight;
        int bottomToolbarHeight;
        Rectangle bounds = target.getLocalBounds();
        int x = bounds.x;
        int width = bounds.width;
        int top = bounds.y;
        int remaining = bounds.height;
        int height = this.mRulerPanel.getPreferredSize((int)width, (int)-1).y;
        remaining -= height;
        this.mRulerPanel.setBounds(x, top, width, height);
        top += height;
        height = this.mCrossSectionHandlePanel.getPreferredSize((int)width, (int)-1).y;
        remaining -= height;
        this.mCrossSectionHandlePanel.setBounds(x, top, width, height);
        top += height;
        int dividerHeight = this.mDividerPanel.getPreferredSize((int)width, (int)-1).y;
        if ((remaining -= dividerHeight) < 0) {
            remaining = 0;
        }
        int n = bottomToolbarHeight = this.mBottomToolbar != null ? this.mBottomToolbar.getPreferredSize((int)width, (int)-1).y : 0;
        if ((remaining -= bottomToolbarHeight) < 0) {
            remaining = 0;
        }
        if (this.mDividerPosition == -1) {
            topHeight = remaining * 3 / 4;
        } else {
            if (this.mDividerPosition > remaining) {
                this.mDividerPosition = remaining;
            }
            topHeight = this.mDividerPosition;
        }
        height = this.mChartsScroller.getPreferredSize((int)width, (int)-1).y;
        if (height > topHeight) {
            height = topHeight;
        }
        this.mChartsScroller.setBounds(x, top, width, height);
        this.mDividerPanel.setBounds(x, top += height, width, dividerHeight);
        top += dividerHeight;
        if ((remaining -= height) < 0) {
            remaining = 0;
        }
        if (this.mBottomPanel != null) {
            this.mBottomPanel.setBounds(x, top, width, remaining);
            top += remaining;
        }
        if (this.mBottomToolbar != null) {
            this.mBottomToolbar.setBounds(x, top, width, bottomToolbarHeight);
        }
        this.mHasBeenLaidOut = true;
        this.mDividerPanel.setPosition(this.mDividerPanel.getPosition());
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public final void setBookmarkPopOver(BookmarkPopOver bookmarkPopOver) {
        boolean changed = false;
        if (this.mBookmarkPopOver != null) {
            this.mBookmarkPopOver.removeFromParent();
            this.getRoot().repaint(this.mBookmarkPopOver.getBounds());
            this.mBookmarkPopOver = null;
            changed = true;
        }
        if (bookmarkPopOver != null) {
            this.mBookmarkPopOver = bookmarkPopOver;
            this.getRoot().add(this.mBookmarkPopOver);
            this.mBookmarkPopOver.adjust();
            changed = true;
        }
        if (changed) {
            this.mRulerPanel.repaint();
            this.mCrossSectionHandlePanel.repaint();
        }
    }

    public final void setBottomPanel(Block bottomPanel) {
        if (this.mBottomPanel != null) {
            this.mBottomPanel.removeFromParent();
        }
        this.mBottomPanel = bottomPanel;
        if (this.mBottomPanel != null) {
            this.getRoot().add(this.mBottomPanel);
        }
    }

    public final void setBottomToolbar(BlockToolbar toolbar) {
        if (this.mBottomToolbar != null) {
            this.mBottomToolbar.removeFromParent();
        }
        this.mBottomToolbar = toolbar;
        if (this.mBottomToolbar != null) {
            this.getRoot().add(this.mBottomToolbar);
        }
    }

    public final void setDividerPosition(int dividerPosition) {
        this.mDividerPosition = dividerPosition;
        BlockRoot root = this.getRoot();
        if (root.getHeight() > 0) {
            root.layout();
        }
    }

    public final void setSelection(ISelection selection) {
        IUniqueThreadID[] uniqueThreads;
        if (selection instanceof ReadOnlyStdSelection) {
            long timeIndexLeft = Long.MAX_VALUE;
            long timeIndexRight = Long.MIN_VALUE;
            for (LogEntry logEntry : new LogEntrySelectionIterator(selection)) {
                timeIndexLeft = Math.min(logEntry.getTimelineMarker(), timeIndexLeft);
                timeIndexRight = Math.max(logEntry.getEndTimelineMarker() - 1L, timeIndexRight);
            }
            if (timeIndexLeft != Long.MAX_VALUE) {
                ICaptureDataProvider cdp = this.mChartsPanel.getCaptureDataProvider();
                Scales scales = cdp.getScales();
                ZoomLevel zoomLevel = scales.getZoomLevel();
                ZoomLevel densestZoomLevel = scales.getDensestZoomLevel();
                Position left = new Position(timeIndexLeft, Scales.ONE_MICROSECOND_ZOOM_LEVEL, densestZoomLevel);
                Position right = timeIndexRight > timeIndexLeft ? new Position(timeIndexRight, Scales.ONE_MICROSECOND_ZOOM_LEVEL, densestZoomLevel) : left;
                cdp.getCrossSectionMarker().set(left, right);
                this.mChartsPanel.getBaseTimelineContent().centerViewOn(left.get(zoomLevel), right.get(zoomLevel));
            }
        } else if (selection instanceof StructuredSelection && (uniqueThreads = SelectionIterator.toArray(new TimelineSelectionIterator(selection), new IUniqueThreadID[0])).length > 0) {
            ((IUniqueThreadSelectionHandler)((Object)this.mBottomToolbar)).handleUniqueThreadSelection((IUniqueID[])uniqueThreads);
        }
    }
}

