/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.cmdline.ValueReporting;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.report.BaseExportDialog;
import com.arm.streamline.editortabs.timeline.TimelineMessages;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.utility.io.CharacterConversionOutputStream;
import com.arm.streamline.widget.Error;
import com.arm.utils.text.SWTLabelFilter;
import gnu.trove.set.TIntSet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExportTimelineDialog
extends BaseExportDialog {
    private static ValueReporting DEFAULT_VALUE_REPORTING = ValueReporting.AGGREGATE;
    private Combo mValueReportingCombo;

    public static void setDefaultValueReporting(ValueReporting valueReporting) {
        DEFAULT_VALUE_REPORTING = valueReporting;
    }

    public static void show(Analysis analysis, long start, long end, TIntSet selectedProcessAndThreadIds) {
        String filename = MessageFormat.format("timeline_for_{0}.csv", analysis);
        String path = FilePath.getPathForPlatform((String)FilePath.getFullPath((String)ExportTimelineDialog.getDefaultPath(), (String)filename));
        ExportTimelineDialog dialog = new ExportTimelineDialog(path);
        dialog.create();
        if (dialog.open() == 0) {
            try {
                try {
                    long actualStart = start < 0L ? 0L : start;
                    int binCount = analysis.getBinCount();
                    long actualEnd = end < 0L || end > (long)binCount ? (long)binCount : end;
                    @NonNull ZoomLevel zoomLevel = analysis.getScales().getZoomLevel();
                    ReportProcessor.Format format = ExportTimelineDialog.getSelectedFormat();
                    String outputPath = dialog.getPath();
                    new ProgressMonitorDialog(null).run(true, true, monitor -> {
                        try {
                            Throwable throwable = null;
                            Object var11_11 = null;
                            try (PrintStream out = new PrintStream(new CharacterConversionOutputStream(new BufferedOutputStream(new FileOutputStream(outputPath)), '\u00b5', 'u'));){
                                analysis.setReportGeneration(true);
                                ReportProcessor.dumpTimeline(analysis, DEFAULT_VALUE_REPORTING, zoomLevel, actualStart, actualEnd, selectedProcessAndThreadIds, out, format, monitor);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException ioe) {
                            Error.show(ioe);
                        }
                    });
                }
                catch (InterruptedException actualStart) {
                    analysis.setReportGeneration(false);
                }
                catch (Exception exception) {
                    Error.show(exception);
                    analysis.setReportGeneration(false);
                }
            }
            finally {
                analysis.setReportGeneration(false);
            }
        }
    }

    private ExportTimelineDialog(String path) {
        super(path, TimelineMessages.EXPORT_TIMELINE_MESSAGE, "com.arm.streamline.export_timeline");
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.mValueReportingCombo) {
            ExportTimelineDialog.setDefaultValueReporting(ValueReporting.values()[this.mValueReportingCombo.getSelectionIndex()]);
        } else {
            super.widgetSelected(event);
        }
    }

    @Override
    protected void addAdditionalOptions() {
        this.addDivider();
        ExportTimelineDialog.createLabel(this.mContent, TimelineMessages.EXPORT_TIMELINE_TITLE, TimelineMessages.EXPORT_TIMELINE_TOOLTIP);
        this.mValueReportingCombo = this.createCombo(this.mContent, TimelineMessages.EXPORT_TIMELINE_TOOLTIP, (Object[])ValueReporting.values());
    }

    private Combo createCombo(Composite parent, String tooltip, Object[] values) {
        Combo combo = new Combo(parent, 8);
        int i = 0;
        while (i < values.length) {
            combo.add(values[i].toString());
            if (values[i] == DEFAULT_VALUE_REPORTING) {
                combo.select(i);
            }
            ++i;
        }
        combo.setVisibleItemCount(combo.getItemCount());
        combo.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        combo.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)combo);
        return combo;
    }
}

