/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.streamline.editortabs.AbstractInstructionCounterColumn;
import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.widget.outline.HistogramCell;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramUnscaledCellDataProvider<T>
implements HistogramCellDataProvider.IHistogramSizedCellDataProvider<T> {
    private static final int MIN_WIDTH = 4;
    protected final long @NonNull [] datapointBase;
    protected final int @NonNull [] datapointPixelBase;
    protected final int @NonNull [] datapointPixelWidth;
    protected final int @NonNull [] datapointWidth;
    protected final @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper;
    protected final long numberOfDataPoints;
    protected final int pixelWidth;
    protected final long smallestDataPoint;
    protected final @NonNull String unitsSuffix;
    protected final @Nullable Integer @NonNull [] colours;

    public HistogramUnscaledCellDataProvider(boolean linearScale, int pixelWidth, long numberOfDataPoints, long @NonNull [] datapointBase, int @NonNull [] datapointWidth, long smallestDataPoint, @NonNull String units, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userPreference, int typicalBinCount) {
        this(linearScale, 4, pixelWidth, numberOfDataPoints, datapointBase, datapointWidth, smallestDataPoint, units, mapper, colourPreference, userPreference, typicalBinCount);
    }

    HistogramUnscaledCellDataProvider(boolean linearScale, int minWidth, int pixelWidth, long numberOfDataPoints, long @NonNull [] datapointBase, int @NonNull [] datapointWidth, long smallestDataPoint, @NonNull String units, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer userPreference, int typicalBinCount) {
        assert (minWidth > 0);
        assert (pixelWidth > 0);
        assert (datapointBase.length * minWidth <= pixelWidth);
        units = units.trim();
        this.pixelWidth = pixelWidth;
        this.mapper = mapper;
        this.datapointBase = datapointBase;
        this.datapointWidth = datapointWidth;
        this.datapointPixelBase = new int[datapointWidth.length];
        this.datapointPixelWidth = new int[datapointWidth.length];
        this.smallestDataPoint = smallestDataPoint;
        this.numberOfDataPoints = numberOfDataPoints;
        this.unitsSuffix = units.isEmpty() ? units : String.format(" %s", units);
        double pixelScale = (double)pixelWidth / (double)Math.max(1, datapointBase.length);
        int i = 0;
        while (i < datapointBase.length) {
            int previousEnd;
            int scaledWidth;
            int scaledBase;
            if (linearScale) {
                long dpBase = datapointBase[i] - smallestDataPoint;
                int dpWidth = datapointWidth[i];
                long dpEnd = dpBase + (long)dpWidth;
                int scaledLimit = Math.toIntExact(dpEnd * (long)pixelWidth / numberOfDataPoints);
                scaledBase = Math.toIntExact(dpBase * (long)pixelWidth / numberOfDataPoints);
                scaledWidth = Math.max(minWidth, scaledLimit - scaledBase);
            } else {
                int scaledLimit = Math.toIntExact((long)((double)(i + 1) * pixelScale));
                scaledBase = Math.toIntExact((long)((double)i * pixelScale));
                scaledWidth = Math.max(minWidth, scaledLimit - scaledBase);
            }
            int scaledEnd = scaledBase + scaledWidth;
            int maxBase = pixelWidth - datapointBase.length * minWidth + i * minWidth;
            int maxEnd = maxBase + minWidth;
            int n = previousEnd = i > 0 ? this.datapointPixelBase[i - 1] + this.datapointPixelWidth[i - 1] : 0;
            assert (previousEnd <= maxBase);
            int actualBase = Math.min(maxBase, Math.max(previousEnd, scaledBase));
            int actualEnd = Math.min(scaledEnd, maxEnd);
            int actualWidth = actualEnd - actualBase;
            if (actualWidth >= minWidth) {
                this.datapointPixelBase[i] = actualBase;
                this.datapointPixelWidth[i] = actualWidth;
            } else if (actualBase <= maxBase) {
                this.datapointPixelBase[i] = actualBase;
                this.datapointPixelWidth[i] = minWidth;
            } else {
                this.datapointPixelBase[i] = maxBase;
                this.datapointPixelWidth[i] = minWidth;
            }
            ++i;
        }
        this.colours = AbstractInstructionCounterColumn.makeColourSpread(colourPreference, userPreference, Math.max(typicalBinCount, datapointBase.length));
    }

    @Override
    public  @Nullable HistogramCell.IHistogramData get(@NonNull T value) {
        ISampleCounterColumnAccessorFactory.HistogramValue histogramDataSet = this.mapper.apply(value);
        if (histogramDataSet == null) {
            return null;
        }
        final double limit = histogramDataSet.scalingLimit();
        final long[] histogramData = histogramDataSet.values();
        assert (histogramData.length == this.datapointBase.length);
        return new HistogramCell.IHistogramData(){

            @Override
            public int getBinCount() {
                return histogramData.length;
            }

            @Override
            public int getBinOffset(int bin) {
                if (bin < histogramData.length) {
                    return HistogramUnscaledCellDataProvider.this.datapointPixelBase[bin];
                }
                return HistogramUnscaledCellDataProvider.this.pixelWidth;
            }

            @Override
            public double getBinValue(int bin) {
                return (double)histogramData[bin] / limit;
            }

            @Override
            public int getBinWidth(int bin) {
                if (bin < histogramData.length) {
                    return HistogramUnscaledCellDataProvider.this.datapointPixelWidth[bin];
                }
                return 0;
            }

            @Override
            public @NonNull String getLabelForBin(int bin) {
                long base = HistogramUnscaledCellDataProvider.this.datapointBase[bin];
                int width = HistogramUnscaledCellDataProvider.this.datapointWidth[bin];
                if (width > 1) {
                    long end = base + (long)width - 1L;
                    return String.format("%d-%d%s: %d", base, end, HistogramUnscaledCellDataProvider.this.unitsSuffix, histogramData[bin]);
                }
                return String.format("%d%s: %d", base, HistogramUnscaledCellDataProvider.this.unitsSuffix, histogramData[bin]);
            }

            @Override
            public double getMaxValue() {
                long result = 0L;
                long[] lArray = histogramData;
                int n = histogramData.length;
                int n2 = 0;
                while (n2 < n) {
                    long d = lArray[n2];
                    result = Math.max(result, d);
                    ++n2;
                }
                return (double)result / limit;
            }

            @Override
            public @Nullable String getText() {
                return null;
            }

            @Override
            public @Nullable Integer getColour(int bin) {
                return HistogramUnscaledCellDataProvider.this.colours[bin];
            }
        };
    }
}

