/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.streamline.editortabs.histogram.HistogramScaledCellDataProvider;
import com.arm.streamline.editortabs.histogram.HistogramUnscaledCellDataProvider;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.HistogramDataPoint;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.HistogramCell;
import com.arm.streamline.widget.outline.Row;
import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramCellDataProvider<T extends IExtractable>
implements HistogramCell.IHistogramCellDataProvider<EnumColumn<T>> {
    private final @NonNull BaseProvider<T> baseProvider;

    public HistogramCellDataProvider(@NonNull HistogramDataPoint @NonNull [] datapoints, boolean scaleRelativeToLimit, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer colour, int typicalBinCount, @NonNull String units, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper) {
        this.baseProvider = new BaseProvider<T>(datapoints, scaleRelativeToLimit, colourPreference, colour, typicalBinCount, units, mapper);
    }

    @Override
    public int compare(EnumColumn<T> column, Row<EnumColumn<T>> one, Row<EnumColumn<T>> two) {
        @NonNull T value1 = ((ReportRow)one).getModelObject();
        @NonNull T value2 = ((ReportRow)two).getModelObject();
        long total1 = this.baseProvider.calculateTotal(value1);
        long total2 = this.baseProvider.calculateTotal(value2);
        return Long.compare(total1, total2);
    }

    @Override
    public  @Nullable HistogramCell.IHistogramData get(EnumColumn<T> column, Row<EnumColumn<T>> row, int pixelWidth) {
        @NonNull T value = ((ReportRow)row).getModelObject();
        return this.baseProvider.getForPixelWidth(pixelWidth).get(value);
    }

    @Override
    public @Nullable String getTooltip(EnumColumn<T> column, Row<EnumColumn<T>> row) {
        return null;
    }

    @Override
    public boolean shouldScaleRelativeToLimit() {
        return this.baseProvider.scaleRelativeToLimit;
    }

    public static final class BaseProvider<T> {
        private static final boolean USE_LINEAR_SCALE = false;
        public final @Nullable Integer colour;
        public final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IColumnDescriptor.ColourPreference colourPreference;
        public final long largestDataPoint;
        public final @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper;
        public final long numberOfDataPoints;
        public final boolean scaleRelativeToLimit;
        public final long smallestDataPoint;
        public final @NonNull String units;
        protected final long @NonNull [] datapointBase;
        protected final int @NonNull [] datapointWidth;
        private @Nullable IHistogramSizedCellDataProvider<T> lastDataProvider;
        private long lastPixelWidth = 0L;
        private final @NonNull IHistogramSizedCellDataProvider<T> zeroWidthDataProvider;
        private final int typicalBinCount;

        public BaseProvider(@NonNull HistogramDataPoint @NonNull [] datapoints, boolean scaleRelativeToLimit, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IColumnDescriptor.ColourPreference colourPreference, @Nullable Integer colour, int typicalBinCount, @NonNull String units, @NonNull Function<@NonNull T, // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ISampleCounterColumnAccessorFactory.HistogramValue> mapper) {
            this.scaleRelativeToLimit = scaleRelativeToLimit;
            this.colourPreference = colourPreference;
            this.colour = colour;
            this.typicalBinCount = typicalBinCount;
            this.units = units;
            this.mapper = mapper;
            this.datapointBase = HistogramDataPoint.calculateAbsoluteBaseValues((HistogramDataPoint[])datapoints);
            this.datapointWidth = Arrays.stream(datapoints).mapToInt(d -> d.width).toArray();
            assert (this.datapointBase.length == datapoints.length);
            assert (this.datapointWidth.length == datapoints.length);
            this.smallestDataPoint = this.datapointBase.length > 0 ? this.datapointBase[0] : 0L;
            this.largestDataPoint = this.datapointBase.length > 0 ? this.datapointBase[this.datapointBase.length - 1] + (long)this.datapointWidth[this.datapointWidth.length - 1] - 1L : 0L;
            this.numberOfDataPoints = this.largestDataPoint - this.smallestDataPoint + 1L;
            this.zeroWidthDataProvider = new IHistogramSizedCellDataProvider<T>(){

                @Override
                public  @Nullable HistogramCell.IHistogramData get(@NonNull T value) {
                    return null;
                }
            };
        }

        public long calculateTotal(long @Nullable [] histogramData) {
            if (histogramData == null || histogramData.length == 0) {
                return 0L;
            }
            assert (histogramData.length == this.datapointBase.length);
            long result = 0L;
            int i = 0;
            while (i < histogramData.length) {
                long n = histogramData[i];
                long base = this.datapointBase[i];
                long width = this.datapointWidth[i];
                long v = width > 1L ? n * base + n * width * (width - 1L) / (2L * width) : n * base;
                result += v;
                ++i;
            }
            return result;
        }

        public long calculateTotal(@NonNull T value) {
            ISampleCounterColumnAccessorFactory.HistogramValue histogramData1 = this.mapper.apply(value);
            return this.calculateTotal(histogramData1 != null ? histogramData1.values() : null);
        }

        public @NonNull IHistogramSizedCellDataProvider<T> getForPixelWidth(int pixelWidth) {
            if (pixelWidth < 1) {
                return this.zeroWidthDataProvider;
            }
            @Nullable IHistogramSizedCellDataProvider<T> lastDataProvider = this.lastDataProvider;
            if ((long)pixelWidth == this.lastPixelWidth && lastDataProvider != null) {
                return lastDataProvider;
            }
            @NonNull IHistogramSizedCellDataProvider<T> result = this.numberOfDataPoints <= (long)pixelWidth || this.datapointBase.length <= pixelWidth ? this.createUnscaledHistogramBinData(false, pixelWidth) : this.createScaledHistogramBinData(pixelWidth);
            this.lastDataProvider = result;
            this.lastPixelWidth = pixelWidth;
            return result;
        }

        private @NonNull IHistogramSizedCellDataProvider<T> createScaledHistogramBinData(int pixelWidth) {
            return new HistogramScaledCellDataProvider<T>(pixelWidth, this.numberOfDataPoints, this.datapointBase, this.datapointWidth, this.smallestDataPoint, this.units, this.mapper, this.colourPreference, this.colour);
        }

        private @NonNull IHistogramSizedCellDataProvider<T> createUnscaledHistogramBinData(boolean linearScale, int pixelWidth) {
            return new HistogramUnscaledCellDataProvider<T>(linearScale, pixelWidth, this.numberOfDataPoints, this.datapointBase, this.datapointWidth, this.smallestDataPoint, this.units, this.mapper, this.colourPreference, this.colour, this.typicalBinCount);
        }
    }

    public static interface IHistogramSizedCellDataProvider<T> {
        public  @Nullable HistogramCell.IHistogramData get(@NonNull T var1);
    }
}

