/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionRow;
import com.arm.streamline.editortabs.function.FunctionTab;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class FunctionContributor
implements IContextMenuContributor {
    private static final String CMD = "FunctionCallPathLink";
    private static final int MAX = 10;
    private final @NonNull Supplier<@NonNull List<@NonNull IFunctionContributorSortProperties>> columnPropertiesSupplier;

    private static String formatPercent(double percent, long count, @Nullable CallPathRowValue callPath) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(NumberUtils.prettyFormat((long)count));
        buffer.append(" (");
        buffer.append(NumberUtils.formatPercentage((double)percent, (boolean)false));
        buffer.append(")");
        if (callPath != null) {
            buffer.append(' ');
            buffer.append(callPath.getThreadName());
        }
        return buffer.toString();
    }

    public FunctionContributor(@NonNull Supplier<@NonNull List<@NonNull IFunctionContributorSortProperties>> columnPropertiesSupplier) {
        this.columnPropertiesSupplier = columnPropertiesSupplier;
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (CMD.equals(commandID)) {
            FunctionTab tab = (FunctionTab)WidgetUtils.getAncestorOfType(cm.getClickControl(), FunctionTab.class);
            tab.requireEditor().select(EditorTabID.CALL_PATH, (ISelection)new StructuredSelection(menuItem.getData()));
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        OutlineModel model;
        Control control = cm.getClickControl();
        if (control instanceof Outline && (model = ((Outline)control).getModel()).getSelectionCount() == 1) {
            FunctionRow cpfRow = (FunctionRow)model.getSelectionAsList().get(0);
            FunctionRowValue function = (FunctionRowValue)cpfRow.getModelObject();
            ArrayList<CallPathRowValue> callPaths = new ArrayList<CallPathRowValue>(function.getAssociatedCallPaths());
            @NonNull List<@NonNull IFunctionContributorSortProperties> columns = this.columnPropertiesSupplier.get();
            if (!callPaths.isEmpty() && !columns.isEmpty()) {
                cm.createConditionalSeparator();
                for (IFunctionContributorSortProperties properties : columns) {
                    this.createMenuFor(cm, callPaths, properties);
                }
            }
        }
    }

    private void createMenuFor(@NonNull ContextMenu cm, @NonNull List<@NonNull CallPathRowValue> callPaths, @NonNull IFunctionContributorSortProperties properties) {
        boolean needRemainder;
        int max;
        Collections.sort(callPaths, properties);
        cm.createCascadeMenu(properties.getName(), CMD, true);
        if (callPaths.size() > 11) {
            max = 11;
            needRemainder = true;
        } else {
            max = callPaths.size() + 1;
            needRemainder = false;
        }
        long remainderValue = 0L;
        double remainderPercent = 0.0;
        int count = 0;
        for (CallPathRowValue callPath : callPaths) {
            ISampleCounterColumnAccessorFactory.PercentAndLong metric = properties.getMetric(callPath.getCallPathNode());
            if (metric == null) continue;
            if (++count < max) {
                MenuItem item = cm.createCascadeMenuItem(this, CMD, FunctionContributor.formatPercent(metric.percent(), metric.value(), callPath), CMD, true);
                item.setData((Object)callPath);
                continue;
            }
            remainderValue += metric.value();
            remainderPercent += metric.percent();
        }
        if (needRemainder) {
            cm.createCascadeMenuItem(this, CMD, MessageFormat.format(FunctionMessages.REMAINDER, FunctionContributor.formatPercent(remainderPercent, remainderValue, null), NumberUtils.format((long)(count - 10))), CMD, false);
        }
    }

    public static interface IFunctionContributorSortProperties
    extends Comparator<CallPathRowValue> {
        @Override
        default public int compare(CallPathRowValue o1, CallPathRowValue o2) {
            ISampleCounterColumnAccessorFactory.PercentAndLong t2;
            long v2;
            ISampleCounterColumnAccessorFactory.PercentAndLong t1 = this.getMetric(o1.getCallPathNode());
            long v1 = t1 != null ? t1.value() : Long.MIN_VALUE;
            int result = Long.compare(v1, v2 = (t2 = this.getMetric(o2.getCallPathNode())) != null ? t2.value() : Long.MIN_VALUE);
            if (result == 0) {
                result = o1.compareTo(o2);
            }
            return result;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ISampleCounterColumnAccessorFactory.PercentAndLong getMetric(@NonNull CallPathNode var1);

        public @NonNull String getName();
    }
}

