/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.function.FunctionInstructionCounterColumn;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.function.FunctionStackCell;
import com.arm.streamline.editortabs.function.IFunctionColumn;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class FunctionColumn
implements IFunctionColumn {
    public static final @NonNull FunctionColumn IMAGE = new FunctionColumn(FunctionMessages.IMAGE_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            String result = function != null ? function.getImageLabel() : null;
            return result != null ? result : FunctionMessages.NA;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getModel().getLargestFileName().length();
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            String result = function != null ? function.getImageLabel() : null;
            return result != null ? result : FunctionMessages.IMAGE_DESCRIPTION;
        }
    };
    public static final @NonNull FunctionColumn INSTANCES = new FunctionColumn(FunctionMessages.INSTANCES_TITLE){

        @Override
        public Object getData(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return function.getAssociatedCallPaths().size();
        }

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return NumberUtils.format((long)this.getDataAsLong(row, function));
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((int)source.getLargestFunctionCallPathCount()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            return function == null ? FunctionMessages.INSTANCES_DESCRIPTION : null;
        }
    };
    public static final @NonNull FunctionColumn LOCATION = new FunctionColumn(FunctionMessages.LOCATION_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            String result = function != null ? function.getLocationLabel(row != null && row.getOwner().isExporting()) : null;
            return result != null ? result : FunctionMessages.NA;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            String result = function != null ? function.getLocationLabel(true) : null;
            return result != null ? result : FunctionMessages.LOCATION_DESCRIPTION;
        }
    };
    public static final @NonNull FunctionColumn NAME = new FunctionColumn(FunctionMessages.NAME_TITLE, 16384, true, 1, IColumnCompareType.TEXT()){

        @Override
        public ICell<EnumColumn<FunctionRowValue>> getCell(Void data) {
            return new FunctionNameCell<FunctionRowValue>();
        }

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return function.getName();
        }

        @Override
        public Image getImage(ReportRow<FunctionRowValue> row) {
            return CallPathFunctionColumn.getCallPathFunctionImage(row.getModelObject().getReferencedSymbol());
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getLargestFunctionName().length();
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            return function == null ? FunctionMessages.NAME_DESCRIPTION : null;
        }
    };
    public static final @NonNull FunctionColumn SIZE = new FunctionColumn(FunctionMessages.SIZE_TITLE){

        @Override
        public Object getData(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return function != null ? function.getSizeInBytes() : -1L;
        }

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            long result;
            long l = result = function != null ? function.getSizeInBytes() : -1L;
            if (result <= 0L) {
                return FunctionMessages.NA;
            }
            return NumberUtils.prettyFormat((long)result);
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((long)source.getLargestFunctionSize()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            return FunctionMessages.SIZE_DESCRIPTION;
        }
    };
    public static final @NonNull FunctionColumn STACK_USED = new FunctionColumn(FunctionMessages.STACK_USED_TITLE){

        @Override
        public ICell<EnumColumn<FunctionRowValue>> getCell(Void data) {
            return new FunctionStackCell(this.alignment, this.compareType);
        }

        @Override
        public Object getData(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            return function != null ? function.getStackFrameSize() : -1L;
        }

        @Override
        public String getDataAsText(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
            long result = function != null ? function.getStackFrameSize() : -1L;
            return NumberUtils.prettyFormat((long)Math.max(result, 0L));
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((long)source.getMaxStack()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(FunctionRowValue function) {
            if (function == null || function.isUnknown()) {
                return FunctionMessages.STACK_USED_DESCRIPTION;
            }
            return function.getStackFrameSize() <= 0L ? FunctionMessages.INDETERMINATE : FunctionMessages.STACK_USED_DESCRIPTION;
        }
    };
    protected final int alignment;
    protected final @NonNull IColumnCompareType<EnumColumn<FunctionRowValue>> compareType;
    protected final boolean initialSortAscending;
    protected final int initialSortSequence;
    protected final @NonNull String name;

    public static @NonNull Iterable<@NonNull IFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
        Stream<Object> counterColumns;
        if (instructionCounterSource != null) {
            ISamplesReportData dataSet = instructionCounterSource.getActiveReportData();
            counterColumns = instructionCounterSource.getFunctionColumns().stream().map(c -> FunctionInstructionCounterColumn.factory(dataSet, c)).flatMap(c -> c.toRecursiveStream());
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(INSTANCES, STACK_USED, SIZE, LOCATION, IMAGE)).collect(Collectors.toList());
    }

    protected FunctionColumn(@NonNull String name) {
        this(name, true, IColumnCompareType.INTEGER());
    }

    protected FunctionColumn(@NonNull String name, boolean alignLeft) {
        this(name, alignLeft ? 16384 : 131072, true, -1, IColumnCompareType.TEXT());
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, @NonNull IColumnCompareType<EnumColumn<FunctionRowValue>> compareType) {
        this(name, initialSortAscending, -1, compareType);
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence) {
        this(name, initialSortAscending, initialSortSequence, IColumnCompareType.INTEGER());
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<FunctionRowValue>> compareType) {
        this(name, 131072, initialSortAscending, initialSortSequence, compareType);
    }

    protected FunctionColumn(@NonNull String name, int alignment, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<FunctionRowValue>> compareType) {
        this.name = name;
        this.alignment = alignment;
        this.initialSortAscending = initialSortAscending;
        this.initialSortSequence = initialSortSequence;
        this.compareType = compareType;
    }

    @Override
    public ICell<EnumColumn<FunctionRowValue>> getCell(Void data) {
        return new TextCell<EnumColumn<FunctionRowValue>>(this.alignment, this.compareType);
    }

    public Object getData(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
        return this.getDataAsText(row, function);
    }

    @Override
    public final double getDataAsDouble(ReportRow<FunctionRowValue> row) {
        return this.getDataAsDouble(row, row.getModelObject());
    }

    public double getDataAsDouble(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
        return 0.0;
    }

    @Override
    public final long getDataAsLong(ReportRow<FunctionRowValue> row) {
        return this.getDataAsLong(row, row.getModelObject());
    }

    public long getDataAsLong(ReportRow<FunctionRowValue> row, FunctionRowValue function) {
        return 0L;
    }

    @Override
    public final @NonNull String getDataAsText(ReportRow<FunctionRowValue> row) {
        return this.getDataAsText(row, row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(ReportRow<FunctionRowValue> var1, FunctionRowValue var2);

    @Override
    public final @NonNull String getHeader(Void data) {
        return this.name;
    }

    @Override
    public Image getImage(ReportRow<FunctionRowValue> row) {
        return null;
    }

    @Override
    public final int getInitialSortSequence() {
        return this.initialSortSequence;
    }

    public final @NonNull String getTitle() {
        return this.getHeader(null).replace('\n', ' ');
    }

    @Override
    public final String getToolTip(ReportRow<FunctionRowValue> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final String getToolTip(Void data) {
        return this.getToolTip((FunctionRowValue)null);
    }

    @Override
    public final boolean isInitialSortAscending() {
        return this.initialSortAscending;
    }

    @Override
    public final boolean isPrimary() {
        return false;
    }

    @Override
    protected abstract String getToolTip(FunctionRowValue var1);
}

