/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.code.AbstractCodeContextMenuContributor;
import com.arm.streamline.editortabs.code.CFamilyKeywordColorData;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.CodeTabInstructionCounterColumn;
import com.arm.streamline.editortabs.code.CodeTabSelectionModel;
import com.arm.streamline.editortabs.code.ColorRun;
import com.arm.streamline.editortabs.code.SourceColorizer;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterDataSingleAccessor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISampleSourceLineDataAccessorBase;
import com.arm.streamline.jni.apcdbgen.proto.ISampleSourceLineDataAccessorForColumn;
import com.arm.streamline.jni.apcdbgen.proto.ISampleSourceLineDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SimpleSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.apcdbgen.proto.SymbolName;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.ConsolidatedUIExec;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.IAutoScrollArea;
import com.arm.streamline.widget.IToolTipTracker;
import com.arm.streamline.widget.LineScrollCanvas;
import com.arm.streamline.widget.UpdatingToolTip;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuSelectionResolver;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.LRUCache;
import com.arm.utils.collections.Pair;
import com.arm.utils.io.FileUtils;
import com.arm.utils.text.BasicTextFilter;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SourcePanel
extends LineScrollCanvas
implements IToolTipTracker,
IStdSelectionOwner,
FocusListener,
KeyListener,
IAutoScrollArea,
MouseListener,
MouseMoveListener,
Runnable,
IContextMenuSelectionResolver {
    protected static final int MARGIN = 2;
    private static final int COL_COUNTER = 0;
    private static final int COL_INLINE = 1;
    private static final int COL_LINE = 2;
    private static final int COL_SOURCE = 3;
    private static final int COL_TOTAL = 4;
    private static final int GAP = 5;
    private static final int HEADER_MARGIN = 4;
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_OFFSET = 4;
    private static final int MORE_V_MARGIN = 0;
    private static final int MSG_GAP = 10;
    private static final int TAB_WIDTH = 4;
    private @Nullable InstructionCounterCodeColumnsWithMetadata activeColumnSelection;
    private @Nullable CodeTabSelectionModel.ActiveImageProperties activeImageProperties;
    private final @NonNull LRUCache<@NonNull String, @NonNull SourceFileLineData> cachedSourceFileLineData = new LRUCache(10);
    private final @NonNull ContextMenu contextMenu;
    private @Nullable SourceFileLineData mActiveFileLineInfo;
    private int mCharWidth;
    private int[] mColumnSizes = new int[4];
    private @Nullable Pair<@NonNull InstructionCounterCodeColumnsWithMetadata, @NonNull CodeTabSelectionModel.ActiveImageProperties> mDeferredSelection;
    private boolean mDragSelectOK;
    private TIntObjectHashMap<Color> mFunctionColorMap = new TIntObjectHashMap();
    private final LRUCache<ReferencedSymbol, ReferencedSymbol> mFunctionLRUCache = new LRUCache(10);
    private boolean mHasSource;
    private int mHeaderLineHeight;
    private long mInitialMouseTime;
    private int mInitialMouseY;
    private Image mInlineImage_InlinedFrom;
    private Image mInlineImage_InlinedInto;
    private Image mInlineImage_InlinedBoth;
    private boolean mInMsgBounds;
    private boolean mIsStale;
    private @Nullable ReferencedSymbol mLastSelectedFunction;
    private int mLineHeight;
    private Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private MouseState mMouseHandlingState = MouseState.NORMAL;
    private String mMsg;
    private Rectangle mMsgBounds;
    private String mMsgHint;
    private boolean mMsgShowSearchHint;
    private final @NonNull CodeTab mOwner;
    private StdSelection mPreservedSelection;
    private StdSelection mSelection = new StdSelection(this);
    private int mSelectOnMouseUp;
    private String mTitle = "";
    private final @NonNull BitSet inlinedFromRows = new BitSet();
    private final @NonNull BitSet inlinedIntoRows = new BitSet();
    private final @NonNull BitSet inlinedBothRows = new BitSet();
    private boolean sourcePathSearchActive = false;

    private @Nullable Image computeInlineImage(@Nullable ISampleSourceLineDataAccessorForColumn view, int index, @NonNull BitSet inlinedFromRows, @NonNull BitSet inlinedIntoRows, @NonNull BitSet inlinedBothRows) {
        if (view == null) {
            return null;
        }
        ISampleSourceLineDataAccessorBase.PerSymbolAccessor[] perFunction = view.getPerSymbolDataAccessors();
        if (perFunction == null) {
            return null;
        }
        boolean from = false;
        boolean into = false;
        ISampleSourceLineDataAccessorBase.PerSymbolAccessor[] perSymbolAccessorArray = perFunction;
        int n = perFunction.length;
        int n2 = 0;
        while (n2 < n) {
            ISampleSourceLineDataAccessorBase.PerSymbolAccessor entry = perSymbolAccessorArray[n2];
            switch (entry.properties.type) {
                case INLINED_FROM: {
                    from = true;
                    break;
                }
                case INLINED_INTO: {
                    into = true;
                    break;
                }
                case ORIGINAL: {
                    break;
                }
                default: {
                    throw new AssertionError(entry.properties.type);
                }
            }
            ++n2;
        }
        if (from && into) {
            inlinedBothRows.set(index);
            return this.mInlineImage_InlinedBoth;
        }
        if (from) {
            inlinedFromRows.set(index);
            return this.mInlineImage_InlinedFrom;
        }
        if (into) {
            inlinedIntoRows.set(index);
            return this.mInlineImage_InlinedInto;
        }
        return null;
    }

    private static int getBestSize(String header, int contentWidth) {
        return Math.max(FontInfo.get(Fonts.getNormal()).getWidth(header), contentWidth);
    }

    private static int getBestSize(String header, String content) {
        return SourcePanel.getBestSize(header, FontInfo.get(Fonts.getSource()).getWidth(content));
    }

    private static @Nullable ISourceLineReference @Nullable [] makeSelectionReferences(@NonNull ReferencedSymbol lastFunction, @NonNull List<@Nullable ISampleSourceLineDataProperties> properties) {
        ISourceLineReference[] result = new ISourceLineReference[properties.size()];
        ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange lastFunctionInstructionProperties = (ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange)NullChecking.neverNull((Object)lastFunction.symbol.instructionRange);
        int lineIndex = 0;
        while (lineIndex < properties.size()) {
            block7: {
                ISampleSourceLineDataProperties.PerSymbolProperties[] functions;
                ISampleSourceLineDataProperties lineData = properties.get(lineIndex);
                if (lineData != null && (functions = lineData.getPerSymbolProperties()) != null && functions.length != 0) {
                    ReferencedSymbol closestedByIndex = null;
                    ISampleSourceLineDataProperties.PerSymbolProperties[] perSymbolPropertiesArray = functions;
                    int n = functions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferencedSymbol referencedSymbol;
                        ISampleSourceLineDataProperties.PerSymbolProperties entry = perSymbolPropertiesArray[n2];
                        Symbol entrySymbol = entry.associatedSymbol;
                        ReferencedSymbol referencedSymbol2 = referencedSymbol = entrySymbol != null ? entrySymbol.referencedSymbol : null;
                        if (referencedSymbol != null) {
                            if (referencedSymbol == lastFunction) {
                                result[lineIndex] = new SimpleSourceReference(referencedSymbol, lineData.getSourceFile(), lineData.getLineNo());
                                break block7;
                            }
                            ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionProperties = (ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange)NullChecking.neverNull((Object)referencedSymbol.symbol.instructionRange);
                            if (closestedByIndex == null || Math.abs(((ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange)NullChecking.neverNull((Object)closestedByIndex.symbol.instructionRange)).fromIndex() - lastFunctionInstructionProperties.fromIndex()) > Math.abs(instructionProperties.fromIndex() - lastFunctionInstructionProperties.fromIndex())) {
                                closestedByIndex = referencedSymbol;
                            }
                        }
                        ++n2;
                    }
                    if (closestedByIndex != null) {
                        result[lineIndex] = new SimpleSourceReference(closestedByIndex, lineData.getSourceFile(), lineData.getLineNo());
                    }
                }
            }
            ++lineIndex;
        }
        return result;
    }

    public SourcePanel(Composite parent, final @NonNull CodeTab owner) {
        super(parent);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        this.mOwner = owner;
        this.mInlineImage_InlinedFrom = StreamlinePlugin.getImage("InlinedElsewhere.png");
        this.mInlineImage_InlinedInto = StreamlinePlugin.getImage("InlinedHere.png");
        this.mInlineImage_InlinedBoth = StreamlinePlugin.getImage("InlinedBoth.png");
        this.updateSizes();
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        UpdatingToolTip.create((Control)this, this);
        Analysis analysis = owner.getAnalysis();
        analysis.addSourcePathSearchListener(active -> {
            this.sourcePathSearchActive = active;
            this.sourceFilePathChanged();
        });
        this.contextMenu = new ContextMenu((Control)this, (Control)this);
        this.contextMenu.add(new AbstractCodeContextMenuContributor(){
            private static final String ID_DI = "code-view";
            private static final String ID_FN = "function-view";
            private static final String ID_RL = "related-lines";

            /*
             * WARNING - void declaration
             */
            @Override
            public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
                if (menuItem.getData() instanceof ReferencedSymbol) {
                    owner.requireEditor().select(EditorTabID.FUNCTIONS, (ISelection)new StructuredSelection(menuItem.getData()));
                } else {
                    Object object = menuItem.getData();
                    if (object instanceof PairOfImageFileAndInstructions) {
                        void data;
                        PairOfImageFileAndInstructions pairOfImageFileAndInstructions = (PairOfImageFileAndInstructions)object;
                        PairOfImageFileAndInstructions cfr_ignored_0 = (PairOfImageFileAndInstructions)object;
                        BitSet bitSet = new BitSet();
                        data.instructionIndexes.forEach(i -> {
                            if (i >= 0L && i <= Integer.MAX_VALUE) {
                                bitSet.set((int)i);
                            }
                            return true;
                        });
                        data.currentImageProperties.selection = new CodeTabSelectionModel.ActiveSelection(data.selection.imageFile(), bitSet, data.selection.sourceFile(), data.selection.selectedLineNos(), data.selection.lastSelectedSymbol());
                        SourcePanel.this.mOwner.getDisassemblyPanel().refreshSelection();
                    } else {
                        Object object2 = menuItem.getData();
                        if (object2 instanceof SourceLocationItem) {
                            void data;
                            SourceLocationItem bitSet = (SourceLocationItem)object2;
                            SourceLocationItem cfr_ignored_1 = (SourceLocationItem)object2;
                            BitSet lineNos = new BitSet();
                            lineNos.set(data.location.lineNo);
                            Symbol targetSymbol = data.key.targetSymbol;
                            data.currentImageProperties.selection = new CodeTabSelectionModel.ActiveSelection(data.selection.imageFile(), data.selection.selectedInstructions(), data.location.sourceFile, lineNos, targetSymbol != null ? targetSymbol.referencedSymbol : data.selection.lastSelectedSymbol());
                            SourcePanel.this.recomputeSelectedFileFromSelectionChange((Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties>)new Pair((Object)data.currentColumnSelection, (Object)data.currentImageProperties), false, true);
                            SourcePanel.this.redraw();
                        }
                    }
                }
            }

            @Override
            public void prepareMenu(ContextMenu cm) {
                List functionToSourceLinesFiltered;
                SourceFileLineData sourceFileLineInfo = SourcePanel.this.mActiveFileLineInfo;
                ReferencedSymbol lastfunction = SourcePanel.this.mLastSelectedFunction;
                if (sourceFileLineInfo == null || lastfunction == null) {
                    return;
                }
                Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = SourcePanel.this.getCheckedActiveSelectionState();
                if (currentSelectionState == null) {
                    return;
                }
                InstructionCounterCodeColumnsWithMetadata currentColumnSelection = (InstructionCounterCodeColumnsWithMetadata)currentSelectionState.first;
                CodeTabSelectionModel.ActiveImageProperties currentImageProperties = (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second;
                ISamplesReportDataForDisasmAndSourceAnnotations currentDataSet = currentImageProperties.activeDataSet;
                HashMap<ContextMenuItemKey, Double> functionToRank = new HashMap<ContextMenuItemKey, Double>();
                HashMap<ContextMenuItemKey, TLongSet> functionToInstructionSet = new HashMap<ContextMenuItemKey, TLongSet>();
                HashMap<ContextMenuItemKey, Set> functionToSourceLines = new HashMap<ContextMenuItemKey, Set>();
                HashSet<SourceLocation> selectedSourceLocations = new HashSet<SourceLocation>();
                double sumOfRanks = 0.0;
                int i = SourcePanel.this.mSelection.nextSelectedIndex(0);
                while (i >= 0) {
                    selectedSourceLocations.add(new SourceLocation(sourceFileLineInfo.sourceFile, i + 1));
                    ISampleSourceLineDataAccessorForColumn[] lineDatas = currentDataSet.getSourceLocationDataAccessorFor(currentColumnSelection.column, sourceFileLineInfo.sourceFile.uid, i + 1, 1);
                    if (lineDatas != null && lineDatas.length != 0) {
                        if (!$assertionsDisabled && lineDatas.length != 1) {
                            throw new AssertionError();
                        }
                        ISampleSourceLineDataAccessorForColumn[] iSampleSourceLineDataAccessorForColumnArray = lineDatas;
                        int n = lineDatas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISampleSourceLineDataAccessorBase.PerSymbolAccessor[] functionCounters;
                            ISampleSourceLineDataAccessorForColumn lineData = iSampleSourceLineDataAccessorForColumnArray[n2];
                            if (lineData != null && (functionCounters = lineData.getPerSymbolDataAccessors()) != null && functionCounters.length != 0) {
                                ISampleSourceLineDataAccessorBase.PerSymbolAccessor[] perSymbolAccessorArray = functionCounters;
                                int n3 = functionCounters.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ISampleSourceLineDataAccessorBase.PerSymbolAccessor functionAccessor = perSymbolAccessorArray[n4];
                                    ContextMenuItemKey key = new ContextMenuItemKey(functionAccessor.properties.type, functionAccessor.properties.symbolName, functionAccessor.properties.associatedSymbol);
                                    SourceLocation location = functionAccessor.properties.associatedSourceLocation;
                                    if (location != null) {
                                        Set set = functionToSourceLines.computeIfAbsent(key, k -> new HashSet());
                                        set.add(location);
                                    }
                                    double value = ((ISampleCounterDataSingleAccessor)functionAccessor.accessor).getRankingValue();
                                    sumOfRanks += value;
                                    functionToRank.compute(key, (k, v) -> {
                                        if (v == null) {
                                            return value;
                                        }
                                        return (double)v.longValue() + value;
                                    });
                                    TLongSet fnSet = (TLongSet)functionToInstructionSet.get(key);
                                    if (fnSet == null) {
                                        fnSet = new TLongHashSet(10, 0.5f, 0L);
                                        functionToInstructionSet.put(key, fnSet);
                                    }
                                    fnSet.addAll(functionAccessor.properties.correspondingInstructionIndexes);
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    i = SourcePanel.this.mSelection.nextSelectedIndex(i + 1);
                }
                Map.Entry<ContextMenuItemKey, V>[] functionEntries = 1.sortByRank(functionToRank, f -> true, Comparator.comparing(a -> a.symbolName));
                if (functionEntries.length > 0) {
                    MenuItem menuFn = cm.createCascadeMenu("Functions", ID_FN, true);
                    menuFn.setImage(StreamlinePlugin.getImage("Functions.png"));
                    MenuItem menuDi = cm.createCascadeMenu("Disassembly", ID_DI, true);
                    menuDi.setImage(StreamlinePlugin.getImage("CodeView.gif"));
                    double total = sumOfRanks;
                    1.populateMenu(functionEntries, entry -> {
                        double percent = total > 0.0 ? (Double)entry.getValue() * 100.0 / total : 0.0;
                        String val = NumberUtils.formatPercentage((double)percent, (boolean)false);
                        String title = String.format("%s (%s)", 1.fixAmp(1.makeTitle((ContextMenuItemKey)entry.getKey())), val);
                        Image image = switch (((ContextMenuItemKey)entry.getKey()).type) {
                            case ISampleSourceLineDataProperties.PerSymbolProperties.Type.INLINED_FROM -> SourcePanel.this.mInlineImage_InlinedFrom;
                            case ISampleSourceLineDataProperties.PerSymbolProperties.Type.INLINED_INTO -> SourcePanel.this.mInlineImage_InlinedInto;
                            case ISampleSourceLineDataProperties.PerSymbolProperties.Type.ORIGINAL -> null;
                            default -> throw new AssertionError(((ContextMenuItemKey)entry.getKey()).type);
                        };
                        MenuItem menuItemFn = cm.createCascadeMenuItem(this, ID_FN, title, ID_FN, true);
                        menuItemFn.setData(entry.getKey());
                        menuItemFn.setImage(image);
                        TLongSet fnSet = (TLongSet)NullChecking.neverNull((Object)((TLongSet)functionToInstructionSet.get(entry.getKey())));
                        MenuItem menuItemDi = cm.createCascadeMenuItem(this, ID_DI, title, ID_DI, true);
                        menuItemDi.setData((Object)new PairOfImageFileAndInstructions(currentColumnSelection, currentImageProperties, activeImageProperties.selection, fnSet, (ContextMenuItemKey)entry.getKey()));
                        menuItemDi.setImage(image);
                        return true;
                    });
                }
                if (!(functionToSourceLinesFiltered = functionToSourceLines.entrySet().stream().map(e -> {
                    Set v = (Set)e.getValue();
                    v.removeIf(selectedSourceLocations::contains);
                    return e;
                }).filter(e -> !((Set)e.getValue()).isEmpty()).sorted((a, b) -> {
                    ContextMenuItemKey keyA = (ContextMenuItemKey)a.getKey();
                    Double rankA = (Double)NullChecking.neverNull((Object)((Double)functionToRank.get(keyA)));
                    ContextMenuItemKey keyB = (ContextMenuItemKey)b.getKey();
                    Double rankB = (Double)NullChecking.neverNull((Object)((Double)functionToRank.get(keyB)));
                    return -rankA.compareTo(rankB);
                }).collect(Collectors.toList())).isEmpty()) {
                    MenuItem menuRL = cm.createCascadeMenu("Related lines", ID_RL, true);
                    menuRL.setImage(StreamlinePlugin.getImage("SourceFile.gif"));
                    int MAX_ITEMS = 20;
                    int totalItems = 0;
                    for (Map.Entry entry2 : functionToSourceLinesFiltered) {
                        ContextMenuItemKey key = (ContextMenuItemKey)entry2.getKey();
                        List locations = ((Set)entry2.getValue()).stream().sorted().limit(Math.max(20 - totalItems, 5)).collect(Collectors.toList());
                        for (SourceLocation location : locations) {
                            String title = String.format("%s:%d (%s)", location.sourceFile.getFileName(), location.lineNo, 1.makeTitle(key));
                            MenuItem menuItemRL = cm.createCascadeMenuItem(this, ID_RL, title, ID_RL, true);
                            menuItemRL.setData((Object)new SourceLocationItem(currentColumnSelection, currentImageProperties, currentImageProperties.selection, key, location));
                            ++totalItems;
                        }
                        if (totalItems > 20) break;
                    }
                }
            }

            private static @NonNull String makeTitle(@NonNull ContextMenuItemKey key) {
                switch (key.type) {
                    case INLINED_FROM: {
                        return String.format("%s (inlined into %s)", 1.truncateSymbol(key.symbolName, 100), 1.truncateSymbol(((Symbol)NullChecking.neverNull((Object)key.targetSymbol)).name, 100));
                    }
                    case INLINED_INTO: 
                    case ORIGINAL: {
                        return 1.truncateSymbol(key.symbolName, 100);
                    }
                }
                throw new AssertionError(key.type);
            }
        });
    }

    public void activeStateChanged(@Nullable InstructionCounterCodeColumnsWithMetadata newColumn, @Nullable CodeTabSelectionModel.ActiveImageProperties newImageProperties) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> beforeSelectionState = this.getCheckedActiveSelectionState();
        this.activeColumnSelection = newColumn;
        this.activeImageProperties = newImageProperties;
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> afterSelectionState = this.getCheckedActiveSelectionState();
        if (!NullChecking.equalsNullable(beforeSelectionState, afterSelectionState)) {
            this.recomputeSelectedFileFromSelectionChange(afterSelectionState, false, true);
            this.redraw();
        } else {
            this.updateSizes();
            this.redraw();
        }
    }

    private boolean recomputeSourceFileViewContents(@Nullable SourceFile selectedSourceFile, @Nullable ReferencedSymbol selectedSymbol, boolean forceUpdate) {
        ImageFile imageFile;
        Analysis analysis;
        File imageFilePath;
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties;
        SourceFileLineData previousActiveFileLineInfo = this.mActiveFileLineInfo;
        SourceFileLineData fileLineInfo = selectedSourceFile != null ? this.getSourceFileLineData(selectedSourceFile) : null;
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties activeImageProperties = currentImageProperties = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        if (!forceUpdate && previousActiveFileLineInfo == fileLineInfo) {
            return fileLineInfo != null;
        }
        if (fileLineInfo == null) {
            this.mHasSource = false;
            this.mActiveFileLineInfo = null;
            this.mLastSelectedFunction = null;
            this.mFunctionColorMap.clear();
            if (currentImageProperties != null) {
                if (currentImageProperties.selection.sourceFile() != null) {
                    this.mMsg = CodeMessages.MISSING;
                    this.mMsgHint = CodeMessages.BAD_SUBSTITION_MESSAGE;
                    this.mMsgShowSearchHint = true;
                } else {
                    this.mMsg = CodeMessages.NO_SOURCE_AVAILABLE;
                    this.mMsgHint = CodeMessages.NO_SYMBOLS_HINT + "\n\n" + CodeMessages.NO_SOURCE_HINT;
                    this.mMsgShowSearchHint = false;
                }
            } else {
                this.mMsg = CodeMessages.NO_SOURCE_AVAILABLE;
                this.mMsgHint = CodeMessages.NO_SOURCE_HINT;
                this.mMsgShowSearchHint = false;
            }
            return false;
        }
        this.mHasSource = true;
        this.mActiveFileLineInfo = fileLineInfo;
        this.mLastSelectedFunction = selectedSymbol;
        this.mSelection.setSize(fileLineInfo.mLines.size());
        this.mDeferredSelection = null;
        this.recomputeFunctionLineColourMap(fileLineInfo);
        this.mTitle = MessageFormat.format(CodeMessages.SOURCE_FILE, fileLineInfo.filePath);
        this.mMsg = null;
        this.mMsgHint = null;
        this.mIsStale = currentImageProperties != null ? (imageFilePath = (analysis = this.getAnalysis()).toImageFilePath(imageFile = currentImageProperties.selection.imageFile())) != null && CommonFileUtils.getModifiedTime((File)fileLineInfo.filePath) > CommonFileUtils.getModifiedTime((File)imageFilePath) : false;
        this.updateSizes();
        return true;
    }

    private boolean recomputeSelectedFileFromSelectionChange(@Nullable Pair<@NonNull InstructionCounterCodeColumnsWithMetadata, @NonNull CodeTabSelectionModel.ActiveImageProperties> currentSelectionState, boolean notifyDisasm, boolean forceUpdate) {
        if (!this.recomputeSourceFileViewContents(currentSelectionState != null ? ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.sourceFile() : null, currentSelectionState != null ? ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.lastSelectedSymbol() : null, forceUpdate)) {
            this.mDeferredSelection = currentSelectionState;
            boolean saved = this.mSelection.canNotify();
            this.mSelection.setNotify(false);
            this.mSelection.deselect();
            this.mSelection.setNotify(saved);
            this.notifyOfSelectionChange(notifyDisasm);
            return false;
        }
        assert (currentSelectionState != null);
        boolean saved = this.mSelection.canNotify();
        this.mSelection.setNotify(false);
        if (((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.selectedLineNos().isEmpty()) {
            this.mSelection.deselect();
        } else {
            BitSet selectedLineNos = ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.selectedLineNos();
            int[] low_high = new int[]{-1, -1};
            this.mSelection.deselect();
            selectedLineNos.stream().forEach(lineNo -> {
                int index = lineNo - 1;
                this.mSelection.select(index, true);
                if (low_high[0] < 0 || index >= 0 && index < low_high[0]) {
                    nArray[0] = index;
                }
                if (low_high[1] < 0 || index >= 0 && index > low_high[1]) {
                    nArray[1] = index;
                }
            });
            this.showLine(low_high[1]);
            this.showLine(low_high[0]);
        }
        this.mSelection.setNotify(saved);
        this.notifyOfSelectionChange(notifyDisasm);
        return true;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        InstructionCounterCodeColumnsWithMetadata currentColumnSelection = this.activeColumnSelection;
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        int lineCharCount = currentFileLineInfo != null ? currentFileLineInfo.mLineCharCount : 0;
        @NonNull String counterTitle = currentColumnSelection != null ? currentColumnSelection.getTitle() : "";
        this.mColumnSizes[0] = SourcePanel.getBestSize(counterTitle, PercentageCell.getMinimumContentWidth(Fonts.getSource(), false) + 50);
        this.mColumnSizes[1] = Math.max(Math.max(this.mInlineImage_InlinedFrom.getBounds().width, this.mInlineImage_InlinedInto.getBounds().width), this.mInlineImage_InlinedBoth.getBounds().width);
        this.mColumnSizes[2] = SourcePanel.getBestSize(CodeMessages.LINE, NumberUtils.format((long)lineCount));
        this.mColumnSizes[3] = SourcePanel.getBestSize(this.mTitle, lineCharCount * this.mCharWidth);
        int width = 4 + 5 * (this.mColumnSizes.length - 1);
        int[] nArray = this.mColumnSizes;
        int n = this.mColumnSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnSize = nArray[n2];
            width += columnSize;
            ++n2;
        }
        Point scrollbarSize = this.getSliderSize();
        return new Point(width + scrollbarSize.x, lineCount + (scrollbarSize.y + this.mLineHeight - 1) / this.mLineHeight);
    }

    public void deselect() {
        this.mSelection.deselect();
    }

    public void focusGained(FocusEvent event) {
        this.redraw();
    }

    public void focusLost(FocusEvent event) {
        this.redraw();
    }

    public @Nullable SourceFile getActiveSourceFile() {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        return currentFileLineInfo != null ? currentFileLineInfo.sourceFile : null;
    }

    @Override
    public Rectangle getAutoScrollArea() {
        Rectangle bounds = this.getClientArea();
        bounds.y += this.mHeaderLineHeight + 4;
        bounds.height -= this.mHeaderLineHeight + 4;
        return bounds;
    }

    public int getFirstVisibleLine() {
        return this.getVerticalSlider().getSelection();
    }

    public int getLastFullyVisibleLine() {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int line = (bounds.height - (this.mHeaderLineHeight + 4)) / this.mLineHeight;
        if (line % this.mLineHeight != 0) {
            --line;
        }
        if ((line += this.getFirstVisibleLine()) < 0) {
            return -1;
        }
        return Math.min(line, lineCount - 1);
    }

    public int getLastVisibleLine() {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        return Math.min(this.getFirstVisibleLine() + this.getPageSize().y, lineCount - 1);
    }

    public ReferencedSymbol[] getRecentFunctions() {
        ArrayList list = new ArrayList(this.mFunctionLRUCache.keySet());
        Collections.reverse(list);
        return list.toArray(new ReferencedSymbol[list.size()]);
    }

    public @Nullable ISourceLineReference getSelectableObjectAtIndex(int index) {
        ISourceLineReference[] result = this.getSelectableObjectAtIndexes(index, 1);
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    @Override
    public ISelection getSelection(Control control, Point where) {
        return null;
    }

    @Override
    public String getToolTipForLocation(Point location) {
        int x1 = 0;
        int i = 0;
        while (i < 1) {
            x1 += this.mColumnSizes[i] + 5;
            ++i;
        }
        int x2 = x1 + this.mColumnSizes[1] + 5;
        Point pt = this.toVirtual(new Point(location.x, location.y));
        if (pt.x >= x1 && pt.x <= x2) {
            if (location.y < this.mHeaderLineHeight + 4) {
                return CodeMessages.INFO_HEADER_TOOLTIP;
            }
            int line = this.getLineIndexAt(pt.y);
            if (line > -1) {
                if (this.inlinedFromRows.get(line)) {
                    return CodeMessages.INLINED_FROM_TOOLTIP;
                }
                if (this.inlinedIntoRows.get(line)) {
                    return CodeMessages.INLINED_INTO_TOOLTIP;
                }
                if (this.inlinedBothRows.get(line)) {
                    return CodeMessages.INLINED_BOTH_TOOLTIP;
                }
            }
        }
        if (location.y < this.mHeaderLineHeight + 4) {
            x1 = 0;
            int i2 = 0;
            while (i2 < 0) {
                x1 += this.mColumnSizes[i2] + 5;
                ++i2;
            }
            x2 = x1 + this.mColumnSizes[0] + 5;
            pt = this.toVirtual(new Point(location.x, location.y));
            if (pt.x >= x1 && pt.x <= x2) {
                InstructionCounterCodeColumnsWithMetadata currentColumnSelection = this.activeColumnSelection;
                if (currentColumnSelection == null) {
                    return null;
                }
                return currentColumnSelection.getTitle();
            }
            if (this.mIsStale) {
                i2 = 0;
                while (i2 < 3) {
                    x1 += this.mColumnSizes[i2] + 5;
                    ++i2;
                }
                x2 = x1 + this.mColumnSizes[3] + 5;
                pt = this.toVirtual(new Point(location.x, location.y));
                if (pt.x >= x1 && pt.x <= x2) {
                    return CodeMessages.STALE_TOOLTIP;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isAutoScrollMouseDown(int x, int y) {
        return this.getAutoScrollArea().contains(x, y);
    }

    public void keyPressed(KeyEvent event) {
        if (this.mHasSource) {
            if (event.doit) {
                event.doit = false;
                boolean shiftDown = (event.stateMask & 0x20000) != 0;
                switch (event.keyCode) {
                    case 0x1000001: {
                        this.showLine(this.mSelection.selectUp(shiftDown, false));
                        break;
                    }
                    case 0x1000002: {
                        this.showLine(this.mSelection.selectDown(shiftDown, false));
                        break;
                    }
                    case 0x1000007: {
                        this.showLine(this.mSelection.selectToHome(shiftDown));
                        break;
                    }
                    case 0x1000008: {
                        this.showLine(this.mSelection.selectToEnd(shiftDown));
                        break;
                    }
                    case 0x1000005: {
                        this.showLine(this.mSelection.selectToPageUp(Math.max(1, this.getPageSize().y), shiftDown));
                        break;
                    }
                    case 0x1000006: {
                        this.showLine(this.mSelection.selectToPageDown(Math.max(1, this.getPageSize().y), shiftDown));
                        break;
                    }
                    default: {
                        event.doit = true;
                        break;
                    }
                }
            }
        } else {
            this.mOwner.getDisassemblyPanel().keyPressed(event);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        this.setFocus();
        if (this.mMsgBounds != null) {
            this.mInMsgBounds = this.mMsgBounds.contains(event.x, event.y) && this.isMsgClickable();
        } else if (this.mMoreUpArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_UP;
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_DOWN;
        } else {
            this.mMouseHandlingState = MouseState.NORMAL;
            if (this.mHasSource) {
                this.mSelectOnMouseUp = -1;
                int method = 0;
                int y = this.toVirtual((Point)new Point((int)0, (int)event.y)).y;
                int line = this.getLineIndexAt(y);
                if ((event.stateMask & 0x20000) != 0) {
                    method |= 1;
                }
                if (event.button == 1 && (event.stateMask & WorkspaceUtils.getCommandKey()) != 0) {
                    method |= 2;
                }
                this.mSelectOnMouseUp = this.mSelection.selectByMouse(line, method);
                if (event.button != 1) {
                    this.mSelectOnMouseUp = -1;
                }
                boolean bl = this.mDragSelectOK = event.button == 1;
                if (this.mDragSelectOK) {
                    this.mInitialMouseY = event.y;
                    this.mInitialMouseTime = System.currentTimeMillis();
                }
            }
        }
    }

    public void mouseMove(MouseEvent event) {
        int lineCount;
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int n = lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        if (this.mMsgBounds == null && this.mHasSource && this.mDragSelectOK && (event.stateMask & WorkspaceUtils.getCommandKey()) == 0) {
            if (this.mInitialMouseTime != 0L) {
                if (Math.abs(this.mInitialMouseY - event.y) < 4 && System.currentTimeMillis() - this.mInitialMouseTime < 250L) {
                    return;
                }
                this.mInitialMouseTime = 0L;
            }
            if (this.mPreservedSelection == null) {
                this.mPreservedSelection = new StdSelection(this.mSelection);
                this.mPreservedSelection.setNotify(false);
            }
            StdSelection newSel = new StdSelection(this.mPreservedSelection);
            int y = this.toVirtual((Point)new Point((int)0, (int)event.y)).y;
            int line = this.getLineIndexAt(y);
            if (line < 0) {
                line = event.y < 0 ? 0 : lineCount - 1;
            }
            this.mSelectOnMouseUp = newSel.selectByMouse(line, 1);
            this.mSelection.select(newSel);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.mMsgBounds != null) {
            if (this.mInMsgBounds && this.mMsgBounds.contains(event.x, event.y)) {
                this.locateSourceFile();
            }
        } else if (this.mMoreUpArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_UP) {
                this.scrollMoreUp();
            }
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_DOWN) {
                this.scrollMoreDown();
            }
        } else if (this.mHasSource) {
            this.mDragSelectOK = false;
            this.mPreservedSelection = null;
            if (this.mSelectOnMouseUp != -1) {
                this.mSelection.select(this.mSelectOnMouseUp, false);
                this.mSelectOnMouseUp = -1;
            }
        }
        this.mMouseHandlingState = MouseState.NORMAL;
    }

    public void refreshInstructionSelection() {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        this.recomputeSelectedFileFromSelectedInstructions(currentSelectionState, false);
        this.redraw();
    }

    private void recomputeSelectedFileFromSelectedInstructions(@Nullable Pair<@NonNull InstructionCounterCodeColumnsWithMetadata, @NonNull CodeTabSelectionModel.ActiveImageProperties> currentSelectionState, boolean forceUpdate) {
        if (currentSelectionState != null) {
            SourceFile[] selectedSourceFile = new SourceFile[1];
            BitSet selectedLineNos = new BitSet();
            BitSet selectedInstructions = ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.selectedInstructions();
            ISamplesReportDataForDisasmAndSourceAnnotations dataSet = ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).activeDataSet;
            selectedInstructions.stream().forEach(index -> {
                ISampleInstructionRowDataProperties properties = dataSet.getInstructionProperties((long)index);
                switch (properties.getRowType()) {
                    case ARM32: 
                    case ARM64: 
                    case SYMBOL_LABEL: 
                    case THUMB: {
                        SourceFile sf;
                        SourceLocation sourceLocation = properties.getOriginalSourceLocation();
                        if (sourceLocation == null) break;
                        if (selectedSourceFile[0] == null) {
                            sourceFileArray[0] = sourceLocation.sourceFile;
                        }
                        if (!(sf = (SourceFile)NullChecking.neverNull((Object)selectedSourceFile[0])).equals(sourceLocation.sourceFile) || sourceLocation.lineNo <= 0) break;
                        selectedLineNos.set(sourceLocation.lineNo);
                        break;
                    }
                    case DATA: 
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new AssertionError(properties.getRowType());
                    }
                }
            });
            ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection = new CodeTabSelectionModel.ActiveSelection(((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.imageFile(), selectedInstructions, selectedSourceFile[0], selectedLineNos, ((CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second).selection.lastSelectedSymbol());
        }
        if (!this.recomputeSelectedFileFromSelectionChange(currentSelectionState, false, forceUpdate) && this.mOwner.setShowDisassembly(true)) {
            this.mOwner.getDisassemblyPanel().refreshSelection();
        }
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.refocus();
        }
    }

    public void selectAll() {
        this.mSelection.select();
    }

    @Override
    public void selectionAboutToChange() {
    }

    @Override
    public void selectionDidChange() {
        this.redraw();
        this.notifyOfSelectionChange(true);
    }

    public void showLine(int lineIndex) {
        int lineCount;
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int n = lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        if (lineIndex >= 0 && lineIndex < lineCount) {
            int firstLine = this.getFirstVisibleLine();
            int lastLine = this.getLastFullyVisibleLine();
            int pageSize = lastLine - firstLine;
            if (lineIndex < firstLine) {
                this.getVerticalSlider().setSelection(lineIndex);
                this.wasScrolled();
                this.adjustSliders();
            } else if (lineIndex > lastLine) {
                this.getVerticalSlider().setSelection(Math.max(lineIndex - pageSize, 0));
                this.wasScrolled();
                this.adjustSliders();
            }
            this.redraw();
        }
    }

    public void sourceFilePathChanged() {
        if (this.mDeferredSelection != null) {
            this.recomputeSelectedFileFromSelectionChange(this.mDeferredSelection, false, true);
            this.redraw();
        } else {
            boolean deselect;
            SourceFileLineData previousActiveFileLineInfo = this.mActiveFileLineInfo;
            if (!this.recomputeSourceFileViewContents(previousActiveFileLineInfo != null ? previousActiveFileLineInfo.sourceFile : null, this.mLastSelectedFunction, true)) {
                deselect = true;
            } else {
                boolean bl = deselect = previousActiveFileLineInfo == null || previousActiveFileLineInfo != this.mActiveFileLineInfo;
            }
            if (deselect) {
                boolean saved = this.mSelection.canNotify();
                this.mSelection.setNotify(false);
                this.mSelection.deselect();
                this.mSelection.setNotify(saved);
                this.redraw();
            }
        }
    }

    private void notifyOfSelectionChange(boolean notifyDisasm) {
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = this.activeImageProperties;
        List<ISourceLineReference> selection = this.getSelectedSourceLines();
        if (notifyDisasm && currentImageProperties != null) {
            ISamplesReportDataForDisasmAndSourceAnnotations dataSet = currentImageProperties.activeDataSet;
            BitSet selectedInstructions = new BitSet();
            BitSet selectedLineNos = new BitSet();
            SourceFile selectedSourceFile = null;
            ReferencedSymbol selectedSymbol = null;
            for (ISourceLineReference s : selection) {
                ReferencedSymbol sym = s.getAssociatedFunction();
                SourceFile src = s.getSourceFile();
                int lno = s.getStartLine();
                assert (selectedSourceFile == null || src.equals(selectedSourceFile));
                assert (selectedSymbol == null || sym.equals(selectedSymbol));
                assert (lno > 0);
                if (selectedSourceFile == null) {
                    selectedSourceFile = src;
                }
                if (selectedSymbol == null) {
                    selectedSymbol = sym;
                }
                selectedLineNos.set(lno);
                ISampleSourceLineDataProperties properties = dataSet.getSourceLocationDataPropertiesFor(src.uid, lno);
                if (properties == null) continue;
                long[] lArray = properties.getCorrespondingInstructionIndexes();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long index = lArray[n2];
                    if (index >= 0L && index <= Integer.MAX_VALUE) {
                        selectedInstructions.set((int)index);
                    }
                    ++n2;
                }
            }
            currentImageProperties.selection = new CodeTabSelectionModel.ActiveSelection(currentImageProperties.selection.imageFile(), selectedInstructions, selectedSourceFile, selectedLineNos, selectedSymbol);
            this.mOwner.getDisassemblyPanel().refreshSelection();
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this.mOwner, (ISelection)new StructuredSelection(selection));
        this.mOwner.selectionChanged(event);
    }

    @Override
    protected Point getPageSize() {
        Rectangle bounds = this.getClientArea();
        return new Point(bounds.width, (bounds.height - 4 - this.mHeaderLineHeight) / this.mLineHeight);
    }

    protected @NonNull List<@NonNull ISourceLineReference> getSelectedSourceLines() {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        ReferencedSymbol lastfunction = this.mLastSelectedFunction;
        if (currentFileLineInfo == null || lastfunction == null) {
            return Collections.emptyList();
        }
        ArrayList<ISourceLineReference> list = new ArrayList<ISourceLineReference>();
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = this.activeImageProperties;
        ISamplesReportDataForDisasmAndSourceAnnotations currentData = currentImageProperties != null ? currentImageProperties.activeDataSet : null;
        int i = this.mSelection.nextSelectedIndex(0);
        while (i >= 0) {
            ISourceLineReference[] refs;
            ISampleSourceLineDataProperties properties;
            ISampleSourceLineDataProperties iSampleSourceLineDataProperties = properties = currentData != null ? currentData.getSourceLocationDataPropertiesFor(currentFileLineInfo.sourceFile.uid, i + 1) : null;
            if (properties != null && (refs = SourcePanel.makeSelectionReferences(lastfunction, List.of(properties))) != null) {
                ISourceLineReference[] iSourceLineReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceLineReference ref = iSourceLineReferenceArray[n2];
                    if (ref != null) {
                        list.add(ref);
                    }
                    ++n2;
                }
            }
            i = this.mSelection.nextSelectedIndex(i + 1);
        }
        return list;
    }

    @Override
    protected void paintCanvas(GC gc) {
        InstructionCounterCodeColumnsWithMetadata currentColumnSelection = this.activeColumnSelection;
        CodeTabSelectionModel.ActiveImageProperties currentImagePropertiesRaw = this.activeImageProperties;
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = currentColumnSelection == null || currentImagePropertiesRaw == null || currentColumnSelection.source != currentImagePropertiesRaw.source ? null : currentImagePropertiesRaw;
        gc.fillRectangle(gc.getClipping());
        if (this.mMsg != null) {
            this.drawMessage(gc);
        } else {
            this.mMsgBounds = null;
            this.drawLines(gc, currentColumnSelection, currentImageProperties);
        }
        this.drawHeader(gc, currentColumnSelection);
        this.drawDividers(gc);
        if (this.mMsg != null) {
            this.drawMore(gc);
        }
    }

    private void drawDividers(GC gc) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 4;
        int x = 2;
        int i = 0;
        while (i < 3) {
            if (this.mColumnSizes[i] > 0) {
                gc.setForeground(Colors.getDivider());
                gc.drawLine((x += this.mColumnSizes[i]) + 2, bounds.y, x + 2, bounds.y + headerHeight);
                gc.setForeground(Colors.getOutlineDivider());
                gc.drawLine(x + 2, bounds.y + headerHeight, x + 2, bounds.y + bounds.height);
                x += 5;
            }
            ++i;
        }
    }

    private void drawHeader(GC gc, @Nullable InstructionCounterCodeColumnsWithMetadata counterColumn) {
        @NonNull String title = counterColumn != null ? counterColumn.getTitle() : "";
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 4;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(x, y, width, headerHeight);
        gc.setForeground(Colors.getDivider());
        y = bounds.y + headerHeight - 1;
        gc.drawLine(x, y, x + width, y);
        x = 2;
        y = bounds.y + 2;
        int col = 0;
        gc.setFont(Fonts.getNormal());
        gc.setForeground(Colors.getWidgetForeground());
        x = this.drawOneHeader(gc, title, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.INFO, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.LINE, x, y, col++);
        if (this.mIsStale) {
            Image image = StreamlinePlugin.getImage("Warning.png");
            gc.drawImage(image, x, y);
            x += image.getBounds().width + 2;
        }
        TextDrawing.drawString(gc, this.mTitle, x, y, 16384);
    }

    private void drawLines(GC gc, @Nullable InstructionCounterCodeColumnsWithMetadata counterColumn, @Nullable CodeTabSelectionModel.ActiveImageProperties imageProperties) {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        boolean isFocus = this.isFocusControl();
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int firstLine = this.getFirstVisibleLine();
        int lastLine = this.getLastVisibleLine();
        Font font = Fonts.getSource();
        assert (font != null);
        FontInfo fi = FontInfo.get(font);
        gc.setFont(font);
        int textYOffset = (this.mLineHeight - fi.getHeight()) / 2;
        ISampleSourceLineDataAccessorForColumn[] lineData = counterColumn != null && imageProperties != null && currentFileLineInfo != null ? imageProperties.activeDataSet.getSourceLocationDataAccessorFor(counterColumn.column, currentFileLineInfo.sourceFile.uid, firstLine + 1, lastLine + 1 - firstLine) : null;
        int y = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 4))).y;
        this.inlinedFromRows.clear();
        this.inlinedBothRows.clear();
        this.inlinedIntoRows.clear();
        if (currentFileLineInfo != null) {
            int index = firstLine;
            while (index <= lastLine) {
                Image inlineImage;
                int x = 2;
                int col = 0;
                if (lineData != null && index - firstLine < lineData.length) {
                    ISampleSourceLineDataAccessorForColumn view = lineData[index - firstLine];
                    inlineImage = this.computeInlineImage(view, index, this.inlinedFromRows, this.inlinedIntoRows, this.inlinedBothRows);
                    if (view != null) {
                        CodeTabInstructionCounterColumn.render((ISampleCounterDataSingleAccessor)view, gc, font, 2, x, y, this.mColumnSizes[col], this.mLineHeight);
                    }
                } else {
                    inlineImage = null;
                }
                x += this.mColumnSizes[col++] + 5;
                if (inlineImage != null) {
                    gc.drawImage(inlineImage, x, y);
                }
                x += this.mColumnSizes[col++] + 5;
                gc.setForeground(Colors.getBlack());
                Color color = (Color)this.mFunctionColorMap.get(index + 1);
                if (color != null) {
                    gc.setBackground(color);
                    gc.fillRectangle(x - 2, y, 2 + this.mColumnSizes[col] + 2, this.mLineHeight);
                }
                String lineNum = NumberUtils.format((long)(index + 1));
                TextDrawing.drawString(gc, lineNum, x + this.mColumnSizes[col], y + textYOffset, 131072);
                x += this.mColumnSizes[col++] + 5;
                String text = currentFileLineInfo.mLines.get(index);
                if (this.mSelection.isSelected(index)) {
                    gc.setBackground(Colors.getSelection(isFocus));
                    gc.fillRectangle(x - 2, y, bounds.x + bounds.width - (x - 2), this.mLineHeight);
                    gc.setForeground(Colors.getText(isFocus));
                    TextDrawing.drawString(gc, text, x, y + textYOffset, 16384);
                } else {
                    int pos = 0;
                    ColorRun[] colorRunArray = currentFileLineInfo.mColorRuns.get(index);
                    int n = colorRunArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ColorRun colorRun = colorRunArray[n2];
                        gc.setForeground(colorRun.mColor);
                        String piece = text.substring(pos, colorRun.mUpTo);
                        TextDrawing.drawString(gc, piece, x, y + textYOffset, 16384);
                        pos = colorRun.mUpTo;
                        x += fi.getWidth(piece);
                        ++n2;
                    }
                }
                y += this.mLineHeight;
                ++index;
            }
        }
    }

    private void drawMessage(GC gc) {
        Point hintSize;
        int gap;
        Rectangle bounds = this.getClientArea();
        int header = this.mHeaderLineHeight + 4;
        bounds.y += header;
        bounds.height -= header;
        this.toVirtual(bounds);
        Font font = Fonts.getNormalStandout();
        gc.setFont(font);
        FontInfo fontInfo = FontInfo.get(font);
        Point sizeMsg = fontInfo.getExtent(this.mMsg);
        String hint = this.mMsgHint;
        if (hint == null) {
            gap = 10;
            hintSize = new Point(0, 0);
        } else {
            gap = 20;
            hint = BasicTextFilter.wrap((String)hint, (int)50);
            hintSize = fontInfo.getExtent(hint);
        }
        boolean clickable = this.isMsgClickable();
        gc.setForeground(clickable ? Colors.getDarkRed() : Colors.getGray());
        int y = bounds.y + (bounds.height - (sizeMsg.y + gap + hintSize.y)) / 2;
        TextDrawing.drawText(gc, this.mMsg, bounds.x + (bounds.width - sizeMsg.x) / 2, y, 16384);
        y += sizeMsg.y + 10;
        if (hint != null) {
            gc.setForeground(Colors.getGray());
            TextDrawing.drawText(gc, hint, bounds.x + (bounds.width - hintSize.x) / 2, y, 16384);
            y += hintSize.y + 10;
        }
        if (this.sourcePathSearchActive && this.mMsgShowSearchHint) {
            String text = BasicTextFilter.wrap((String)CodeMessages.SOURCE_SEARCH_ACTIVE, (int)50);
            Point sizeActive = fontInfo.getExtent(text);
            gc.setForeground(Colors.getDarkGray());
            TextDrawing.drawText(gc, text, bounds.x + (bounds.width - sizeActive.x) / 2, y, 16384);
            y += sizeActive.y + 10;
        }
        if (clickable) {
            Point clickSize = fontInfo.getExtent(CodeMessages.CLICK_HERE);
            gc.setForeground(Colors.getBlue());
            this.mMsgBounds = new Rectangle(bounds.x + (bounds.width - clickSize.x) / 2, y, clickSize.x, clickSize.y);
            TextDrawing.drawText(gc, CodeMessages.CLICK_HERE, this.mMsgBounds.x, this.mMsgBounds.y, 16384);
            gc.drawLine(this.mMsgBounds.x, this.mMsgBounds.y + this.mMsgBounds.height, this.mMsgBounds.x + this.mMsgBounds.width, this.mMsgBounds.y + this.mMsgBounds.height);
            this.fromVirtual(this.mMsgBounds);
            y += clickSize.y + 10;
        } else {
            this.mMsgBounds = new Rectangle(0, 0, 0, 0);
        }
    }

    private void drawMore(GC gc) {
        if (!this.mSelection.isEmpty()) {
            int remaining = this.mSelection.getCountOfSelectedIndexesBefore(this.getFirstVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            remaining = this.mSelection.getCountOfSelectedIndexesAfter(this.getLastFullyVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    private void drawMore(GC gc, boolean up, int amt) {
        Rectangle clientArea = this.toVirtual(this.getClientArea());
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(CodeMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = clientArea.x + clientArea.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = clientArea.y + (up ? this.mHeaderLineHeight + 4 + 4 : clientArea.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    private int drawOneHeader(GC gc, String title, int x, int y, int col) {
        if (this.mColumnSizes[col] > 0) {
            TextDrawing.drawString(gc, title, x + this.mColumnSizes[col] / 2, y, 0x1000000);
            x += this.mColumnSizes[col] + 5;
        }
        return x;
    }

    private @NonNull Analysis getAnalysis() {
        return this.mOwner.getAnalysis();
    }

    private @Nullable Pair<@NonNull InstructionCounterCodeColumnsWithMetadata, @NonNull CodeTabSelectionModel.ActiveImageProperties> getCheckedActiveSelectionState() {
        InstructionCounterCodeColumnsWithMetadata currentColumnSelection = this.activeColumnSelection;
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = this.activeImageProperties;
        if (currentColumnSelection == null || currentImageProperties == null || currentColumnSelection.source != currentImageProperties.source) {
            return null;
        }
        return new Pair((Object)currentColumnSelection, (Object)currentImageProperties);
    }

    private int getLineIndexAt(int virtualY) {
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        int lineCount = currentFileLineInfo != null ? currentFileLineInfo.mLines.size() : 0;
        int top = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 4))).y;
        int line = (virtualY - top) / this.mLineHeight;
        if (line < 0) {
            return -1;
        }
        if ((line += this.getFirstVisibleLine()) >= lineCount) {
            return -1;
        }
        return line;
    }

    private @Nullable ISourceLineReference @Nullable [] getSelectableObjectAtIndexes(int index, int count) {
        if (count < 1) {
            return null;
        }
        int firstLineNo = index + 1;
        SourceFileLineData currentFileLineInfo = this.mActiveFileLineInfo;
        ReferencedSymbol lastFunction = this.mLastSelectedFunction;
        if (currentFileLineInfo == null || lastFunction == null) {
            return null;
        }
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        if (currentSelectionState == null) {
            return null;
        }
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second;
        ISamplesReportDataForDisasmAndSourceAnnotations currentDataSet = currentImageProperties.activeDataSet;
        ISampleSourceLineDataProperties[] properties = currentDataSet.getSourceLocationDataPropertiesFor(currentFileLineInfo.sourceFile.uid, firstLineNo, count);
        if (properties == null || properties.length == 0) {
            return null;
        }
        assert (properties.length <= count);
        return SourcePanel.makeSelectionReferences(lastFunction, List.of(properties));
    }

    private @Nullable SourceFileLineData getSourceFileLineData(@NonNull SourceFile sourceFile) {
        Analysis analysis = this.getAnalysis();
        File fullPath = FileUtils.canonicalise((File)new File(analysis.computeFullPath(sourceFile)));
        String cacheKey = fullPath.getPath();
        if (!fullPath.isFile() || !fullPath.canRead()) {
            this.cachedSourceFileLineData.remove((Object)cacheKey);
            return null;
        }
        SourceFileLineData cachedEntry = (SourceFileLineData)this.cachedSourceFileLineData.get((Object)cacheKey);
        if (cachedEntry != null && cachedEntry.isValid(fullPath)) {
            return cachedEntry;
        }
        this.cachedSourceFileLineData.remove((Object)cacheKey);
        SourceFileLineData result = new SourceFileLineData(fullPath, sourceFile);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(fullPath));){
                SourceColorizer colorizer = new SourceColorizer(Colors.getListForeground(), CFamilyKeywordColorData.DATA);
                String text = in.readLine();
                while (text != null) {
                    text = TextDrawing.expandTabs(text, 0, 4);
                    result.mLines.add(text);
                    result.mColorRuns.add(colorizer.colorize(text, sourceFile));
                    int length = text.length();
                    if (length > result.mLineCharCount) {
                        result.mLineCharCount = length;
                    }
                    text = in.readLine();
                }
                CommonFileUtils.ignoredClose((Closeable)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        this.cachedSourceFileLineData.put((Object)cacheKey, (Object)result);
        return result;
    }

    private boolean isMsgClickable() {
        return CodeMessages.MISSING.equals(this.mMsg);
    }

    private void locateSourceFile() {
        Shell shell;
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = this.activeImageProperties;
        if (currentImageProperties == null) {
            assert (false);
            return;
        }
        SourceFile sourceFile = currentImageProperties.selection.sourceFile();
        if (sourceFile == null) {
            assert (false);
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (shell = window.getShell()) != null) {
            PathSubstitutionsFile pathSubstitutionsFile;
            String newPath;
            FileDialog dialog = new FileDialog(shell, 69632);
            Analysis analysis = this.getAnalysis();
            String name = sourceFile.getFileName();
            dialog.setText(MessageFormat.format(CodeMessages.LOCATE_SOURCE_FILE_TITLE, name));
            dialog.setFileName(name);
            String oldPath = sourceFile.getParentPath();
            if (!oldPath.isEmpty()) {
                dialog.setFilterPath(oldPath);
            }
            if ((newPath = dialog.open()) != null && (pathSubstitutionsFile = analysis.getPathSubstitutionsFile()).updateSubstitutionsBasedOnFile(sourceFile.filePath, newPath)) {
                analysis.notifyOfSourceFilePathChange();
                String updatedPath = pathSubstitutionsFile.computeUpdatedPath(sourceFile);
                if (!new File(updatedPath).isFile()) {
                    Error.show(CodeMessages.BAD_SUBSTITION_MESSAGE);
                    return;
                }
            }
        }
    }

    private void recomputeFunctionLineColourMap(@NonNull SourceFileLineData fileLineInfo) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        this.mFunctionColorMap.clear();
        if (currentImageProperties != null && fileLineInfo.sourceFile.referencingImage == currentImageProperties.selection.imageFile()) {
            ISamplesReportDataForDisasmAndSourceAnnotations currentData = currentImageProperties.activeDataSet;
            List symbols = currentData.getAllKnownSymbolsIn(fileLineInfo.sourceFile.uid);
            Collections.sort(symbols, new Comparator<ISamplesReportDataForDisasmAndSourceAnnotations.SymbolLineRange>(){

                @Override
                public int compare(ISamplesReportDataForDisasmAndSourceAnnotations.SymbolLineRange f1, ISamplesReportDataForDisasmAndSourceAnnotations.SymbolLineRange f2) {
                    int l2;
                    int l1 = f1.fromLine();
                    if (l1 < (l2 = f2.fromLine())) {
                        return -1;
                    }
                    if (l1 > l2) {
                        return 1;
                    }
                    return f1.symbol().compareTo(f2.symbol());
                }
            });
            Color functionColor1 = Colors.create(232, 255, 232);
            Color functionColor2 = Colors.create(232, 232, 255);
            Color currentColor = functionColor1;
            for (ISamplesReportDataForDisasmAndSourceAnnotations.SymbolLineRange symbol : symbols) {
                int n = 0;
                while (n < symbol.lineCount()) {
                    this.mFunctionColorMap.put(symbol.fromLine() + n, (Object)currentColor);
                    ++n;
                }
                currentColor = currentColor == functionColor1 ? functionColor2 : functionColor1;
            }
        }
    }

    private void refocus() {
        this.computeSize(-1, -1);
        this.getHorizontalSlider().setIncrement(this.mCharWidth);
        this.adjustSliders();
        Slider slider = this.getVerticalSlider();
        int max = slider.getMaximum();
        int current = slider.getSelection();
        if (current > max) {
            slider.setSelection(max);
            this.wasScrolled();
            this.adjustSliders();
        }
        this.redraw();
    }

    private void scrollMoreDown() {
        int first;
        int max = this.getPageSize().y;
        int last = first = this.mSelection.nextSelectedIndex(this.getLastFullyVisibleLine() + 1);
        int index = first;
        while ((index = this.mSelection.nextSelectedIndex(index + 1)) != -1 && index - first <= max) {
            last = index;
        }
        this.showLine(last);
        this.showLine(first);
    }

    private void scrollMoreUp() {
        int rangeEnd;
        int rangeStart;
        int first = this.getFirstVisibleLine();
        int index = -1;
        TIntArrayList list = new TIntArrayList();
        while ((index = this.mSelection.nextSelectedIndex(index + 1)) != -1 && index < first) {
            list.add(index);
        }
        int max = this.getPageSize().y;
        int last = list.size() - 1;
        first = rangeStart = (rangeEnd = list.get(last--));
        while (last >= 0) {
            if (rangeEnd - (first = list.get(last--)) > max) break;
            rangeStart = first;
        }
        this.showLine(rangeEnd);
        this.showLine(rangeStart);
    }

    private void updateSizes() {
        this.updateSizesNoRefocus();
        ConsolidatedUIExec.exec(this, null, this, false);
    }

    private void updateSizesNoRefocus() {
        Font font = Fonts.getSource();
        FontInfo fontInfo = FontInfo.get(font);
        this.mCharWidth = fontInfo.getMaxWidth();
        this.mLineHeight = Math.max(fontInfo.getHeight(), Math.max(Math.max(this.mInlineImage_InlinedBoth.getBounds().height, this.mInlineImage_InlinedFrom.getBounds().height), this.mInlineImage_InlinedInto.getBounds().height));
        this.mHeaderLineHeight = FontInfo.get(Fonts.getNormal()).getHeight();
    }

    static /* synthetic */ Image access$1(SourcePanel sourcePanel) {
        return sourcePanel.mInlineImage_InlinedFrom;
    }

    static /* synthetic */ Image access$2(SourcePanel sourcePanel) {
        return sourcePanel.mInlineImage_InlinedInto;
    }

    private record ContextMenuItemKey(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ISampleSourceLineDataProperties.PerSymbolProperties.Type type, @NonNull SymbolName symbolName, @Nullable Symbol targetSymbol) {
        static /* synthetic */ SymbolName access$6(ContextMenuItemKey contextMenuItemKey) {
            return contextMenuItemKey.symbolName;
        }

        static /* synthetic */ ISampleSourceLineDataProperties.PerSymbolProperties.Type access$7(ContextMenuItemKey contextMenuItemKey) {
            return contextMenuItemKey.type;
        }
    }

    private static enum MouseState {
        MORE_DOWN,
        MORE_UP,
        NORMAL;

    }

    private record PairOfImageFileAndInstructions(@NonNull InstructionCounterCodeColumnsWithMetadata currentColumnSelection, @NonNull CodeTabSelectionModel.ActiveImageProperties currentImageProperties, @NonNull CodeTabSelectionModel.ActiveSelection selection, @NonNull TLongSet instructionIndexes, @NonNull ContextMenuItemKey key) {
    }

    private static final class SourceFileLineData {
        public final @NonNull File filePath;
        public final @NonNull List<@NonNull ColorRun @NonNull []> mColorRuns = new ArrayList<ColorRun[]>();
        public int mLineCharCount = 0;
        public final @NonNull List<@NonNull String> mLines = new ArrayList<String>();
        public final long modificationTimestamp;
        public final @NonNull SourceFile sourceFile;

        public SourceFileLineData(@NonNull File filePath, @NonNull SourceFile sourceFile) {
            this.sourceFile = sourceFile;
            this.filePath = filePath;
            this.modificationTimestamp = filePath.lastModified();
        }

        public boolean isValid(@NonNull File filePath) {
            return filePath.lastModified() == this.modificationTimestamp;
        }
    }

    private record SourceLocationItem(@NonNull InstructionCounterCodeColumnsWithMetadata currentColumnSelection, @NonNull CodeTabSelectionModel.ActiveImageProperties currentImageProperties, @NonNull CodeTabSelectionModel.ActiveSelection selection, @NonNull ContextMenuItemKey key, @NonNull SourceLocation location) {
    }
}

