/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.editortabs.code.ColorRun;
import com.arm.streamline.editortabs.code.IKeywordColorData;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;

public class SourceColorizer {
    private static final int NORMAL = 0;
    private static final int LOOK_FOR_COMMENT_START = 1;
    private static final int IN_COMMENT = 2;
    private static final int LOOK_FOR_COMMENT_END = 3;
    private static final int IN_ESCAPE = 4;
    private static final int IN_DOUBLE_QUOTE = 5;
    private static final int IN_SINGLE_QUOTE = 6;
    private int mState = 0;
    private IKeywordColorData mKeywordColorData;
    private int mReturnState;
    private Color mColor;
    private Color mTextColor;
    private int mStart;

    public SourceColorizer(Color textColor, IKeywordColorData data) {
        this.mTextColor = textColor;
        this.mKeywordColorData = data;
        this.mColor = this.mTextColor;
    }

    public @NonNull ColorRun @NonNull [] colorize(String text, SourceFile file) {
        int len;
        ArrayList<ColorRun> colors = new ArrayList<ColorRun>();
        int length = text.length();
        StringBuilder buffer = new StringBuilder();
        if (this.mKeywordColorData.canColorize(file)) {
            int i = 0;
            while (i < length) {
                char ch = text.charAt(i);
                switch (this.mState) {
                    case 0: {
                        if (ch == '/') {
                            this.finishKeywordMatch(colors, buffer, i);
                            this.mState = 1;
                            this.mStart = i;
                            break;
                        }
                        if (ch == '\\') {
                            this.finishKeywordMatch(colors, buffer, i);
                            this.mReturnState = this.mState;
                            this.mState = 4;
                            break;
                        }
                        if (ch == '\'' || ch == '\"') {
                            if (!this.finishKeywordMatch(colors, buffer, i) && i > 0) {
                                colors.add(new ColorRun(this.mColor, i));
                            }
                            this.mColor = this.mKeywordColorData.getQuoteColor();
                            this.mState = ch == '\"' ? 5 : 6;
                            break;
                        }
                        if (buffer.length() == 0 && (ch == '#' || Character.isJavaIdentifierStart(ch)) || buffer.length() > 0 && Character.isJavaIdentifierPart(ch)) {
                            buffer.append(ch);
                            break;
                        }
                        this.finishKeywordMatch(colors, buffer, i);
                        break;
                    }
                    case 1: {
                        if (ch == '/') {
                            if (this.mStart > 0) {
                                colors.add(new ColorRun(this.mColor, this.mStart));
                            }
                            this.mColor = this.mKeywordColorData.getCommentColor();
                            colors.add(new ColorRun(this.mColor, text.length()));
                            this.mState = 0;
                            this.mColor = this.mTextColor;
                            return colors.toArray(new ColorRun[colors.size()]);
                        }
                        if (ch == '*') {
                            if (this.mStart > 0) {
                                colors.add(new ColorRun(this.mColor, this.mStart));
                            }
                            this.mColor = this.mKeywordColorData.getCommentColor();
                            this.mState = 2;
                            break;
                        }
                        this.mState = 0;
                        break;
                    }
                    case 2: {
                        if (ch != '*') break;
                        this.mState = 3;
                        break;
                    }
                    case 3: {
                        if (ch == '/') {
                            colors.add(new ColorRun(this.mColor, i + 1));
                            this.mColor = this.mTextColor;
                            this.mState = 0;
                            break;
                        }
                        if (ch == '*') break;
                        this.mState = 2;
                        break;
                    }
                    case 4: {
                        this.mState = this.mReturnState;
                        break;
                    }
                    case 5: {
                        if (ch == '\"') {
                            colors.add(new ColorRun(this.mColor, i + 1));
                            this.mColor = this.mTextColor;
                            this.mState = 0;
                            break;
                        }
                        if (ch != '\\') break;
                        this.mReturnState = this.mState;
                        this.mState = 4;
                        break;
                    }
                    case 6: {
                        if (ch == '\'') {
                            colors.add(new ColorRun(this.mColor, i + 1));
                            this.mColor = this.mTextColor;
                            this.mState = 0;
                            break;
                        }
                        if (ch != '\\') break;
                        this.mReturnState = this.mState;
                        this.mState = 4;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!this.finishKeywordMatch(colors, buffer, len = text.length())) {
            colors.add(new ColorRun(this.mColor, len));
        }
        return colors.toArray(new ColorRun[colors.size()]);
    }

    private boolean finishKeywordMatch(@NonNull List<@NonNull ColorRun> colors, StringBuilder buffer, int pos) {
        if (buffer.length() > 0) {
            String text = buffer.toString();
            buffer.setLength(0);
            if (this.mKeywordColorData.isKeyword(text)) {
                int last = pos - text.length();
                if (last > 0) {
                    colors.add(new ColorRun(this.mColor, last));
                }
                this.mColor = this.mKeywordColorData.getKeywordColor();
                colors.add(new ColorRun(this.mColor, pos));
                this.mColor = this.mTextColor;
                return true;
            }
        }
        return false;
    }
}

