/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Divider;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.ImageButton;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PathPrefixSubstitutionDialog
extends TitleAreaDialog {
    private static final String PREFIX = "prefix";
    private static final String REPLACEMENT = "replacement";
    private static final String DEC_KEY = "decoration";
    private Analysis mAnalysis;
    private ScrolledComposite mScroller;
    private Composite mContent;
    private Composite mSubstitutionsPanel;
    private Composite mExistingPathsPanel;
    private Map<@NonNull String, @NonNull String> mResult;
    private List<TextField> mRevised = new ArrayList<TextField>();

    public static void show(Analysis analysis) {
        PathPrefixSubstitutionDialog dialog = new PathPrefixSubstitutionDialog(analysis);
        dialog.create();
        if (dialog.open() != 1) {
            PathSubstitutionsFile pathSubstitutionsFile = analysis.getPathSubstitutionsFile();
            Map substitutions = pathSubstitutionsFile.getPathSubstitutions();
            substitutions.clear();
            substitutions.putAll(dialog.mResult);
            pathSubstitutionsFile.save();
            analysis.notifyOfSourceFilePathChange();
        }
    }

    private static Label createHeader(String title, Composite parent) {
        Label label = new Label(parent, 0x1000000);
        label.setFont(Fonts.getNormalStandout());
        label.setText(title);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        return label;
    }

    private PathPrefixSubstitutionDialog(Analysis analysis) {
        super(WorkspaceUtils.getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mAnalysis = analysis;
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            this.mResult = this.getSubstitutionMap();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CodeMessages.PATH_PREFIX_SUBS);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(CodeMessages.APPLY);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(CodeMessages.PATH_PREFIX_SUBS);
        this.setMessage(MessageFormat.format(CodeMessages.MESSAGE, this.mAnalysis));
        this.mScroller = new ScrolledComposite((Composite)super.createDialogArea(parent), 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mScroller);
        this.mScroller.setExpandHorizontal(true);
        this.mScroller.setShowFocusedControl(true);
        this.mContent = new Composite((Composite)this.mScroller, 0x20000000);
        this.mScroller.setContent((Control)this.mContent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.mContent);
        this.createSubstitutionsPanel();
        PathPrefixSubstitutionDialog.createHeader(CodeMessages.RESULTS, this.mContent);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)new Divider(this.mContent, false));
        this.createExistingPathsPanel();
        this.updateResults();
        this.mContent.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, "com.arm.streamline.path_prefix_subs");
        return this.mScroller;
    }

    protected void initializeBounds() {
        this.getShell().setMinimumSize(640, 480);
        super.initializeBounds();
    }

    private void addSubstitutionRow(String prefix) {
        Control[] children = this.mSubstitutionsPanel.getChildren();
        children[children.length - 1].dispose();
        TextField text = this.createSubstitutionRow(prefix, "");
        this.createAddButton();
        SafeUpdate.pack(this.mContent);
        text.selectAll();
        text.setFocus();
    }

    private ImageButton createAddButton() {
        ImageButton button = new ImageButton(this.mSubstitutionsPanel, StreamlinePlugin.getImage(StreamlineImages.ADD));
        button.addClickListener(imgButton -> this.addSubstitutionRow(""));
        return button;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createExistingPathsPanel() {
        this.mExistingPathsPanel = new Composite(this.mContent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mExistingPathsPanel);
        GridLayoutFactory.swtDefaults().spacing(4, 2).numColumns(2).equalWidth(true).applyTo(this.mExistingPathsPanel);
        PathPrefixSubstitutionDialog.createHeader(CodeMessages.ORIGINAL, this.mExistingPathsPanel).setToolTipText(CodeMessages.ORIGINAL_TOOLTIP);
        PathPrefixSubstitutionDialog.createHeader(CodeMessages.REVISED, this.mExistingPathsPanel).setToolTipText(CodeMessages.REVISED_TOOLTIP);
        PathSubstitutionsFile pathSubstitutionsFile = this.mAnalysis.getPathSubstitutionsFile();
        @NonNull @NonNull @NonNull Map substitutions = pathSubstitutionsFile.getPathSubstitutions();
        @NonNull ArrayList<@NonNull String> paths = new ArrayList<String>();
        for (String path : this.mAnalysis.getInstructionCounterModel().getUnadjustedSourceDirectories()) {
            if (path.isEmpty() || !FilePath.isFullPath((String)path)) {
                path = FilePath.getFullPath((String)"/UNSPECIFIED", (String)path);
            }
            if (pathSubstitutionsFile.isSpecialDirectory(path, true)) continue;
            paths.add(path);
        }
        Collections.sort(paths);
        int decWidth = 2 + FieldDecorationRegistry.getDefault().getFieldDecoration((String)"DEC_ERROR").getImage().getBounds().width;
        for (String path : paths) {
            TextField field = new TextField(this.mExistingPathsPanel, 8);
            field.setTextBackground(Colors.getWidgetBackground());
            field.setTextForeground(Colors.getText(false));
            field.setText(path);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)field);
            field = new TextField(this.mExistingPathsPanel, 8);
            String revised = PathSubstitutionsFile.adjustPathForSubstitutions((String)path, (Map)substitutions);
            field.setText(revised);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(decWidth, -1).applyTo((Control)field);
            field.setData(path);
            this.mRevised.add(field);
            ControlDecoration dec = new ControlDecoration((Control)field, 16512);
            dec.setMarginWidth(1);
            field.setData(DEC_KEY, dec);
        }
    }

    private TextField createSubstitutionRow(String prefix, String replacement) {
        ImageButton button = new ImageButton(this.mSubstitutionsPanel, StreamlinePlugin.getImage("Remove.gif"));
        button.addClickListener(imgButton -> {
            ((TextField)button.getData(REPLACEMENT)).dispose();
            ((TextField)button.getData(PREFIX)).dispose();
            button.dispose();
            this.updateResults();
            SafeUpdate.pack(this.mContent);
        });
        TextField field = this.createTextField(prefix, 0);
        button.setData(PREFIX, field);
        button.setData(REPLACEMENT, this.createTextField(replacement, 2 + FieldDecorationRegistry.getDefault().getFieldDecoration((String)"DEC_ERROR").getImage().getBounds().width));
        return field;
    }

    private void createSubstitutionsPanel() {
        this.mSubstitutionsPanel = new Composite(this.mContent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mSubstitutionsPanel);
        GridLayoutFactory.swtDefaults().spacing(4, 2).numColumns(3).applyTo(this.mSubstitutionsPanel);
        GridDataFactory.swtDefaults().applyTo((Control)new Label(this.mSubstitutionsPanel, 0x1000000));
        PathPrefixSubstitutionDialog.createHeader(CodeMessages.PREFIX_TITLE, this.mSubstitutionsPanel);
        PathPrefixSubstitutionDialog.createHeader(CodeMessages.REPLACEMENT_TITLE, this.mSubstitutionsPanel);
        PathSubstitutionsFile pathSubstitutionsFile = this.mAnalysis.getPathSubstitutionsFile();
        Map substitutions = pathSubstitutionsFile.getPathSubstitutions();
        for (Pair entry : PathSubstitutionsFile.getSubstitutionOrder((Map)substitutions)) {
            this.createSubstitutionRow((String)entry.first, (String)entry.second);
        }
        this.createAddButton();
        this.mSubstitutionsPanel.setSize(this.mSubstitutionsPanel.computeSize(-1, -1));
    }

    private TextField createTextField(String contents, int indent) {
        TextField field = new TextField(this.mSubstitutionsPanel);
        field.setText(contents);
        field.addFieldModifiedListener(textField -> this.updateResults());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).indent(indent, -1).applyTo((Control)field);
        return field;
    }

    private @NonNull Map<@NonNull String, @NonNull String> getSubstitutionMap() {
        @NonNull HashMap<@NonNull String, @NonNull String> map = new HashMap<String, String>();
        Control[] children = this.mSubstitutionsPanel.getChildren();
        int i = 3;
        while (++i < children.length) {
            String prefix;
            if (!(prefix = ((TextField)children[i++]).getText().trim()).isEmpty()) {
                map.put(prefix, ((TextField)children[i++]).getText().trim());
                continue;
            }
            ++i;
        }
        return map;
    }

    private void updateResults() {
        @NonNull Map<@NonNull String, @NonNull String> map = this.getSubstitutionMap();
        for (TextField text : this.mRevised) {
            @NonNull String path = (String)NullChecking.neverNullOr((Object)((String)text.getData()), (Object)"");
            @NonNull String revised = PathSubstitutionsFile.adjustPathForSubstitutions((String)path, map);
            text.setText(revised);
            boolean match = revised.equals(path);
            text.setTextForeground(match ? Colors.getText(false) : Colors.getInfoForeground());
            text.setTextBackground(match ? Colors.getWidgetBackground() : Colors.getInfoBackground());
            ControlDecoration dec = (ControlDecoration)text.getData(DEC_KEY);
            if (new File(revised).exists()) {
                dec.setDescriptionText(null);
                dec.setImage(null);
                continue;
            }
            dec.setDescriptionText(CodeMessages.DOES_NOT_EXIST);
            dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        }
    }
}

