/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.code.AbstractCodeContextMenuContributor;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.CodeTabInstructionCounterColumn;
import com.arm.streamline.editortabs.code.CodeTabSelectionModel;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.jni.apcdbgen.proto.IOptionalSourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterDataSingleAccessor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataAccessorForColumn;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SimpleSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.streamline.utility.text.DisassemblyRenderer;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.ConsolidatedUIExec;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.IAutoScrollArea;
import com.arm.streamline.widget.IToolTipTracker;
import com.arm.streamline.widget.LineScrollCanvas;
import com.arm.streamline.widget.UpdatingToolTip;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuSelectionResolver;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Slider;

public class DisasmPanel
extends LineScrollCanvas
implements IToolTipTracker,
IAutoScrollArea,
MouseListener,
MouseMoveListener,
KeyListener,
Runnable,
IContextMenuSelectionResolver {
    protected static final int MARGIN = 1;
    private static final int COL_COUNTER_VALUE = 0;
    private static final int COL_INLINE = 1;
    private static final int COL_ADDRESS = 2;
    private static final int COL_OPCODE = 3;
    private static final int COL_DISASM = 4;
    private static final int COL_TARGET_SYMBOL = 5;
    private static final int COL_ORIGINAL_LOC = 6;
    private static final int COL_INLINE_LOC = 7;
    private static final int COL_TOTAL = 8;
    private static final int GAP = 3;
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_OFFSET = 4;
    private static final int MORE_V_MARGIN = 0;
    private static final int LINE_PADDING = 1;
    private static final int CLIPPING_PADDING = 2;
    protected final @NonNull Image mInlineImage;
    protected final @NonNull CodeTab mOwner;
    private @Nullable InstructionCounterCodeColumnsWithMetadata activeColumnSelection;
    private @Nullable CodeTabSelectionModel.ActiveImageProperties activeImageProperties;
    private final @NonNull ContextMenu contextMenu;
    private int mCharWidth;
    private final int @NonNull [] mColumnSizes = new int[8];
    private int mHeaderLineHeight;
    private int mLastSelection = -1;
    private int mLineHeight;
    private final Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private final Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private boolean mMouseDown;
    private @NonNull MouseState mMouseHandlingState = MouseState.NORMAL;

    private static void drawAtColumn(@NonNull GC gc, int @NonNull [] mColumnSizes, @NonNull String text, int y, int col) {
        int x = 1;
        int i = 0;
        while (i < col) {
            x += mColumnSizes[i] + 3;
            ++i;
        }
        TextDrawing.drawString(gc, text, x, y, 16384);
    }

    private static void drawLines_Break(@NonNull GC gc, @NonNull Rectangle bounds, int y, int textYOffset, int mLineHeight, int @NonNull [] mColumnSizes, long size) {
        gc.setBackground(Colors.lighten(Colors.getRed(), 95));
        gc.fillRectangle(bounds.x, y, bounds.width, mLineHeight);
        gc.setBackground(Colors.getWhite());
        gc.setForeground(Colors.getDarkRed());
        DisasmPanel.drawAtColumn(gc, mColumnSizes, MessageFormat.format(CodeMessages.BYTE_BREAK, size, Long.toHexString(size)), y + textYOffset, 4);
    }

    private static void drawLines_Instruction(@NonNull GC gc, @NonNull Rectangle bounds, @NonNull BitSet selection, int y, int textYOffset, int mLineHeight, int @NonNull [] mColumnSizes, @NonNull Image inlineImage, @NonNull Font font, long instructionIndex, @NonNull ISampleInstructionRowDataAccessorForColumn accessor) {
        AbstractStringBuilder buffer;
        ISampleInstructionRowDataProperties rowProperties = accessor.getRowProperties();
        Symbol targetSymbol = rowProperties.getTargetSymbol();
        long targetOffset = rowProperties.getTargetSymbolOffset();
        boolean isSelected = selection.get(Math.toIntExact(instructionIndex));
        int x = 1;
        int col = 0;
        if (isSelected) {
            gc.setBackground(Colors.getInstructionHighlight());
            gc.fillRectangle(bounds.x, y, bounds.width, mLineHeight);
        }
        Rectangle clipping = gc.getClipping();
        gc.setClipping(x, y, mColumnSizes[col], mLineHeight + 2);
        CodeTabInstructionCounterColumn.render((ISampleCounterDataSingleAccessor)accessor, gc, font, 1, x, y, mColumnSizes[col], mLineHeight);
        int n = col++;
        gc.setClipping(clipping);
        clipping = gc.getClipping();
        gc.setClipping(x += mColumnSizes[n] + 3, y, mColumnSizes[col], mLineHeight + 2);
        if (rowProperties.getInlinedSymbolName() != null || rowProperties.getInlinedSourceLocation() != null) {
            gc.drawImage(inlineImage, x, y);
        }
        int n2 = col++;
        gc.setClipping(clipping);
        clipping = gc.getClipping();
        gc.setClipping(x += mColumnSizes[n2] + 3, y, mColumnSizes[col], mLineHeight + 2);
        gc.setForeground(Colors.getBlack());
        TextDrawing.drawString(gc, NumberUtils.formatAddress((long)rowProperties.getAddress()), x, y + textYOffset, 16384);
        int n3 = col++;
        gc.setClipping(clipping);
        clipping = gc.getClipping();
        gc.setClipping(x += mColumnSizes[n3] + 3, y, mColumnSizes[col], mLineHeight + 2);
        gc.setForeground(Colors.getGray());
        byte[] opCode = rowProperties.getOpcodeOrData();
        TextDrawing.drawString(gc, NumberUtils.formatOpcode((byte[])opCode, (rowProperties.getRowType() == ISampleInstructionRowDataProperties.RowType.THUMB ? 1 : 0) != 0, (rowProperties.getRowType() == ISampleInstructionRowDataProperties.RowType.ARM32 || rowProperties.getRowType() == ISampleInstructionRowDataProperties.RowType.ARM64 ? 1 : 0) != 0), x, y + textYOffset, 16384);
        int n4 = col++;
        gc.setClipping(clipping);
        clipping = gc.getClipping();
        gc.setClipping(x += mColumnSizes[n4] + 3, y, mColumnSizes[col], mLineHeight + 2);
        DisassemblyRenderer.draw(gc, font, x, y + textYOffset, false, false, rowProperties);
        x += mColumnSizes[col++] + 3;
        gc.setClipping(clipping);
        if (targetSymbol != null) {
            buffer = new StringBuffer();
            ((StringBuffer)buffer).append(targetSymbol.getName());
            if (targetOffset > 0L) {
                ((StringBuffer)buffer).append(" + ");
                ((StringBuffer)buffer).append("0x");
                ((StringBuffer)buffer).append(Long.toHexString(targetOffset).toUpperCase());
            }
            Rectangle clipping2 = gc.getClipping();
            gc.setClipping(x, y, mColumnSizes[col], mLineHeight + 2);
            TextDrawing.drawString(gc, ((StringBuffer)buffer).toString(), x, y + textYOffset, 16384);
            gc.setClipping(clipping2);
        }
        x += mColumnSizes[col++] + 3;
        gc.setForeground(Colors.getGray());
        buffer = new StringBuilder();
        SourceLocation originalSourceLocation = rowProperties.getOriginalSourceLocation();
        if (originalSourceLocation != null) {
            ((StringBuilder)buffer).append(originalSourceLocation.sourceFile.getFileName());
            ((StringBuilder)buffer).append(':');
            ((StringBuilder)buffer).append(originalSourceLocation.lineNo);
        }
        Rectangle clipping3 = gc.getClipping();
        gc.setClipping(x, y, mColumnSizes[col], mLineHeight + 2);
        TextDrawing.drawString(gc, ((StringBuilder)buffer).toString(), x, y + textYOffset, 16384);
        gc.setClipping(clipping3);
        x += mColumnSizes[col++] + 3;
        buffer = new StringBuilder();
        SourceLocation inlinedSourceLocation = rowProperties.getInlinedSourceLocation();
        if (inlinedSourceLocation != null) {
            ((StringBuilder)buffer).append(inlinedSourceLocation.sourceFile.getFileName());
            ((StringBuilder)buffer).append(':');
            ((StringBuilder)buffer).append(inlinedSourceLocation.lineNo);
        }
        clipping3 = gc.getClipping();
        gc.setClipping(x, y, mColumnSizes[col], mLineHeight + 2);
        TextDrawing.drawString(gc, ((StringBuilder)buffer).toString(), x, y + textYOffset, 16384);
        gc.setClipping(clipping3);
    }

    private static void drawLines_Symbol(@NonNull GC gc, @NonNull Rectangle bounds, int y, int textYOffset, int mLineHeight, int @NonNull [] mColumnSizes, @NonNull Symbol symbol) {
        gc.setBackground(Colors.lighten(Colors.getBlue(), 95));
        gc.fillRectangle(bounds.x, y, bounds.width, mLineHeight);
        gc.setBackground(Colors.getWhite());
        gc.setForeground(Colors.getBlue());
        DisasmPanel.drawAtColumn(gc, mColumnSizes, symbol.getName(), y + textYOffset, 4);
    }

    private static int getBestSize(String header, int contentWidth) {
        return Math.max(FontInfo.get(Fonts.getNormal()).getWidth(header), contentWidth);
    }

    private static int getBestSize(String header, String content) {
        return DisasmPanel.getBestSize(header, FontInfo.get(Fonts.getSource()).getWidth(content));
    }

    private static int getCountOfSelectedIndexesAfter(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions, int afterIndex) {
        int count = 0;
        int index = afterIndex;
        while ((index = currentImageAndInstructions.selection.selectedInstructions().nextSetBit(index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static int getCountOfSelectedIndexesBefore(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions, int beforeIndex) {
        int count = 0;
        int index = -1;
        while ((index = currentImageAndInstructions.selection.selectedInstructions().nextSetBit(index + 1)) != -1 && index < beforeIndex) {
            ++count;
        }
        return count;
    }

    private static int safeInstructionCount(@Nullable CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions) {
        if (currentImageAndInstructions == null) {
            return 0;
        }
        return (int)Math.min(currentImageAndInstructions.activeDataSet.maxInstructionIndex(), Integer.MAX_VALUE);
    }

    public DisasmPanel(@NonNull Composite parent, final @NonNull CodeTab owner) {
        super(parent);
        ControlHacks.setBackground((Control)this, Colors.getWhite());
        this.mOwner = owner;
        this.mInlineImage = (Image)NullChecking.neverNull((Object)StreamlinePlugin.getImage("InlinedHere.png"));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        UpdatingToolTip.create((Control)this, this);
        this.updateSizes();
        this.contextMenu = new ContextMenu((Control)this, (Control)this);
        this.contextMenu.add(new AbstractCodeContextMenuContributor(){
            private static final String ID = "show-disasm-item";
            private static final String ID_FN = "functions-menu";
            private static final String ID_SL = "source-line-menu";
            private static final String ID_SI = "select-instructions-menu";

            /*
             * WARNING - void declaration
             */
            @Override
            public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
                Object object = menuItem.getData();
                if (object instanceof ReferencedSymbol) {
                    void that;
                    ReferencedSymbol referencedSymbol = (ReferencedSymbol)object;
                    ReferencedSymbol cfr_ignored_0 = (ReferencedSymbol)object;
                    owner.requireEditor().select(EditorTabID.FUNCTIONS, (ISelection)new StructuredSelection((Object)that));
                } else {
                    Object object2 = menuItem.getData();
                    if (object2 instanceof SelectInstructionsMenuAction) {
                        void that;
                        SelectInstructionsMenuAction selectInstructionsMenuAction = (SelectInstructionsMenuAction)object2;
                        SelectInstructionsMenuAction cfr_ignored_1 = (SelectInstructionsMenuAction)object2;
                        Symbol symbol = that.symbol;
                        ReferencedSymbol referencedSymbol = symbol.referencedSymbol;
                        ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange = that.instructionRange;
                        long[] instructionIndexes = that.instructionIndexes;
                        BitSet bitSet = new BitSet();
                        if (instructionRange != null) {
                            long i = 0L;
                            while (i < instructionRange.count()) {
                                long index = i + instructionRange.fromIndex();
                                if (index >= 0L && index <= Integer.MAX_VALUE) {
                                    bitSet.set((int)index);
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            if (!$assertionsDisabled && instructionIndexes == null) {
                                throw new AssertionError();
                            }
                            long[] lArray = instructionIndexes;
                            int n = instructionIndexes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long index = lArray[n2];
                                if (index >= 0L && index <= Integer.MAX_VALUE) {
                                    bitSet.set((int)index);
                                }
                                ++n2;
                            }
                        }
                        that.currentImageProperties.selection = new CodeTabSelectionModel.ActiveSelection(that.selection.imageFile(), bitSet, null, new BitSet(), referencedSymbol != null ? referencedSymbol : that.selection.lastSelectedSymbol());
                        DisasmPanel.this.refreshSelection();
                        DisasmPanel.this.mOwner.getSourcePanel().refreshInstructionSelection();
                    } else {
                        ISourceLineReference slr = IOptionalSourceLineReference.mapObject((Object)menuItem.getData());
                        if (slr != null) {
                            owner.requireEditor().select(EditorTabID.CODE, (ISelection)new StructuredSelection((Object)slr));
                        }
                    }
                }
            }

            @Override
            public void prepareMenu(ContextMenu cm) {
                MenuItem menu;
                DisasmPanel.this.mMouseDown = false;
                Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = DisasmPanel.this.getCheckedActiveSelectionState();
                if (currentSelectionState == null) {
                    return;
                }
                InstructionCounterCodeColumnsWithMetadata currentColumnSelection = (InstructionCounterCodeColumnsWithMetadata)currentSelectionState.first;
                CodeTabSelectionModel.ActiveImageProperties currentImageProperties = (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second;
                HashMap<ISourceLineReference, Double> originalSourceLineToRank = new HashMap<ISourceLineReference, Double>();
                HashMap<ISourceLineReference, Double> inlineSourceLineToRank = new HashMap<ISourceLineReference, Double>();
                HashMap<ReferencedSymbol, Double> functionToRank = new HashMap<ReferencedSymbol, Double>();
                HashMap<Symbol, TLongSet> relatedSymbols = new HashMap<Symbol, TLongSet>();
                HashSet<Symbol> selectedSymbols = new HashSet<Symbol>();
                int selectedInstructionIndex = currentImageProperties.selection.selectedInstructions().nextSetBit(0);
                while (selectedInstructionIndex >= 0) {
                    ISampleInstructionRowDataAccessorForColumn accessor = currentImageProperties.activeDataSet.getInstructionDataAccessorFor(currentColumnSelection.column, (long)selectedInstructionIndex);
                    ISampleInstructionRowDataProperties rowProperties = accessor.getRowProperties();
                    switch (rowProperties.getRowType()) {
                        case ARM32: 
                        case ARM64: 
                        case THUMB: {
                            Symbol targetSymbol = rowProperties.getTargetSymbol();
                            if (targetSymbol != null) {
                                long l = targetSymbol.address + rowProperties.getTargetSymbolOffset();
                                TLongSet set = relatedSymbols.computeIfAbsent(targetSymbol, k -> new TLongHashSet());
                                set.add(l);
                            }
                            Symbol symbol = rowProperties.getSymbol();
                            selectedSymbols.add(symbol);
                            ReferencedSymbol referencedSymbol = symbol.referencedSymbol;
                            if (referencedSymbol == null) break;
                            double value = accessor.getRankingValue();
                            SourceLocation originalLine = rowProperties.getOriginalSourceLocation();
                            SourceLocation inlineLine = rowProperties.getInlinedSourceLocation();
                            functionToRank.compute(referencedSymbol, (k, v) -> {
                                if (v == null) {
                                    return value;
                                }
                                return v + value;
                            });
                            if (originalLine != null) {
                                originalSourceLineToRank.compute((ISourceLineReference)new SimpleSourceReference(referencedSymbol, originalLine.sourceFile, originalLine.lineNo), (k, v) -> {
                                    if (v == null) {
                                        return value;
                                    }
                                    return v + value;
                                });
                            }
                            if (inlineLine == null) break;
                            inlineSourceLineToRank.compute((ISourceLineReference)new SimpleSourceReference(referencedSymbol, inlineLine.sourceFile, inlineLine.lineNo), (k, v) -> {
                                if (v == null) {
                                    return value;
                                }
                                return v + value;
                            });
                            break;
                        }
                        case DATA: 
                        case NONE: 
                        case SYMBOL_LABEL: {
                            Symbol symbol = rowProperties.getSymbol();
                            selectedSymbols.add(symbol);
                            break;
                        }
                        default: {
                            throw new AssertionError(rowProperties.getRowType());
                        }
                    }
                    selectedInstructionIndex = currentImageProperties.selection.selectedInstructions().nextSetBit(selectedInstructionIndex + 1);
                }
                Map.Entry<ReferencedSymbol, V>[] functionEntries = 1.sortByRank(functionToRank, f -> true, Comparator.comparing(a -> a.symbol.name));
                Map.Entry<ISourceLineReference, V>[] originalSourceEntries = 1.sortByRank(originalSourceLineToRank, f -> true, Comparator.comparing(a -> a.getStartLine()));
                Map.Entry<ISourceLineReference, V>[] inlineSourceEntries = 1.sortByRank(inlineSourceLineToRank, f -> !originalSourceLineToRank.containsKey(f), Comparator.comparing(a -> a.getStartLine()));
                if (functionEntries.length > 0) {
                    menu = cm.createCascadeMenu("Functions", ID_FN, true);
                    menu.setImage(StreamlinePlugin.getImage("Functions.png"));
                    1.populateMenu(functionEntries, entry -> {
                        String val = NumberUtils.format((double)((Double)entry.getValue()), (int)1, (boolean)false);
                        String title = String.format("%s (%s)", 1.fixAmp(1.truncateSymbol((ReferencedSymbol)entry.getKey(), 100)), val);
                        MenuItem menuItem = cm.createCascadeMenuItem(this, ID_FN, title, ID, true);
                        menuItem.setData(entry.getKey());
                        return true;
                    });
                }
                if (originalSourceEntries.length > 0 || inlineSourceEntries.length > 0) {
                    menu = cm.createCascadeMenu("Source Lines", ID_SL, true);
                    menu.setImage(StreamlinePlugin.getImage("CodeView.gif"));
                    1.populateMenu(originalSourceEntries, entry -> {
                        String val = NumberUtils.format((double)((Double)entry.getValue()), (int)1, (boolean)false);
                        String title = String.format("%s (%s)", 1.fixAmp(1.truncateSourceLine((ISourceLineReference)entry.getKey())), val);
                        MenuItem menuItem = cm.createCascadeMenuItem(this, ID_SL, title, ID, true);
                        menuItem.setData(entry.getKey());
                        return true;
                    });
                    1.populateMenu(inlineSourceEntries, entry -> {
                        String val = NumberUtils.format((double)((Double)entry.getValue()), (int)1, (boolean)false);
                        String title = String.format("%s (%s)", 1.fixAmp(1.truncateSourceLine((ISourceLineReference)entry.getKey())), val);
                        MenuItem menuItem = cm.createCascadeMenuItem(this, ID_SL, title, ID, true);
                        menuItem.setData(entry.getKey());
                        menuItem.setImage(DisasmPanel.this.mInlineImage);
                        return true;
                    });
                }
                ArrayList<SelectInstructionsMenuAction> selectInstructionsItems = new ArrayList<SelectInstructionsMenuAction>();
                for (Map.Entry entry2 : relatedSymbols.entrySet()) {
                    Symbol symbol = (Symbol)entry2.getKey();
                    TLongSet addressSet = (TLongSet)entry2.getValue();
                    ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructions = symbol.instructionRange;
                    if (instructions == null) continue;
                    selectInstructionsItems.add(new SelectInstructionsMenuAction(currentImageProperties, currentImageProperties.selection, symbol, symbol.address, null, instructions));
                    for (long address : addressSet) {
                        long[] indexes;
                        if (address == symbol.address || (indexes = currentImageProperties.activeDataSet.getInstructionIndexesForAddress(address)) == null || indexes.length <= 0) continue;
                        selectInstructionsItems.add(new SelectInstructionsMenuAction(currentImageProperties, currentImageProperties.selection, symbol, address, indexes, null));
                    }
                }
                for (Symbol symbol : selectedSymbols) {
                    ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructions;
                    if (relatedSymbols.containsKey(symbol) || (instructions = symbol.instructionRange) == null) continue;
                    selectInstructionsItems.add(new SelectInstructionsMenuAction(currentImageProperties, currentImageProperties.selection, symbol, symbol.address, null, instructions));
                }
                selectInstructionsItems.sort((a, b) -> {
                    int result = a.symbol.compareTo(b.symbol);
                    if (result != 0) {
                        return result;
                    }
                    result = Boolean.compare(a.instructionRange == null, b.instructionRange == null);
                    if (result != 0) {
                        return result;
                    }
                    return Long.compareUnsigned(a.address, b.address);
                });
                if (!selectInstructionsItems.isEmpty()) {
                    MenuItem menuItem = cm.createCascadeMenu("Select Instructions", ID_SI, true);
                    menuItem.setImage(StreamlinePlugin.getImage("CodeView.gif"));
                    for (SelectInstructionsMenuAction entry3 : selectInstructionsItems) {
                        Symbol symbol = entry3.symbol;
                        long address = entry3.address;
                        ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange = entry3.instructionRange;
                        long[] instructionIndexes = entry3.instructionIndexes;
                        String symbolTitle = 1.fixAmp(1.truncateSymbol(symbol.name, 100));
                        if (instructionRange != null) {
                            MenuItem menuItem2 = cm.createCascadeMenuItem(this, ID_SI, symbolTitle, ID, true);
                            menuItem2.setData((Object)entry3);
                            continue;
                        }
                        if (!$assertionsDisabled && instructionIndexes == null) {
                            throw new AssertionError();
                        }
                        long offset = address - symbol.address;
                        String title = String.format(" -> %s + 0x%x", symbolTitle, offset);
                        MenuItem menuItem3 = cm.createCascadeMenuItem(this, ID_SI, title, ID, true);
                        menuItem3.setData((Object)entry3);
                    }
                }
            }
        });
    }

    public void activeStateChanged(@Nullable InstructionCounterCodeColumnsWithMetadata newColumn, @Nullable CodeTabSelectionModel.ActiveImageProperties newImageProperties) {
        InstructionCounterCodeColumnsWithMetadata prevColumn = this.activeColumnSelection;
        CodeTabSelectionModel.ActiveImageProperties prevImageProperties = this.activeImageProperties;
        this.activeColumnSelection = newColumn;
        this.activeImageProperties = newImageProperties;
        if (!NullChecking.equalsNullable((Object)prevImageProperties, (Object)newImageProperties)) {
            this.mLastSelection = newImageProperties != null ? newImageProperties.selection.selectedInstructions().nextSetBit(0) : -1;
            this.showLine(newImageProperties != null ? newImageProperties.selection.selectedInstructions().length() - 1 : -1);
        }
        if (!NullChecking.equalsNullable((Object)prevColumn, (Object)newColumn) || !NullChecking.equalsNullable((Object)prevImageProperties, (Object)newImageProperties)) {
            this.updateSizes();
            this.redraw();
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        int nRows = this.updateColumnSizes();
        int width = 2 + 3 * (this.mColumnSizes.length - 1);
        int[] nArray = this.mColumnSizes;
        int n = this.mColumnSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnSize = nArray[n2];
            width += columnSize;
            ++n2;
        }
        int extraRows = (this.getSliderSize().y + this.mLineHeight - 1) / this.mLineHeight;
        return new Point(width, nRows + extraRows);
    }

    @Override
    public Rectangle getAutoScrollArea() {
        Rectangle bounds = this.getClientArea();
        bounds.y += this.mHeaderLineHeight;
        bounds.height -= this.mHeaderLineHeight;
        return bounds;
    }

    public int getFirstVisibleLine() {
        return this.getVerticalSlider().getSelection();
    }

    @Override
    public ISelection getSelection(Control control, Point where) {
        return null;
    }

    @Override
    public String getToolTipForLocation(Point location) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        int x1 = 0;
        int i = 0;
        while (i < 1) {
            x1 += this.mColumnSizes[i] + 3;
            ++i;
        }
        int x2 = x1 + this.mColumnSizes[1] + 3;
        Point pt = this.toVirtual(new Point(location.x, location.y));
        if (pt.x >= x1 && pt.x <= x2) {
            ISampleInstructionRowDataProperties properties;
            CodeTabSelectionModel.ActiveImageProperties currentImageProperties;
            int line;
            if (location.y < this.mHeaderLineHeight + 1) {
                return CodeMessages.INFO_HEADER_TOOLTIP;
            }
            if (currentSelectionState != null && (line = this.getLineIndexAt(currentImageProperties = (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second, pt.y)) > -1 && ((properties = currentImageProperties.activeDataSet.getInstructionProperties((long)line)).getInlinedSourceLocation() != null || properties.getInlinedSymbolName() != null)) {
                return CodeMessages.DISASM_INLINE_TOOLTIP;
            }
        }
        if (location.y < this.mHeaderLineHeight + 1) {
            x1 = 0;
            int i2 = 0;
            while (i2 < 0) {
                x1 += this.mColumnSizes[i2] + 3;
                ++i2;
            }
            x2 = x1 + this.mColumnSizes[0] + 3;
            pt = this.toVirtual(new Point(location.x, location.y));
            if (pt.x >= x1 && pt.x <= x2 && currentSelectionState != null) {
                InstructionCounterCodeColumnsWithMetadata currentColumnSelection = (InstructionCounterCodeColumnsWithMetadata)currentSelectionState.first;
                return currentColumnSelection.getTitle();
            }
        }
        return null;
    }

    @Override
    public boolean isAutoScrollMouseDown(int x, int y) {
        return this.getAutoScrollArea().contains(x, y);
    }

    public void keyPressed(KeyEvent event) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        int instructionCount = DisasmPanel.safeInstructionCount(currentImageAndInstructions);
        if (event.doit) {
            event.doit = false;
            switch (event.keyCode) {
                case 0x1000001: {
                    if (--this.mLastSelection < 0) {
                        this.mLastSelection = instructionCount - 1;
                    }
                    this.selectLineIf(currentImageAndInstructions, this.mLastSelection);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000002: {
                    if (++this.mLastSelection >= instructionCount) {
                        this.mLastSelection = 0;
                    }
                    this.selectLineIf(currentImageAndInstructions, this.mLastSelection);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000007: {
                    this.selectLineIf(currentImageAndInstructions, 0);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000008: {
                    this.selectLineIf(currentImageAndInstructions, instructionCount - 1);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000005: {
                    this.setScrollPosition(this.getVerticalSlider().getSelection() - Math.max(1, this.getPageSize().y - 1));
                    break;
                }
                case 0x1000006: {
                    this.setScrollPosition(this.getVerticalSlider().getSelection() + Math.max(1, this.getPageSize().y - 1));
                    break;
                }
                default: {
                    event.doit = true;
                }
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        this.setFocus();
        if (this.mMoreUpArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_UP;
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_DOWN;
        } else {
            this.mMouseHandlingState = MouseState.NORMAL;
            this.mMouseDown = true;
            int line = currentImageAndInstructions != null ? this.getLineIndexAt(currentImageAndInstructions, this.toVirtual((Point)new Point((int)0, (int)event.y)).y) : -1;
            this.selectLineIf(currentImageAndInstructions, line);
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.mMouseDown) {
            this.mouseDown(event);
        }
    }

    public void mouseUp(MouseEvent event) {
        this.mMouseDown = false;
        if (this.mMoreUpArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_UP) {
                this.scrollMoreUp();
            }
        } else if (this.mMoreDownArea.contains(event.x, event.y) && this.mMouseHandlingState == MouseState.MORE_DOWN) {
            this.scrollMoreDown();
        }
        this.mMouseHandlingState = MouseState.NORMAL;
    }

    public void refreshSelection() {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        this.mLastSelection = currentImageAndInstructions != null ? currentImageAndInstructions.selection.selectedInstructions().nextSetBit(0) : -1;
        this.showLine(currentImageAndInstructions != null ? currentImageAndInstructions.selection.selectedInstructions().length() - 1 : -1);
        this.redraw();
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.refocus();
        }
    }

    private void showLine(int lineIndex) {
        this.showLine(lineIndex, false);
    }

    public void showLine(int lineIndex, boolean andSelect) {
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions;
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties activeImageProperties = currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        if (currentImageAndInstructions == null) {
            this.getVerticalSlider().setSelection(0);
            this.wasScrolled();
            this.adjustSliders();
            this.redraw();
        } else if (lineIndex >= 0 && (long)lineIndex < currentImageAndInstructions.activeDataSet.maxInstructionIndex()) {
            if (andSelect) {
                currentImageAndInstructions.selection.selectedInstructions().clear();
                currentImageAndInstructions.selection.selectedInstructions().set(lineIndex);
            }
            int firstLine = this.getFirstVisibleLine();
            int lastLine = this.getLastFullyVisibleLine(currentImageAndInstructions);
            int pageSize = lastLine - firstLine;
            if (lineIndex < firstLine) {
                this.getVerticalSlider().setSelection(lineIndex);
                this.wasScrolled();
                this.adjustSliders();
            } else if (lineIndex > lastLine) {
                this.getVerticalSlider().setSelection(Math.max(lineIndex - pageSize, 0));
                this.wasScrolled();
                this.adjustSliders();
            }
            this.redraw();
        }
    }

    @Override
    protected Point getPageSize() {
        Rectangle bounds = this.getClientArea();
        return new Point(bounds.width, (bounds.height - 1 - this.mHeaderLineHeight) / this.mLineHeight);
    }

    @Override
    protected void paintCanvas(GC gc) {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        InstructionCounterCodeColumnsWithMetadata currentCounter = currentSelectionState != null ? (InstructionCounterCodeColumnsWithMetadata)currentSelectionState.first : null;
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        gc.fillRectangle(gc.getClipping());
        if (currentCounter != null && currentImageAndInstructions != null) {
            this.drawLines(gc, currentCounter, currentImageAndInstructions);
        }
        if (currentCounter != null) {
            this.drawHeader(gc, currentCounter);
        }
        this.drawDividers(gc);
        this.drawMore(gc, currentImageAndInstructions);
    }

    private void drawDividers(GC gc) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 1;
        int x = 1;
        int i = 0;
        while (i < 7) {
            if (this.mColumnSizes[i] > 0) {
                gc.setForeground(Colors.getDivider());
                gc.drawLine((x += this.mColumnSizes[i]) + 1, bounds.y, x + 1, bounds.y + headerHeight);
                gc.setForeground(Colors.getOutlineDivider());
                gc.drawLine(x + 1, bounds.y + headerHeight, x + 1, bounds.y + bounds.height);
                x += 3;
            }
            ++i;
        }
    }

    private void drawHeader(GC gc, @NonNull InstructionCounterCodeColumnsWithMetadata counterColumn) {
        @NonNull String title = counterColumn.getTitle();
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 1;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(x, y, width, headerHeight);
        gc.setForeground(Colors.getDivider());
        y = bounds.y + headerHeight - 1;
        gc.drawLine(x, y, x + width, y);
        x = 1;
        y = bounds.y;
        int col = 0;
        gc.setFont(Fonts.getNormal());
        gc.setForeground(Colors.getWidgetForeground());
        x = this.drawOneHeader(gc, title, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.INFO, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.ADDRESS, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.OPCODE, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.DISASM, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.DISASM_TARGET, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.ORIGINAL_LOCATION, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.INLINE_LOCATION, x, y, col++);
    }

    private void drawLines(GC gc, @NonNull InstructionCounterCodeColumnsWithMetadata counterColumn, @NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions) {
        @NonNull Rectangle bounds = this.getClientArea();
        this.toVirtual(bounds);
        int firstLine = this.getFirstVisibleLine();
        int lastLine = this.getLastVisibleLine(currentImageAndInstructions);
        int requestedCount = firstLine >= 0 && lastLine > firstLine ? lastLine - firstLine + 1 : 0;
        @NonNull Font font = (Font)NullChecking.neverNull((Object)Fonts.getSource());
        gc.setFont(font);
        @NonNull FontInfo fi = FontInfo.get(font);
        int textYOffset = (this.mLineHeight - fi.getHeight()) / 2;
        int y = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 1))).y;
        ISamplesReportDataForDisasmAndSourceAnnotations ads = currentImageAndInstructions.activeDataSet;
        long maxIndex = ads.maxInstructionIndex();
        long realFromIndex = Math.min((long)Math.max(firstLine, 0), maxIndex);
        long realCount = Math.min(Math.min(maxIndex, maxIndex - realFromIndex), (long)requestedCount);
        ISampleInstructionRowDataAccessorForColumn[] accessors = ads.getInstructionDataAccessorFor(counterColumn.column, realFromIndex, Math.toIntExact(realCount));
        if (accessors != null) {
            int i = 0;
            while (i < accessors.length) {
                gc.setBackground(Colors.getWhite());
                ISampleInstructionRowDataAccessorForColumn accessor = accessors[i];
                ISampleInstructionRowDataProperties rowProperties = accessor.getRowProperties();
                switch (rowProperties.getRowType()) {
                    case SYMBOL_LABEL: {
                        DisasmPanel.drawLines_Symbol(gc, bounds, y, textYOffset, this.mLineHeight, this.mColumnSizes, rowProperties.getSymbol());
                        break;
                    }
                    case DATA: 
                    case NONE: {
                        DisasmPanel.drawLines_Break(gc, bounds, y, textYOffset, this.mLineHeight, this.mColumnSizes, rowProperties.getSize());
                        break;
                    }
                    case ARM32: 
                    case ARM64: 
                    case THUMB: {
                        DisasmPanel.drawLines_Instruction(gc, bounds, currentImageAndInstructions.selection.selectedInstructions(), y, textYOffset, this.mLineHeight, this.mColumnSizes, this.mInlineImage, font, (long)i + realFromIndex, accessor);
                        break;
                    }
                    default: {
                        throw new AssertionError(rowProperties.getRowType());
                    }
                }
                if ((long)i + realFromIndex == (long)this.mLastSelection) {
                    gc.setForeground(Colors.getGray());
                    gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                    gc.drawLine(bounds.x, y + this.mLineHeight - 1, bounds.x + bounds.width, y + this.mLineHeight - 1);
                }
                y += this.mLineHeight;
                ++i;
            }
        }
    }

    private void drawMore(GC gc, @Nullable CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions) {
        if (currentImageAndInstructions != null && !currentImageAndInstructions.selection.selectedInstructions().isEmpty()) {
            int remaining = DisasmPanel.getCountOfSelectedIndexesBefore(currentImageAndInstructions, this.getFirstVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            remaining = DisasmPanel.getCountOfSelectedIndexesAfter(currentImageAndInstructions, this.getLastFullyVisibleLine(currentImageAndInstructions));
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    private void drawMore(GC gc, boolean up, int amt) {
        Rectangle clientArea = this.toVirtual(this.getClientAreaExcludingSliders());
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(CodeMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = clientArea.x + clientArea.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = clientArea.y + (up ? this.mHeaderLineHeight + 4 : clientArea.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    private int drawOneHeader(GC gc, String title, int x, int y, int col) {
        if (this.mColumnSizes[col] > 0) {
            Rectangle clipping = gc.getClipping();
            gc.setClipping(x, y, this.mColumnSizes[col], this.mLineHeight + 2);
            TextDrawing.drawString(gc, title, x, y, 16384);
            x += this.mColumnSizes[col] + 3;
            gc.setClipping(clipping);
        }
        return x;
    }

    private @Nullable Pair<@NonNull InstructionCounterCodeColumnsWithMetadata, @NonNull CodeTabSelectionModel.ActiveImageProperties> getCheckedActiveSelectionState() {
        InstructionCounterCodeColumnsWithMetadata currentColumnSelection = this.activeColumnSelection;
        CodeTabSelectionModel.ActiveImageProperties currentImageProperties = this.activeImageProperties;
        if (currentColumnSelection == null || currentImageProperties == null || currentColumnSelection.source != currentImageProperties.source) {
            return null;
        }
        return new Pair((Object)currentColumnSelection, (Object)currentImageProperties);
    }

    private int getLastFullyVisibleLine(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        long line = (bounds.height - (this.mHeaderLineHeight + 1)) / this.mLineHeight;
        if (line % (long)this.mLineHeight != 0L) {
            --line;
        }
        if ((line += (long)this.getFirstVisibleLine()) < 0L) {
            return -1;
        }
        return (int)Math.min(line, currentImageAndInstructions.activeDataSet.maxInstructionIndex() - 1L);
    }

    private int getLastVisibleLine(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions) {
        long result = Math.min((long)(this.getFirstVisibleLine() + this.getPageSize().y), currentImageAndInstructions.activeDataSet.maxInstructionIndex() - 1L);
        return (int)Math.min(result, Integer.MAX_VALUE);
    }

    private int getLineIndexAt(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions, int virtualY) {
        int top = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 1))).y;
        int line = (virtualY - top) / this.mLineHeight;
        if (line < 0) {
            return -1;
        }
        if ((long)(line += this.getFirstVisibleLine()) >= currentImageAndInstructions.activeDataSet.maxInstructionIndex()) {
            return -1;
        }
        return line;
    }

    private void refocus() {
        this.getHorizontalSlider().setIncrement(this.mCharWidth);
        this.adjustSliders();
        Slider slider = this.getVerticalSlider();
        int max = slider.getMaximum();
        int current = slider.getSelection();
        if (current > max) {
            slider.setSelection(max);
            this.wasScrolled();
            this.adjustSliders();
        }
        this.redraw();
    }

    private void scrollMoreDown() {
        int first;
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        int max = this.getPageSize().y;
        int last = first = currentImageAndInstructions != null ? currentImageAndInstructions.selection.selectedInstructions().nextSetBit(this.getLastFullyVisibleLine(currentImageAndInstructions)) : -1;
        int index = first;
        while (currentImageAndInstructions != null) {
            index = currentImageAndInstructions.selection.selectedInstructions().nextSetBit(index + 1);
            if (index == -1 || index - first > max) break;
            last = index;
        }
        this.showLine(last);
        this.showLine(first);
        this.mLastSelection = first;
    }

    private void scrollMoreUp() {
        int rangeEnd;
        int rangeStart;
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        int first = this.getFirstVisibleLine();
        int index = -1;
        TIntArrayList list = new TIntArrayList();
        while (currentImageAndInstructions != null) {
            index = currentImageAndInstructions.selection.selectedInstructions().nextSetBit(index + 1);
            if (index == -1 || index >= first) break;
            list.add(index);
        }
        int max = this.getPageSize().y;
        int last = list.size() - 1;
        first = rangeStart = (rangeEnd = list.get(last--));
        while (last >= 0) {
            if (rangeEnd - (first = list.get(last--)) > max) break;
            rangeStart = first;
        }
        this.showLine(rangeEnd);
        this.showLine(rangeStart);
        this.mLastSelection = rangeStart;
    }

    private void selectLine(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions, int line) {
        currentImageAndInstructions.selection.selectedInstructions().clear();
        this.mLastSelection = line;
        if (line >= 0) {
            ISampleInstructionRowDataProperties properties = currentImageAndInstructions.activeDataSet.getInstructionProperties((long)line);
            switch (properties.getRowType()) {
                case ARM32: 
                case ARM64: 
                case THUMB: {
                    currentImageAndInstructions.selection.selectedInstructions().set(Math.toIntExact(line));
                    SourceLocation location = properties.getOriginalSourceLocation();
                    if (location != null) {
                        Symbol symbol = properties.getSymbol();
                        ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionsRange = symbol.instructionRange;
                        if (instructionsRange != null && instructionsRange.count() > 0L) {
                            currentImageAndInstructions.activeDataSet.forEachInstruction(instructionsRange.fromIndex(), instructionsRange.count(), false, (index, rowDataAccessor) -> {
                                if (index > Integer.MAX_VALUE) {
                                    return false;
                                }
                                if (NullChecking.equalsNullable((Object)location, (Object)rowDataAccessor.getRowProperties().getOriginalSourceLocation())) {
                                    activeImageProperties.selection.selectedInstructions().set(Math.toIntExact(index));
                                }
                                return true;
                            });
                        }
                    }
                    this.mOwner.getSourcePanel().refreshInstructionSelection();
                    break;
                }
                case DATA: 
                case NONE: {
                    break;
                }
                case SYMBOL_LABEL: {
                    Symbol symbol = properties.getSymbol();
                    ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionsRange = symbol.instructionRange;
                    if (instructionsRange == null) break;
                    long max = Math.min(instructionsRange.count() + instructionsRange.fromIndex(), Integer.MAX_VALUE);
                    if (instructionsRange.fromIndex() >= max) break;
                    currentImageAndInstructions.selection.selectedInstructions().set(Math.toIntExact(instructionsRange.fromIndex()), Math.toIntExact(max));
                    this.mOwner.getSourcePanel().refreshInstructionSelection();
                    break;
                }
                default: {
                    throw new AssertionError(properties.getRowType());
                }
            }
        }
        this.redraw();
    }

    private void selectLineIf(@Nullable CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions, int line) {
        if (currentImageAndInstructions != null) {
            this.selectLine(currentImageAndInstructions, line);
        } else {
            this.mLastSelection = -1;
            this.redraw();
        }
    }

    private void setScrollPosition(int pos) {
        int max;
        if (pos < 0) {
            pos = 0;
        }
        if (pos > (max = this.getVerticalSlider().getMaximum())) {
            pos = max;
        }
        this.getVerticalSlider().setSelection(pos);
        this.wasScrolled();
        this.adjustSliders();
        this.redraw();
    }

    private int updateColumnSizes() {
        Pair<InstructionCounterCodeColumnsWithMetadata, CodeTabSelectionModel.ActiveImageProperties> currentSelectionState = this.getCheckedActiveSelectionState();
        InstructionCounterCodeColumnsWithMetadata currentCounter = currentSelectionState != null ? (InstructionCounterCodeColumnsWithMetadata)currentSelectionState.first : null;
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = currentSelectionState != null ? (CodeTabSelectionModel.ActiveImageProperties)currentSelectionState.second : null;
        @NonNull Analysis analysis = this.mOwner.getAnalysis();
        @NonNull String counterTitle = currentCounter != null ? currentCounter.getTitle() : "";
        IInstructionCounterSource source = currentCounter != null ? currentCounter.source : null;
        int largestFunctionName = source != null ? source.getLargestFunctionName().length() : 0;
        boolean has64BitAddresses = currentImageAndInstructions != null ? currentImageAndInstructions.selection.imageFile().is64bit : false;
        this.mColumnSizes[0] = DisasmPanel.getBestSize(counterTitle, PercentageCell.getMinimumContentWidth(Fonts.getSource(), false) + 50);
        this.mColumnSizes[1] = this.mInlineImage.getBounds().width;
        this.mColumnSizes[2] = DisasmPanel.getBestSize(CodeMessages.ADDRESS, has64BitAddresses ? NumberUtils.formatAddress((long)-1L) : NumberUtils.formatAddress((int)-1));
        this.mColumnSizes[3] = DisasmPanel.getBestSize(CodeMessages.OPCODE, NumberUtils.formatHex((int)-1, (int)8, (boolean)false));
        this.mColumnSizes[4] = DisasmPanel.getBestSize(CodeMessages.DISASM, Math.min(48, largestFunctionName + 50) * this.mCharWidth);
        this.mColumnSizes[5] = DisasmPanel.getBestSize(CodeMessages.DISASM, Math.min(120, largestFunctionName + 16) * this.mCharWidth);
        this.mColumnSizes[6] = DisasmPanel.getBestSize(CodeMessages.ORIGINAL_LOCATION, (analysis.getInstructionCounterModel().getLargestFileName().length() + 6) * this.mCharWidth);
        this.mColumnSizes[7] = DisasmPanel.getBestSize(CodeMessages.INLINE_LOCATION, (analysis.getInstructionCounterModel().getLargestFileName().length() + 6) * this.mCharWidth);
        return DisasmPanel.safeInstructionCount(currentImageAndInstructions);
    }

    private void updateSizes() {
        Font font = Fonts.getSource();
        this.mCharWidth = FontInfo.get(font).getMaxWidth();
        this.mLineHeight = Math.max(FontInfo.get(font).getHeight(), this.mInlineImage.getBounds().height) + 2;
        this.mHeaderLineHeight = FontInfo.get(Fonts.getNormal()).getHeight();
        this.updateColumnSizes();
        ConsolidatedUIExec.exec(this, null, this, false);
    }

    public boolean isActiveImage(@NonNull ImageFile newImage) {
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = this.activeImageProperties;
        if (currentImageAndInstructions == null) {
            return false;
        }
        return currentImageAndInstructions.selection.imageFile().equals(newImage);
    }

    public void clearSelectedLines() {
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = this.activeImageProperties;
        if (currentImageAndInstructions != null && !currentImageAndInstructions.selection.selectedInstructions().isEmpty()) {
            currentImageAndInstructions.selection.selectedInstructions().clear();
            this.mLastSelection = -1;
            this.redraw();
        }
    }

    public void updateSelectedLines(@NonNull BitSet newInstructionIndexes) {
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = this.activeImageProperties;
        if (currentImageAndInstructions != null) {
            currentImageAndInstructions.selection.selectedInstructions().clear();
            currentImageAndInstructions.selection.selectedInstructions().or(newInstructionIndexes);
            this.mLastSelection = newInstructionIndexes.nextSetBit(0);
            this.showLine(newInstructionIndexes.length());
            this.redraw();
        }
    }

    private static enum MouseState {
        MORE_DOWN,
        MORE_UP,
        NORMAL;

    }

    private record SelectInstructionsMenuAction(@NonNull CodeTabSelectionModel.ActiveImageProperties currentImageProperties, @NonNull CodeTabSelectionModel.ActiveSelection selection, @NonNull Symbol symbol, long address, long @Nullable [] instructionIndexes, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ISamplesReportDataForDisasmAndSourceAnnotations.InstructionRange instructionRange) {
    }
}

