/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnAccessorFactory;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnValueVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterDataSingleAccessor;
import com.arm.streamline.widget.outline.HistogramCell;
import com.arm.streamline.widget.outline.MpkiCell;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.outline.RatioCell;
import com.arm.streamline.widget.outline.TextCell;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;

public class CodeTabInstructionCounterColumn {
    public static void render(@NonNull ISampleCounterDataSingleAccessor view, final @NonNull GC gc, final @NonNull Font font, final int margin, final int x, final int y, final int width, final int height) {
        view.getColumnValue((ISampleCounterColumnValueVisitor)new ISampleCounterColumnValueVisitor<Void, Void, RuntimeException>(){

            public Void empty(Void data, @NonNull IColumnDescriptor columnDescriptor) throws RuntimeException {
                gc.setFont(font);
                return null;
            }

            public Void histogram(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IHistogramColumnDescriptor columnDescriptor, long limit, long @NonNull [] values) throws RuntimeException {
                HistogramCellDataProvider.BaseProvider<ISampleCounterColumnAccessorFactory.HistogramValue> dataProvider = new HistogramCellDataProvider.BaseProvider<ISampleCounterColumnAccessorFactory.HistogramValue>(columnDescriptor.getDatapoints(), columnDescriptor.shouldScaleRelativeToLimit(), columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB(), columnDescriptor.getTypicalBinCount(), columnDescriptor.getDescriptor().getUnits(), i -> i);
                HistogramCell.drawBarsAndText(dataProvider.scaleRelativeToLimit, gc, new Rectangle(x + margin, y, width - 2 * margin, height), maxBins -> dataProvider.getForPixelWidth(maxBins).get(new ISampleCounterColumnAccessorFactory.HistogramValue(values, limit)), false, true);
                gc.setFont(font);
                return null;
            }

            public Void number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor columnDescriptor, double value) throws RuntimeException {
                if (value >= 0.0) {
                    switch (columnDescriptor.getFormat()) {
                        case number: {
                            TextCell.drawTextCellSimple(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), NumberUtils.format((double)value, (int)3, (boolean)true), false, true);
                            break;
                        }
                        case mpki: {
                            MpkiCell.drawScale(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), value, false, false, true, columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB());
                            break;
                        }
                        case percent: {
                            PercentageCell.drawPercentage(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), value, false, false, true, columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB());
                            break;
                        }
                    }
                }
                gc.setFont(font);
                return null;
            }

            public Void number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor columnDescriptor, long value) throws RuntimeException {
                if (value >= 0L) {
                    switch (columnDescriptor.getFormat()) {
                        case number: {
                            TextCell.drawTextCellSimple(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), NumberUtils.format((long)value), false, true);
                            break;
                        }
                        case mpki: {
                            MpkiCell.drawScale(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), value, false, false, true, columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB());
                            break;
                        }
                        case percent: {
                            PercentageCell.drawPercentage(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), (double)value, false, false, true, columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB());
                            break;
                        }
                    }
                }
                gc.setFont(font);
                return null;
            }

            public Void percentAndNumber(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IPercentAndValueColumnDescriptor columnDescriptor, long value, double percent) throws RuntimeException {
                if (value >= 0L && percent >= 0.0) {
                    PercentageCell.drawValueAndPercentage(gc, font, new Rectangle(x + margin, y, width - 2 * margin, height), value, percent, false, false, true, columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getUserDefinedRGB());
                }
                gc.setFont(font);
                return null;
            }

            public Void ratio(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IRatioColumnDescriptor columnDescriptor, long @NonNull [] values) throws RuntimeException {
                RatioCell.drawBarsAndText(gc, new Rectangle(x + margin, y, width - 2 * margin, height), columnDescriptor.getDescriptor().getColourPreference(), columnDescriptor.getItems(), values, false, true);
                gc.setFont(font);
                return null;
            }
        }, null);
    }
}

