/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.concurrent.NamingThreadFactory;
import com.arm.databinding.ObservableLastSelectionFromListMapValue;
import com.arm.databinding.swt.TypedLabelProviderAdapter;
import com.arm.streamline.application.IVetoablePageChangeListener;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.ProcessingDialog;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeSummary;
import com.arm.streamline.editortabs.code.CodeTabSelectionModel;
import com.arm.streamline.editortabs.code.DisasmPanel;
import com.arm.streamline.editortabs.code.PathPrefixSubstitutionAction;
import com.arm.streamline.editortabs.code.RecentFunctionsAction;
import com.arm.streamline.editortabs.code.SourcePanel;
import com.arm.streamline.editortabs.code.ViewLayoutAction;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.IBasicSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.IExtractable;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnValueVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleSourceLineDataAccessor;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.common.IProgressMonitor;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.reportmodel.icounters.FunctionRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterModel;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IReAnalysisProgressListener;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.streamline.model.iterable.ExtractableSelectionIterator;
import com.arm.streamline.model.iterable.SelectionIterator;
import com.arm.streamline.model.iterable.SourceLineReferenceSelectionIterator;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.Splitter;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public class CodeTab
extends EditorTab
implements ICommandTarget,
ISelectionProvider,
ISelectionChangedListener {
    private @Nullable CodeTabSelectionModel codeTabSelectionModel;
    private final @NonNull ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory("CodeTabDataLoader"));
    private DisasmPanel mDisasmPanel;
    private boolean mFirstInitialFocus;
    private RecentFunctionsAction mRecentFunctionsAction;
    private Set<ISelectionChangedListener> mSelectionListeners;
    private boolean mShowDisassembly;
    private SourcePanel mSourcePanel;
    private Splitter mSplitter;
    private CodeSummary mSummary;
    private ToolbarReadout mTotalsField;
    private ViewLayoutAction mViewLayoutAction;

    private static @NonNull String calculateCodeTabSelectionText(@NonNull InstructionCounterCodeColumnsWithMetadata activeCounter, @NonNull Stream<@NonNull ISampleSourceLineDataAccessor> selectionStream) {
        double count = selectionStream.mapToDouble(a -> (Double)a.getColumnValueFor(instructionCounterCodeColumnsWithMetadata.column, (ISampleCounterColumnValueVisitor)new ISampleCounterColumnValueVisitor<Void, Double, RuntimeException>(){

            public @NonNull Double empty(Void data, @NonNull IColumnDescriptor columnDescriptor) throws RuntimeException {
                return 0.0;
            }

            public @NonNull Double number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor columnDescriptor, double value) throws RuntimeException {
                return value;
            }

            public @NonNull Double number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor columnDescriptor, long value) throws RuntimeException {
                return value;
            }

            public @NonNull Double percentAndNumber(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IPercentAndValueColumnDescriptor columnDescriptor, long value, double percent) throws RuntimeException {
                return value;
            }

            public @NonNull Double ratio(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IRatioColumnDescriptor columnDescriptor, long @NonNull [] values) throws RuntimeException {
                return 0.0;
            }

            public @NonNull Double histogram(Void data, // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IColumnDescriptor.IHistogramColumnDescriptor columnDescriptor, long limit, long @NonNull [] values) throws RuntimeException {
                return 0.0;
            }
        }, null)).sum();
        if (count <= 0.0) {
            return CodeMessages.NA;
        }
        return NumberUtils.format((double)count, (int)0, (boolean)true);
    }

    private static @Nullable CodeTabSelectionModel.SelectionRequest computeSelectionProperties(@Nullable ISelection selection) {
        if (selection == null) {
            return null;
        }
        final HashSet viableSourceReferences = new HashSet();
        final HashSet viableFunctionReferences = new HashSet();
        for (IExtractable extractable : SelectionIterator.toSet(new ExtractableSelectionIterator(selection))) {
            extractable.accept((IExtractable.IExtractableVisitor)new IExtractable.IExtractableVisitor<Void, RuntimeException>(){

                public Void visit(@NonNull IBasicSourceReference value) throws RuntimeException {
                    return null;
                }

                public Void visit(@NonNull CallPathNode value) throws RuntimeException {
                    ReferencedSymbol symbol = value.symbol;
                    if (symbol != null) {
                        viableFunctionReferences.add(symbol.symbol);
                    }
                    return null;
                }

                public Void visit(@NonNull Symbol value) throws RuntimeException {
                    viableFunctionReferences.add(value);
                    return null;
                }

                public Void visit(@NonNull ReferencedSymbol value) throws RuntimeException {
                    viableFunctionReferences.add(value.symbol);
                    return null;
                }

                public Void visit(@NonNull ReferencedSymbol value, @NonNull Collection<@NonNull CallPathNode> associatedPaths) throws RuntimeException {
                    viableFunctionReferences.add(value.symbol);
                    return null;
                }

                public Void visit(@NonNull SourceFile value) throws RuntimeException {
                    return null;
                }

                public Void visit(@NonNull ISourceLineReference value) throws RuntimeException {
                    viableSourceReferences.add(value);
                    return null;
                }

                public Void visit(@NonNull IUniqueThreadID value) throws RuntimeException {
                    return null;
                }

                public Void visit(@NonNull IUniqueProcessID value) throws RuntimeException {
                    return null;
                }
            });
        }
        HashSet<Symbol> selectedSymbols = new HashSet<Symbol>();
        BitSet selectedLineNos = new BitSet();
        ImageFile selectedImage = null;
        SourceFile selectedSourceFile = null;
        ReferencedSymbol selectedReferencedSymbol = null;
        for (Symbol symbol : viableFunctionReferences) {
            ReferencedSymbol referencedSymbol;
            if (symbol.instructionRange == null) continue;
            if (selectedImage == null) {
                selectedImage = symbol.image;
                selectedSymbols.add(symbol);
            } else if (selectedImage.equals(symbol.image)) {
                selectedSymbols.add(symbol);
            }
            SourceLocation sourceLocation = symbol.sourceLocation;
            if (sourceLocation != null && sourceLocation.lineNo > 0) {
                if (selectedSourceFile == null) {
                    selectedSourceFile = sourceLocation.sourceFile;
                    selectedLineNos.set(sourceLocation.lineNo);
                } else if (selectedSourceFile.equals(sourceLocation.sourceFile)) {
                    selectedLineNos.set(sourceLocation.lineNo);
                }
            }
            if ((referencedSymbol = symbol.referencedSymbol) == null) continue;
            selectedReferencedSymbol = (ReferencedSymbol)NullChecking.neverNullOr(selectedReferencedSymbol, (Object)referencedSymbol);
        }
        for (ISourceLineReference sourceLocation : viableSourceReferences) {
            ReferencedSymbol associatedSymbol = sourceLocation.getAssociatedFunction();
            Symbol symbol = associatedSymbol.symbol;
            if (symbol.instructionRange == null) continue;
            if (selectedImage == null) {
                selectedImage = symbol.image;
            } else {
                selectedImage.equals(symbol.image);
            }
            if (sourceLocation.getStartLine() <= 0) continue;
            if (selectedSourceFile == null) {
                selectedSourceFile = sourceLocation.getSourceFile();
                selectedLineNos.set(sourceLocation.getStartLine());
                if (selectedReferencedSymbol != null) continue;
                selectedReferencedSymbol = associatedSymbol;
                continue;
            }
            if (!selectedSourceFile.equals(sourceLocation.getSourceFile())) continue;
            selectedLineNos.set(sourceLocation.getStartLine());
        }
        if (selectedImage == null) {
            return null;
        }
        if (!selectedSymbols.isEmpty()) {
            if (selectedLineNos.isEmpty()) {
                return new CodeTabSelectionModel.SelectionRequest(selectedImage, selectedSymbols, selectedSourceFile, selectedReferencedSymbol);
            }
            if (selectedSourceFile != null) {
                return new CodeTabSelectionModel.SelectionRequest(selectedImage, selectedSymbols, selectedSourceFile, selectedLineNos, selectedReferencedSymbol);
            }
        }
        if (selectedSourceFile != null && !selectedLineNos.isEmpty()) {
            return new CodeTabSelectionModel.SelectionRequest(selectedImage, selectedSourceFile, selectedLineNos, selectedReferencedSymbol);
        }
        return null;
    }

    public CodeTab(@NonNull AnalysisEditor editor) {
        super(editor);
        this.init();
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mSelectionListeners == null) {
            this.mSelectionListeners = new HashSet<ISelectionChangedListener>();
        }
        this.mSelectionListeners.add(listener);
    }

    @Override
    public void dispose() {
        CodeTabSelectionModel codeTabSelectionModel = this.codeTabSelectionModel;
        if (codeTabSelectionModel != null) {
            codeTabSelectionModel.dispose();
            this.codeTabSelectionModel = null;
        }
        super.dispose();
    }

    public DisasmPanel getDisassemblyPanel() {
        return this.mDisasmPanel;
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.mSourcePanel.getSelectedSourceLines());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this;
    }

    public SourcePanel getSourcePanel() {
        return this.mSourcePanel;
    }

    public Splitter getSplitter() {
        return this.mSplitter;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mSummary.handleCommand(command) && command.equals(ActionFactory.SELECT_ALL.getId())) {
            this.mSourcePanel.selectAll();
        }
    }

    @Override
    public void recomputeFromModel() {
        CodeTabSelectionModel codeTabSelectionModel = this.codeTabSelectionModel;
        if (codeTabSelectionModel != null) {
            codeTabSelectionModel.recomputeFromModel();
        }
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SourcePanel sourcePanel = CodeTab.this.getSourcePanel();
                if (!sourcePanel.isDisposed()) {
                    CodeTab.this.updateSummary(new SelectionChangedEvent((ISelectionProvider)CodeTab.this, (ISelection)new StructuredSelection(sourcePanel.getSelectedSourceLines())));
                }
            }
        });
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mSelectionListeners != null) {
            this.mSelectionListeners.remove(listener);
            if (this.mSelectionListeners.isEmpty()) {
                this.mSelectionListeners = null;
            }
        }
    }

    public void select(ReferencedSymbol ... functions) {
        Task.callOnUIThread((Runnable)new ShowFunction(functions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> list = null;
        CodeTab codeTab = this;
        synchronized (codeTab) {
            if (this.mSelectionListeners != null) {
                list = new ArrayList<ISelectionChangedListener>(this.mSelectionListeners);
            }
        }
        if (list != null) {
            for (ISelectionChangedListener listener : list) {
                listener.selectionChanged(event);
            }
        }
        this.updateSummary(event);
    }

    public boolean setFocus() {
        IInstructionCounterModel instructionCounterModel;
        boolean result = this.mSourcePanel.setFocus();
        if (this.mFirstInitialFocus && (instructionCounterModel = this.getAnalysis().getInstructionCounterModel()).getInstructionCounterSources().size() > 0) {
            IInstructionCounterSource defaultSource = instructionCounterModel.getDefaultSource();
            List symbols = defaultSource.getSymbols();
            if (symbols.isEmpty()) {
                return result;
            }
            FunctionRowValue firstSymbol = (FunctionRowValue)defaultSource.getSymbols().get(0);
            this.setSelection((ISelection)new StructuredSelection((Object)firstSymbol));
            this.mFirstInitialFocus = false;
        }
        return result;
    }

    public void setSelection(ISelection selection) {
        CodeTabSelectionModel.SelectionRequest imageAndInstructions = CodeTab.computeSelectionProperties(selection);
        this.updateSelectedImageAndInstructions(imageAndInstructions);
    }

    public boolean setShowDisassembly(boolean show) {
        if (this.mShowDisassembly != show) {
            this.mShowDisassembly = show;
            this.mSplitter.setMaximizedControl((Control)(this.mShowDisassembly ? null : this.mSourcePanel));
            this.mViewLayoutAction.adjustToCurrentState();
            if (show) {
                this.mDisasmPanel.refreshSelection();
            }
            return true;
        }
        return false;
    }

    public boolean showDisassembly() {
        return this.mShowDisassembly;
    }

    @Override
    public void sourceFilePathChanged() {
        this.mSourcePanel.sourceFilePathChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void widgetDisposed(DisposeEvent event) {
        CodeTab codeTab = this;
        synchronized (codeTab) {
            this.mSelectionListeners = null;
        }
        super.widgetDisposed(event);
    }

    @Override
    protected Composite createContent() {
        Splitter splitter;
        CodeTabSelectionModel codeTabSelectionModel;
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.requireEditor().requireInstructionCountersViewModel();
        this.codeTabSelectionModel = codeTabSelectionModel = new CodeTabSelectionModel(instructionCountersViewModel, this::enqueueLoadDataTask, (counter, imageProperties) -> Task.callOnUIThread(() -> {
            DisasmPanel mDisasmPanel = this.mDisasmPanel;
            SourcePanel mSourcePanel = this.mSourcePanel;
            CodeSummary mSummary = this.mSummary;
            if (mDisasmPanel != null && !mDisasmPanel.isDisposed()) {
                mDisasmPanel.activeStateChanged((InstructionCounterCodeColumnsWithMetadata)counter, (CodeTabSelectionModel.ActiveImageProperties)imageProperties);
            }
            if (mSourcePanel != null && !mSourcePanel.isDisposed()) {
                mSourcePanel.activeStateChanged((InstructionCounterCodeColumnsWithMetadata)counter, (CodeTabSelectionModel.ActiveImageProperties)imageProperties);
            }
            if (mSummary != null) {
                mSummary.activeStateChanged((InstructionCounterCodeColumnsWithMetadata)counter, (CodeTabSelectionModel.ActiveImageProperties)imageProperties);
            }
        }));
        this.mFirstInitialFocus = true;
        this.mSplitter = splitter = new Splitter(this, true);
        this.mSourcePanel = new SourcePanel((Composite)splitter, this);
        this.mDisasmPanel = new DisasmPanel((Composite)splitter, this);
        this.mSplitter.setMaximizedControl((Control)this.mSourcePanel);
        return this.mSplitter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        Analysis analysis = this.getAnalysis();
        CodeTabSelectionModel codeTabSelectionModel = (CodeTabSelectionModel)NullChecking.neverNull((Object)this.codeTabSelectionModel);
        @NonNull InstructionCountersViewModel instructionCountersViewModel = codeTabSelectionModel.getInstructionCounterViewModel();
        this.mViewLayoutAction = new ViewLayoutAction(this);
        this.mRecentFunctionsAction = new RecentFunctionsAction(this);
        toolbar.addAction(this.mViewLayoutAction);
        toolbar.addAction(this.mRecentFunctionsAction);
        toolbar.addAction(new OpenSourceFileAction(analysis::computeFullPath, this, analysis::showPathSubstitutionDialog));
        toolbar.addAction(new PathPrefixSubstitutionAction(this.getAnalysis())).setLayoutData(new CustomToolbar.LayoutData().setGap(5));
        @NonNull Combo sourceComboBox = InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        @NonNull Combo counterComboBox = new Combo((Composite)toolbar, 8);
        counterComboBox.setLayoutData((Object)new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        ObservableLastSelectionFromListMapValue<IInstructionCounterSource, InstructionCounterCodeColumnsWithMetadata> selectedCounterProperty = codeTabSelectionModel.getSelectedCounterProperty();
        @NonNull @NonNull IObservableList currentInstructionCounters = selectedCounterProperty.propertyCurrentValues();
        @NonNull ComboViewer comboViewer = new ComboViewer(counterComboBox);
        comboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new TypedLabelProviderAdapter(item -> {
            if (item.depth > 0) {
                String indent = "  ".repeat(item.depth);
                return String.format("%s%s", indent, item.getTitle());
            }
            return item.getTitle();
        }));
        comboViewer.setInput((Object)currentInstructionCounters);
        this.ctx.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)counterComboBox), (IObservableValue)WidgetProperties.visible().observe((Widget)sourceComboBox));
        this.ctx.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)counterComboBox), ComputedValue.create(() -> !currentInstructionCounters.isEmpty()));
        @NonNull @Nullable IViewerObservableValue selectionValue = ViewerProperties.singleSelection(InstructionCounterCodeColumnsWithMetadata.class).observe((Viewer)comboViewer);
        @Nullable InstructionCounterCodeColumnsWithMetadata initialSelection = (InstructionCounterCodeColumnsWithMetadata)selectedCounterProperty.getValue();
        this.ctx.bindValue((IObservableValue)selectionValue, selectedCounterProperty);
        selectionValue.setValue((Object)initialSelection);
        this.mSummary = new CodeSummary(this);
        this.mTotalsField = new ToolbarReadout(toolbar, CodeMessages.NA, 131072, CodeMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("0000000000000000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(2));
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.codeview";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        this.addCommandAction(map, ActionFactory.FIND);
        this.addCommandAction(map, ActionFactory.SELECT_ALL);
    }

    private void addCommandAction(Map<String, IAction> map, ActionFactory factory) {
        String id = factory.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    private void enqueueLoadDataTask(@NonNull Function<@NonNull IProgressMonitorFactory, @Nullable CodeTabSelectionModel.IComputeActiveDataSetTask> taskSupplier) {
        Task.callOnUIThread(() -> {
            TaskProgressMonitorFactory progressMonitorFactoryAndCallbacks = new TaskProgressMonitorFactory();
            CodeTabSelectionModel.IComputeActiveDataSetTask task = (CodeTabSelectionModel.IComputeActiveDataSetTask)taskSupplier.apply(progressMonitorFactoryAndCallbacks);
            if (task == null) {
                return;
            }
            progressMonitorFactoryAndCallbacks.task = task;
            ProcessingDialog dialog = new ProcessingDialog(progressMonitorFactoryAndCallbacks);
            this.executor.execute(() -> {
                AnalysisEditor editor = this.getEditor();
                if (editor == null) {
                    task.cancel();
                    return;
                }
                AtomicBoolean dialogShown = new AtomicBoolean(false);
                IVetoablePageChangeListener tabChangeListener = (from, to) -> {
                    if (to == EditorTabID.CODE && !dialogShown.getAndSet(true)) {
                        Task.blockingCallOnUIThread(() -> {
                            dialog.setBlockOnOpen(false);
                            dialog.create();
                            dialog.open();
                        });
                    }
                    return true;
                };
                editor.addVetoablePageChangeListener(tabChangeListener);
                try {
                    Task.blockingCallOnUIThread(() -> {
                        if (editor.getCurrentActiveEditorTab() == EditorTabID.CODE && !dialogShown.getAndSet(true)) {
                            dialog.setBlockOnOpen(false);
                            dialog.create();
                            dialog.open();
                        }
                    });
                    task.run();
                }
                finally {
                    editor.removeVetoablePageChangeListener(tabChangeListener);
                    dialog.reAnalysisFinished();
                }
            });
        });
    }

    private void updateSelectedImageAndInstructions(@Nullable CodeTabSelectionModel.SelectionRequest selection) {
        CodeTabSelectionModel codeTabSelectionModel = this.codeTabSelectionModel;
        if (codeTabSelectionModel != null) {
            codeTabSelectionModel.setSelectionRequest(selection);
        }
    }

    RecentFunctionsAction getRecentFunctionsAction() {
        return this.mRecentFunctionsAction;
    }

    boolean isStillInInitialFocus() {
        return this.mFirstInitialFocus;
    }

    void updateSummary(SelectionChangedEvent event) {
        String text = CodeMessages.NA;
        CodeTabSelectionModel codeTabSelectionModel = this.codeTabSelectionModel;
        if (codeTabSelectionModel != null) {
            InstructionCounterCodeColumnsWithMetadata activeCounter = (InstructionCounterCodeColumnsWithMetadata)codeTabSelectionModel.getSelectedCounterProperty().getValue();
            CodeTabSelectionModel.ActiveImageProperties activeImageProperties = codeTabSelectionModel.getSelectedActiveImageProperties();
            if (activeCounter != null && activeImageProperties != null && activeCounter.source == activeImageProperties.source) {
                ISamplesReportDataForDisasmAndSourceAnnotations data = activeImageProperties.activeDataSet;
                @NonNull ArrayList<E> references = new ArrayList();
                new SourceLineReferenceSelectionIterator(event.getSelection()).forEach(references::add);
                text = CodeTab.calculateCodeTabSelectionText(activeCounter, StreamUtils.filterOutNull(references.stream().map(srcRef -> data.getSourceLocationDataAccessorFor(srcRef.getSourceFile().uid, srcRef.getStartLine(), 1)).flatMap(a -> a != null ? Arrays.stream(a) : Stream.of(new ISampleSourceLineDataAccessor[0]))));
            }
        }
        if (this.mTotalsField.setText(text)) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    private class ShowFunction
    implements Runnable {
        private ReferencedSymbol[] mFunctions;

        public ShowFunction(ReferencedSymbol ... functions) {
            this.mFunctions = functions;
        }

        @Override
        public void run() {
            CodeTab.this.setSelection((ISelection)new StructuredSelection((Object[])this.mFunctions));
        }
    }

    private static class TaskProgressMonitorFactory
    implements IProgressMonitorFactory,
    ProcessingDialog.IProcessingDialogCallbacks {
        private @Nullable IReAnalysisProgressListener listener;
        private @Nullable CodeTabSelectionModel.IComputeActiveDataSetTask task;

        private TaskProgressMonitorFactory() {
        }

        @Override
        public void close(@NonNull IReAnalysisProgressListener listener, boolean cancelled) {
            assert (this.listener == listener || this.listener == null);
            CodeTabSelectionModel.IComputeActiveDataSetTask task = (CodeTabSelectionModel.IComputeActiveDataSetTask)NullChecking.neverNull((Object)this.task);
            if (cancelled) {
                task.cancel();
            }
        }

        public @NonNull IProgressMonitor create(final @NonNull String label) {
            return new IProgressMonitor(){
                private int percent;
                private @Nullable String subLabel;

                public void done() {
                }

                public void updateLabel(@NonNull String subLabel) {
                    this.subLabel = subLabel;
                    this.updateRecomputeProgressListeners(label, subLabel, this.percent);
                }

                public void updatePercent(int percent) {
                    this.percent = percent;
                    this.updateRecomputeProgressListeners(label, this.subLabel, percent);
                }

                public void warning(@NonNull String warning) {
                }
            };
        }

        @Override
        public void setProgressListener(@NonNull IReAnalysisProgressListener listener) {
            assert (this.listener == null);
            this.listener = listener;
        }

        private void updateRecomputeProgressListeners(@NonNull String title, @Nullable String subTitle, int percent) {
            IReAnalysisProgressListener listener = this.listener;
            if (listener != null) {
                listener.progress(title, subTitle, percent);
            }
        }
    }
}

