/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.CodeTabSelectionModel;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISourceLineReference;
import com.arm.streamline.jni.apcdbgen.proto.ReferencedSymbol;
import com.arm.streamline.jni.apcdbgen.proto.SimpleSourceReference;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.TextField;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicNumberUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.actions.ActionFactory;

public class CodeSummary
implements KeyListener {
    private CodeTab mOwner;
    private TextField mFind;
    private ToolbarReadout mResults;
    private long mLastAddress = -1L;
    private long @Nullable [] mDisasmIndexes;
    private String mLastFunctionPrefix = "";
    private List<ReferencedSymbol> mFunctions = new ArrayList<ReferencedSymbol>();
    private int mJumpPos;
    private ISourceLineReference mJumpToSrcRef;
    private String mSrcRefDesc;
    private  @Nullable CodeTabSelectionModel.ActiveImageProperties activeImageProperties;
    private @Nullable Long showInstructionIndex;

    private static String getSuffix(int chosen) {
        if (chosen > 10 && chosen < 20) {
            chosen = 4;
        }
        switch (chosen % 10) {
            case 1: {
                return CodeMessages.FIRST;
            }
            case 2: {
                return CodeMessages.SECOND;
            }
            case 3: {
                return CodeMessages.THIRD;
            }
        }
        return CodeMessages.REST;
    }

    public CodeSummary(CodeTab owner) {
        this.mOwner = owner;
        CustomToolbar toolbar = this.mOwner.getToolbar();
        this.mFind = new TextField(toolbar);
        this.mFind.setWatermark(CodeMessages.FIND);
        this.mFind.setToolTipText(CodeMessages.FIND_TOOLTIP);
        this.mFind.addKeyListener(this);
        this.mFind.addFieldModifiedListener(field -> this.adjustFind(false));
        this.mFind.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setPreferredWidth(100).setGap(3));
        this.mResults = new ToolbarReadout(toolbar, "", 16384, CodeMessages.SUMMARY_RESULTS_TOOLTIP);
        this.mResults.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(50).setPreferredWidth(100).setGap(5));
    }

    public boolean handleCommand(String command) {
        if (command.equals(ActionFactory.SELECT_ALL.getId())) {
            if (this.mFind.isFocused()) {
                this.mFind.selectAll();
                return true;
            }
        } else if (command.equals(ActionFactory.FIND.getId())) {
            this.mFind.setFocus();
        }
        return false;
    }

    public void keyPressed(KeyEvent event) {
        char ch;
        if (event.doit && ((ch = event.character) == '\n' || ch == '\r')) {
            ISourceLineReference mJumpToSrcRef;
            Long showInstructionIndex = this.showInstructionIndex;
            if (showInstructionIndex != null) {
                this.mOwner.getDisassemblyPanel().showLine(showInstructionIndex.intValue(), true);
            }
            if ((mJumpToSrcRef = this.mJumpToSrcRef) != null) {
                this.mOwner.setSelection((ISelection)new StructuredSelection(List.of(mJumpToSrcRef)));
            }
            this.adjustFind(true);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void activeStateChanged(@Nullable InstructionCounterCodeColumnsWithMetadata newCounter,  @Nullable CodeTabSelectionModel.ActiveImageProperties newImageProperties) {
        boolean changed = !NullChecking.equalsNullable((Object)newImageProperties, (Object)this.activeImageProperties);
        this.activeImageProperties = newImageProperties;
        if (changed) {
            this.adjustFind(false);
        }
    }

    private void adjustFind(boolean advance) {
        CodeTabSelectionModel.ActiveImageProperties currentImageAndInstructions = this.activeImageProperties;
        if (currentImageAndInstructions == null) {
            this.mResults.setText("");
            return;
        }
        String text = this.mFind.getText();
        int chosen = 1;
        int count = 0;
        this.mJumpToSrcRef = null;
        this.showInstructionIndex = null;
        if (!text.isBlank()) {
            if (advance) {
                ++this.mJumpPos;
            }
            if (text.startsWith("0x")) {
                long[] mDisasmIndexes = this.mDisasmIndexes;
                long value = BasicNumberUtils.getNonLocalizedHexLong((String)text, (long)-1L);
                if (value != this.mLastAddress) {
                    this.mLastAddress = value;
                    this.mJumpPos = 0;
                    this.mDisasmIndexes = mDisasmIndexes = currentImageAndInstructions.activeDataSet.getInstructionIndexesForAddress(value);
                } else if (mDisasmIndexes == null || this.mJumpPos >= mDisasmIndexes.length) {
                    this.mJumpPos = 0;
                }
                if (mDisasmIndexes != null && mDisasmIndexes.length > 0) {
                    ISampleInstructionRowDataProperties properties = currentImageAndInstructions.activeDataSet.getInstructionProperties(mDisasmIndexes[this.mJumpPos]);
                    ISourceLineReference ref = CodeSummary.createOriginalSourceReference(properties);
                    if (ref == null) {
                        ref = CodeSummary.createInlinedSourceReference(properties);
                    }
                    this.mJumpToSrcRef = ref;
                    this.mSrcRefDesc = CodeSummary.getFunctionAddressDescription(properties);
                    this.showInstructionIndex = mDisasmIndexes[this.mJumpPos];
                    count = mDisasmIndexes.length;
                    chosen = this.mJumpPos + 1;
                }
            } else {
                if (!this.mLastFunctionPrefix.equals(text)) {
                    Predicate<String> patternPredicate;
                    this.mLastFunctionPrefix = text;
                    this.mJumpPos = 0;
                    this.mFunctions.clear();
                    try {
                        Pattern pattern = Pattern.compile(text);
                        patternPredicate = pattern.asPredicate();
                    }
                    catch (PatternSyntaxException e) {
                        patternPredicate = s -> true;
                    }
                    for (Symbol function : currentImageAndInstructions.selection.imageFile().symbols) {
                        String name;
                        ISourceLineReference ref = function.asSourceLineReference();
                        if (ref == null || !(name = function.getName()).contains(text) && !patternPredicate.test(name)) continue;
                        this.mFunctions.add(ref.getAssociatedFunction());
                    }
                } else if (this.mJumpPos >= this.mFunctions.size()) {
                    this.mJumpPos = 0;
                }
                if (!this.mFunctions.isEmpty()) {
                    ReferencedSymbol symbol = this.mFunctions.get(this.mJumpPos);
                    this.mJumpToSrcRef = (ISourceLineReference)NullChecking.neverNull((Object)symbol.asSourceLineReference());
                    this.mSrcRefDesc = symbol.symbol.getName();
                    count = this.mFunctions.size();
                    chosen = this.mJumpPos + 1;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (this.mJumpToSrcRef != null) {
            builder.append(this.mSrcRefDesc);
            if (count > 1) {
                builder.append(MessageFormat.format(CodeMessages.MATCHES, chosen, CodeSummary.getSuffix(chosen), count));
            }
        }
        this.mResults.setText(builder.toString());
    }

    private static @Nullable String getFunctionAddressDescription(@NonNull ISampleInstructionRowDataProperties properties) {
        @NonNull StringBuilder builder = new StringBuilder();
        builder.append(properties.getSymbol().getName());
        long delta = properties.getAddress() - properties.getSymbol().address;
        if (delta != 0L) {
            builder.append(" + 0x");
            builder.append(Long.toHexString(delta));
        }
        return builder.toString();
    }

    private static @Nullable ISourceLineReference createInlinedSourceReference(@NonNull ISampleInstructionRowDataProperties properties) {
        ReferencedSymbol symbol = properties.getSymbol().referencedSymbol;
        SourceLocation location = properties.getInlinedSourceLocation();
        return CodeSummary.asSourceLineReference(symbol, location);
    }

    private static @Nullable ISourceLineReference createOriginalSourceReference(@NonNull ISampleInstructionRowDataProperties properties) {
        ReferencedSymbol symbol = properties.getSymbol().referencedSymbol;
        SourceLocation location = properties.getOriginalSourceLocation();
        return CodeSummary.asSourceLineReference(symbol, location);
    }

    private static @Nullable ISourceLineReference asSourceLineReference(@Nullable ReferencedSymbol symbol, @Nullable SourceLocation location) {
        if (location == null || symbol == null) {
            return null;
        }
        return new SimpleSourceReference(symbol, location.sourceFile, location.lineNo);
    }
}

