/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.OpenSourceContextMenuContributor;
import com.arm.streamline.editortabs.SelectInContributor;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineContributor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Control;

public class StreamlineContextMenu {
    public static final ContextMenu createStdContextMenu(final AnalysisEditor editor, Control clickTarget, Control handlerTarget, EditorTabID ... exclude) {
        ContextMenu cm = new ContextMenu(clickTarget, handlerTarget);
        if (clickTarget instanceof Outline) {
            cm.add(new OutlineContributor());
        }
        cm.add(new SelectInContributor(editor, exclude));
        cm.add(new OpenSourceContextMenuContributor(new Function<SourceFile, String>(){

            @Override
            public @NonNull String apply(@NonNull SourceFile sf) {
                @Nullable Analysis analysis = editor.getAnalysis();
                if (analysis != null) {
                    return analysis.computeFullPath(sf);
                }
                return sf.filePath;
            }
        }, new Runnable(){

            @Override
            public void run() {
                @Nullable Analysis analysis = editor.getAnalysis();
                if (analysis != null) {
                    analysis.showPathSubstitutionDialog();
                }
            }
        }));
        return cm;
    }

    public static final ContextMenu createStdContextMenu(AnalysisEditor editor, Control target, EditorTabID ... exclude) {
        return StreamlineContextMenu.createStdContextMenu(editor, target, target, exclude);
    }
}

