/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.jni.apcdbgen.proto.SourceFile;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.MenuItem;

public class OpenSourceContextMenuContributor
implements IContextMenuContributor {
    private @Nullable OpenSourceFileAction mAction;
    private final @NonNull Runnable showPathSubstitutionDialogRunner;
    private final @NonNull Function<@NonNull SourceFile, @NonNull String> sourcePathMapper;

    public OpenSourceContextMenuContributor(@NonNull Function<@NonNull SourceFile, @NonNull String> sourcePathMapper, @NonNull Runnable showPathSubstitutionDialogRunner) {
        this.sourcePathMapper = sourcePathMapper;
        this.showPathSubstitutionDialogRunner = showPathSubstitutionDialogRunner;
    }

    @Override
    public void cleanup(ContextMenu cm) {
        this.mAction = null;
    }

    @Override
    public int getPriority() {
        return 2000;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        @Nullable OpenSourceFileAction action = this.mAction;
        assert (action != null);
        action.run();
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        OpenSourceFileAction action = new OpenSourceFileAction(this.sourcePathMapper, cm, this.showPathSubstitutionDialogRunner);
        if (action.isEnabled()) {
            cm.createConditionalSeparator();
            String title = action.getText();
            cm.createMenuItem((IContextMenuContributor)this, title, StreamlinePlugin.getImage("SourceFile.gif"), title, true);
            this.mAction = action;
        }
    }
}

