/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MonitorWrapper {
    private static final NumberFormat counterFormatter = NumberFormat.getIntegerInstance();
    private @Nullable String cntrLabel;
    private long lastCounterValue;
    private long lastUpdatedCounterTime;
    private final @NonNull IProgressMonitor monitor;
    private final int multiplier;
    private @Nullable String subtaskName;
    private final @NonNull AtomicInteger subTaskNo = new AtomicInteger(-1);
    private final int taskCount;
    private final @NonNull AtomicInteger workPosition = new AtomicInteger(0);

    public MonitorWrapper(@NonNull IProgressMonitor monitor, @NonNull String taskName, int taskCount) {
        this.monitor = monitor;
        this.taskCount = taskCount;
        this.lastUpdatedCounterTime = 0L;
        this.lastCounterValue = 0L;
        this.multiplier = Math.max(1, 100 / taskCount);
        monitor.beginTask(taskName, taskCount * this.multiplier);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void progress(long amnt, long total, long cntr) {
        block2: {
            if (total > 0L) {
                int done;
                int currentProgress;
                int progress = (int)(amnt * (long)this.multiplier / total);
                do {
                    currentProgress = this.workPosition.get();
                    done = progress - currentProgress;
                    if (progress < 0 || progress > this.multiplier || done <= 0) break block2;
                } while (!this.workPosition.compareAndSet(currentProgress, progress));
                this.monitor.worked(done);
            }
        }
        this.updateSubtaskName(cntr, false);
    }

    public void subTask(@NonNull String subtaskName, @Nullable String cntrLabel) {
        int stn = this.subTaskNo.incrementAndGet();
        assert (stn < this.taskCount);
        int amountToSkip = stn * this.multiplier - this.workPosition.get();
        this.subtaskName = subtaskName;
        this.cntrLabel = cntrLabel;
        this.updateSubtaskName(0L, true);
        this.monitor.worked(amountToSkip);
        this.workPosition.set(0);
    }

    private void updateSubtaskName(long cntr, boolean force) {
        String subtaskName = this.subtaskName;
        String cntrLabel = this.cntrLabel;
        if (subtaskName != null) {
            if (cntrLabel == null) {
                if (force) {
                    this.monitor.subTask(subtaskName);
                }
            } else {
                long now = System.nanoTime();
                if (force || cntr > this.lastCounterValue && now - this.lastUpdatedCounterTime > 1000000000L) {
                    this.lastCounterValue = cntr;
                    this.lastUpdatedCounterTime = now;
                    this.monitor.subTask(String.format("%s: %s %s", subtaskName, counterFormatter.format(cntr), cntrLabel));
                }
            }
        }
    }
}

