/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.dataimport.ImportJob;
import com.arm.streamline.dataimport.ImportingApcFile;
import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.PerfToAPCTransformer;
import com.arm.streamline.perf.data_file.Header;
import com.arm.streamline.perf.data_file.HeaderType;
import com.arm.streamline.perf.misc.ResourceEventsXmlProvider;
import com.arm.streamline.perf.transform.IPerfTransformMonitor;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportPerfCaptureJob
extends ImportJob {
    private static final int TOTAL_PROGRESS_PER_STAGE = 1000;
    private final @NonNull List<@NonNull File> inputFiles;

    public static boolean isPerfFile(@NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            @Nullable HeaderType headerType = Header.validateMagicBytes(inputStream);
            boolean bl = headerType != null;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ImportPerfCaptureJob(@NonNull List<@NonNull File> perfDataFiles, @NonNull File apcOutputPath) {
        super(MessageFormat.format(DocumentsMessages.IMPORTING_ONE, perfDataFiles.stream().map(f -> f.getName()).collect(Collectors.joining(", ", "", ""))), apcOutputPath);
        this.setUser(true);
        this.inputFiles = perfDataFiles;
    }

    protected IStatus run(final IProgressMonitor monitor) {
        boolean completedSuccessfully = false;
        File apcDirectory = null;
        try {
            int totalWork = 1000 * IPerfTransformMonitor.ProgressStage.values().length * this.inputFiles.size();
            monitor.beginTask(DocumentsMessages.IMPORTING_TITLE, totalWork);
            for (File inputFile : this.inputFiles) {
                if (!inputFile.exists() || !inputFile.isFile()) {
                    throw new AssertionError(inputFile);
                }
                if (!this.outputPath.exists() || !this.outputPath.isDirectory()) {
                    throw new AssertionError(this.outputPath);
                }
                Throwable throwable = null;
                Object var8_12 = null;
                try (@NonNull ImportingApcFile apcFile = ImportPerfCaptureJob.getApcFile(this.outputPath, (String)NullChecking.neverNull((Object)inputFile.getName()));){
                    Throwable throwable2 = null;
                    Object var11_17 = null;
                    try (PerfToAPCTransformer transformer = PerfToAPCTransformer.create(inputFile, new ResourceEventsXmlProvider());){
                        apcDirectory = apcFile.getFile();
                        transformer.writeTo((File)NullChecking.neverNull((Object)apcDirectory), new IPerfTransformMonitor(){
                            private long counter = 0L;
                            private IPerfTransformMonitor.ProgressStage currentStage = null;
                            private long nEvents = 0L;
                            private int progress = 0;
                            private int stageProgress = 0;

                            @Override
                            public void incProgress() throws InterruptedException {
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                ++this.counter;
                                int newProgress = (int)Math.min(this.counter * 1000L / this.nEvents, 1000L);
                                if (this.progress < newProgress) {
                                    monitor.worked(newProgress - this.progress);
                                    this.progress = newProgress;
                                }
                            }

                            @Override
                            public void setProgress(@NonNull IPerfTransformMonitor.ProgressStage stage, long nEvents) throws InterruptedException {
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                this.nEvents = nEvents;
                                if (this.currentStage != stage) {
                                    this.counter = 0L;
                                    this.currentStage = stage;
                                    switch (stage) {
                                        case VALIDATING_INPUT: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_VALIDATING_INPUT, 0);
                                            break;
                                        }
                                        case MAPPING_ATTRIBUTES_TO_IDS: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_MAPPING_ATTRIBUTES_TO_IDS, 1);
                                            break;
                                        }
                                        case COUNT_EVENT_RECORDS: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_COUNT_EVENT_RECORDS, 2);
                                            break;
                                        }
                                        case EXAMINE_RECORDS: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_EXAMINE_RECORDS, 3);
                                            break;
                                        }
                                        case PARSING_TRACING_DATA: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_PARSING_TRACING_DATA, 4);
                                            break;
                                        }
                                        case WRITING_APC: {
                                            this.startTask(DocumentsMessages.PERF_IMPORT_STATUS_WRITING_APC, 5);
                                            break;
                                        }
                                    }
                                }
                            }

                            private void startTask(String label, int stageNo) {
                                if (!($assertionsDisabled || this.stageProgress < stageNo || this.stageProgress == stageNo && this.progress == 0)) {
                                    throw new AssertionError();
                                }
                                monitor.subTask(label);
                                if (this.stageProgress < stageNo) {
                                    monitor.worked(1000 - this.progress + (stageNo - (this.stageProgress + 1)) * 1000);
                                }
                                this.stageProgress = stageNo;
                                this.progress = 0;
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                DocumentScanner.INSTANCE.updateAndSelect(Arrays.asList(apcDirectory));
                completedSuccessfully = true;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (InterruptedException e) {
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "com.arm.streamline", DocumentsMessages.IMPORT_ERROR_EXCEPTION, (Throwable)e);
            return status;
        }
        catch (InvalidPerfDataException exception) {
            switch (exception.getReason()) {
                case BIG_ENDIAN_NOT_SUPPORTED: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_BIG_ENDIAN_NOT_SUPPORTED);
                    return status;
                }
                case CANNOT_DECODE_ID: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_CANNOT_DECODE_ID);
                    return status;
                }
                case DUPLICATE_IDS: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_DUPLICATE_IDS);
                    return status;
                }
                case FILE_NOT_RECOGNIZED: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_FILE_NOT_RECOGNIZED);
                    return status;
                }
                case INVALID_CLUSTER_DATA: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_INVALID_CLUSTER_DATA);
                    return status;
                }
                case MISSING_CMDLINE_ARG_T: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_MISSING_CMDLINE_ARG_T);
                    return status;
                }
                case MISSING_HEADER_EVENT_DESC: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_MISSING_HEADER_EVENT_DESC);
                    return status;
                }
                case MISSING_HEADER_PMU_MAPPINGS: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_MISSING_HEADER_PMU_MAPPINGS);
                    return status;
                }
                case MISSING_HEADER_TRACING_DATA: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_MISSING_HEADER_TRACING_DATA);
                    return status;
                }
                case MISSING_ID: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_MISSING_ID);
                    return status;
                }
                case NO_SAMPLES: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_NO_SAMPLES);
                    return status;
                }
                case NO_SAMPLE_ID_ALL: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_NO_SAMPLE_ID_ALL);
                    return status;
                }
                case NO_SAMPLE_TYPE_READ_OR_FREQ_PERIOD: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_NO_SAMPLE_TYPE_READ_OR_FREQ_PERIOD);
                    return status;
                }
                case UNEXPECTED_READ_FORMAT: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_UNEXPECTED_READ_FORMAT);
                    return status;
                }
                case META_INFO_MISSING_EVENT_TYPE_INFO: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_META_INFO_MISSING_EVENT_TYPE_INFO);
                    return status;
                }
                case BAD_META_INFO_EVENT_TYPE_INFO: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_BAD_META_INFO_EVENT_TYPE_INFO);
                    return status;
                }
                case INVALID_RECORD_TYPE: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_INVALID_RECORD_TYPE);
                    return status;
                }
                case INVALID_COMPRESSED_RECORD: {
                    Status status = new Status(4, "com.arm.streamline", DocumentsMessages.PERF_IMPORT_ERROR_INVALID_COMPRESSED_RECORD);
                    return status;
                }
            }
            throw new AssertionError("Unexpected " + String.valueOf(exception.getReason()), exception);
        }
        catch (IOException e) {
            Status status = new Status(4, "com.arm.streamline", DocumentsMessages.IMPORT_ERROR_EXCEPTION, (Throwable)e);
            return status;
        }
        finally {
            if (!completedSuccessfully && apcDirectory != null) {
                ImportPerfCaptureJob.deleteRecursive(apcDirectory);
            } else if (completedSuccessfully) {
                DocumentsView.makeVisible();
            }
        }
    }
}

