/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.IDocumentScanner;
import com.arm.streamline.dataimport.ImportingApcFile;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public abstract class ImportJob
extends Job {
    protected final @NonNull File outputPath;

    public static void deleteRecursive(@NonNull File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    ImportJob.deleteRecursive(child);
                } else {
                    child.delete();
                }
                ++n2;
            }
        }
        dir.delete();
    }

    public static @NonNull ImportingApcFile getApcFile(@NonNull File parent, @NonNull String name) throws FileNotFoundException {
        if (name.toLowerCase().endsWith(".apc")) {
            name = name.substring(0, name.length() - ".apc".length());
        }
        if (!parent.isDirectory()) {
            throw new FileNotFoundException(parent.getAbsolutePath());
        }
        File result = ImportJob.createApcDirectory(parent, name, DocumentScanner.INSTANCE);
        return new ImportingApcFile(result);
    }

    public static @NonNull File createApcDirectory(@NonNull File parent, @NonNull String name, @NonNull IDocumentScanner scanner) throws FileNotFoundException {
        File result = new File(parent, name + ".apc");
        if (!ImportJob.tryMakeApcDirectory(result, scanner)) {
            int counter = 1;
            while (!ImportJob.tryMakeApcDirectory(result = new File(parent, name + "_" + ++counter + ".apc"), scanner)) {
            }
        }
        return result;
    }

    public static boolean tryMakeApcDirectory(@NonNull File result, @NonNull IDocumentScanner scanner) throws FileNotFoundException {
        scanner.addExcludedCapturePath(result);
        if (!result.mkdirs()) {
            scanner.removeExcludedCapturePath(result);
            return false;
        }
        return true;
    }

    protected ImportJob(String name, @NonNull File apcOutputPath) {
        super(name);
        this.outputPath = apcOutputPath;
    }
}

