/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.dataimport.ImportJob;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;

public class ImportCaptureJob
extends ImportJob {
    private File[] mFiles;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(@NonNull File file) {
        try {
            var1_1 = null;
            var2_4 = null;
            try {
                fileStream = new FileInputStream(file);
                try {
                    i = 0;
                    while (true) {
                        b = fileStream.read();
                        if (b < 0) {
                            return false;
                        }
                        if (i == 0 && b != 80) {
                            return false;
                        }
                        if (i == 1 && b != 75) {
                            return false;
                        }
                        ++i;
                        return (boolean)i;
                    }
                }
                finally {
                    if (i < 2) ** continue;
                    return true;
                }
            }
            catch (Throwable var2_5) {
                if (var1_1 == null) {
                    var1_1 = var2_5;
                    throw var1_1;
                }
                if (var1_1 == var2_5) throw var1_1;
                var1_1.addSuppressed(var2_5);
                throw var1_1;
            }
        }
        catch (Throwable var1_3) {
            return false;
        }
    }

    private static String containsPrefix(String name, List<String> list) {
        for (String one : list) {
            if (!name.startsWith(one)) continue;
            return one;
        }
        return null;
    }

    private static String getTopParent(String path) {
        String last = path;
        while (path != null && !path.isEmpty()) {
            last = path;
            path = FilePath.getParent((String)path, (boolean)false);
        }
        return last;
    }

    private static void mapTopLevelDirectory(File docsDir, List<File> apcs, File dir, List<String> ignoreList, List<String> mappingList, Map<String, String> mappings) {
        Object fileName = dir.getName();
        if (mappingList.contains((String)fileName + FilePath.PATH_SEPARATOR)) {
            return;
        }
        String extension = FilePath.getExtension((String)fileName);
        if (extension.equalsIgnoreCase(".apc")) {
            if (dir.exists()) {
                String base = FilePath.getLeafName((String)fileName, (boolean)false);
                int counter = 1;
                while ((dir = new File(docsDir, base + "_" + ++counter + extension)).exists()) {
                }
            }
            fileName = (String)fileName + FilePath.PATH_SEPARATOR;
            mappingList.add((String)fileName);
            if (!mappings.containsKey(fileName)) {
                mappings.put((String)fileName, dir.getName() + FilePath.PATH_SEPARATOR);
            }
            apcs.add(dir);
        } else {
            ignoreList.add((String)fileName + FilePath.PATH_SEPARATOR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processOne(IProgressMonitor monitor, File src, @NonNull File docsDir) {
        ArrayList<@NonNull File> apcs = new ArrayList<File>();
        boolean abort = false;
        byte[] buffer = new byte[4096];
        HashMap<String, String> mappings = new HashMap<String, String>();
        ArrayList<String> ignoreList = new ArrayList<String>();
        ArrayList<String> mappingList = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (ZipInputStream in = new ZipInputStream(new FileInputStream(src));){
                ZipEntry entry;
                while ((entry = in.getNextEntry()) != null) {
                    if (monitor.isCanceled()) {
                        abort = true;
                        break;
                    }
                    Object name = entry.getName();
                    if (ImportCaptureJob.containsPrefix((String)name, ignoreList) != null) continue;
                    String match = ImportCaptureJob.containsPrefix((String)name, mappingList);
                    if (match == null) {
                        String path = ImportCaptureJob.getTopParent((String)name);
                        ImportCaptureJob.mapTopLevelDirectory(docsDir, apcs, new File(docsDir, path), ignoreList, mappingList, mappings);
                        match = ImportCaptureJob.containsPrefix((String)name, mappingList);
                    }
                    if (match == null) {
                        throw new IllegalArgumentException();
                    }
                    name = (String)mappings.get(match) + ((String)name).substring(match.length());
                    File file = new File(docsDir, (String)name);
                    @NonNull File parent = (File)NullChecking.neverNull((Object)file.getParentFile());
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    if (parent.equals(docsDir)) {
                        if (!entry.isDirectory()) continue;
                        ImportCaptureJob.mapTopLevelDirectory(docsDir, apcs, file, ignoreList, mappingList, mappings);
                    }
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    Throwable throwable2 = null;
                    Object var18_23 = null;
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int amount;
                        while ((amount = in.read(buffer)) > 0) {
                            out.write(buffer, 0, amount);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception exception) {
            abort = true;
            String errorMessage = MessageFormat.format(ImportMessages.ERROR_DURING_IMPORT, src.toString());
            Error.show(errorMessage, exception, true);
        }
        if (abort || monitor.isCanceled()) {
            for (File dir : apcs) {
                try {
                    StreamlineFileUtils.deleteAsynchronously(dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        DocumentScanner.INSTANCE.addToWatchSet(docsDir);
        DocumentsView.makeVisible();
        DocumentScanner.INSTANCE.updateAndSelect(apcs);
    }

    public ImportCaptureJob(List<File> files, @NonNull File outputPath) {
        super(DocumentsMessages.IMPORTING_TITLE, outputPath);
        this.setUser(true);
        this.setSystem(false);
        this.mFiles = files.toArray(new File[files.size()]);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(DocumentsMessages.IMPORTING_TITLE, this.mFiles.length);
        if (!this.outputPath.exists() || !this.outputPath.isDirectory()) {
            throw new AssertionError(this.outputPath);
        }
        File[] fileArray = this.mFiles;
        int n = this.mFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File one = fileArray[n2];
            monitor.setTaskName(MessageFormat.format(DocumentsMessages.IMPORTING_ONE, one.getName()));
            ImportCaptureJob.processOne(monitor, one, this.outputPath);
            if (monitor.isCanceled()) break;
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

