/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.coresight.ds5_trace_dump.ITMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.STMTraceSourceStreamWrapper;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPDecodeException;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.frames.IBarmanSerializableFrameProducer;
import com.arm.streamline.barman.frames.UncheckedBarmanDecodeException;
import com.arm.streamline.barman.stm.STPFrameHandler;
import com.arm.streamline.barman.stm.STPMerger;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.dataimport.AbstractTraceDumpImportJob;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.MonitorWrapper;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Container;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportBarmanSTMJob
extends AbstractTraceDumpImportJob {
    private final @NonNull Container<Integer> channelIds;
    private final @NonNull Container<Integer> masterIds;

    public static boolean isSTMStream(@NonNull ITraceSourceStreamWrapper s) {
        return s instanceof STMTraceSourceStreamWrapper;
    }

    private static @NonNull Container<Integer> getChannelsFromStmConfig(@NonNull STMBackendConfiguration stmConfig) {
        int begin = stmConfig.getMinChannelNumber();
        int end = begin + stmConfig.getNumberOfChannels();
        return Container.fromRange((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end));
    }

    private static @NonNull Container<Integer> getMasterIdsFromStmConfig(@NonNull STMBackendConfiguration stmConfig) {
        Set result = stmConfig.getMasterIds().stream().distinct().collect(Collectors.toSet());
        return Container.wrapCollection((Collection)((Collection)NullChecking.neverNull(result)));
    }

    public ImportBarmanSTMJob(@NonNull File apcOutputPath, @NonNull File barmanXml, @NonNull ITraceDumpDirectory directory, @Nullable File agentImage) throws IOException, ImportJobFactory.ImportJobCreationException {
        super((String)NullChecking.neverNull((Object)MessageFormat.format(ImportMessages.STM_IMPORT_JOB_NAME, directory.getDirectory().getCanonicalPath())), apcOutputPath, barmanXml, null, directory, agentImage);
        BarmanConfiguration barmanConfig = this.barmanConfig;
        if (barmanConfig == null) {
            throw new AssertionError();
        }
        @Nullable STMBackendConfiguration stmConfig = barmanConfig.getStmConfiguration();
        if (stmConfig == null) {
            throw new ImportJobFactory.ImportJobCreationException(ImportMessages.BARMAN_XML_MISSING_STM_CONFIG);
        }
        this.masterIds = ImportBarmanSTMJob.getMasterIdsFromStmConfig(stmConfig);
        this.channelIds = ImportBarmanSTMJob.getChannelsFromStmConfig(stmConfig);
    }

    @Override
    protected void copyTargetSpecificFilesToAPCDirectory(@NonNull File apcDirectory) throws IOException {
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            assert (monitor != null);
            return this.runWith(monitor, sw -> ImportBarmanSTMJob.isSTMStream(sw), (fw, mw) -> this.createVisitor((Consumer<IBarmanSerializableFrame>)fw, (MonitorWrapper)mw), "bytes");
        }
        catch (Throwable t) {
            return new Status(4, "com.arm.streamline", ImportMessages.EXCEPTION_THROWN, t);
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Void, Void, Throwable> createVisitor(final @NonNull Consumer<@NonNull IBarmanSerializableFrame> frameConsumer, final @NonNull MonitorWrapper progressMonitor) {
        return new ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Void, Void, Throwable>(){

            public Void visit(@NonNull ITMTraceSourceStreamWrapper stream, Void data) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            public Void visit(@NonNull STMTraceSourceStreamWrapper stream, Void data) throws IOException {
                STPFrameHandler frameHandler = new STPFrameHandler(frameConsumer);
                STPMerger stpMerger = STPMerger.newWithDefaultPipeline(ImportBarmanSTMJob.this.masterIds, ImportBarmanSTMJob.this.channelIds, frameHandler);
                IBarmanSerializableFrameProducer frameProducer = (d, l) -> {
                    try {
                        stpMerger.extractFrames(d, l);
                    }
                    catch (STPDecodeException e) {
                        String message = (String)NullChecking.neverNull((Object)MessageFormat.format(DocumentsMessages.CORRUPT_STPV2_STREAM, Long.toString(stpMerger.getNumNibblesProcessed() / 2L)));
                        throw new UncheckedBarmanDecodeException(message, e);
                    }
                };
                ImportBarmanSTMJob.produceCaptureFromTraceSource(progressMonitor, frameProducer, stream.getFiles());
                return null;
            }
        };
    }
}

