/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.coresight.ds5_trace_dump.ITMTraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.STMTraceSourceStreamWrapper;
import com.arm.coresight.itm.IITMPacketReceiver;
import com.arm.coresight.itm.ITMParser;
import com.arm.coresight.itm.InvalidITMPacketFormatException;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.frames.IBarmanSerializableFrameProducer;
import com.arm.streamline.barman.frames.UncheckedBarmanDecodeException;
import com.arm.streamline.barman.frames.objects.SimpleFrame;
import com.arm.streamline.barman.frames.objects.WarningFrame;
import com.arm.streamline.barman.itm.ITMFrameDataMerger;
import com.arm.streamline.barman.itm.ITMFrameHandler;
import com.arm.streamline.barman.itm.LocalTimestampedPacketEmitter;
import com.arm.streamline.barman.v1.BarmanHeaderDataFactoryV1;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barman.v1.BarmanWarningType;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.configuration.ITMBackendConfiguration;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.dataimport.AbstractTraceDumpImportJob;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.MonitorWrapper;
import com.arm.streamline.dwt.DWTUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Container;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImportBarmanITMJob
extends AbstractTraceDumpImportJob {
    private final @Nullable DWTConfiguration dwtConfig;
    private final boolean importAsSynchronizedStream;
    private final int permittedSamplingPeriod;
    private final @NonNull Container<@NonNull Byte> ports;
    private final @NonNull List<@NonNull IBarmanSerializableFrame> warningFrames;
    private final @Nullable IBarmanSerializableFrame header;

    public static boolean isITMStream(@NonNull ITraceSourceStreamWrapper s) {
        return s instanceof ITMTraceSourceStreamWrapper;
    }

    public ImportBarmanITMJob(@NonNull File apcOutputPath, @Nullable File barmanXml, @Nullable BarmanConfiguration barmanConfig, @NonNull ITraceDumpDirectory directory, @Nullable File agentImage, boolean importAsSynchronizedStream) throws IOException, ImportJobFactory.ImportJobCreationException {
        super((String)NullChecking.neverNull((Object)MessageFormat.format(ImportMessages.ITM_IMPORT_JOB_NAME, directory.getDirectory().getCanonicalPath())), apcOutputPath, barmanXml, barmanConfig, directory, agentImage);
        this.importAsSynchronizedStream = importAsSynchronizedStream;
        this.warningFrames = new ArrayList<IBarmanSerializableFrame>();
        barmanConfig = this.barmanConfig;
        if (barmanConfig == null) {
            throw new AssertionError();
        }
        this.header = (IBarmanSerializableFrame)NullChecking.applyIfNonNull((Object)((byte[])NullChecking.applyIfNonNull((Object)BarmanHeaderDataFactoryV1.fromConfig(barmanConfig), BarmanHeaderDataV1::serialize)), SimpleFrame::new);
        @Nullable ITMBackendConfiguration itmConfig = barmanConfig.getITMConfiguration();
        if (itmConfig == null && this.header == null) {
            throw new ImportJobFactory.ImportJobCreationException(ImportMessages.BARMAN_XML_MISSING_ITM_CONFIG);
        }
        if (itmConfig != null) {
            byte portBegin = itmConfig.getPortNumber();
            byte portEnd = (byte)(itmConfig.getPortNumber() + itmConfig.getNumPortsUsed());
            this.ports = Container.fromRange((Comparable)Byte.valueOf(portBegin), (Comparable)Byte.valueOf(portEnd));
        } else {
            this.ports = Container.newWithNothing();
        }
        this.dwtConfig = barmanConfig.getDWTConfiguration();
        if (this.dwtConfig != null) {
            int requestedSamplingPeriod = this.dwtConfig.getPCSamplingPeriod();
            this.permittedSamplingPeriod = DWTUtils.convertToValidSamplingInterval(requestedSamplingPeriod);
            if (requestedSamplingPeriod != this.permittedSamplingPeriod) {
                this.warningFrames.add(new WarningFrame(0L, -1, BarmanWarningType.DWT_CYCLE_PERIOD_ROUNDED));
            }
        } else {
            this.permittedSamplingPeriod = 0;
        }
    }

    @Override
    protected void copyTargetSpecificFilesToAPCDirectory(@NonNull File apcDirectory) throws IOException {
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            assert (monitor != null);
            return this.runWith(monitor, sw -> ImportBarmanITMJob.isITMStream(sw), (fw, mw) -> this.createVisitor((Consumer<IBarmanSerializableFrame>)fw, (MonitorWrapper)mw), "bytes");
        }
        catch (Throwable t) {
            return new Status(4, "com.arm.streamline", ImportMessages.EXCEPTION_THROWN, t);
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Void, Void, Throwable> createVisitor(final @NonNull Consumer<@NonNull IBarmanSerializableFrame> frameConsumer, final @NonNull MonitorWrapper progressMonitor) {
        return new ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Void, Void, Throwable>(){

            public Void visit(@NonNull ITMTraceSourceStreamWrapper stream, Void data) throws IOException {
                boolean coreNumber = false;
                @NonNull ITMFrameHandler itmFrameHandler = new ITMFrameHandler(frameConsumer);
                final @NonNull ITMFrameDataMerger itmFrameDataMerger = new ITMFrameDataMerger(0, ImportBarmanITMJob.this.permittedSamplingPeriod, ImportBarmanITMJob.this.ports, itmFrameHandler);
                final @NonNull ITMParser itmParser = new ITMParser((IITMPacketReceiver)new LocalTimestampedPacketEmitter(itmFrameDataMerger), ImportBarmanITMJob.this.importAsSynchronizedStream, ImportBarmanITMJob.this.dwtConfig != null);
                IBarmanSerializableFrameProducer frameProducer = new IBarmanSerializableFrameProducer(){
                    private long bytesProcessed = 0L;

                    @Override
                    public void extractFrames(byte @NonNull [] data, int length) {
                        ByteBuffer buffer = ByteBuffer.wrap(data, 0, length);
                        try {
                            itmParser.parse(buffer);
                        }
                        catch (InvalidITMPacketFormatException e) {
                            String message = (String)NullChecking.neverNull((Object)MessageFormat.format(DocumentsMessages.CORRUPT_ITM_STREAM, Long.toString(this.bytesProcessed + (long)buffer.position())));
                            throw new UncheckedBarmanDecodeException(message, e);
                        }
                        this.bytesProcessed += (long)length;
                    }

                    @Override
                    public void setUp() {
                        (this).ImportBarmanITMJob.this.warningFrames.forEach(frameConsumer);
                        NullChecking.consumeIfNonNull((Object)(this).ImportBarmanITMJob.this.header, (Consumer)frameConsumer);
                    }

                    @Override
                    public void tearDown() {
                        itmFrameDataMerger.flush();
                    }
                };
                ImportBarmanITMJob.produceCaptureFromTraceSource(progressMonitor, frameProducer, stream.getFiles());
                return null;
            }

            public Void visit(@NonNull STMTraceSourceStreamWrapper stream, Void data) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
    }
}

