/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.dataimport;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.coresight.ds5_trace_dump.TraceStreamReader;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.frames.IBarmanSerializableFrameProducer;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.xml.BarmanConfigurationXML;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.dataimport.ImportJob;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.dataimport.MonitorWrapper;
import com.arm.utils.NullChecking;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractTraceDumpImportJob
extends ImportJob {
    protected final @Nullable File agentImage;
    protected final @Nullable BarmanConfiguration barmanConfig;
    protected final @Nullable File barmanXml;
    protected final @NonNull ITraceDumpDirectory directory;
    protected final @NonNull Events events;
    protected final @Nullable File eventsXmlPath;
    protected final @NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> pmus;
    protected final @Nullable File pmusXmlPath;

    protected static void copyToAPCDirectoryIfExists(@NonNull File apcDirectory, @Nullable File fileToCopy, @NonNull String destinationName) throws IOException, InterruptedException {
        if (fileToCopy != null && fileToCopy.exists()) {
            CommonFileUtils.copyFile((File)fileToCopy, (File)new File(apcDirectory, destinationName));
        }
    }

    protected static void produceCaptureFromTraceSource(@NonNull MonitorWrapper progressMonitor, @NonNull IBarmanSerializableFrameProducer frameProducer, @NonNull List<@NonNull File> traceStreamFiles) throws IOException {
        frameProducer.setUp();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TraceStreamReader traceStreamReader = new TraceStreamReader(traceStreamFiles);){
                byte[] buffer = new byte[655536];
                while (!progressMonitor.isCanceled()) {
                    int amountRead = traceStreamReader.next(buffer);
                    frameProducer.extractFrames(buffer, amountRead);
                    progressMonitor.progress(traceStreamReader.getCurrentStreamPosition(), traceStreamReader.getTotalStreamLength(), traceStreamReader.getCurrentStreamPosition());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        frameProducer.tearDown();
    }

    public AbstractTraceDumpImportJob(@NonNull String jobName, @NonNull File apcOutputPath, @Nullable File barmanXml, @Nullable BarmanConfiguration barmanConfig, @NonNull ITraceDumpDirectory directory, @Nullable File agentImage) throws ImportJobFactory.ImportJobCreationException, IOException {
        block11: {
            super(jobName, apcOutputPath);
            this.barmanXml = barmanXml;
            this.agentImage = agentImage;
            this.directory = directory;
            try {
                BarmanConfigurationXML.EventsAndPmusXmlPaths eventsAndPmusXmlPaths = (BarmanConfigurationXML.EventsAndPmusXmlPaths)NullChecking.applyIfNonNullOrCreateDefaultThrows((Object)barmanXml, b -> BarmanConfigurationXML.getEventsAndPmusXmlPaths((String)NullChecking.neverNull((Object)b.getCanonicalPath())), () -> new BarmanConfigurationXML.EventsAndPmusXmlPaths(null, null));
                this.pmusXmlPath = (File)NullChecking.applyIfNonNull((Object)eventsAndPmusXmlPaths.pmusXmlPath, File::new);
                this.eventsXmlPath = (File)NullChecking.applyIfNonNull((Object)eventsAndPmusXmlPaths.eventsXmlPath, File::new);
                this.pmus = (Map)EventsAndPmusXml.getPmusFromXml((File)this.pmusXmlPath, (File)this.eventsXmlPath).first;
                this.events = EventsAndPmusXml.getEventsFromXml((File)this.eventsXmlPath);
                if (barmanConfig != null || barmanXml == null) break block11;
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream stream = new FileInputStream(barmanXml);){
                    barmanConfig = BarmanConfigurationXML.parse(stream, this.pmus, msg -> StdLog.warn((Plugin)StreamlinePlugin.getInstance(), (String)msg));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ImportJobFactory.ImportJobCreationException(ImportMessages.BARMAN_XML_CANNOT_BE_READ);
            }
        }
        this.barmanConfig = barmanConfig;
    }

    protected abstract void copyTargetSpecificFilesToAPCDirectory(@NonNull File var1) throws IOException;

    /*
     * Exception decompiling
     */
    protected final IStatus runWith(@NonNull IProgressMonitor monitor, @NonNull Predicate<@NonNull ITraceSourceStreamWrapper> sourceFilter, @NonNull BiFunction<@NonNull Consumer<@NonNull IBarmanSerializableFrame>, @NonNull MonitorWrapper, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ITraceSourceStreamWrapper.ITraceSourceStreamWrapperVisitor<Void, Void, Throwable>> visitorFactory, @Nullable String counterLabel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 46[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$5(Predicate predicate, ITraceSourceStreamWrapper s) {
        return predicate.test(s);
    }
}

