/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.model;

import com.arm.streamline.databrowser.model.FileOrDirectoryListPanelModel;
import com.arm.streamline.databrowser.view.Messages;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import java.io.File;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class ImageSearchPathsDirectoryListPanelModel
extends FileOrDirectoryListPanelModel {
    public ImageSearchPathsDirectoryListPanelModel(@NonNull IAnalysisInputSettings settings) {
        this(settings.getImageSearchPathsWithEnabledFlags());
    }

    public ImageSearchPathsDirectoryListPanelModel(@NonNull Set<@NonNull PathWithEnabledFlag> currentPaths) {
        this.replaceContents(currentPaths);
    }

    @Override
    public @Nullable File commandShowAddDialog(Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(shell);
        dd.setFilterPath(this.lastFilterStorePath.getLastFilterPath().getAbsolutePath());
        dd.setText(Messages.ImageSearch_FileOpen_Title);
        String path = dd.open();
        this.lastFilterStorePath.setLastFilterPath(new File(dd.getFilterPath()));
        return path != null ? new File(path) : null;
    }

    @Override
    public @NonNull String getNewItemLabel() {
        return Messages.ImageSearch_AddNew_Label;
    }

    @Override
    public @NonNull String getPathLabel(@NonNull File path) {
        return path.getAbsolutePath();
    }

    @Override
    public @NonNull IObservableValue<@NonNull Boolean> getPropertyCanRemoveSelection() {
        return ComputedValue.create(() -> Boolean.TRUE);
    }

    @Override
    public boolean isValidPath(@NonNull File path) {
        return path.isDirectory();
    }

    public void replaceContents(@NonNull Set<@NonNull PathWithEnabledFlag> paths) {
        this.propCheckedDirectories.clear();
        this.propAllDirectories.clear();
        for (PathWithEnabledFlag entry : paths) {
            File dir = entry.getFile();
            boolean enabled = entry.isUsed() && dir.isDirectory();
            this.commandAddPath(dir, enabled);
        }
    }
}

