/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.browser.AdbTargetBrowser;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowser;
import com.arm.streamline.databrowser.browser.ITargetBrowserAdapter;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.databrowser.browser.StdTargetBrowser;
import com.arm.streamline.databrowser.browser.TargetBrowserForwarder;
import com.arm.streamline.utility.AdbRunnerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TargetBrowserAdapter
implements ITargetBrowserAdapter {
    private static final int SCAN_TIMEOUT_SECONDS = 1;
    private static final @NonNull ConnectionType @NonNull [] STREAMLINE_CONNECTION_TYPES = new ConnectionType[]{ConnectionType.STREAMLINE, ConnectionType.ADB};
    private final @NonNull ITargetBrowser @Nullable [] additionalBrowsers;
    private final @NonNull ConnectionType @Nullable [] allowedTypes;
    private @Nullable ITargetBrowser targetBrowser;

    private static void addHardwareBrowser(@NonNull ITargetBrowserClient client, @NonNull List<@NonNull ITargetBrowser> browsers, @NonNull ITargetBrowser browser) {
        browser.addClient(client);
        browser.startBrowsing(1, true);
        browsers.add(browser);
    }

    private static @NonNull ITargetBrowser @Nullable [] makeAdbBrowser(@Nullable File pathToAdb, @Nullable Consumer<@NonNull Exception> exceptionConsumer) {
        if (pathToAdb != null) {
            try {
                return new ITargetBrowser[]{new AdbTargetBrowser(AdbRunnerFactory.SINGLETON.create(pathToAdb), exceptionConsumer)};
            }
            catch (IOException e) {
                StreamlinePlugin.warning(e);
            }
        }
        return null;
    }

    public TargetBrowserAdapter(@NonNull ConnectionType @Nullable [] allowedTypes, @NonNull ITargetBrowser @Nullable [] additionalBrowsers) {
        this.allowedTypes = allowedTypes;
        this.additionalBrowsers = additionalBrowsers;
    }

    public TargetBrowserAdapter(@Nullable File pathToAdb, @Nullable Consumer<@NonNull Exception> exceptionConsumer) {
        this(STREAMLINE_CONNECTION_TYPES, TargetBrowserAdapter.makeAdbBrowser(pathToAdb, exceptionConsumer));
    }

    @Override
    public boolean allowed(@NonNull ConnectionType type) {
        @NonNull ConnectionType @Nullable [] allowedTypes = this.allowedTypes;
        if (allowedTypes == null) {
            return true;
        }
        ConnectionType[] connectionTypeArray = allowedTypes;
        int n = allowedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionType allowedType = connectionTypeArray[n2];
            if (allowedType.equals((Object)type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void create(@NonNull ITargetBrowserClient client) {
        assert (this.targetBrowser == null);
        @NonNull ITargetBrowser @Nullable [] additionalBrowsers = this.additionalBrowsers;
        @NonNull ConnectionType @Nullable [] allowedTypes = this.allowedTypes;
        @NonNull ArrayList<@NonNull ITargetBrowser> browsers = new ArrayList<ITargetBrowser>();
        if (allowedTypes != null && allowedTypes.length > 0) {
            try {
                TargetBrowserAdapter.addHardwareBrowser(client, browsers, new StdTargetBrowser(allowedTypes));
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        if (additionalBrowsers != null) {
            ITargetBrowser[] iTargetBrowserArray = additionalBrowsers;
            int n = additionalBrowsers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetBrowser browser = iTargetBrowserArray[n2];
                TargetBrowserAdapter.addHardwareBrowser(client, browsers, browser);
                ++n2;
            }
        }
        if (!browsers.isEmpty()) {
            this.targetBrowser = new TargetBrowserForwarder(browsers);
        }
    }

    @Override
    public void allowBrowisng(boolean allowBrowse) {
        if (allowBrowse) {
            if (this.targetBrowser != null) {
                this.targetBrowser.resumeContinuousBrowsing();
            }
        } else if (this.targetBrowser != null) {
            this.targetBrowser.pauseContinuousBrowsing();
        }
    }

    public void dispose() {
        ITargetBrowser targetBrowser = this.targetBrowser;
        if (targetBrowser != null) {
            targetBrowser.closeBrowser();
        }
    }
}

