/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.AdbPortForwarder;
import com.arm.streamline.databrowser.browser.AndroidProbeResult;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowser;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbCommandIOException;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import com.arm.streamline.deviceconn.adb.utils.AdbDeviceEnumeration;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AdbTargetBrowser
implements ITargetBrowser {
    private static final int MAX_CONNECTION_RETRIES = 5;
    private final @NonNull IAdbProcessRunner adbProcessRunner;
    private final boolean mAllDevices;
    private int mBrowseTimeoutInSeconds;
    private ITargetBrowserClient mClient;
    private @NonNull Map<@NonNull String, @NonNull BrowseResult> mHardware = new HashMap<String, BrowseResult>();
    private boolean mRunning;
    private int mRemainingRetries = 5;
    private Thread mThread;
    private @NonNull Consumer<@NonNull Exception> mExceptionConsumer;
    private static volatile File probeScript;
    private final @NonNull AtomicBoolean canBrowse = new AtomicBoolean(true);

    private static @Nullable BrowseResult tryBrowse(@NonNull IAdbProcessRunner processRunner, @NonNull String device, int port, boolean tcp, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AdbDevice.AdbDeviceState state) {
        AndroidProbeResult probeResult;
        GatorSendCommandUtility.RunningGatordInfo runningGatordInfo = GatorSendCommandUtility.getRunningGatordInformation(port);
        if (!runningGatordInfo.couldConnect()) {
            return null;
        }
        try {
            probeResult = AdbTargetBrowser.probeDevice(processRunner, device, state);
        }
        catch (IOException ex) {
            probeResult = AndroidProbeResult.makeEmptyProbeResult();
        }
        return BrowseResult.adbBrowseResult(TargetAddressString.makeAndroid(device, tcp), device, runningGatordInfo.version(), probeResult.model, true, state, Optional.ofNullable(runningGatordInfo.currentConfig()), probeResult.configVersion, probeResult.hasMali);
    }

    public AdbTargetBrowser(@NonNull IAdbProcessRunner adbProcessRunner, @Nullable Consumer<@NonNull Exception> exceptionConsumer) {
        this(adbProcessRunner, exceptionConsumer, false);
    }

    public AdbTargetBrowser(@NonNull IAdbProcessRunner adbProcessRunner, boolean allDevices) {
        this(adbProcessRunner, null, allDevices);
    }

    public AdbTargetBrowser(@NonNull IAdbProcessRunner adbProcessRunner) {
        this(adbProcessRunner, false);
    }

    public AdbTargetBrowser(@NonNull IAdbProcessRunner adbProcessRunner, @Nullable Consumer<@NonNull Exception> exceptionConsumer, boolean allDevices) {
        this.adbProcessRunner = adbProcessRunner;
        this.mAllDevices = allDevices;
        this.mExceptionConsumer = exceptionConsumer != null ? exceptionConsumer : CommonPlugin::error;
    }

    @Override
    public void addClient(ITargetBrowserClient client) {
        this.mClient = client;
    }

    public @Nullable BrowseResult browseOne(@NonNull TargetAddressString targetAddressString) throws IOException {
        AdbPortForwarder forwarder = new AdbPortForwarder(this.adbProcessRunner);
        AdbPortForwarder.AdbPortPair ports = forwarder.getAdbDevicePorts(targetAddressString.getAndroidSerialNumber());
        if (targetAddressString.isAndroidOverTcp()) {
            return AdbTargetBrowser.tryBrowse(this.adbProcessRunner, targetAddressString.getAndroidSerialNumber(), ports.tcp, true, AdbDevice.AdbDeviceState.AVAILABLE);
        }
        assert (targetAddressString.isAndroidOverUds());
        return AdbTargetBrowser.tryBrowse(this.adbProcessRunner, targetAddressString.getAndroidSerialNumber(), ports.uds, false, AdbDevice.AdbDeviceState.AVAILABLE);
    }

    @Override
    public void closeBrowser() {
        if (this.mRunning) {
            this.mRunning = false;
            this.mThread.interrupt();
        }
    }

    @Override
    public void startBrowsing(int browseTimeoutInSeconds, boolean browseContinuously) {
        this.mBrowseTimeoutInSeconds = browseTimeoutInSeconds;
        this.mRemainingRetries = 5;
        if (browseContinuously) {
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    AdbTargetBrowser.this.browseContinuously();
                }
            });
            this.mThread.start();
        } else {
            this.browse(false);
        }
    }

    @Override
    public void stopBrowsing() {
    }

    @Override
    public void pauseContinuousBrowsing() {
        this.canBrowse.set(false);
    }

    @Override
    public void resumeContinuousBrowsing() {
        this.canBrowse.set(true);
    }

    private boolean browse(boolean ignoreExceptions) {
        try {
            try {
                this.mClient.beginBrowse(ConnectionType.ADB);
                Set devices = AdbDeviceEnumeration.enumerate((IAdbProcessRunner)this.adbProcessRunner);
                AdbPortForwarder forwarder = new AdbPortForwarder(this.adbProcessRunner);
                HashMap<String, BrowseResult> removed = new HashMap<String, BrowseResult>(this.mHardware);
                for (AdbDevice adbDevice : devices) {
                    BrowseResult result = null;
                    AndroidProbeResult probeResult = AdbTargetBrowser.probeDevice(this.adbProcessRunner, adbDevice.getSerialNo(), adbDevice.getState());
                    if (probeResult.isEmpty()) continue;
                    if (adbDevice.getState() != AdbDevice.AdbDeviceState.AVAILABLE) {
                        if (!this.mAllDevices) continue;
                        result = BrowseResult.adbBrowseResult(TargetAddressString.makeAndroid(adbDevice.getSerialNo(), false), adbDevice.getSerialNo(), null, probeResult.model, false, adbDevice.getState(), Optional.empty(), probeResult.configVersion, probeResult.hasMali);
                    } else {
                        AdbPortForwarder.AdbPortPair ports = forwarder.getAdbDevicePorts(adbDevice.getSerialNo());
                        result = AdbTargetBrowser.tryBrowse(this.adbProcessRunner, adbDevice.getSerialNo(), ports.uds, false, adbDevice.getState());
                        if (result == null) {
                            result = AdbTargetBrowser.tryBrowse(this.adbProcessRunner, adbDevice.getSerialNo(), ports.tcp, true, adbDevice.getState());
                        }
                    }
                    if (result == null && this.mAllDevices) {
                        result = BrowseResult.adbBrowseResult(TargetAddressString.makeAndroid(adbDevice.getSerialNo(), false), adbDevice.getSerialNo(), null, probeResult.model, false, adbDevice.getState(), Optional.empty(), probeResult.configVersion, probeResult.hasMali);
                    }
                    if (result == null) continue;
                    removed.remove(adbDevice.getSerialNo());
                    this.mHardware.put(adbDevice.getSerialNo(), result);
                    this.mClient.foundNewDebugHardware(result);
                }
                for (Map.Entry entry : removed.entrySet()) {
                    this.mHardware.remove(entry.getKey());
                    this.mClient.removeDebugHardware((BrowseResult)entry.getValue());
                }
            }
            catch (AdbCommandIOException exception) {
                if (!ignoreExceptions || this.mRemainingRetries-- <= 0) {
                    this.mRemainingRetries = 0;
                    this.mExceptionConsumer.accept((Exception)((Object)exception));
                }
                this.mClient.endBrowse(ConnectionType.ADB);
                return false;
            }
            catch (Exception exception) {
                this.mExceptionConsumer.accept(exception);
                this.mClient.endBrowse(ConnectionType.ADB);
                return false;
            }
        }
        finally {
            this.mClient.endBrowse(ConnectionType.ADB);
        }
        return true;
    }

    private static AndroidProbeResult probeDevice(@NonNull IAdbProcessRunner processRunner, @NonNull String serial, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AdbDevice.AdbDeviceState deviceState) throws IOException {
        if (probeScript == null) {
            AdbTargetBrowser.createProbeScriptTempFile();
            NullChecking.neverNull((Object)probeScript);
        }
        IBasicInteractiveShell.InteractiveCommandResult result = processRunner.runCommandAndGetOutput(new String[]{"-s", serial, "push", probeScript.getAbsolutePath(), "/data/local/tmp/streamline-android-probe.sh"});
        if (!result.status.isSuccessful()) {
            return AndroidProbeResult.makeEmptyProbeResult();
        }
        result = processRunner.runCommandAndGetOutput(new String[]{"-s", serial, "shell", "sh", "/data/local/tmp/streamline-android-probe.sh"});
        if (!result.status.isSuccessful()) {
            return AndroidProbeResult.makeEmptyProbeResult();
        }
        return AndroidProbeResult.fromCommandOutput(result.output, deviceState);
    }

    private static void createProbeScriptTempFile() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (InputStream in = AdbTargetBrowser.class.getResourceAsStream("streamline-android-probe.sh");){
            if (in == null) {
                throw new FileNotFoundException("streamline-android-probe.sh is missing!");
            }
            File file = File.createTempFile("streamline-android-probe", null);
            file.deleteOnExit();
            FileUtils.writeStreamToFile((InputStream)in, (File)file);
            probeScript = file;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void browseContinuously() {
        this.mRunning = true;
        while (this.mRunning) {
            if (this.canBrowse.get()) {
                this.browse(true);
            }
            try {
                Thread.sleep(this.mBrowseTimeoutInSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mRunning = false;
    }
}

