/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.model.templates.TemplateUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TargetUtils {
    private static final @NonNull Pattern MALI_GPU_NAME_PATTERN = Pattern.compile("^(ARM_)(Mali-[a-zA-Z0-9]+).*");
    private static final @NonNull String MALI_GPU_COUNTER_NAME_STARTSWITH = "ARM_Mali-";

    public static final @Nullable String findSupportedGpuFromCounterNamesAndPublicName(@NonNull CounterNames counterNames, @Nullable String gpuPublicName) {
        if (gpuPublicName != null && TemplateUtils.hasTemplateFromBuiltIn(gpuPublicName).isPresent()) {
            return gpuPublicName;
        }
        return TargetUtils.findSupportedGpuFromCounterNames(counterNames);
    }

    public static final @Nullable String findSupportedGpuFromCounterNames(@NonNull CounterNames counterNames) {
        return counterNames.stream().filter(c -> c.startsWith(MALI_GPU_COUNTER_NAME_STARTSWITH)).map(counter -> {
            String matchedName;
            Matcher matched = MALI_GPU_NAME_PATTERN.matcher((CharSequence)counter);
            if (matched.find() && matched.groupCount() == 2 && (matchedName = matched.group(2)) != null && TemplateUtils.hasTemplateFromBuiltIn(matchedName).isPresent()) {
                return matchedName;
            }
            return null;
        }).filter(s -> s != null).findFirst().orElse(null);
    }
}

