/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.session.LiveSessionProcessor;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.ITarget;
import com.arm.streamline.databrowser.ITargetXml;
import com.arm.streamline.model.session.BufferMode;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.IAdbRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetLauncher {
    private final @NonNull IAdbRunnerFactory adbRunnerFactory = AdbRunnerFactory.SINGLETON;
    private final @NonNull IPreferences mAppSettings;
    private final @NonNull CounterConfiguration mCounterConfig;
    private @NonNull String mOutputPath;
    private final @NonNull Session mSession;
    private LiveSessionProcessor mSessionProcessor;
    private final @NonNull RunningTargetXml mTargetXmls;
    private final @NonNull Runnable mCallback;
    private final @Nullable ISshTargetLauncher mTarget;

    public TargetLauncher(@NonNull Session session, @NonNull String outputPath, @NonNull IPreferences appSettings, @NonNull Runnable callback, @Nullable ISshTargetLauncher target) throws IOException {
        this.mAppSettings = appSettings;
        this.mSession = new Session(session);
        this.mOutputPath = outputPath;
        this.mCallback = callback;
        this.mTarget = target;
        this.mTargetXmls = (RunningTargetXml)GatorSendCommandUtility.useGatorTarget(this.mSession.getTargetAddress(), this.adbRunnerFactory.tryCreate(this.mAppSettings.getAdbPathOrDefault(), this.mSession.getTargetAddress().isAndroid()), this.mSession.getBufferMode() == BufferMode.STREAMING, gatorTarget -> {
            RunningTargetXml xmls = new RunningTargetXml(gatorTarget.getConfigurationXml(), gatorTarget.getCountersXML(), gatorTarget.getDefaultsXml(), gatorTarget.getEventsXML());
            gatorTarget.disconnect();
            return xmls;
        });
        this.mCounterConfig = new CounterConfiguration(this.mTargetXmls);
    }

    public @NonNull CounterConfiguration getCountersConfiguration() {
        return this.mCounterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String getOutputPath() {
        RunningTargetXml runningTargetXml = this.mTargetXmls;
        synchronized (runningTargetXml) {
            return this.mOutputPath;
        }
    }

    public @NonNull Runnable getRunnableWith(@NonNull ICaptureProxy proxy) {
        return () -> this.run(proxy);
    }

    public @NonNull Session getSession() {
        return this.mSession;
    }

    public void stop(boolean discard) {
        if (discard) {
            this.mSessionProcessor.discard();
        } else {
            this.mSessionProcessor.stop();
        }
    }

    public void stopAndWait() {
        this.stop(false);
        while (!this.mSessionProcessor.isDone()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exception) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(@NonNull ICaptureProxy proxy) {
        byte @Nullable [] configurationXml = null;
        do {
            String capturePath;
            RunningTargetXml runningTargetXml = this.mTargetXmls;
            synchronized (runningTargetXml) {
                capturePath = this.mOutputPath;
            }
            this.runOnce(configurationXml, proxy, capturePath);
        } while ((configurationXml = this.mTargetXmls.takeNewConfigurationXml()) != null);
        proxy.captureFinished(this.mSessionProcessor.isDiscard());
    }

    private @Nullable ILiveCapture runOnce(byte @Nullable [] configurationXml, @NonNull ICaptureProxy proxy, @NonNull String capturePath) {
        ILiveCapture captureFile = null;
        try {
            if (configurationXml != null) {
                GatorSendCommandUtility.useGatorTarget(this.mSession.getTargetAddress(), this.adbRunnerFactory.tryCreate(this.mAppSettings.getAdbPathOrDefault(), this.mSession.getTargetAddress().isAndroid()), this.mSession.getBufferMode() == BufferMode.STREAMING, gatorTarget -> {
                    gatorTarget.sendXML(configurationXml);
                    gatorTarget.disconnect();
                    return null;
                });
            }
            this.mSessionProcessor = new LiveSessionProcessor();
            captureFile = (ILiveCapture)GatorSendCommandUtility.useGatorTarget(this.mSession.getTargetAddress(), this.adbRunnerFactory.tryCreate(this.mAppSettings.getAdbPathOrDefault(), this.mSession.getTargetAddress().isAndroid()), this.mSession.getBufferMode() == BufferMode.STREAMING, gatorTarget -> {
                gatorTarget.sendXML(this.mSession.toString().getBytes(StandardCharsets.UTF_8));
                gatorTarget.setOnActivityStartedCallback(this.mCallback);
                return this.mSessionProcessor.collectAPC(proxy, (ITarget)gatorTarget, capturePath, this.mSession, this.mCounterConfig, this.mTarget);
            });
        }
        catch (UnknownHostException uhe) {
            proxy.captureError(String.format(DocumentsMessages.UNKNOWN_HOST, this.mSession.getTargetAddress()));
        }
        catch (ConnectException | SocketTimeoutException ce) {
            proxy.captureError(MessageFormat.format(DocumentsMessages.GATOR_CONNECT_FAILED, this.mSession.getTargetAddress(), GatorProtocolVersion.getMinSupportedLiveProductVersion().getVersionString()));
        }
        catch (Throwable exception) {
            proxy.captureError(exception);
        }
        return captureFile;
    }

    private class RunningTargetXml
    implements ITargetXml {
        private byte @NonNull [] configuration;
        private final byte @NonNull [] counters;
        private final byte @NonNull [] defaults;
        private final byte @NonNull [] events;
        private boolean mHaveNewConfigurationXml;

        public RunningTargetXml(byte @NonNull [] configuration, byte @NonNull [] counters, byte @NonNull [] defaults, byte[] events) {
            this.configuration = configuration;
            this.counters = counters;
            this.defaults = defaults;
            this.events = events;
            this.mHaveNewConfigurationXml = false;
        }

        @Override
        public byte @NonNull [] getConfigurationXml() {
            return this.configuration;
        }

        @Override
        public byte @NonNull [] getCountersXml() {
            return this.counters;
        }

        @Override
        public byte @NonNull [] getDefaultsXml() {
            return this.defaults;
        }

        @Override
        public byte @NonNull [] getEventsXml() {
            return this.events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable IOException sendConfigurationXml(byte @NonNull [] newCountersXml, boolean discardExisting) {
            RunningTargetXml runningTargetXml = this;
            synchronized (runningTargetXml) {
                this.configuration = newCountersXml;
                this.mHaveNewConfigurationXml = true;
                if (!discardExisting) {
                    File oldOutputPath = new File(TargetLauncher.this.mOutputPath);
                    File parent = (File)NullChecking.neverNull((Object)oldOutputPath.getParentFile());
                    TargetLauncher.this.mOutputPath = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)oldOutputPath.getName())).getPath();
                }
            }
            TargetLauncher.this.stop(discardExisting);
            return null;
        }

        public synchronized byte @Nullable [] takeNewConfigurationXml() {
            if (this.mHaveNewConfigurationXml) {
                this.mHaveNewConfigurationXml = false;
                return this.configuration;
            }
            return null;
        }
    }
}

