/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.deviceconn.Log;
import com.arm.streamline.deviceconn.ssh.BasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.OpenSSHConfigParser;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SshConfigurationDialog
extends TitleAreaDialog {
    private final OpenSSHConfigParser.OpenSSHConfig opensshConfig = OpenSSHConfigParser.parseUserConfig();
    private TextField mGatorPath;
    private TextField mGatorPort;
    private TextField mSessionName;
    private TextField mSSHAddress;
    private TextField mSSHPort;
    private TextField mSSHUsername;
    private TextField mSSHPrivateKey;
    private TextField mSSHPassword;
    private Button mBtnPass;
    private Button mBtnKey;
    ObservableList<@NonNull ISshTargetLauncher> mDetectedDevices;
    private ISshTargetLauncher mSshTarget;
    private Button mTestConnectionBtn;
    private Button mSaveBtn;
    private Label mConnectionStatusLabel;
    private Color mDefaultBackground;

    private boolean validateSSHConfigurationInput() {
        boolean hasAddress;
        boolean hasSessionName = this.mSessionName != null && !this.mSessionName.getText().isEmpty();
        boolean bl = hasAddress = this.mSSHAddress != null && !this.mSSHAddress.getText().isEmpty();
        if (!hasSessionName) {
            SshConfigurationDialog.showErrorToUserAndWait("Session name is required");
            this.mSessionName.setTextBackground(Colors.getInstructionHighlight());
            return false;
        }
        if (!hasAddress) {
            SshConfigurationDialog.showErrorToUserAndWait("Address name is required");
            this.mSSHAddress.setTextBackground(Colors.getInstructionHighlight());
            return false;
        }
        return true;
    }

    private @Nullable SshDeviceConfiguration buildSshConfig() throws Exception {
        ISshTargetLauncher targetDevice = this.buildSshTargetLauncher();
        if (targetDevice == null) {
            return null;
        }
        OpenSSHConfigParser.SSHTargetConfig targetConfig = targetDevice.getSSHTargetConfig();
        if (this.mBtnPass.getSelection()) {
            String pw = targetConfig.password();
            if (pw == null || pw.isEmpty()) {
                return null;
            }
            return new SshDeviceConfiguration(targetConfig.hostname(), targetConfig.port(), targetConfig.username(), pw);
        }
        for (File key : targetConfig.keyFiles()) {
            block9: {
                block8: {
                    try {
                        if (key.exists()) break block8;
                        SshConfigurationDialog.showErrorToUserAndWait("SSH private key file " + key.getAbsolutePath() + " does not exist. Enter the correct path and filename.");
                        return null;
                    }
                    catch (Exception e) {
                        SshConfigurationDialog.showErrorToUserAndWait("Reading SSH private key file failed. Error: " + e.getMessage());
                        return null;
                    }
                }
                if (key.isFile()) break block9;
                SshConfigurationDialog.showErrorToUserAndWait("SSH private key file " + key.getAbsolutePath() + " is not a valid file. Enter the correct path and filename.");
                return null;
            }
            if (key.canRead()) continue;
            SshConfigurationDialog.showErrorToUserAndWait("SSH private key file " + key.getAbsolutePath() + " can not be read. Please check that the file has read permissions.");
            return null;
        }
        return new SshDeviceConfiguration(targetConfig.hostname(), targetConfig.port(), targetConfig.username(), targetConfig.keyFiles());
    }

    private @Nullable ISshTargetLauncher buildSshTargetLauncher() {
        List sshKeyFiles;
        String sshaddress = this.mSSHAddress.getText();
        String sshSessionName = this.mSessionName.getText();
        String sshUsername = this.mSSHUsername.getText();
        String sshPort = this.mSSHPort.getText();
        String sshGatorPort = this.mGatorPort.getText();
        String sshGatorPath = this.mGatorPath.getText();
        String sshPassword = this.mSSHPassword.getText();
        List<Object> list = sshKeyFiles = this.mBtnKey.getSelection() && !this.mSSHPrivateKey.getText().isEmpty() ? SshConfigurationDialog.unjoinPaths(this.mSSHPrivateKey.getText()) : Collections.emptyList();
        if (sshSessionName.isEmpty()) {
            SshConfigurationDialog.showErrorToUserAndWait("Name is required.");
            this.mSessionName.setTextBackground(Colors.getInstructionHighlight());
            return null;
        }
        if (sshaddress.isEmpty()) {
            SshConfigurationDialog.showErrorToUserAndWait("Address is required.");
            this.mSSHAddress.setTextBackground(Colors.getInstructionHighlight());
            return null;
        }
        if (this.mBtnPass.getSelection() && this.mSSHPassword.getText().isEmpty()) {
            SshConfigurationDialog.showErrorToUserAndWait("Password is required.");
            this.mSSHPassword.setTextBackground(Colors.getInstructionHighlight());
            return null;
        }
        if (this.mBtnKey.getSelection() && this.mSSHPrivateKey.getText().isEmpty()) {
            SshConfigurationDialog.showErrorToUserAndWait("Path to PrivateKey is required.");
            this.mSSHPrivateKey.setTextBackground(Colors.getInstructionHighlight());
            return null;
        }
        if (!sshPort.isBlank() && !SshTargetLauncher.isPortValid(sshPort)) {
            SshConfigurationDialog.showErrorToUserAndWait("Enter a valid SSH port value.");
            return null;
        }
        if (!sshGatorPort.isBlank() && !SshTargetLauncher.isPortValid(sshGatorPort)) {
            SshConfigurationDialog.showErrorToUserAndWait(CmdLineMessages.INVALID_GATORD_PORT);
            return null;
        }
        OpenSSHConfigParser.SSHTargetConfig hostDefaults = this.opensshConfig.createTargetConfig(sshSessionName, sshaddress, sshUsername, this.mBtnPass.getSelection() ? sshPassword : null, sshKeyFiles, sshPort.isBlank() ? null : Integer.decode(sshPort));
        int gatorPort = sshGatorPort.isBlank() ? 0 : Integer.parseInt(sshGatorPort);
        return new SshTargetLauncher(hostDefaults, "", "", "", SshTargetLauncher.isPortValid(gatorPort) ? gatorPort : SshTargetLauncher.getDefaultGatorPort(), sshGatorPath != null && !sshGatorPath.isBlank() ? sshGatorPath : SshTargetLauncher.getDefaultGatorPath(), false, false);
    }

    public SshConfigurationDialog(Shell parentShell, ObservableList<@NonNull ISshTargetLauncher> detectedDevices, ISshTargetLauncher sshTarget) {
        super(parentShell);
        this.mDetectedDevices = detectedDevices;
        this.mSshTarget = sshTarget;
    }

    protected void configureShell(Shell parentShell) {
        super.configureShell(parentShell);
        parentShell.setText(DocumentsMessages.SSH_CONFIGURATION_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite innerArea = new Composite(dialogArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).spacing(5, 5).applyTo(innerArea);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)innerArea);
        this.setTitle(DocumentsMessages.SSH_CONFIGURATION_TITLE);
        this.setMessage(DocumentsMessages.SSH_CONFIGURATION_MESSAGE, 1);
        GridLayoutFactory.fillDefaults().spacing(5, 5).numColumns(1).margins(5, 5).applyTo(innerArea);
        BorderedComposite mSshNameContainer = new BorderedComposite(innerArea, "Name*");
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(5, 5).applyTo((Composite)mSshNameContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)mSshNameContainer);
        this.mSessionName = SshConfigurationDialog.createTextField(mSshNameContainer, "Session name", "enter_session_name", 2048, false);
        FontInfo mFontInfo = FontInfo.get(this.mSessionName.getFont());
        this.mSessionName.setDesiredMinimumTextWidth(mFontInfo.getWidth("0") * 64);
        BorderedComposite mSshAddressContainer = new BorderedComposite(innerArea, "Address");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 5).equalWidth(true).applyTo((Composite)mSshAddressContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)mSshAddressContainer);
        SWTUtils.createLabel(mSshAddressContainer, DocumentsMessages.SSH_CONFIGURATION_ADDRESS, DocumentsMessages.SSH_CONFIGURATION_ADDRESS_TOOLTIP, 0);
        SWTUtils.createLabel(mSshAddressContainer, DocumentsMessages.SSH_CONFIGURATION_PORT, DocumentsMessages.SSH_CONFIGURATION_PORT_TOOLTIP, 0);
        this.mSSHAddress = SshConfigurationDialog.createTextField(mSshAddressContainer, DocumentsMessages.SSH_CONFIGURATION_ADDRESS_TOOLTIP, "enter_address", 2048, true);
        this.mSSHPort = SshConfigurationDialog.createTextField(mSshAddressContainer, DocumentsMessages.SSH_CONFIGURATION_PORT_TOOLTIP, String.valueOf(22), 2048, false);
        BorderedComposite mSshGroupContainer = new BorderedComposite(innerArea, "Credentials");
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(5, 5).applyTo((Composite)mSshGroupContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)mSshGroupContainer);
        SWTUtils.createLabel(mSshGroupContainer, DocumentsMessages.SSH_CONFIGURATION_USERNAME, DocumentsMessages.SSH_CONFIGURATION_USERNAME_TOOLTIP, 0);
        this.mSSHUsername = SshConfigurationDialog.createTextField(mSshGroupContainer, DocumentsMessages.SSH_CONFIGURATION_USERNAME_TOOLTIP, OpenSSHConfigParser.getDefaultSshUserName(), 2048, true);
        Composite mSshGroupComp = new Composite((Composite)mSshGroupContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 5).equalWidth(true).applyTo(mSshGroupComp);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)mSshGroupComp);
        this.mBtnKey = new Button(mSshGroupComp, 16);
        this.mBtnKey.setText(DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY);
        this.mBtnKey.setToolTipText(DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY_TOOLTIP);
        GridDataFactory.fillDefaults().applyTo((Control)this.mBtnKey);
        this.mBtnPass = new Button(mSshGroupComp, 16);
        this.mBtnPass.setText(DocumentsMessages.SSH_CONFIGURATION_PASSWORD);
        this.mBtnPass.setToolTipText(DocumentsMessages.SSH_CONFIGURATION_PASSWORD_TOOLTIP);
        GridDataFactory.fillDefaults().applyTo((Control)this.mBtnPass);
        this.mSSHPrivateKey = new TextField(mSshGroupComp, StreamlinePlugin.getImage("Browse.png"), 2048);
        this.mSSHPrivateKey.setWatermark(SshConfigurationDialog.joinPaths(((List)NullChecking.neverNullOr((Object)OpenSSHConfigParser.OpenSSHConfig.getDefaultIdentityFiles(), Collections.emptyList())).stream().map(File::new).map(FileUtils::canonicalise).toList()));
        this.mSSHPrivateKey.setToolTipText(DocumentsMessages.SSH_CONFIGURATION_PRIVATE_KEY_TOOLTIP);
        FontInfo fontInfo = FontInfo.get(this.mSSHPrivateKey.getFont());
        this.mSSHPrivateKey.setDesiredMinimumTextWidth(fontInfo.getWidth("0") * 16);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.mSSHPrivateKey);
        this.mSSHPrivateKey.addClickListener(new TextField.IClickListener(){

            @Override
            public void buttonClicked(TextField field) {
                FileDialog fileDialog = new FileDialog(SshConfigurationDialog.this.getShell(), 4098);
                List<File> paths = SshConfigurationDialog.unjoinPaths(SshConfigurationDialog.this.mSSHPrivateKey.getText());
                File dir = !paths.isEmpty() ? paths.get(0).getParentFile() : null;
                String name = !paths.isEmpty() ? paths.get(0).getName() : null;
                fileDialog.setFileName(name);
                fileDialog.setFilterPath(dir != null ? dir.getAbsolutePath() : null);
                String path = fileDialog.open();
                if (path != null && !path.isEmpty()) {
                    String[] extras = fileDialog.getFileNames();
                    if (extras != null && extras.length > 0) {
                        String filterPath = fileDialog.getFilterPath();
                        ArrayList<File> files = new ArrayList<File>();
                        String[] stringArray = extras;
                        int n = extras.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String x = stringArray[n2];
                            if (filterPath != null) {
                                f = new File(filterPath, x);
                                files.add(f);
                            } else {
                                f = new File(x);
                                files.add(f);
                            }
                            ++n2;
                        }
                        SshConfigurationDialog.this.mSSHPrivateKey.setText(SshConfigurationDialog.joinPaths(files));
                    } else {
                        SshConfigurationDialog.this.mSSHPrivateKey.setText(path);
                    }
                }
            }
        });
        this.mSSHPassword = SshConfigurationDialog.createTextField(mSshGroupComp, DocumentsMessages.SSH_CONFIGURATION_PASSWORD_TOOLTIP, "", 0x400800, false);
        FontInfo mFontInfo2 = FontInfo.get(this.mSSHPassword.getFont());
        this.mSSHPassword.setDesiredMinimumTextWidth(mFontInfo2.getWidth("0") * 32);
        this.mSSHPrivateKey.setDesiredMinimumTextWidth(mFontInfo2.getWidth("0") * 28);
        this.selectPasswordOption(true);
        this.mBtnPass.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshConfigurationDialog.this.mSSHPrivateKey.setEnabled(false);
                SshConfigurationDialog.this.mSSHPassword.setEnabled(true);
                SshConfigurationDialog.this.mSSHPassword.setTextBackground(SshConfigurationDialog.this.mDefaultBackground);
            }
        });
        this.mBtnKey.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshConfigurationDialog.this.mSSHPrivateKey.setEnabled(true);
                SshConfigurationDialog.this.mSSHPassword.setEnabled(false);
                SshConfigurationDialog.this.mSSHPrivateKey.setTextBackground(SshConfigurationDialog.this.mDefaultBackground);
            }
        });
        BorderedComposite mGatorGroup = new BorderedComposite(innerArea, "Gator Configuration");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(5, 5).equalWidth(true).applyTo((Composite)mGatorGroup);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)mGatorGroup);
        SWTUtils.createLabel(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH_TOOLTIP, 0);
        SWTUtils.createLabel(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT_TOOLTIP, 0);
        this.mGatorPath = SshConfigurationDialog.createTextField(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PATH_TOOLTIP, SshTargetLauncher.getDefaultGatorPath(), 2048, true);
        this.mGatorPort = SshConfigurationDialog.createTextField(mGatorGroup, DocumentsMessages.SSH_CONFIGURATION_GATOR_PORT_TOOLTIP, String.valueOf(SshTargetLauncher.getDefaultGatorPort()), 2048, false);
        if (this.mSshTarget != null) {
            OpenSSHConfigParser.SSHTargetConfig targetConfig = this.mSshTarget.getSSHTargetConfig();
            this.mSessionName.setText(targetConfig.id());
            this.mSSHUsername.setText(targetConfig.username());
            this.mSSHAddress.setText(targetConfig.hostname());
            this.mSSHPort.setText(String.valueOf(targetConfig.port()));
            this.mGatorPort.setText(String.valueOf(this.mSshTarget.getGatorPortNumeric()));
            this.mGatorPath.setText(this.mSshTarget.getGatorPath());
            String password = targetConfig.password();
            if (password != null && !password.isEmpty()) {
                this.selectPasswordOption(true);
                this.mSSHPassword.setText(password);
            } else {
                this.mSSHPrivateKey.setText(SshConfigurationDialog.joinPaths(targetConfig.keyFiles()));
                this.selectPasswordOption(false);
            }
        }
        this.mDefaultBackground = this.mSessionName.getTextBackground();
        this.mSessionName.addFocusListener(new TextFieldFocusListener(this.mSessionName));
        this.mSSHAddress.addFocusListener(new TextFieldFocusListener(this.mSSHAddress));
        this.mSSHPassword.addFocusListener(new TextFieldFocusListener(this.mSSHPassword));
        this.mSSHPrivateKey.addFocusListener(new TextFieldFocusListener(this.mSSHPrivateKey));
        this.mSSHPort.addVerifyListener(SshConfigurationDialog::ensureTextContainsOnlyDigits);
        this.mGatorPort.addVerifyListener(SshConfigurationDialog::ensureTextContainsOnlyDigits);
        parent.layout();
        return dialogArea;
    }

    private static @NonNull String joinPaths(@NonNull List<@NonNull File> keyFiles) {
        return keyFiles.stream().map(FileUtils::canonicalisePath).collect(Collectors.joining(File.pathSeparator));
    }

    private static @NonNull List<@NonNull File> unjoinPaths(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(text.split(File.pathSeparator)).filter(s -> !s.isEmpty()).map(File::new).toList();
    }

    private static void ensureTextContainsOnlyDigits(VerifyEvent e) {
        String string = e.text;
        e.doit = string.matches("\\d*");
    }

    protected Control createButtonBar(Composite parent) {
        Composite innerArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).spacing(5, 5).applyTo(innerArea);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)innerArea);
        Control control = super.createButtonBar(innerArea);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo(control);
        this.mSaveBtn = this.getButton(0);
        this.mSaveBtn.setText(DocumentsMessages.SAVE);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)this.mSaveBtn);
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)this.getButton(1));
        return control;
    }

    public void okPressed() {
        ISshTargetLauncher targetDevice = this.buildSshTargetLauncher();
        if (targetDevice == null) {
            return;
        }
        for (ISshTargetLauncher sshTargetLauncher : this.mDetectedDevices) {
            if (this.mSshTarget == null || this.mSshTarget == sshTargetLauncher) continue;
            OpenSSHConfigParser.SSHTargetConfig thisTargetConfig = targetDevice.getSSHTargetConfig();
            OpenSSHConfigParser.SSHTargetConfig thatTargetConfig = sshTargetLauncher.getSSHTargetConfig();
            if (!thisTargetConfig.id().contentEquals(thatTargetConfig.id())) continue;
            SshConfigurationDialog.showErrorToUserAndWait("Target with name " + thisTargetConfig.id() + " already exists");
            return;
        }
        if (!this.validateSSHConfigurationInput()) {
            return;
        }
        if (this.mSshTarget != null) {
            int pos = this.mDetectedDevices.indexOf((Object)this.mSshTarget);
            if (pos == -1) {
                SshConfigurationDialog.showErrorToUserAndWait("Cannot modify existing target. Reopen SSH configuration dialog and try again.");
                return;
            }
            this.mDetectedDevices.set(pos, (Object)targetDevice);
        } else {
            this.mDetectedDevices.add((Object)targetDevice);
        }
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(5, 5).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)parent);
        this.mTestConnectionBtn = this.createButton(parent, 10, "Test connection", false);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.mTestConnectionBtn);
        this.mTestConnectionBtn.setToolTipText("Test connection");
        this.mConnectionStatusLabel = SWTUtils.createLabel(parent, ": disconnected", "Connection status", 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.mConnectionStatusLabel);
        this.mTestConnectionBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SshDeviceConfiguration cfg;
                if (!SshConfigurationDialog.this.validateSSHConfigurationInput()) {
                    return;
                }
                Display ui = SshConfigurationDialog.this.mConnectionStatusLabel.getDisplay();
                Cursor cursorWait = new Cursor((Device)ui, 1);
                final Cursor oldCursor = SshConfigurationDialog.this.getShell().getCursor();
                SshConfigurationDialog.this.getShell().setCursor(cursorWait);
                SshConfigurationDialog.this.mConnectionStatusLabel.setText(": testing...");
                try {
                    cfg = SshConfigurationDialog.this.buildSshConfig();
                    if (cfg == null) {
                        SshConfigurationDialog.this.mConnectionStatusLabel.setText(": failed");
                        Log.warn((String)String.format("SSH: Failed to build SSH configuration", new Object[0]));
                        SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                        return;
                    }
                }
                catch (Exception e) {
                    SshConfigurationDialog.this.mConnectionStatusLabel.setText(": failed");
                    Log.warn((String)String.format("SSH: Could not build SSH configuration %s", e.getMessage()));
                    SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String resultMessage;
                        if (BasicSshDeviceConnection.test((SshDeviceConfiguration)cfg)) {
                            resultMessage = ": connected";
                        } else {
                            Log.warn((String)String.format("SSH: Could not establish connection", new Object[0]));
                            resultMessage = ": failed";
                        }
                        (this).SshConfigurationDialog.this.mConnectionStatusLabel.setText(resultMessage);
                        SshConfigurationDialog.this.getShell().setCursor(oldCursor);
                    }
                });
            }
        });
        super.createButtonsForButtonBar(parent);
        parent.layout();
    }

    private static TextField createTextField(Composite parent, String tooltip, String defaultValue, int style, boolean isLongFiled) {
        TextField field = new TextField(parent, style);
        field.setWatermark(defaultValue);
        field.setToolTipText(tooltip);
        FontInfo fontInfo = FontInfo.get(field.getFont());
        field.setDesiredMinimumTextWidth(fontInfo.getWidth("0") * (isLongFiled ? 48 : 16));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)field);
        return field;
    }

    private void selectPasswordOption(boolean enablePassword) {
        this.mBtnKey.setSelection(!enablePassword);
        this.mBtnPass.setSelection(enablePassword);
        this.mSSHPrivateKey.setEnabled(!enablePassword);
        this.mSSHPassword.setEnabled(enablePassword);
    }

    private static void showErrorToUserAndWait(String errorMessage) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setHeaderText(errorMessage);
        alert.showAndWait();
    }

    class TextFieldFocusListener
    implements FocusListener {
        private TextField txtField;

        public TextFieldFocusListener(TextField t) {
            this.txtField = t;
        }

        public void focusGained(FocusEvent e) {
            this.txtField.setTextBackground(SshConfigurationDialog.this.mDefaultBackground);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

